/*-
 * Copyright (C) @BABOLO  2002 Dec 23
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 23\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: execute.c,v 1.8 2005/10/24 05:18:37 gd Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include <err.h>
#include <libpq-fe.h>
#include "pgoblin.h"

int
pgoblin_execute(pgoblin_con *options, pgoblin_p *pgm, struct mife_descriptor *in, int out) {
    pnode p;
    int pipa[2];
    int ex;

    ifBLIN_QV3(options->flag) fprintf( stderr, "+pgoblin_execute pgm=%s in=%s out=%d\n"
                                     , pgm ? "OK" : "NULL"
                                     , in ? "OK" : "NULL"
                                     , out
                                     );
    for (p = 0, ex = 0; !ex && p < pgm->maxx; p++) {
        switch(pgm->code[p].cmd) {
        case pgob_null:
        case pgob_bang:
            break;
        case pgob_copyin:
            ex = pgoblin_copyin(options, pgm->code[p].parm, in);
            break;
        case pgob_copyout:
            ex = pgoblin_copyout(options, pgm->code[p].parm, out);
            break;
        case pgob_binselect:
            ex = pgoblin_binsel(options, pgm->code[p].parm, out);
            break;
        case pgob_strselect:
            ex = pgoblin_strsel(options, pgm->code[p].parm, out);
            break;
        case pgob_select:
            ex = pgoblin_sel_p(options, pgoblin_sel_q(options, pgm->code[p].parm), out);
            break;
        case pgob_perform:
            ex = pgoblin_perform(options, pgm->code[p].parm);
            break;
        case pgob_getarg:
            if  (pipe(pipa)) {
                ifBLIN_QV1(options->flag) warn("execute");
                ex = EX_OSERR;
                break;
            }
            if  ((ex = pgoblin_getarg(options, pipa[1]))) break;
            if  (in) mife_close(in);
            if  (!(in = mife_opef(MIFE_FULL, pipa[0]))) {
                warn("execute");
                ex = EX_NOINPUT;
            }
            break;
        case pgob_getenv:
            if  (pipe(pipa)) {
                ifBLIN_QV1(options->flag) warn("execute");
                ex = EX_OSERR;
                break;
            }
            if  ((ex = pgoblin_getenv(options, pipa[1]))) break;
            if  (in) mife_close(in);
            if  (!(in = mife_opef(MIFE_FULL, pipa[0]))) {
                warn("execute");
                ex = EX_NOINPUT;
            }
            break;
        case pgob_getget:
            if  (pipe(pipa)) {
                ifBLIN_QV1(options->flag) warn("execute");
                ex = EX_OSERR;
                break;
            }
            if  ((ex = pgoblin_getget(options, pipa[1]))) break;
            if  (in) mife_close(in);
            if  (!(in = mife_opef(MIFE_FULL, pipa[0]))) {
                warn("execute");
                ex = EX_NOINPUT;
            }
            break;
        case pgob_getpost:
            if  (pipe(pipa)) {
                ifBLIN_QV1(options->flag) warn("execute");
                ex = EX_OSERR;
                break;
            }
            if  ((ex = pgoblin_getpost(options, in, pipa[1]))) break;
            if  (in) mife_close(in);
            if  (!(in = mife_opef(MIFE_FULL, pipa[0]))) {
                warn("execute");
                ex = EX_NOINPUT;
            }
            break;
        case pgob_echo:
            if  ((ex = pgoblin_echo(options, pgm->code[p].parm, out))) return(ex);
            break;
        case pgob_cat:
            if  ((ex = pgoblin_cat(options, pgm->code[p].parm, out))) return(ex);
            break;
        case pgob_illegal:
        default:
            ifBLIN_QV1(options->flag) errx(EX_DATAERR, "Unknown command");
            exit(EX_DATAERR);
    }   }
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_execute %d\n", ex);
    return(ex);
};
