/*-
 * Copyright (C) @BABOLO  2002 Dec 17
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 17\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cmd_select.c,v 1.2 2004/11/29 20:36:18 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include <err.h>
#include <libpq-fe.h>
#include "pgoblin.h"

PGresult *
pgoblin_sel_q(pgoblin_con *options, char *query) {
    PGresult *res;
    char *q;

    ifBLIN_QV3(options->flag) fprintf( stderr, "+pgoblin_sel_q %s\n"
                                     , query ? query : "NULL"
                                     );
    if  (pgoblin_shurecon(options)) return(NULL);
    if  (query) q = query;
    else {
        ifBLIN_QV1(options->flag) warnx("pgoblin_sel_q: No query");
        return(NULL);
    }

    PQEXEC(res, q, PGRES_TUPLES_OK, NULL);
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_sel_q %s\n", res ? "OK" : "NULL");
    return(res);
}

int
pgoblin_sel_p(pgoblin_con *options, PGresult *res, int out) {
    int j, c, k;
    ssize_t e;

    ifBLIN_QV3(options->flag) fprintf(stderr, "+pgoblin_sel_p out=%d\n", out);
    if  (res == NULL) return(-1);
    if  (!options->tdl) j = e = 0;
      else j = (e = mife_writ(out, options->tdl->tbeg, 0));

    for (k = 0; k < PQntuples(res) && e >= 0; k++) {
        if  (e >= 0 && options->tdl && k) j += (e = mife_writ(out, options->tdl->rmed, 0));
        if  (e >= 0 && options->tdl) j += (e = mife_writ(out, options->tdl->rbeg, 0));
        for (c = 0; c < PQnfields(res) && e >= 0; c++) {
            if  (e >= 0 && options->tdl && c) j += (e = mife_writ(out, options->tdl->cmed, 0));
            if  (e >= 0 && options->tdl) j += (e = mife_writ(out, options->tdl->cbeg, 0));
            if  (!PQgetisnull(res, k, c) && e >= 0)
                j += (e = mife_writ(out, PQgetvalue(res, k, c), PQgetlength(res, k, c)));
            if  (e >= 0 && options->tdl) j += (e = mife_writ(out, options->tdl->cend, 0));
        }
        if  (e >= 0 && options->tdl) j += (e = mife_writ(out, options->tdl->rend, 0));
    }
    if  (e >= 0 && options->tdl) j += (e = mife_writ(out, options->tdl->tend, 0));
    PQclear(res);
    if  (e < 0) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_sel_p: write error");
        return(-1);
    }
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_sel_p %d\n", 0);
    return(0);
}
