/*-
 * Copyright (C) @BABOLO  2002 Dec 17
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 17\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cmd_perform.c,v 1.6 2004/11/29 20:36:18 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include <err.h>
#include <libpq-fe.h>
#include "pgoblin.h"

int
pgoblin_perform(pgoblin_con *options, char *query) {
    PGresult *res;
    char *q;

    ifBLIN_QV3(options->flag) fprintf(stderr, "+pgoblin_perform %s\n", query ? query : "NULL");
    if  (pgoblin_shurecon(options)) return(-1);
    if  (!(q = query)) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_perform: No query");
        return(-1);
    }
    PQEXEC(res, q, PGRES_COMMAND_OK, -1);
    PQclear(res);
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_perform %d\n", 0);
    return(0);
}
