/*-
 * Copyright (C) @BABOLO  2004 Nov 18
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2004 Nov 18\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cmd_get.c,v 1.2 2004/11/29 20:36:18 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
//#include <limits.h>
//#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <getCGIparm.h>
#include <mife.h>
#include <err.h>
#include <libpq-fe.h>
#include "pgoblin.h"

int
pgoblin_getarg(pgoblin_con *options, int out) {
    int ex;

    ifBLIN_QV3(options->flag) fprintf(stderr, "+pgoblin_getarg %d\n", out);
    ex = fork();
    ifBLIN_QV3(options->flag) fprintf(stderr, "?pgoblin_getarg %d\n", ex);
    if  (ex > 0) {
        close(out);
        return(EX_OK);
    }
    if  (ex < 0) {
        ifBLIN_QV1(options->flag) warn("getarg");
        exit(EX_OSERR);
    }
    if  ((ex = getCGIparmarray(0, options->argv, "any", "\t", "\\N", out))) {
        ifBLIN_QV1(options->flag) warnx("getarg getCGIparmarray");
        exit(ex);
    }
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_getarg %d\n", ex);
    exit(EX_OK);
}

int
pgoblin_getenv(pgoblin_con *options, int out) {
    int ex;

    ifBLIN_QV3(options->flag) fprintf(stderr, "+pgoblin_getenv %d\n", out);
    ex = fork();
    ifBLIN_QV3(options->flag) fprintf(stderr, "?pgoblin_getenv %d\n", ex);
    if  (ex > 0) {
        close(out);
        return(EX_OK);
    }
    if  (ex < 0) {
        ifBLIN_QV1(options->flag) warn("getenv");
        exit(EX_OSERR);
    }
    if  ((ex = getCGIparmenv(gCGI_RNUM, options->envp, "any", "\t", "\\N", out))) {
        ifBLIN_QV1(options->flag) warnx("getenv getCGIparmenv");
        exit(ex);
    }
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_getenv %d\n", ex);
    exit(EX_OK);
}

int
pgoblin_getget(pgoblin_con *options, int out) {
    int ex;

    ifBLIN_QV3(options->flag) fprintf(stderr, "+pgoblin_getget %d\n", out);
    ex = fork();
    ifBLIN_QV3(options->flag) fprintf(stderr, "?pgoblin_getget %d\n", ex);
    if  (ex > 0) {
        close(out);
        return(EX_OK);
    }
    if  (ex < 0) {
        ifBLIN_QV1(options->flag) warn("getget");
        exit(EX_OSERR);
    }
    if  ((ex = getCGIparmcopy(gCGI_RNUM|gCGI_SEPR, getenv("QUERY_STRING"), "any", "\t", "\\N", out))) {
        ifBLIN_QV1(options->flag) warnx("getget getCGIparmcopy");
        exit(ex);
    }
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_getget %d\n", ex);
    exit(EX_OK);
}

int
pgoblin_getpost(pgoblin_con *options, struct mife_descriptor *in, int out) {
    int ex;

    ifBLIN_QV3(options->flag) fprintf(stderr, "+pgoblin_getpost %s %d\n", in ? "OK" : "NULL", out);
    if  (mife_read(in, 0, 0, NULL) < 0) {
        ifBLIN_QV1(options->flag) warn("getpost 1");
        return(EX_OSERR);
    }
    ex = fork();
    ifBLIN_QV3(options->flag) fprintf(stderr, "?pgoblin_getpost %d\n", ex);
    if  (ex > 0) {
        close(out);
        return(EX_OK);
    }
    if  (ex < 0) {
        ifBLIN_QV1(options->flag) warn("getpost 2");
        exit(EX_OSERR);
    }
    if  ((ex = getCGIparmcopy(gCGI_RNUM|gCGI_SEPR, mife_get(in, 0), "any", "\t", "\\N", out))) {
        ifBLIN_QV1(options->flag) warnx("getpost getCGIparmcopy");
        exit(ex);
    }
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_getpost %d\n", ex);
    exit(EX_OK);
}
