/*-
 * Copyright (C) @BABOLO  2004 Nov 18
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2004 Nov 18\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cmd_file.c,v 1.4 2005/10/24 14:24:25 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
//#include <limits.h>
//#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <getCGIparm.h>
#include <mife.h>
#include <err.h>
#include <libpq-fe.h>
#include "pgoblin.h"

int
pgoblin_echo(pgoblin_con *options, char *query, int out) {
    int ex;

    ifBLIN_QV3(options->flag) fprintf(stderr, "+pgoblin_echo %d\n", out);
    if  ((ex = mife_writ(out, query, strlen(query))) < 0) {
        ifBLIN_QV1(options->flag) warn("echo");
        return(EX_IOERR);
    }
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_echo %d\n", ex);
    return(EX_OK);
}

int
pgoblin_cat(pgoblin_con *options, char *query, int out) {
    int off = 0;
    struct mife_descriptor *md;
    char *cont;
    ssize_t bl;

    ifBLIN_QV3(options->flag) fprintf(stderr, "+pgoblin_cat %d\n", out);
    if (!query) {
	ifBLIN_QV1(options->flag) warnx("cat no file");
	return(EX_NOINPUT);
    }
    if (!(md = mife_open(kukMIFE_BUFL(RAWIOBUFL) | MIFE_BUFX, query))) {
	ifBLIN_QV1(options->flag) warn("cat open %s:", query);
	return(EX_IOERR);
    }
    while (!(md->flag & MIFE_EOFL)) {
        if  ((bl = mife_read(md, 1 << (RAWIOBUFL + 16), off, NULL)) < 0) {
            ifBLIN_QV1(options->flag) warn("cat read %s:", query);
            return(EX_IOERR);
        }
	if  (!(cont = mife_get(md, off))) {
    	    ifBLIN_QV1(options->flag) warn("cat get %s:", query);
    	    return(EX_IOERR);
	}
	if  (mife_writ(out, cont, bl) < 0) {
    	    ifBLIN_QV1(options->flag) warn("cat write");
    	    return(EX_IOERR);
	}
	off += bl;
    }
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_cat\n");
    return(EX_OK);
}
