/*-
 * Copyright (C) @BABOLO  2002 Dec 04
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 04\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cmd_fetselect.c,v 1.3 2005/03/15 02:35:11 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include <err.h>
#include <libpq-fe.h>
#include "pgoblin.h"

static const char *fetchN[] =
{ "FETCH 1 FROM pgoblin"
, "FETCH 2 FROM pgoblin"
, "FETCH 3 FROM pgoblin"
, "FETCH 5 FROM pgoblin"
, "FETCH 8 FROM pgoblin"
, "FETCH 13 FROM pgoblin"
, "FETCH 21 FROM pgoblin"
, "FETCH 34 FROM pgoblin"
, "FETCH 55 FROM pgoblin"
, "FETCH 89 FROM pgoblin"
, "FETCH 144 FROM pgoblin"
, "FETCH 233 FROM pgoblin"
, "FETCH 377 FROM pgoblin"
, "FETCH 610 FROM pgoblin"
, "FETCH 987 FROM pgoblin"
, "FETCH 1597 FROM pgoblin"
, "FETCH 2584 FROM pgoblin"
, "FETCH 4181 FROM pgoblin"
, "FETCH 6765 FROM pgoblin"
, "FETCH 10946 FROM pgoblin"
, "FETCH 17711 FROM pgoblin"
, NULL
};

int
pgoblin_binsel(pgoblin_con *options, char *query, int out) {
    int j, c, k, t;
    PGresult *res;
    char *q;
    size_t i;
    ssize_t e;

    ifBLIN_QV3(options->flag) fprintf( stderr, "+pgoblin_binsel %s out=%d\n"
                                           , query ? query : "NULL"
                                           , out
                                           );
    if  (pgoblin_shurecon(options)) return(-1);
    if  (!(q = query)) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_binsel: No query");
        return(-1);
    }

    if  (!options->intran) {
/*  if  (PQtransactionStatus(options->conn) != PQTRANS_INTRANS) { */
        PQEXEC(res, "BEGIN", PGRES_COMMAND_OK, -1);
        PQclear(res);
    }
    asprintf(&q, "DECLARE pgoblin BINARY CURSOR FOR %s", q);
    if  (q == NULL) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_binsel: No memory");
        return(-1);
    }
    PQEXEC(res, q, PGRES_COMMAND_OK, -1);
    PQclear(res);
    free(q);
    i = 0;
    PQEXEC(res, fetchN[i], PGRES_TUPLES_OK, -1);

    for (e = 0; (t = PQntuples(res)) > 0 && e >= 0; ) {
        for (j = 0, k = 0; k < t && e >= 0; k++) {
            for (c = 0; c < PQnfields(res) && e >= 0; c++) {
                if  (!PQgetisnull(res, k, c)) {
                    j += (e = mife_writ(out, PQgetvalue(res, k, c), PQgetlength(res, k, c)));
        }   }   }
        PQclear(res);
        ifBLIN_QV3(options->flag)
            fprintf(stderr, "j=%d aim=%d i %d => ", j, BUFMULT * BUFSIZE, i);
        if  (j > BUFMULT * BUFSIZE && i > 0) i--;
        if  (j < BUFMULT * BUFSIZE && fetchN[i + 1]) i++;
        ifBLIN_QV3(options->flag) fprintf(stderr, "%d\n", i);
        PQEXEC(res, fetchN[i], PGRES_TUPLES_OK, -1)
    }

    PQclear(res);
    if  (!options->intran) {
        PQEXEC(res, "END", PGRES_COMMAND_OK, -1);
        PQclear(res);
    }
    if  (e < 0) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_binsel: write error");
        return(-1);
    }
    ifBLIN_QV3(options->flag) fprintf( stderr, "-pgoblin_binsel %d\n", 0);
    return(0);
}

int
pgoblin_strsel(pgoblin_con *options, char *query, int out) {
    int j, c, k, t;
    PGresult *res;
    char *q;
    size_t i;
    ssize_t e;

    ifBLIN_QV3(options->flag) fprintf( stderr, "+pgoblin_strsel %s out=%d\n"
                                           , query ? query : "NULL"
                                           , out
                                           );
    if  (pgoblin_shurecon(options)) return(-1);
    if  (!(q = query)) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_strsel: No query");
        return(-1);
    }

    if  (!options->intran) {
/*  if  (PQtransactionStatus(options->conn) != PQTRANS_INTRANS) { */
        PQEXEC(res, "BEGIN", PGRES_COMMAND_OK, -1);
        PQclear(res);
    }
    asprintf(&q, "DECLARE pgoblin CURSOR FOR %s", q);
    if  (q == NULL) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_strsel: No memory");
        return(-1);
    }
    PQEXEC(res, q, PGRES_COMMAND_OK, -1);
    PQclear(res);
    free(q);
    i = 0;
    PQEXEC(res, fetchN[i], PGRES_TUPLES_OK, -1);
    if  (!options->tdl) e = 0;
      else e = mife_writ(out, options->tdl->tbeg, 0);

    for (j = 0; (t = PQntuples(res)) > 0 && e >= 0; j = 0) {
        for (k = 0; k < t && e >= 0; k++) {
            if  (e >= 0 && options->tdl && k && i) j += (e = mife_writ(out, options->tdl->rmed, 0));
            if  (e >= 0 && options->tdl) j += (e = mife_writ(out, options->tdl->rbeg, 0));
            for (c = 0; c < PQnfields(res) && e >= 0; c++) {
                if  (e >= 0 && options->tdl && c) j += (e = mife_writ(out, options->tdl->cmed, 0));
                if  (e >= 0 && options->tdl) j += (e = mife_writ(out, options->tdl->cbeg, 0));
                if  (!PQgetisnull(res, k, c))
                    j += (e = mife_writ(out, PQgetvalue(res, k, c), PQgetlength(res, k, c)));
                if  (e >= 0 && options->tdl) j += (e = mife_writ(out, options->tdl->cend, 0));
            }
            if  (e >= 0 && options->tdl) j += (e = mife_writ(out, options->tdl->rend, 0));
        }
        if  (e >= 0 && options->tdl) j += (e = mife_writ(out, options->tdl->tend, 0));
        PQclear(res);
        ifBLIN_QV3(options->flag)
            fprintf(stderr, "j=%d aim=%d i %d => ", j, BUFMULT * BUFSIZE, i);
        if  (j > BUFMULT * BUFSIZE && i > 1) i--;
        if  (j < BUFMULT * BUFSIZE && fetchN[i + 1]) i++;
        ifBLIN_QV3(options->flag) fprintf(stderr, "%d\n", i);
        PQEXEC(res, fetchN[i], PGRES_TUPLES_OK, -1)
    }

    PQclear(res);
    if  (!options->intran) {
        PQEXEC(res, "END", PGRES_COMMAND_OK, -1);
        PQclear(res);
    }
    if  (e < 0) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_strsel: write error");
        return(-1);
    }
    ifBLIN_QV3(options->flag) fprintf( stderr, "-pgoblin_strsel %d\n", 0);
    return(0);
}
