/*-
 * Copyright (C) @BABOLO  2002 Dec 17
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 17\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: cmd_copy.c,v 1.6 2004/11/29 20:36:18 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include <err.h>
#include <libpq-fe.h>
#include "pgoblin.h"

enum fich {fn, fs, fp, fo, fx};
enum finde {finde_beg, finde_eol, finde_bsl, finde_dot, finde_end};
/* static const char *fichn[] = {"fn", "fs", "fp", "fo", "fx"};
 * static const char *finden[] = {"finde_beg", "finde_eol", "finde_bsl", "finde_dot", "finde_end"};
 */

int
pgoblin_copyout(pgoblin_con *options, char *query, int out) {
    int k, f;
    size_t i;
    PGresult *res;
    char *q, buf[BUFSIZE];
    ssize_t e;

    ifBLIN_QV3(options->flag) fprintf( stderr, "+pgoblin_copyout %s out=%d\n"
                                     , query ? query : "NULL"
                                     , out
                                     );
    if  (pgoblin_shurecon(options)) return(-1);

    if  (!(q = query)) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_copyout: No query");
        return(-1);
    }

    PQEXEC(res, q, PGRES_COPY_OUT, -1);

    for (k = 0, e = 0; (f = PQgetline(options->conn, buf, BUFSIZE)) != EOF && e >= 0;) {
        ifBLIN_QV3(options->flag) fprintf(stderr, "%d%d buf=%s\n", k, f, buf);
        if  (!k && strcmp("\\.", buf) == 0) break;
        if  (f == 1) {
            e = mife_writ(out, buf, BUFSIZE - 1);
        } else {
            i = strlen(buf);
            buf[i] = '\n';
            e = mife_writ(out, buf, i + 1);
        }
        k = f;
    }
    if  (e < 0) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_copyout: write error");
        return(-1);
    }
    if  ((f = PQendcopy(options->conn)) != 0) {
        ifBLIN_QV1(options->flag)
            warnx("pgoblin_copyout: PQendcopy failed: %s", PQerrorMessage(options->conn));
        return(-1);
    }
    PQclear(res);
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_copyout %d\n", 0);
    return(0);
}

int
pgoblin_copyin(pgoblin_con *options, char *query, struct mife_descriptor *in) {
    int e = 0;                                                  /*   PQputnbytes */
    ssize_t f = 0;
    PGresult *res;
    char *q, *d;
    enum finde k;
    off_t o;
                                                  /*    "\n\\.\n"    */
    const enum fich fich[256] =
    {fn,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fn,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fp,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fs,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo

    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo ,fo,fo,fo,fo
    };
    const u_char automa[finde_end][fx] =
    /*      fn         fs         fp         fo */
    {{ finde_eol, finde_beg, finde_beg, finde_beg} /*finde_beg*/
    ,{ finde_beg, finde_bsl, finde_beg, finde_beg} /*finde_eol*/
    ,{ finde_beg, finde_beg, finde_dot, finde_beg} /*finde_bsl*/
    ,{ finde_end, finde_beg, finde_beg, finde_beg} /*finde_dot*/
    };

    ifBLIN_QV3(options->flag) fprintf( stderr, "+pgoblin_copyin query=%s in=%s\n"
                                     , query ? query : "NULL"
                                     , in ? "OK" : "NULL"
                                     );
    if  (pgoblin_shurecon(options)) return(-1);
    d = NULL;                                                                 /*   COPY */

    if  (!(q = query)) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_copyin: No query");
        return(-1);
    }

    PQEXEC(res, q, PGRES_COPY_IN, -1);

    if  (!in) {
        ifBLIN_QV1(options->flag) warnx("pgoblin_copyin: No input data");
        return(-1);
    }
                                                                                 /*   mife in */
    for (k = finde_beg, o = 0, f = 1, e = 0; f > 0 && e == 0; o += f) {
        if  ((f = mife_read(in, BUFSIZE, o, NULL)) < 0) {
            ifBLIN_QV1(options->flag) warn("pgoblin_copyin: mife_read");
            return(-1);
        }
        ifBLIN_QV4(options->flag) fprintf(stderr, "mife_read=%d,", f);
        for ( q = mife_get(in, o)
            ; q < (char*)(mife_get(in, o) + f) && k != finde_end
            ; k = automa[k][fich[(u_char)*q++]]
            ) ifBLIN_QV4(options->flag) fprintf(stderr, "%c", *q);
        if  (q - (char*)mife_get(in, o)) {
            e = PQputnbytes(options->conn, mife_get(in, o), q - (char*)mife_get(in, o));
            ifBLIN_QV4(options->flag)
                fprintf(stderr, "\nPQputnbytes=%d %d (%d)\n", e, k, q - (char*)mife_get(in, o));
        } else ifBLIN_QV4(options->flag)
            fprintf(stderr, "\nno PQputnbytes %d (%d)\n", k, q - (char*)mife_get(in, o));
    }
    if  (e == 0 && k != finde_end) {                      /*  ()    */
        const char *enstin = "\n\\.\n";
        ifBLIN_QV3(options->flag) fprintf(stderr, "end=%s~%d\n", &enstin[k], finde_end - k);
        e = PQputnbytes(options->conn, &enstin[k], finde_end - k);
        ifBLIN_QV4(options->flag) fprintf(stderr, "\nPQputnbytes=%d %d (%d)\n", e, k, finde_end - k);
    }
    if  (e) {                                                  /*       */
        ifBLIN_QV1(options->flag)
            warnx("pgoblin_copyin: PQputnbytes failed: %s", PQerrorMessage(options->conn));
        return(-1);
    }
    if  ((e |= PQendcopy(options->conn)) != 0) {                      /*  -  COPY */
        ifBLIN_QV1(options->flag)
            warnx("pgoblin_copyin: PQendcopy failed");
    }
    PQclear(res);
    ifBLIN_QV3(options->flag) fprintf(stderr, "-pgoblin_copyin %d\n", e);
    return(e);
}
