#!BINDIR/pgoblin
 Copyright (C)2013..2024 @BABOLO http://www.babolo.ru/
 pkg = PKG
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 $Id: pgdbt.pgoblin.m4,v 1.9 2024/08/24 01:11:16 babolo Exp $

#connect 0001
sqlite3 :memory:
#job
local -z
#perform 0001
CREATE TEMP TABLE a(i int, a text);
#perform 0001
CREATE TEMP TABLE e(i int, n text, e text);
#getarg  _
#copyin  00_1
COPY a;
#wait
#close   _0_
#getenv  _
#copyin  00_1
COPY e;
#wait
#close   _0_
#echo Q
##Q copy E
#style   00Q00Q
Q
#cat     E
/dev/stderr
#cat     N
/dev/null
#job     00001
local -z
#echo    V
##select  _001
SELECT 'pgsql' || COALESCE(' dbname=' || arg1, '') || ' application_name=PKG
'FROM o
;
##connect 0_02
##perform 0002
CREATE TEMP TABLE f(n text, t text, d text);
##perform 0002
CREATE TEMP TABLE t(n text, t text, c text);
##select  _002
WITH a AS(SELECT COALESCE( (SELECT NOT pg_attribute.attisdropped
                             FROM  pg_catalog.pg_namespace
                              JOIN pg_catalog.pg_class     ON(pg_namespace.oid = pg_class.relnamespace)
                              JOIN pg_catalog.pg_attribute ON(pg_class.oid     = pg_attribute.attrelid)
                             WHERE pg_namespace.nspname = 'pg_catalog'
                               AND pg_class.relname     = 'pg_constraint'
                               AND pg_attribute.attname = 'conparentid'
                           )
                         , FALSE
                         ) AS a
         )
SELECT '
INSERT INTO f
 SELECT conname::text                              AS n
      , conrelid::pg_catalog.regclass::text         AS t
      , pg_catalog.pg_get_constraintdef(c.oid, TRUE) AS d
  FROM  pg_catalog.pg_constraint c
  WHERE c.contype = ''f''' || CASE WHEN a THEN ' AND conparentid = 0' ELSE '' END || '
;
'FROM a
;
##perform 0_02
##select  _002
WITH a AS(SELECT COALESCE( (SELECT NOT pg_attribute.attisdropped
                             FROM  pg_catalog.pg_namespace
                              JOIN pg_catalog.pg_class     ON(pg_namespace.oid = pg_class.relnamespace)
                              JOIN pg_catalog.pg_attribute ON(pg_class.oid     = pg_attribute.attrelid)
                             WHERE pg_namespace.nspname = 'pg_catalog'
                               AND pg_class.relname     = 'pg_constraint'
                               AND pg_attribute.attname = 'conparentid'
                           )
                         , FALSE
                         ) AS a
               , COALESCE( (SELECT NOT pg_attribute.attisdropped
                             FROM  pg_catalog.pg_namespace
                              JOIN pg_catalog.pg_class     ON(pg_namespace.oid = pg_class.relnamespace)
                              JOIN pg_catalog.pg_attribute ON(pg_class.oid     = pg_attribute.attrelid)
                             WHERE pg_namespace.nspname = 'pg_catalog'
                               AND pg_class.relname     = 'pg_constraint'
                               AND pg_attribute.attname = 'indnkeyatts'
                           )
                         , FALSE
                         ) AS b
               , COALESCE( (SELECT NOT pg_attribute.attisdropped
                             FROM  pg_catalog.pg_namespace
                              JOIN pg_catalog.pg_class     ON(pg_namespace.oid = pg_class.relnamespace)
                              JOIN pg_catalog.pg_attribute ON(pg_class.oid     = pg_attribute.attrelid)
                             WHERE pg_namespace.nspname = 'pg_catalog'
                               AND pg_class.relname     = 'pg_class'
                               AND pg_attribute.attname = 'relispartition'
                           )
                         , FALSE
                         ) AS c
               , COALESCE( (SELECT NOT pg_attribute.attisdropped
                             FROM  pg_catalog.pg_namespace
                              JOIN pg_catalog.pg_class     ON(pg_namespace.oid = pg_class.relnamespace)
                              JOIN pg_catalog.pg_attribute ON(pg_class.oid     = pg_attribute.attrelid)
                             WHERE pg_namespace.nspname = 'pg_catalog'
                               AND pg_class.relname     = 'pg_class'
                               AND pg_attribute.attname = 'relrewrite'
                           )
                         , FALSE
                         ) AS d
               , COALESCE( (SELECT NOT pg_attribute.attisdropped
                             FROM  pg_catalog.pg_namespace
                              JOIN pg_catalog.pg_class     ON(pg_namespace.oid = pg_class.relnamespace)
                              JOIN pg_catalog.pg_attribute ON(pg_class.oid     = pg_attribute.attrelid)
                             WHERE pg_namespace.nspname = 'pg_catalog'
                               AND pg_class.relname     = 'pg_class'
                               AND pg_attribute.attname = 'relpartbound'
                           )
                         , FALSE
                         ) AS e
         )
SELECT '
 INSERT INTO t
  WITH a AS(SELECT n.conname AS n
                 , i.indrelid' || CASE WHEN b THEN '
                 , i.indnkeyatts' ELSE '' END || '
                 , i.indisunique
                 , i.indisprimary
                 , i.indisexclusion
                 , i.indimmediate
                 , i.indisclustered
                 , i.indisvalid
                 , i.indcheckxmin
                 , i.indisready
                 , i.indislive
                 , i.indisreplident
                 , i.indkey
                 , i.indcollation
                 , i.indclass
                 , i.indoption
                 , i.indexprs
                 , i.indpred
                 , z.relnamespace
                 , z.reltype
                 , z.reloftype
                 , z.relowner
                 , z.relam
                 , z.reltablespace
                 , z.relpages
                 , z.relallvisible
                 , z.reltoastrelid
                 , z.relhasindex
                 , z.relisshared
                 , z.relpersistence
                 , z.relkind
                 , z.relnatts
                 , z.relchecks
                 , z.relhasrules
                 , z.relhastriggers
                 , z.relhassubclass
                 , z.relrowsecurity
                 , z.relforcerowsecurity
                 , z.relispopulated
                 , z.relreplident' || CASE WHEN c THEN '
                 , z.relispartition' ELSE '' END || CASE WHEN d THEN '
                 , z.relrewrite' ELSE '' END || '
                 , z.relfrozenxid
                 , z.relminmxid
                 , z.relacl
                 , z.reloptions' || CASE WHEN e THEN '
                 , z.relpartbound' ELSE '' END || '
                 , n.connamespace
                 , n.contype
                 , n.condeferrable
                 , n.condeferred
                 , n.convalidated
                 , n.contypid' || CASE WHEN a THEN '
                 , n.conparentid' ELSE '' END || '
                 , n.confrelid
                 , n.confupdtype
                 , n.confdeltype
                 , n.confmatchtype
                 , n.conislocal
                 , n.coninhcount
                 , n.connoinherit
                 , n.conkey
                 , n.confkey
                 , n.conpfeqop
                 , n.conppeqop
                 , n.conffeqop
                 , n.conexclop
             FROM  pg_catalog.pg_index      i
              JOIN pg_catalog.pg_class      z ON(i.indexrelid = z.oid)
              JOIN pg_catalog.pg_constraint n ON(   n.conrelid = i.indrelid
                                                AND n.conindid = i.indexrelid
           )                                    )
     , b AS(SELECT indrelid, l.n
             FROM a s JOIN a l USING(indrelid)
             WHERE s.n <> l.n
               AND l.n ~ (s.n || ''[0-9]+$'')
               AND ( s.indisunique' || CASE WHEN b THEN '
                   , s.indnkeyatts' ELSE '' END || '
                   , s.indisprimary
                   , s.indisexclusion
                   , s.indimmediate
                   , s.indisclustered
                   , s.indisvalid
                   , s.indcheckxmin
                   , s.indisready
                   , s.indislive
                   , s.indisreplident
                   , s.indkey
                   , s.indcollation
                   , s.indclass
                   , s.indoption
                   , s.indexprs
                   , s.indpred
                   , s.relnamespace
                   , s.reltype
                   , s.reloftype
                   , s.relowner
                   , s.relam
                   , s.reltablespace
                   , s.relpages
                   , s.relallvisible
                   , s.reltoastrelid
                   , s.relhasindex
                   , s.relisshared
                   , s.relpersistence
                   , s.relkind
                   , s.relnatts
                   , s.relchecks
                   , s.relhasrules
                   , s.relhastriggers
                   , s.relhassubclass
                   , s.relrowsecurity
                   , s.relforcerowsecurity
                   , s.relispopulated
                   , s.relreplident' || CASE WHEN c THEN '
                   , s.relispartition' ELSE '' END || CASE WHEN d THEN '
                   , s.relrewrite' ELSE '' END || '
                   , s.relfrozenxid
                   , s.relminmxid
                   , s.relacl
                   , s.reloptions' || CASE WHEN e THEN '
                   , s.relpartbound' ELSE '' END || '
                   , s.connamespace
                   , s.contype
                   , s.condeferrable
                   , s.condeferred
                   , s.convalidated
                   , s.contypid' || CASE WHEN a THEN '
                   , s.conparentid' ELSE '' END || '
                   , s.confrelid
                   , s.confupdtype
                   , s.confdeltype
                   , s.confmatchtype
                   , s.conislocal
                   , s.coninhcount
                   , s.connoinherit
                   , s.conkey
                   , s.confkey
                   , s.conpfeqop
                   , s.conppeqop
                   , s.conffeqop
                   , s.conexclop
                   )
                 IS NOT DISTINCT FROM
                   ( l.indisunique' || CASE WHEN b THEN '
                   , l.indnkeyatts' ELSE '' END || '
                   , l.indisprimary
                   , l.indisexclusion
                   , l.indimmediate
                   , l.indisclustered
                   , l.indisvalid
                   , l.indcheckxmin
                   , l.indisready
                   , l.indislive
                   , l.indisreplident
                   , l.indkey
                   , l.indcollation
                   , l.indclass
                   , l.indoption
                   , l.indexprs
                   , l.indpred
                   , l.relnamespace
                   , l.reltype
                   , l.reloftype
                   , l.relowner
                   , l.relam
                   , l.reltablespace
                   , l.relpages
                   , l.relallvisible
                   , l.reltoastrelid
                   , l.relhasindex
                   , l.relisshared
                   , l.relpersistence
                   , l.relkind
                   , l.relnatts
                   , l.relchecks
                   , l.relhasrules
                   , l.relhastriggers
                   , l.relhassubclass
                   , l.relrowsecurity
                   , l.relforcerowsecurity
                   , l.relispopulated
                   , l.relreplident' || CASE WHEN c THEN '
                   , l.relispartition' ELSE '' END || CASE WHEN d THEN '
                   , l.relrewrite' ELSE '' END || '
                   , l.relfrozenxid
                   , l.relminmxid
                   , l.relacl
                   , l.reloptions' || CASE WHEN e THEN '
                   , l.relpartbound' ELSE '' END || '
                   , l.connamespace
                   , l.contype
                   , l.condeferrable
                   , l.condeferred
                   , l.convalidated
                   , l.contypid' || CASE WHEN a THEN '
                   , l.conparentid' ELSE '' END || '
                   , l.confrelid
                   , l.confupdtype
                   , l.confdeltype
                   , l.confmatchtype
                   , l.conislocal
                   , l.coninhcount
                   , l.connoinherit
                   , l.conkey
                   , l.confkey
                   , l.conpfeqop
                   , l.conppeqop
                   , l.conffeqop
                   , l.conexclop
           )       )
  SELECT n.nspname, c.relname, b.n
   FROM                          b
    JOIN pg_catalog.pg_class     c ON(b.indrelid = c.oid)
    JOIN pg_catalog.pg_namespace n ON(n.oid = c.relnamespace)
;
'FROM a
;
##perform 0_02
#echo    U
##U pgo0
## help  ##################################################################################  help  ####
###echo
Using: pgdbt.pgoblin[ -?nr][ op[ arg1[ arg2...]]]
 -?         - This text
 -n         - zero sized object not indicated
 -r         - reverse output order
    vol     - Total disk space used by tablespaces.
    space   - Disk space used by objects.
                arg1 - DB name.
                arg2 - tablespace name.
    tab     - Total disk space used by tables.
                arg1 - DB name.
                arg2 - tablespace name.
    ddcon   - Show doubled constraints
                arg1 - DB name.
    rmcon   - Delete doubled constraints
                arg1 - DB name.
    copyall - COPY all tables to directory
                arg1 - DB name.
                arg2 - directory path

###
## vol  ####################################################################################  vol  ####
###select  _001
SELECT 'pgsql' || COALESCE(' dbname=' || arg1, '') || ' application_name=PKG
'FROM o
;
###connect 0_02
###select  _002
SELECT pg_tablespace_size(pg_tablespace.oid), pg_tablespace.spcname FROM pg_catalog.pg_tablespace;
###echo
size	tablespace

###display 00_00Q
###
## space  ################################################################################  space  ####
###select  _001
SELECT 'pgsql' || COALESCE(' dbname=' || arg1, '') || ' application_name=PKG
'FROM o
;
###connect 0_02
###select  1001
SELECT '
 WITH d AS(SELECT pg_tablespace.spcname AS d
            FROM pg_catalog.pg_database
             JOIN pg_catalog.pg_tablespace ON(pg_database.dattablespace = pg_tablespace.oid)
            WHERE current_database() = pg_database.datname
          )
    , a AS(SELECT pg_table_size(pg_class.oid) / 1024 AS s
                , COALESCE(t.relname, i.relname)    AS p
                , pg_class.reltablespace           AS v
                , pg_namespace.nspname            AS o
                , pg_class.relkind               AS k
                , pg_class.relname              AS n
            FROM       pg_catalog.pg_class
             LEFT JOIN pg_catalog.pg_namespace  ON(pg_class.relnamespace = pg_namespace.oid)
             LEFT JOIN pg_catalog.pg_class t  ON(pg_class.oid = NULLIF(t.reltoastrelid, 0))
             LEFT JOIN pg_catalog.pg_index ON(pg_class.oid = pg_index.indexrelid)
             LEFT JOIN pg_catalog.pg_class i ON(i.oid = pg_index.indrelid)
          )
 SELECT k, s' || CASE WHEN arg2 IS NULL THEN ', pg_tablespace.spcname' ELSE '' END || ', o, p, n
  FROM       d
        JOIN a ON(TRUE)
   LEFT JOIN pg_catalog.pg_tablespace ON(CASE WHEN a.v = 0
                                              THEN d.d = pg_tablespace.spcname
                                              ELSE a.v = pg_tablespace.oid
                                         END
                                        )
  WHERE COALESCE($1 = pg_tablespace.spcname, TRUE)
    AND (s > 0 OR $2 = 0)
 ORDER BY s ' || CASE WHEN r THEN 'ASC' ELSE 'DESC' END || '
;
'FROM o
;
###select  2001
SELECT arg2, n FROM o;
###select  _122
###select  0001
SELECT 'type	size'
     , CASE WHEN arg2 IS NULL THEN '	tablespace' ELSE '' END
     , '	shema		which	name
'FROM o
;
###display 00_00Q
###
## tab  ####################################################################################  tab  ####
###select  _001
SELECT 'pgsql' || COALESCE(' dbname=' || arg1, '') || ' application_name=PKG
'FROM o
;
###connect 0_02
###select  2001
SELECT '
 SELECT pg_class.relkind
      , pg_total_relation_size(pg_class.oid) / 1024 AS i
      , pg_namespace.nspname
      , pg_class.relname
  FROM       pg_catalog.pg_class
   LEFT JOIN pg_catalog.pg_namespace ON(pg_namespace.oid = pg_class.relnamespace)
  WHERE pg_class.relkind IN(''r'', ''m'')'
    || CASE WHEN n THEN '
    AND pg_total_relation_size(pg_class.oid) / 1024 > 0' ELSE '' END || '
 ORDER BY pg_total_relation_size(pg_class.oid)' || CASE WHEN r THEN '' ELSE ' DESC' END || '
;
'FROM o
;
###select  _202
###echo
type	size	schema		name

###display 00_00Q
###
## tabs  ##################################################################################  tabs  ####
###select  _001
SELECT 'pgsql' || COALESCE(' dbname=' || arg1, '') || ' application_name=PKG
'FROM o
;
###connect 0_02
###select  1001
SELECT arg2 FROM o;
###select  2001
SELECT '
 WITH d AS(SELECT pg_tablespace.spcname AS d
            FROM pg_catalog.pg_database
             JOIN pg_catalog.pg_tablespace ON(pg_database.dattablespace = pg_tablespace.oid)
            WHERE current_database() = pg_database.datname
          )
    , a AS(SELECT CASE WHEN j.oid IS NOT NULL
                       THEN j.relname
                       WHEN t.oid IS NOT NULL
                       THEN t.relname
                       WHEN i.oid IS NOT NULL
                       THEN i.relname
                       ELSE pg_class.relname
                  END                             AS p
                , CASE WHEN j.oid IS NOT NULL
                       THEN j.relnamespace
                       WHEN t.oid IS NOT NULL
                       THEN t.relnamespace
                       WHEN i.oid IS NOT NULL
                       THEN i.relnamespace
                       ELSE pg_class.relnamespace
                  END                             AS o
                , pg_class.reltablespace            AS v
                , pg_table_size(pg_class.oid) / 1024 AS s
            FROM       pg_catalog.pg_class
             LEFT JOIN pg_catalog.pg_class t ON(pg_class.oid = NULLIF(t.reltoastrelid, 0))
             LEFT JOIN pg_catalog.pg_index   ON(pg_class.oid = pg_index.indexrelid)
             LEFT JOIN pg_catalog.pg_class i ON(i.oid = pg_index.indrelid)
             LEFT JOIN pg_catalog.pg_index g ON(pg_class.oid = g.indexrelid)
             LEFT JOIN pg_catalog.pg_class q ON(q.oid = g.indrelid)
             LEFT JOIN pg_catalog.pg_class j ON(q.oid = NULLIF(j.reltoastrelid, 0))
          )
 SELECT SUM(s), pg_namespace.nspname, p
  FROM       d
        JOIN a ON(TRUE)
   LEFT JOIN pg_catalog.pg_namespace  ON(a.o = pg_namespace.oid)
   LEFT JOIN pg_catalog.pg_tablespace ON(CASE WHEN a.v = 0
                                              THEN d.d = pg_tablespace.spcname
                                              ELSE a.v = pg_tablespace.oid
                                         END
                                        )
  WHERE $1 = pg_tablespace.spcname
 GROUP BY pg_namespace.nspname, p, pg_tablespace.spcname'
    || CASE WHEN n THEN '
 HAVING SUM(s) > 0' ELSE '' END
    || '
 ORDER BY SUM(s)' || CASE WHEN r THEN '' ELSE ' DESC' END || ', pg_namespace.nspname, p
;
'FROM o
;
###select  _212
###display 00_00Q
###
## ormcon  ##############################################################################  ormcon  ####
###eval    0V
###select  _002
WITH j AS(SELECT t, s.n AS s, l.n AS l, d
           FROM f s JOIN f l USING(t, d)
           WHERE s.n <> l.n AND l.n ~ (s.n || '[0-9]+$')
         )
SELECT '
####perform 0002
ALTER TABLE ONLY ' || j.t || ' DROP CONSTRAINT ' || j.l || ' RESTRICT;
'FROM j LEFT JOIN j n ON(j.s = n.l) WHERE n.l IS NULL
ORDER BY j.t, j.s, j.l
;
###echo    1_
###trap
###return
###eval    01
###untrap
###
##
## oddcon  ##############################################################################  oddcon  ####
###eval    0V
###select  _002
WITH j AS(SELECT t, s.n AS s, l.n AS l, d
           FROM f s JOIN f l USING(t, d)
           WHERE s.n <> l.n AND l.n ~ (s.n || '[0-9]+$')
         )
SELECT j.t, j.l
 FROM j LEFT JOIN j n ON(j.s = n.l)
 WHERE n.l IS NULL
ORDER BY j.t, j.s, j.l
;
###display 00_00Q
## rmcon  ################################################################################  rmcon  ####
###eval    0V
###select  _002
SELECT '
####perform 0002
ALTER TABLE ONLY ' || quote_ident(n) || '.' || quote_ident(t)
    || ' DROP CONSTRAINT ' || quote_ident(c) || ' RESTRICT;
'FROM t
ORDER BY n, t, c
;
###echo    1_
###trap
###return
###eval    01
###untrap
###
##
## ddcon  ################################################################################  ddcon  ####
###eval    0V
###select  _002
SELECT quote_ident(n) || '.' || quote_ident(t), c FROM t ORDER BY n, t, c;
###display 00_00Q
## copyall  ############################################################################  copyall  ####
####close   101
####clear   1
###select  _001
SELECT 'pgsql' || COALESCE(' dbname=' || arg1, '') || ' application_name=PKG
'FROM o
;
###connect 0_02
###select  1001
SELECT '/bin/sh', '-c', '/bin/mkdir -p ' || quote_literal(arg2) FROM o;
###exec    01
###wait
###select  3001
SELECT arg2 FROM o;
###select  1032
SELECT '
####cat     2
' || $1 || '/'|| nspname || '.' || relname || '
####copyout 2002
COPY ' || quote_ident(nspname) || '.' || quote_ident(relname) || ' TO stdout;
####close   202
####clear   2
'FROM pg_class JOIN pg_namespace ON(relnamespace = pg_namespace.oid)
 WHERE nspname !~ '^pg_' AND nspname <> 'information_schema' AND relkind = 'r' AND relfilenode > 0
;
###eval   01
#style   00U00U  ######################################################################################
U
#perform 0001
CREATE TEMP TABLE o
     ( opt      int  --  
     , qu       int  -- -?
     , n        int  -- -n
     , r        int  -- -r
     , dd       text -- 
     , arg1     text -- 
     , arg2     text -- 
     , arg3     text -- 
     , arg4     text -- 
     )
;
#perform 0001
INSERT INTO o
 VALUES( 0
       , 0
       , 0
       , 0
       , 'db'
       , NULL
       , NULL
       , NULL
       , NULL
       )
;
#perform 0001
UPDATE o SET opt = 1
 WHERE EXISTS(SELECT 1 FROM a WHERE i = 1 AND a REGEXP '^-')
;
#perform 0001
UPDATE o SET qu = 1, dd = 'help'
 WHERE EXISTS(SELECT 1 FROM a WHERE i = 1 AND a REGEXP '\?')
   AND opt
;
#perform 0001
UPDATE o SET n = 1
 WHERE EXISTS(SELECT 1 FROM a WHERE i = 1 AND a REGEXP 'n')
   AND opt
;
#perform 0001
UPDATE o SET r = 1
 WHERE EXISTS(SELECT 1 FROM a WHERE i = 1 AND a REGEXP 'r')
   AND opt
;
#perform 0001
UPDATE a SET i = i - 1;
#perform 0001
UPDATE a SET i = i - 1 WHERE EXISTS(SELECT 1 FROM o WHERE opt);
#perform 0001
DELETE FROM a WHERE i < 0;
#perform 0001
UPDATE o SET dd = (SELECT a FROM a WHERE i = 0 LIMIT 1);
#perform 0001
UPDATE o SET arg1 = (SELECT a FROM a WHERE i = 1 LIMIT 1);
#perform 0001
UPDATE o SET arg2 = (SELECT a FROM a WHERE i = 2 LIMIT 1);
#perform 0001
UPDATE o SET arg3 = (SELECT a FROM a WHERE i = 3 LIMIT 1);
#perform 0001
UPDATE o SET arg4 = (SELECT a FROM a WHERE i = 4 LIMIT 1);
#perform 0001
UPDATE o SET dd = 'help'
 WHERE dd IS NULL
;
#perform 0001
UPDATE o SET dd = 'tabs'
 WHERE dd = 'tab'
   AND arg2 IS NOT NULL
;
#select  1001
SELECT dd FROM o;
#echo    u1000U
#eval    0u
#close   u0u
#wait
#exit
