#!/usr/local/bin/pgoblin -f
  Copyright (C)2019..2021 @BABOLO http://www.babolo.ru/
--PKG = mini-cipa
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: journal.pgoblin.m4,v 1.76 2021/10/30 10:18:03 babolo Exp $

#begin   0002  ################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@    @@@@
#select  1001
SELECT '
 DROP TABLE IF EXISTS public.cipaj CASCADE;
 DROP TABLE IF EXISTS public.cipaf CASCADE;
'FROM v WHERE v < 1.14
;
#perform 0102
#perform 0002  ####################################################     cipaf  ####
CREATE SEQUENCE IF NOT EXISTS public.cipaf_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipaf
     ( f   int8    PRIMARY KEY DEFAULT nextval('public.cipaf_q')
     , m   text    NOT NULL
     , v   text    NOT NULL
     , d   regproc
     , UNIQUE(m, v)
     )
;
#perform 0002  ####################################################################   cipaj  ####
CREATE SEQUENCE IF NOT EXISTS public.cipaj_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipaj
     ( j int8        PRIMARY KEY DEFAULT nextval('public.cipaj_q')
     , t timestamptz DEFAULT now()
     , f int         NOT NULL REFERENCES cipaf
     , w text[]
     , u numeric[]
     )
;
#perform 0002
ALTER TABLE IF EXISTS public.cipaj ALTER t TYPE timestamptz;
#perform 0002
ALTER TABLE IF EXISTS public.cipaj ALTER u TYPE numeric[];
#perform 0002
ALTER SEQUENCE public.cipaf_q OWNED BY public.cipaf.f;
#perform 0002
ALTER SEQUENCE public.cipaj_q OWNED BY public.cipaj.j;
#perform 0002
SELECT setval('public.cipaf_q', COALESCE(MAX(cipaf.f) + 1, 0), FALSE) FROM public.cipaf;
#perform 0002
SELECT setval('public.cipaj_q', COALESCE(MAX(cipaj.j) + 1, 0), FALSE) FROM public.cipaj;
#end     0002  ################
#perform 0002
COMMENT ON TABLE public.cipaf        IS '  ';
COMMENT ON COLUMN public.cipaf.f        IS ' OID';
COMMENT ON COLUMN public.cipaf.m        IS ',    ';
COMMENT ON COLUMN public.cipaf.v        IS '   ';
COMMENT ON COLUMN public.cipaf.d        IS ' ';
#perform 0002
COMMENT ON TABLE public.cipaj        IS '';
COMMENT ON COLUMN public.cipaj.j        IS ' OID';
COMMENT ON COLUMN public.cipaj.t        IS ' ';
COMMENT ON COLUMN public.cipaj.f        IS '   ';
COMMENT ON COLUMN public.cipaj.w        IS ' ';
COMMENT ON COLUMN public.cipaj.u        IS ' ';
#perform 0002
COMMENT ON SEQUENCE public.cipaf_q IS '  ';
#perform 0002
COMMENT ON SEQUENCE public.cipaj_q IS '  ';
#perform 0002  ##############################################     cipaj0(cipaj)  ####
CREATE OR REPLACE FUNCTION public.cipaj0(public.cipaj) RETURNS text
 AS 'SELECT array_to_string($1.w, '' '') || '' '' || array_to_string($1.u, '' '');'
 LANGUAGE 'sql'
 STABLE
 STRICT
 PARALLEL SAFE
;
#perform 0002
COMMENT ON FUNCTION public.cipaj0(public.cipaj)
 IS '   ,    ,     cipaf'
;
#perform 0002  ##############################################     cipajo(cipaj)  ####
CREATE OR REPLACE FUNCTION public.cipajo(public.cipaj) RETURNS text AS
$$
  DECLARE
    t public.cipaj%ROWTYPE;
    r text;
    u text;
  BEGIN
    t = $1;
    SELECT d::text INTO STRICT u FROM public.cipaf WHERE cipaf.f = t.f;
    EXECUTE 'SELECT ' || u || '(cipaj) FROM public.cipaj WHERE cipaj.j = $1;'
     INTO STRICT r
     USING t.j
    ;
    RETURN r;
  END;
$$
 LANGUAGE 'plpgsql'
 STABLE
 STRICT
 PARALLEL SAFE
;
#perform 0002
COMMENT ON FUNCTION public.cipaj0(public.cipaj)
 IS '     ,     '
;
#perform 0002  #################################################################     ####
CREATE SEQUENCE IF NOT EXISTS public.cipatijet;
#perform 0002
COMMENT ON SEQUENCE public.cipatijet IS '   ';
#perform 0002  #################################################################    ####
CREATE OR REPLACE FUNCTION public.cipajoder(text, text)
 RETURNS int8
 AS 'WITH r AS(INSERT INTO public.cipaf(m, v)
                SELECT $1::text, $2::text
               ON CONFLICT DO NOTHING
               RETURNING f, m, v
              )
     SELECT f
      FROM(SELECT f, 2 AS p FROM r
          UNION
           SELECT f, 0 FROM public.cipaf WHERE (m, v) = ($1, $2)
          )d
     ORDER BY p
     LIMIT 1
    '
 LANGUAGE 'sql'
 VOLATILE
 STRICT
 PARALLEL UNSAFE
;
#perform 0002
COMMENT ON FUNCTION public.cipajoder(text, text)
 IS '.      '
;
#select  10b2  ###########################################################################    ####
SELECT '
 GRANT SELECT
  ON public.cipaf_q
   , public.cipaf
   , public.cipaj_q
   , public.cipaj
   , public.cipatijet
  TO cipa, root, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#perform 0002
GRANT INSERT ON public.cipaj, public.cipaf TO cipa;
#select  10b2
SELECT '
 GRANT USAGE ON public.cipaj_q, public.cipaf_q, public.cipatijet
  TO cipa, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#perform 0002
GRANT EXECUTE ON FUNCTION public.cipaj0(public.cipaj)
                        , public.cipajo(public.cipaj)
                        , public.cipajoder(text, text)
 TO cipa
;
#
