#!/usr/local/bin/pgoblin -f
  Copyright (C)2019..2022 @BABOLO http://www.babolo.ru/
--pkg = PKG
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: cipaxn.pgoblin.m4,v 1.6 2022/04/30 03:07:36 babolo Exp $

#perform 0002  ################################################       cipaxn  ####
CREATE OR REPLACE VIEW public.cipaxn AS
 WITH r AS(SELECT cipain, cipalan, renum, cipath, ciparg
            FROM public.cipago JOIN public.ciparun USING(cipain) JOIN public.cipalan USING(cipalan)
          )
dnl     
    , h AS(SELECT hiename
                , cipalevel
                , public.bytearrsum(public.bytearrmask(cipalan.resource, cipamask.cipamask)) AS hieload
            FROM  public.cipalan
             JOIN r USING(cipalan)
                , public.cipamask
             JOIN unnest(renum) WITH ORDINALITY AS hiename ON(ordinality - 1 = cipalevel)
             WHERE hiename IS NOT NULL
           GROUP BY hiename, cipalevel
          )
dnl  ,    
  SELECT cipago.*, plan <= now() AS ready
   FROM (SELECT cipalan, cipain, public.bytearrsum(hieload) AS load
          FROM       (SELECT j.cipalan, j.cipain, hiename, ordinality - 1 AS cipalevel
                       FROM (
dnl   ,    selflock  selfgr    
                             SELECT cipago.cipalan, cipago.cipain, cipago.renum
                              FROM public.cipago JOIN public.cipalan USING(cipalan)
                              WHERE cipago.cipain NOT IN(SELECT cipain FROM public.ciparun)
                                AND cipago.cipain NOT IN(SELECT cipain FROM public.cipaut WHERE actual)
                                AND NOT (   cipalan.selfgr
                                        AND cipalan.cipalan IN(SELECT cipalan
                                                                FROM r
                                                                WHERE cipago.ciparg ==* r.ciparg
                                                                  AND cipago.cipalan = r.cipalan
                                        )                     )
                                AND NOT EXISTS(SELECT
                                                FROM r
                                                WHERE public.compare( cipalan.selflock
                                                                    , cipalan.cipath || cipago.ciparg
                                                                    , r.cipath || r.ciparg
                                              )                     )
                            )j
                          , unnest(renum) WITH ORDINALITY AS hiename
                       WHERE j.cipain NOT IN(SELECT cipain FROM public.ciparun)
                         AND hiename IS NOT NULL
                     )a
           LEFT JOIN h USING(hiename, cipalevel)
         GROUP BY cipalan, cipain
        )b
    JOIN public.cipalan USING(cipalan)
    JOIN public.cipago  USING(cipain, cipalan)
   WHERE public.bytearrmax(public.bytearradd(cipalan.resource, b.load)) < 255
;
#perform 0002
CREATE OR REPLACE RULE cipadn AS
    ON DELETE TO public.cipaxn
    DO INSTEAD
    ( SELECT * FROM public.cipaun(OLD.cipain)
    ; NOTIFY cipaxn
    )
;
#perform 0002
CREATE OR REPLACE RULE cipain AS
    ON INSERT TO public.cipaxn
    DO INSTEAD
    ( INSERT INTO public.cipago(cipaher, cipalan, ciparg, plan, prii, renum)
       SELECT NEW.cipaher
            , NEW.cipalan
            , NEW.ciparg
            , COALESCE(NEW.plan, now())
            , COALESCE(NEW.prii, make_interval(0, 0, 0, 0, 0, 0, param::int4))
            , array_fill(0, ARRAY[1], ARRAY[0])
           || (SELECT array_agg(public.cipadecoder(COALESCE((cipalan.cipath || NEW.ciparg)[r], n))
                                ORDER BY ordinality
                               )
                FROM public.cipalan, unnest(cipalan.resar, cipalan.renul) WITH ORDINALITY AS u(r, n)
                WHERE cipalan.cipalan = NEW.cipalan
              )
        FROM public.ciparam
        WHERE (m, v) = ('PKG', 'defaultprio')
      RETURNING cipain
              , cipaher
              , cipalan
              , ciparg
              , plan
              , prii
              , try
              , renum
              , FALSE
    )
;
#perform 0002
CREATE OR REPLACE RULE cipaun AS
    ON UPDATE TO public.cipaxn
    DO INSTEAD
    ( UPDATE public.cipago
         SET ciparg = NEW.ciparg
           , plan   = NEW.plan
           , prii   = NEW.prii
           , try    = NEW.try
           , renum  = public.dorenum(cipain)
       WHERE cipain = NEW.cipain
      RETURNING cipain
              , cipaher
              , cipalan
              , ciparg
              , plan
              , prii
              , try
              , renum
              , FALSE
    )
;
#perform 0002
COMMENT ON VIEW public.cipaxn            IS '  ';
COMMENT ON COLUMN public.cipaxn.cipain      IS '  ';
COMMENT ON COLUMN public.cipaxn.cipaher     IS '    period';
COMMENT ON COLUMN public.cipaxn.cipalan     IS '  public.cipalan';
COMMENT ON COLUMN public.cipaxn.ciparg      IS ' ';
COMMENT ON COLUMN public.cipaxn.plan        IS '  ';
COMMENT ON COLUMN public.cipaxn.prii        IS '';
COMMENT ON COLUMN public.cipaxn.try         IS '  ';
COMMENT ON COLUMN public.cipaxn.renum       IS '   ';
COMMENT ON COLUMN public.cipaxn.ready       IS '  , , , ';
#select  10b2  ###########################################################################    ####
SELECT 'GRANT SELECT ON public.cipaxn TO cipa, root, ' || quote_ident($1::text) || ';';
#perform 0102
#perform 0002
GRANT INSERT ON public.cipaxn TO cipa;
#perform 0002
GRANT DELETE ON public.cipaxn TO root;
#
