#!/usr/local/bin/pgoblin -f
  Copyright (C)2019..2021 @BABOLO http://www.babolo.ru/
--PKG = mini-cipa
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: cipatree.pgoblin.m4,v 1.6 2021/10/30 10:18:03 babolo Exp $

#perform 0002  ###############  API ,     cipatree(int8)  ####
CREATE OR REPLACE FUNCTION public.cipatree(cipain int8)
 RETURNS SETOF public.cipacome
 AS $tree$
    WITH a AS(WITH RECURSIVE r AS(SELECT cipacome.cipain, cipacut.cipaut
                                   FROM public.cipacome LEFT JOIN public.cipacut USING(cipain)
                                   WHERE cipacome.cipain = $1
                                 UNION
                                  SELECT cipacome.cipain, cipacut.cipaut
                                   FROM       public.cipacome
                                    LEFT JOIN public.cipacut USING(cipain)
                                         JOIN r ON(cipacome.cipain = r.cipaut)
                                 )
              SELECT DISTINCT cipain
               FROM r
             )
    SELECT cipacome.* FROM a JOIN public.cipacome USING(cipain)
$tree$
 LANGUAGE 'sql'
 STABLE
 STRICT
 PARALLEL SAFE
;
#perform 0002
COMMENT ON FUNCTION public.cipatree(cipain int8)
 IS '     ,  (cipain)'
;
#perform 0002  #####################  ,     cipatree(...)  ####
CREATE OR REPLACE FUNCTION public.cipatree
     ( cipain  int8
     , waitout int8[]
     , ciparg  text[]
     , plan    timestamptz
     , prio    int4
     )
 RETURNS SETOF public.cipago
 AS $tree$
    DECLARE
        i RECORD;
    BEGIN
        SET LOCAL client_min_messages = 'WARNING';
        DROP TABLE IF EXISTS "cipatree copy cupport a";
        DROP TABLE IF EXISTS "cipatree copy cupport b";
        DROP TABLE IF EXISTS "cipatree copy cupport d";
        DROP TABLE IF EXISTS "cipatree copy cupport z";
        SET LOCAL client_min_messages TO DEFAULT;
dnl      
        CREATE TEMP TABLE "cipatree copy cupport a"
         ON COMMIT DROP
         AS WITH RECURSIVE
                 r AS (SELECT 0 AS ord, cipacome.cipain, cipacut.cipaut
                        FROM public.cipacome LEFT JOIN public.cipacut USING(cipain)
                        WHERE cipacome.cipain = $1
                      UNION
                       SELECT r.ord + 1 AS ord, cipacome.cipain, cipacut.cipaut
                        FROM       public.cipacome
                         LEFT JOIN public.cipacut USING(cipain)
                              JOIN r ON(cipacome.cipain = r.cipaut)
                      )
            SELECT *
             FROM r
    ;
dnl      
        CREATE TEMP TABLE "cipatree copy cupport b"
         ON COMMIT DROP
         AS SELECT MAX(a.ord) AS ord, a.cipain
             FROM "cipatree copy cupport a" a
            GROUP BY a.cipain
    ;
dnl      
        CREATE TEMP TABLE "cipatree copy cupport d"
         ON COMMIT DROP
         AS SELECT DISTINCT a.cipain, a.cipaut
             FROM "cipatree copy cupport a" a
    ;
dnl     
        CREATE TEMP TABLE "cipatree copy cupport z"(cipain int8, cipaher int8) ON COMMIT DROP;

        FOR i
         IN SELECT row_number() OVER(ORDER BY b.ord DESC) AS row
                 , b.cipain
                 , COALESCE($4, now()) + cipacome.splan AS plan
             FROM "cipatree copy cupport b" b JOIN public.cipacome USING(cipain)
            ORDER BY row
        LOOP
            RETURN QUERY
             WITH y AS(SELECT i.cipain
                            , array_remove(array_agg(d.cipaut), NULL) AS waitout
                        FROM "cipatree copy cupport d" d
                         LEFT JOIN "cipatree copy cupport z" z ON(d.cipaut = z.cipaher)
                        WHERE d.cipain = i.cipain
                       GROUP BY i.cipain
                      )
                , x AS(INSERT INTO public.cipago(cipaher, cipalan, ciparg, plan, prii)
                        SELECT i.cipain
                             , cipacome.cipalan
                             , cipacome.ciparg || $3
                             , i.plan
                             , COALESCE(make_interval(0, 0, 0, 0, 0, 0, $5::int8), cipacome.prii)
                         FROM public.cipacome JOIN y USING(cipain)
                         WHERE y.cipain = i.cipain
                        RETURNING cipago.*
                      )
                , v AS(INSERT INTO public.cipaut(cipain, cipaut)
                         SELECT DISTINCT x.cipain, z.cipain AS cipaut
                          FROM  x
                             , (SELECT y.cipain, unnest(y.waitout) AS cipaher FROM y)h
                           JOIN "cipatree copy cupport z" z USING(cipaher)
                       RETURNING cipaut.*
                      )
                , w AS(INSERT INTO "cipatree copy cupport z"
                        SELECT x.cipain, x.cipaher
                         FROM x
                      )
             SELECT x.*
              FROM x
    ;
        END LOOP
    ;
        INSERT INTO public.cipaut(cipain, cipaut)
         SELECT z.cipain, unnest($2)
          FROM (SELECT DISTINCT z.cipain FROM "cipatree copy cupport z" z)z
    ;
        UPDATE public.cipago
           SET renum = public.dorenum(cipago.cipain)
         FROM (SELECT DISTINCT z.cipain FROM "cipatree copy cupport z" z)z
         WHERE cipago.cipain = z.cipain
    ;
        NOTIFY cipaxn;
        RETURN;
    END;
$tree$
LANGUAGE 'plpgsql'
 VOLATILE
 PARALLEL UNSAFE
;
#perform 0002
COMMENT ON FUNCTION public.cipatree
     ( cipain  int8
     , waitout int8[]
     , ciparg  text[]
     , plan    timestamptz
     , prio    int4
     )
 IS ',    ,  (cipain, waitout, ciparg, plan, prio)'
;
#select  10b2  ###########################################################################    ####
SELECT 'GRANT EXECUTE ON FUNCTION public.cipatree(cipain int8)
 TO cipa, root, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
#select  10b2
SELECT 'GRANT EXECUTE ON FUNCTION public.cipatree
     ( cipain  int8
     , waitout int8[]
     , ciparg  text[]
     , plan    timestamptz
     , prio    int4
     )
 TO cipa, root, ' || quote_ident($1::text) || '
;
'
;
#perform 0102
