#!/bin/sh -SHBANGPARM
#  Copyright (C)2019..2025 @BABOLO http://www.babolo.ru/
#--PKG = mini-cipa
#  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: minicipa_worker.m4,v 1.20 2025/08/05 22:17:18 babolo Exp $

iam="`/bin/realpath \"${0}\"`"
cd /
export TMPDIR=/tmp
export LANG=C

CIPA=`/usr/bin/basename ${0%_worker}`
CIPA_CONF=CONFDIR/${CIPA}.conf
. ${CIPA_CONF}

case "${1}" in
0)  sepa='0'
    ;;
1)  sepa='1'
    ;;
*)  sepa=''
    ;;
esac

pidfile="/var/run/${CIPA}_worker${sepa}.pid"

if  [ -r ${pidfile} ]; then
    pidd="`/usr/bin/head -1 ${pidfile}`"
    if  [ -n "${pidd}" ]; then
        y=` /bin/ps -ax ${pidd}                                           \
          | /usr/bin/awk '/\/bin\/sh/{   if (  ($5 ~ /\/bin\/sh/)         \
                                            && ($6 ~ /-Tm/)               \
                                            && ($7 ~ /.*\/PROTOVER_worker/)\
                                            ) {                           \
                                            print "yes"                   \
                                     }   }                                \
                         '                                                \
          `
        if  [ "${y}" = "yes" ]; then
            /bin/kill -INT ${pidd}
            cnt=0
            while [ -r ${pidfile} -a ${cnt} -lt 20 ]; do
                /bin/sleep 1
                cnt=$(( ${cnt} + 1 ))
            done
            if  [ -r ${pidfile} ]; then
                /bin/kill -TERM ${pidd}
fi; fi; fi; fi

/bin/rm -f ${pidfile}
mypid=$$
/bin/echo "${mypid}" > ${pidfile}
/bin/echo "`/bin/date '+Start %F %T'` ${sepa}" >> ${pidfile}
zass=''

dodo=`printf '
child=\`/bin/ps -axlww\
      | /usr/bin/awk "
BEGIN{   ORS = \\\" \\\"
}
/${CIPA}_worker/ && /pgoblin/{
    if  (\\\\\\\\\\\\\\\$3 == ${mypid}) print \\\\\\\\\\\\\\\$2
}
"
\`
child="\`/bin/ps -axlww\
       | /usr/bin/awk \"{if  (\\\\\\\\\\\\\\\$3 == \\\${child}) print \\\\\\\\\\\\\\\$2}\"\
       \` ${child}\
      "
/bin/kill -TERM ${child}
cnt=0
while [ ${cnt} -lt 20 ]; do
    /bin/sleep 1
    cnt=$(( ${cnt} + 1 ))
    prc=0
    for i in ${child}; do
        if  /bin/kill -0 ${i}; then
            prc=$(( ${prc} + 1 ))
        fi
    done
    if  [ ${prc} -eq 0 ]; then
        exit
    fi
done
exit
'`

# --  pidfile
trap " /usr/bin/logger -t ${CIPA}_worker -p daemon.err \"${CIPA} ${sepa} stop ${mypid} \`/bin/date '+%F %T'\`\"\
     ; /bin/echo \"${CIPA}_worker ${sepa} stop ${mypid} \`/bin/date '+%F %T'\`\" >> /var/log/"${CIPA}".log    \
     ; /bin/rm -f ${pidfile}                                                                       \
     ; exit ${zass}                                                                                \
     " EXIT

# --    
trap "${dodo}" TERM

# --  
stop=''
trap "stop='stop'" INT

# -- endless loop
/usr/bin/logger -t ${CIPA} -p daemon.err "${CIPA}_worker ${sepa} start ${mypid} `/bin/date '+%F %T'`"
/bin/echo "${CIPA}_worker ${sepa} start ${mypid} `/bin/date '+%F %T'`" >> /var/log/"${CIPA}".log
while [ -z "${stop}" ]; do
    BINDIR/pgoblin -f "${iam}" "${sepa}" >> /var/log/"${CIPA}".log 2>&1
    zass=$?
    if  [ ${zass} -ne 0 ]; then
        /usr/bin/logger -t ${CIPA} -p daemon.err "${CIPA}_worker ${sepa} fails `/bin/date '+%F %T'`"
    fi
done

exit

#!BINDIR/pgoblin
#echo      Q
##Q copy E
#style     00Q00Q
Q
#connect   0001
sqlite2 :memory:
#connect   0002
pgsql dbname=MINICIPA requirepeer=postgres application_name=minicipa
#cat       N
/dev/null
GETARG(, 1, 1)
#clear     101
#select    a001
SELECT (SELECT a FROM a WHERE i = 0);
#select    20a1
SELECT '
 INSERT INTO public.ciparun(cipain)
  SELECT x.cipain
   FROM public.cipaxn' || c.c || ' x
   WHERE ready
  ORDER BY public.cipagonext(try, prii, plan)
  LIMIT 1
 RETURNING ciparun.cipain
;
'FROM (SELECT CASE WHEN b.b = 0 OR b.b = 1 THEN '2' || b.b ELSE '' END AS c FROM (SELECT ? AS b)b)c
;
#begin     0002
BEGIN ISOLATION LEVEL SERIALIZABLE;
#select    s202
#end       0002
#perform   0001
CREATE TEMP TABLE f(cipain int8);
#perform   00s1
INSERT INTO f VALUES(?);
#fork      00N    #####################################################################################
#cat       E
/var/log/MINICIPA.log
#perform   0002
CREATE TEMP TABLE t
     ( cipain  int8
     , cipalan int4
     , success bool
     , owns    text[]
     , args    text[]
     , ownc    int4
     , argc    int4
     )
;
#perform   00s2   --      
INSERT INTO t
 SELECT z.*, array_upper(owns, 1) AS ownc, array_upper(args, 1) AS argc
  FROM(SELECT cipago.cipain
            , cipalan.cipalan
            , cipalan.success
            , cipaown.ownpath                AS owns
            , cipalan.cipath || cipago.ciparg AS args
        FROM public.cipago JOIN public.cipalan USING(cipalan) JOIN public.cipaown USING(cipaown)
        WHERE cipago.cipain = $1::int8
       LIMIT 1
      )z
;
#select    1002
SELECT '#exit
'WHERE NOT EXISTS(SELECT 1 FROM t)
;
#eval      01     --   
#select    e002   --   stderr
SELECT 'Start '
     , t.cipalan
     , '.'
     , t.cipain
     , ' '
     , to_char(now(), 'YYYY-MM-DD HH24:MI:SS ')
     , t.args
     , '
'FROM t
;
#echo      Ee
#close     e0e
#select    1002   --     exec
WITH s AS(SELECT NULL::text     AS h
               , 'SELECT '       AS u
               , 0                AS m
               , 0                 AS n
         UNION
          SELECT ','                 AS h
               , ' owns[' || i || ']' AS u
               , 1                    AS m
               , i                    AS n
           FROM t, generate_series(1, t.ownc) AS i
           WHERE t.args[i] IS NOT NULL
         UNION
          SELECT ','                  AS h
               , ' args[' || i || ']' AS u
               , 2                   AS m
               , i                  AS n
           FROM t, generate_series(1, t.argc) AS i
           WHERE t.args[i] IS NOT NULL
         UNION
          SELECT NULL
               , ' FROM t;'    AS u
               , 3            AS m
               , 0           AS n
           FROM t
         )
   , x AS(SELECT m, n FROM s WHERE h IS NOT NULL ORDER BY m, n LIMIT 1)
SELECT CASE WHEN (s.m, s.n) <> (x.m, x.n) THEN s.h END, s.u
 FROM s, x
ORDER BY s.m, s.n
;
#echo      21
#select    3202
#cat       N
/dev/null
#job       00001
local -Z
#connect   0003
sqlite2 :memory:
#perform   0003
CREATE TEMP TABLE j(i int4, n int4, c int4, s int4);
#exec      E3N01  -- 1        
#getjob    50001  --     ,   
#copyin    0053
COPY j FROM stdin;
#select    1003
SELECT '#exit
' || CASE WHEN c = 0 THEN '7' ELSE '8' END || '
'FROM (SELECT COUNT(1) AS c FROM j)c
 WHERE c <> 1
;
#eval      01     --     
#perform   00s2
UPDATE public.cipago SET try = try + 1 WHERE cipain = $1::int8;
#select    R003
SELECT j.c FROM j;
#perform   00R2
UPDATE public.ciparun SET pid = $1::int FROM t WHERE ciparun.cipain = t.cipain;
#wait      00001  -- ,     
#perform   0003
DELETE FROM j;
#getjob    50001  --  exit code
#copyin    0053
COPY j FROM stdin;
#select    R003
SELECT (j.s >> 8) & 255 FROM j;
#trap
#perform   00s2
DELETE FROM ciparun WHERE ciparun.cipain = $1::int8;
#return
#perform   00R2   --      
SELECT public.cipaun(t.cipain) FROM t WHERE NOT success OR 0 = $1::int;
#perform   00s2
DELETE FROM ciparun WHERE ciparun.cipain = $1::int8;
#untrap
#select    R003
SELECT (j.s >> 8) & 255, j.c FROM j;
#select    e0R2   --   stderr
SELECT 'Exit '
     , $1
     , ' '
     , t.cipalan
     , '.'
     , cipain
     , ' '
     , $2
     , ' '
     , to_char(now(), 'YYYY-MM-DD HH24:MI:SS ')
     , t.args
     , '
'FROM t
;
#echo      Ee
#close     e0e
#perform   0002
NOTIFY cipaxn;
#exit      0003      ##################################################################################
#select    1001
SELECT '#exit 0001
'FROM f
;
#eval      01     --   ,  
#connect   0004
pgsql dbname=MINICIPA requirepeer=postgres application_name=minicipa
#perform   0004
LISTEN cipaxn;
#select    10a1
SELECT '
 SELECT (date_part(''epoch'', COALESCE( (SELECT plan
                                          FROM public.cipaxn' || c.c || '
                                         ORDER BY plan
                                         LIMIT 1
                                        )
                                      , now() + (SELECT param::interval
                                                  FROM public.ciparam
                                                  WHERE (m, v) = (''PKG'', ''timeout'')
                                                )
                                      )
                  ) * 1000000.0
        )::int8
;
'FROM (SELECT CASE WHEN b.b = 0 OR b.b = 1 THEN '2' || b.b ELSE '' END AS c FROM (SELECT ? AS b)b)c
;
#binpresel o104
#listen    00o4
cipaxn
#exit      0001
