#!/usr/local/bin/pgoblin -f
  Copyright (C)2019 @BABOLO http://www.babolo.ru/
--PKG = mini-cipa
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: minicipa.pgoblin.m4,v 1.28 2019/10/22 15:08:05 babolo Exp $

#connect 0001
CIPADBMS
GETARG(, 1, 1)dnl
GETENV(, 1, 1)dnl
#echo    Q
##Q copy E
#style   00Q00Q
Q
#perform 0001
CREATE TEMP TABLE x
     ( b text    --    (PROTOVER)  'minicipa'
     , u text    --    (${USER})
     , a text    --    (PROTOVER)
     )
;
#perform 0001
INSERT INTO x
 SELECT COALESCE( (SELECT a FROM a WHERE i = 0 AND regexp('^[a-z0-9_]+$', a))
                , 'minicipa'
                )
      , (SELECT e FROM e WHERE n = 'USER' AND regexp('^[a-z0-9_]+$', e))
      , (SELECT a FROM a WHERE i = 0 AND regexp('^[a-z0-9_]+$', a))
;
#perform 0001  #######################################################      ####
CREATE TEMP TABLE v(v numeric);
#select  1001
SELECT 'PREFIX/include/babolo/PKG' || COALESCE(':' || a, '') || '.VERSION' FROM x;
#cat     V1
#trap
#echo
@@@Ignore it

#perform 0001
INSERT INTO v VALUES(VERS);
#return
#copyin  00V1
COPY v;
#untrap
#select  b001  #################################################################  b - ${PROTOVER}  ####
SELECT b FROM x;
#connect 000T
pgsql dbname=template1 requirepeer=postgres application_name=minicipa
#select  10bT  #####################################################  CREATE DATABASE ${PROTOVER}  ####
SELECT 'CREATE DATABASE ' || x.b || ';
'FROM (SELECT $1::text AS b)x
  LEFT JOIN pg_catalog.pg_database ON(x.b = pg_database.datname::text)
 WHERE pg_database.datname IS NULL
;
#perform 010T
#select  u001  #####################################################################  u - ${USER}  ####
SELECT u FROM x;
#select  10uT  ####################################  CREATE ROLE ${USER}, root WITH LOGIN INHERIT  ####
SELECT 'CREATE ROLE ' || r || ' WITH LOGIN INHERIT;
'FROM  (SELECT $1::text AS r
       UNION
        SELECT 'root' AS r
       )r
  LEFT JOIN pg_catalog.pg_roles ON(r.r = pg_roles.rolname::text)
 WHERE pg_roles.rolname IS NULL
;
#perform 010T
#select  100T  #################################  CREATE ROLE cipa, operator WITH NOLOGIN INHERIT  ####
SELECT 'CREATE ROLE ' || r || ' WITH NOLOGIN INHERIT;
'FROM  (SELECT 'cipa' AS r
       UNION
        SELECT 'operator' AS r
       )r
  LEFT JOIN pg_catalog.pg_roles ON(r.r = pg_roles.rolname::text)
 WHERE pg_roles.rolname IS NULL
;
#perform 010T
#select  10uT  #######################################################  GRANT operator TO ${USER}  ####
SELECT 'GRANT operator TO ' || $1::text || ';';
#perform 010T
#perform 000T  ####################################################  GRANT cipa TO root, operator  ####
GRANT cipa TO root, operator;
#select  1001  ######################################  GRANT ==== ON DATABASE ${PROTOVER} TO ====  ####
 SELECT 'GRANT CONNECT ON DATABASE ' || x.b || ' TO root, ' || x.u || ';
' FROM x
UNION
 SELECT 'GRANT TEMP ON DATABASE ' || x.b || ' TO root, operator;
' FROM x
;
#perform 010T
#select  1001
SELECT 'pgsql dbname=' || b || ' requirepeer=postgres application_name=minicipa'
 FROM x
;
#connect 0102
#perform 0002
CREATE EXTENSION IF NOT EXISTS babolo_pglib;
#perform 0002
ALTER EXTENSION babolo_pglib UPDATE;
#!#####################################################################################################
#perform 0002  #####################################  -   tocipa()  ####
CREATE OR REPLACE FUNCTION public.tocipa() RETURNS trigger AS
$tocipa$
    BEGIN
        NOTIFY cipaxn;
        RETURN NULL;
    END;
$tocipa$
LANGUAGE plpgsql
;
#perform 0002
COMMENT ON FUNCTION public.tocipa() IS '     ';
#!#####################################################################################################
#perform 0002  ###################################################    ciparam  ####
CREATE TABLE IF NOT EXISTS public.ciparam
     ( m      text
     , v      text
     , param  text
     , PRIMARY KEY(m, v)
     )
;
#perform 0002
COMMENT ON TABLE public.ciparam        IS '  ';
COMMENT ON COLUMN public.ciparam.m        IS ',   ̣ ';
COMMENT ON COLUMN public.ciparam.v        IS '   ';
COMMENT ON COLUMN public.ciparam.param    IS ' ';
#begin   0002
#perform 0002
DROP TRIGGER IF EXISTS ciparamt ON public.ciparam;
#perform 0002
CREATE TRIGGER ciparamt
 AFTER INSERT OR UPDATE OR DELETE ON public.ciparam
 FOR EACH STATEMENT
 EXECUTE PROCEDURE public.tocipa()
;
#end     0002
#perform 0002
INSERT INTO public.ciparam
 SELECT 'PKG', 'timeout', '56min'
  WHERE NOT EXISTS(SELECT 1 FROM public.ciparam WHERE (m, v) = ('PKG', 'timeout'))
;
#!#####################################################################################################
#perform 0002  #################################################################   cipares  ####
CREATE SEQUENCE IF NOT EXISTS public.cipares_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipares
     ( cipares    int4     PRIMARY KEY DEFAULT nextval('public.cipares_q')
     , ciparesnm  text     NOT NULL UNIQUE
     )
;
#perform 0002
COMMENT ON TABLE public.cipares          IS '  ';
COMMENT ON COLUMN public.cipares.cipares    IS ' ';
COMMENT ON COLUMN public.cipares.ciparesnm  IS ' ';
#!#####################################################################################################
#perform 0002  #########################################################    cipamask  ####
CREATE SEQUENCE IF NOT EXISTS public.cipalevel_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipamask
     ( cipalevel int4      PRIMARY KEY DEFAULT nextval('public.cipalevel_q')
     , cipamask  varbit    NOT NULL
     )
;
#perform 0002
COMMENT ON TABLE public.cipamask         IS '     ';
COMMENT ON COLUMN public.cipamask.cipalevel IS '  ';
COMMENT ON COLUMN public.cipamask.cipamask  IS ' ';
#begin   0002
#perform 0002
DROP TRIGGER IF EXISTS cipamaskt ON public.cipamask;
#perform 0002
CREATE TRIGGER cipamaskt
 AFTER INSERT OR UPDATE OR DELETE ON public.cipamask
 FOR EACH STATEMENT
 EXECUTE PROCEDURE public.tocipa()
;
#end     0002
#perform 0002
SELECT setval('public.cipalevel_q', MAX(cipamask.cipalevel)) FROM public.cipamask;
#!#####################################################################################################
#perform 0002  #########################################################    cipalan  ####
CREATE SEQUENCE IF NOT EXISTS public.cipalan_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipalan
     ( cipalan   int4      PRIMARY KEY DEFAULT nextval('public.cipalan_q')
     , cipath    text[]    NOT NULL
     , selflock  int4
     , whom      text      NOT NULL
     , period    interval
     , strict    bool      NOT NULL DEFAULT FALSE
     , selfgr    bool      NOT NULL DEFAULT FALSE
     , success   bool      NOT NULL DEFAULT TRUE
     , resource  bytea     NOT NULL
     , resar     int4[]
     , renul     text[]
     )
;
#perform 0002
COMMENT ON TABLE public.cipalan          IS '  ';
COMMENT ON COLUMN public.cipalan.cipalan    IS ' ';
COMMENT ON COLUMN public.cipalan.cipath     IS 'PATH  +  ';
COMMENT ON COLUMN public.cipalan.selflock   IS '  (NULL , 0 -   , ...)';
COMMENT ON COLUMN public.cipalan.whom       IS 'uname,   ';
COMMENT ON COLUMN public.cipalan.period     IS ' ';
COMMENT ON COLUMN public.cipalan.strict     IS '     ';
COMMENT ON COLUMN public.cipalan.selfgr     IS '  ';
COMMENT ON COLUMN public.cipalan.success    IS '  ';
COMMENT ON COLUMN public.cipalan.resource   IS '   ';
COMMENT ON COLUMN public.cipalan.resar      IS '    ';
COMMENT ON COLUMN public.cipalan.renul      IS '   ,   resar';
#begin   0002
#perform 0002
DROP TRIGGER IF EXISTS cipalant ON public.cipalan;
#perform 0002
CREATE TRIGGER cipalant
 AFTER INSERT OR UPDATE OR DELETE ON public.cipalan
 FOR EACH STATEMENT
 EXECUTE PROCEDURE public.tocipa()
;
#end     0002
#perform 0002
SELECT setval('public.cipalan_q', MAX(cipalan.cipalan)) FROM public.cipalan;
#!#####################################################################################################
#perform 0002  ########################################################    cipaon  ####
CREATE SEQUENCE IF NOT EXISTS public.cipaxn_q MINVALUE 0;
#perform 0002
CREATE TABLE IF NOT EXISTS public.cipaon
     ( cipaon    int8      PRIMARY KEY DEFAULT nextval('public.cipaxn_q')
     , cipalan   int4      REFERENCES cipalan 
     , ciparg    text[]
     , plan      timestamp NOT NULL
     , deed      timestamp
     , pid       int4
     , reed      timestamp NOT NULL DEFAULT now()
     , try       int4      NOT NULL DEFAULT 0
     )
;
#perform 0002
COMMENT ON TABLE public.cipaon           IS ' ';
COMMENT ON COLUMN public.cipaon.cipaon      IS '  ';
COMMENT ON COLUMN public.cipaon.cipalan     IS '  public.cipalan';
COMMENT ON COLUMN public.cipaon.ciparg      IS ' ';
COMMENT ON COLUMN public.cipaon.pid         IS 'PID ';
COMMENT ON COLUMN public.cipaon.plan        IS '  ';
COMMENT ON COLUMN public.cipaon.deed        IS '  ';
COMMENT ON COLUMN public.cipaon.reed        IS '  ';
COMMENT ON COLUMN public.cipaon.try         IS '  ';
#!#####################################################################################################
#perform 0002  #######################################################     cipain  ####
CREATE TABLE IF NOT EXISTS public.cipain
     ( cipain    int8      PRIMARY KEY DEFAULT nextval('public.cipaxn_q')
     , cipaher   int8
     , cipalan   int4      REFERENCES cipalan
     , waitout   int8[]
     , ciparg    text[]
     , plan      timestamp NOT NULL DEFAULT now()
     , prio      int2      NOT NULL DEFAULT 1000
     , deed      timestamp
     , pid       int4
     , try       int4      NOT NULL DEFAULT 0
     , ghost     bool      NOT NULL DEFAULT FALSE
     )
;
#perform 0002
COMMENT ON TABLE public.cipain           IS '  ';
COMMENT ON COLUMN public.cipain.cipain      IS '  ';
COMMENT ON COLUMN public.cipain.cipaher     IS '  ';
COMMENT ON COLUMN public.cipain.cipalan     IS '  public.cipalan';
COMMENT ON COLUMN public.cipain.waitout     IS '    cipaon.cipaon';
COMMENT ON COLUMN public.cipain.ciparg      IS ' ';
COMMENT ON COLUMN public.cipain.plan        IS '  ';
COMMENT ON COLUMN public.cipain.prio        IS '';
COMMENT ON COLUMN public.cipain.deed        IS '  ';
COMMENT ON COLUMN public.cipain.pid         IS 'PID ';
COMMENT ON COLUMN public.cipain.try         IS '  ';
COMMENT ON COLUMN public.cipain.ghost       IS ' ,  ';
#begin   0002
#perform 0002
DROP TRIGGER IF EXISTS cipaint ON public.cipain;
#perform 0002
CREATE TRIGGER cipaint
 AFTER INSERT OR UPDATE OR DELETE ON public.cipain
 FOR EACH STATEMENT
 EXECUTE PROCEDURE public.tocipa()
;
#end     0002
#perform 0002
CREATE INDEX IF NOT EXISTS cipain_t ON public.cipain(plan);
#perform 0002
CREATE INDEX IF NOT EXISTS cipain_g ON public.cipain(ghost);
#perform 0002
CREATE INDEX IF NOT EXISTS cipain_l ON public.cipain(cipalan);
#perform 0002
SELECT setval('public.cipaxn_q', MAX(m.m))
 FROM (SELECT MAX(cipain.cipain) AS m FROM public.cipain
      UNION
       SELECT MAX(cipaon.cipaon) AS m FROM public.cipaon
      )m
;
#!#####################################################################################################
#perform 0002  #          cipaun(int8)  ####
CREATE OR REPLACE FUNCTION public.cipaun(int8)
 RETURNS TABLE( cipain  int8
              , cipaher int8
              , cipalan int4
              , waitout int8[]
              , ciparg  text[]
              , plan    timestamp
              , prio    int2
              , deed    timestamp
              , pid     int4
              , try     int4
              , ghost   bool
              )
 AS ' NOTIFY cipaxn
    ; WITH y AS(SELECT d.cipain
                 FROM  public.cipain d
                  JOIN public.cipain i USING(cipalan)
                  JOIN public.cipalan  USING(cipalan)
                 WHERE (d.waitout, d.ciparg) IS NOT DISTINCT FROM (i.waitout, i.ciparg)
                   AND i.cipain = $1
                   AND cipalan.selfgr
                   AND i.plan < now()
                   AND d.plan < i.deed
                   AND NOT d.ghost
                   AND NOT i.ghost
               UNION
                SELECT $1
               EXCEPT
                SELECT cipaon.cipaon FROM cipaon
               )
         , k AS(INSERT INTO public.cipain(cipaher, cipalan, ciparg, plan, waitout, prio)
                 SELECT i.cipain
                      , i.cipalan
                      , i.ciparg
                      , CASE WHEN cipalan.strict
                             THEN i.plan
                             ELSE COALESCE(i.deed, now())
                        END + cipalan.period
                      , (SELECT array_agg(cipain.cipain)
                           FROM public.cipain, unnest(i.waitout)u
                          WHERE cipain.cipaher = u
                        )
                      , i.prio
                  FROM public.cipalan JOIN public.cipain i USING(cipalan)
                  WHERE i.cipain = $1
                    AND cipalan.period IS NOT NULL
               )
         , c AS(DELETE FROM public.cipain
                 WHERE cipain.cipain IN(SELECT y.cipain FROM y)
                RETURNING cipain, cipaher, cipalan, waitout, ciparg, plan, prio, deed, pid, try, ghost
               )
         , e AS(INSERT INTO public.cipaon(cipaon, cipalan, ciparg, pid, plan, deed, try)
                 SELECT cipain, cipalan, ciparg, pid, plan, deed, try
                  FROM c
               )
      SELECT cipain, cipaher, cipalan, waitout, ciparg, plan, prio, deed, pid, try, ghost
       FROM c
    '
 LANGUAGE SQL
 VOLATILE
 STRICT
 PARALLEL UNSAFE
;
#perform 0002
COMMENT ON FUNCTION public.cipaun(int8)
 IS '    RULE cipadn ON DELETE TO cipaxn,   '
;
#!#####################################################################################################
#perform 0002  ################################################       cipaxn  ####
CREATE OR REPLACE VIEW public.cipaxn AS
 WITH i AS(SELECT cipain.*
            FROM cipain
             LEFT JOIN (SELECT DISTINCT waitout             
                         FROM (SELECT DISTINCT cipain.waitout FROM cipain)c
                            , unnest(c.waitout)h LEFT JOIN public.cipaon ON(h = cipaon.cipaon)
                         WHERE cipaon.cipaon IS NULL
                       )e USING(waitout)
            WHERE e.waitout IS NULL
              AND NOT ghost
          )
    , j AS(SELECT i.*
            FROM i JOIN public.cipalan USING(cipalan)
             LEFT JOIN (i b JOIN public.cipalan l USING(cipalan)
                       ) ON(   b.pid IS NOT NULL
                           AND public.compare( cipalan.selflock
                                             , cipalan.cipath || i.ciparg
                                             , l.cipath || b.ciparg
                           )                 )
            WHERE b.pid IS NULL
              AND i.pid IS NULL
          )
    , z AS(SELECT cipain
                , row_number() OVER (PARTITION BY cipain) AS cipalevel
                , arg
            FROM(SELECT cipain
                      , COALESCE((a.cipath || j.ciparg)[anum], a.aval) AS arg
                  FROM  (SELECT cipalan
                              , cipath
                              , unnest(resar) AS anum
                              , unnest(renul) AS aval
                          FROM public.cipalan
                        )a
                   JOIN j USING(cipalan)
                  WHERE NOT ghost
                 ORDER BY cipain
                )b
            WHERE arg IS NOT NULL
          UNION
           SELECT cipain, 0, NULL::text FROM j
          ORDER BY cipain, cipalevel, arg
         )
  SELECT j.cipain
       , j.cipaher
       , j.cipalan
       , j.waitout
       , j.ciparg
       , j.plan
       , j.prio
       , j.deed
       , j.pid
       , j.try
       , j.ghost
       , j.plan <= now() AS ready
   FROM       j
         JOIN public.cipalan USING(cipalan)
    LEFT JOIN (SELECT cipain, public.bytearrsum(resum) AS resum
                FROM z
                 LEFT JOIN(SELECT cipalevel
                                , arg
                                , public.bytearrsum(public.bytearrmask( cipalan.resource
                                                                      , cipamask.cipamask
                                                   )                  ) AS resum
                            FROM public.cipamask
                             JOIN z USING(cipalevel)
                             JOIN j  USING(cipain)
                             JOIN public.cipalan USING(cipalan)
                            WHERE j.pid IS NOT NULL
                           GROUP BY arg, cipalevel
                          )c USING(cipalevel, arg)
               GROUP BY cipain
              )s USING(cipain)
   WHERE public.bytearrmax(public.bytearradd(cipalan.resource, COALESCE(s.resum, '\x'))) < 255
;
#perform 0002
COMMENT ON VIEW public.cipaxn            IS '  ';
COMMENT ON COLUMN public.cipaxn.cipain      IS '  ';
COMMENT ON COLUMN public.cipaxn.cipaher     IS '    period';
COMMENT ON COLUMN public.cipaxn.cipalan     IS '  public.cipalan';
COMMENT ON COLUMN public.cipaxn.waitout     IS '    cipaon.cipaon';
COMMENT ON COLUMN public.cipaxn.ciparg      IS ' ';
COMMENT ON COLUMN public.cipaxn.plan        IS '  ';
COMMENT ON COLUMN public.cipaxn.prio        IS '';
COMMENT ON COLUMN public.cipaxn.deed        IS '  ';
COMMENT ON COLUMN public.cipaxn.pid         IS 'PID ';
COMMENT ON COLUMN public.cipaxn.try         IS '  ';
COMMENT ON COLUMN public.cipaxn.ghost       IS ' ,  ';
COMMENT ON COLUMN public.cipaxn.ready       IS '   ';
#perform 0002
CREATE OR REPLACE RULE cipadn AS
    ON DELETE TO public.cipaxn
    DO INSTEAD
    ( SELECT * FROM public.cipaun(OLD.cipain)
    ; NOTIFY cipaxn
    )
;
#perform 0002
CREATE OR REPLACE RULE cipain AS
    ON INSERT TO public.cipaxn
    DO INSTEAD
    ( INSERT INTO public.cipain(cipaher, cipalan, waitout, ciparg, plan, prio, ghost)
       SELECT NEW.cipaher
            , NEW.cipalan
            , NEW.waitout
            , NEW.ciparg
            , COALESCE(NEW.plan, now())
            , COALESCE(NEW.prio, 1000)
            , COALESCE(NEW.ghost, FALSE)
        FROM public.cipalan
        WHERE cipalan.cipalan = NEW.cipalan
      RETURNING cipain
              , cipaher
              , cipalan
              , waitout
              , ciparg
              , plan
              , prio
              , deed
              , pid
              , try
              , ghost
              , FALSE
    )
;
#perform 0002
CREATE OR REPLACE RULE cipaun AS
    ON UPDATE TO public.cipaxn
    DO INSTEAD
    ( UPDATE public.cipain
         SET waitout = NEW.waitout
           , ciparg  = NEW.ciparg
           , plan    = NEW.plan
           , prio    = NEW.prio
           , deed    = NEW.deed
           , pid     = NEW.pid
           , try     = NEW.try
           , ghost   = NEW.ghost
       WHERE cipain = NEW.cipain
      RETURNING cipain
              , cipaher
              , cipalan
              , waitout
              , ciparg
              , plan
              , prio
              , deed
              , pid
              , try
              , ghost
              , FALSE
    )
;
#!#####################################################################################################
#clear   1
#close   101
#select  1001
SELECT '#trap
##return
##perform 0002
DROP RULE IF EXISTS cipadl ON public.cipalan;
##perform 0002
DROP RULE IF EXISTS cipail ON public.cipalan;
##perform 0002
DROP RULE IF EXISTS cipaul ON public.cipalan;
##untrap
'FROM v
 WHERE v < 0.17
;
#eval    01
#begin   0002
#!#####################################################################################################
#perform 0002  ###############  API ,     cipatree(int8)  ####
CREATE OR REPLACE FUNCTION public.cipatree(int8)
 RETURNS SETOF public.cipain
 AS $tree$
    WITH a AS(WITH RECURSIVE r AS(SELECT cipain.cipain, unnest(cipain.waitout) AS wait
                                   FROM public.cipain
                                   WHERE cipain.cipain = $1
                                 UNION
                                  SELECT cipain.cipain, unnest(cipain.waitout) AS wait
                                   FROM public.cipain JOIN r ON(cipain.cipain = r.wait)
                                 )
              SELECT *
               FROM r
             )
       , b AS(SELECT a.cipain FROM a
             UNION
              SELECT cipain.cipain
               FROM a JOIN public.cipain ON(cipain.cipain = a.wait)
               WHERE COALESCE(cardinality(cipain.waitout), 0) = 0
             UNION
              SELECT cipain.cipain
               FROM public.cipain
               WHERE COALESCE(cardinality(cipain.waitout), 0) = 0
                 AND cipain.cipain = $1
             )
    SELECT cipain.* FROM b JOIN public.cipain USING(cipain)
$tree$
LANGUAGE sql
;
#perform 0002
COMMENT ON FUNCTION public.cipatree(int8)
 IS '     '
;
#!#####################################################################################################
#perform 0002  #####################  ,     cipatree(...)  ####
CREATE OR REPLACE FUNCTION public.cipatree(int8, int8[], text[], timestamp, int2)
 RETURNS SETOF public.cipain
 AS $tree$
    DECLARE
        i RECORD;
    BEGIN
        SET LOCAL client_min_messages = 'WARNING';
        DROP TABLE IF EXISTS "cipatree copy cupport a";
        DROP TABLE IF EXISTS "cipatree copy cupport b";
        DROP TABLE IF EXISTS "cipatree copy cupport d";
        DROP TABLE IF EXISTS "cipatree copy cupport z";
        SET LOCAL client_min_messages TO DEFAULT;
        CREATE TEMP TABLE "cipatree copy cupport a"
         ON COMMIT DROP
         AS WITH RECURSIVE
                 r AS (SELECT 0 AS ord, cipain.cipain, unnest(cipain.waitout) AS wait
                        FROM public.cipain
                        WHERE cipain.cipain = $1
                      UNION
                       SELECT r.ord + 1 AS ord, cipain.cipain, unnest(cipain.waitout) AS wait
                        FROM public.cipain JOIN r ON(cipain.cipain = r.wait)
                      )
            SELECT *
             FROM r
    ;
        CREATE TEMP TABLE "cipatree copy cupport b"
         ON COMMIT DROP
         AS SELECT MAX(d.ord) AS ord, d.cipain, MAX(cipain.plan) AS plan
             FROM (SELECT a.ord, a.cipain
                    FROM "cipatree copy cupport a" a
                  UNION
                   SELECT a.ord + 1, cipain.cipain
                    FROM "cipatree copy cupport a" a JOIN public.cipain ON(cipain.cipain = a.wait)
                    WHERE COALESCE(cardinality(cipain.waitout), 0) = 0
                  UNION
                   SELECT COALESCE(c.ord, 0) + 1, cipain.cipain
                    FROM (SELECT MAX(g.ord) + 1 AS ord FROM "cipatree copy cupport a" g)c
                       , public.cipain
                    WHERE COALESCE(cardinality(cipain.waitout), 0) = 0
                      AND cipain.cipain = $1
                  )d
              JOIN public.cipain USING(cipain)
            GROUP BY d.cipain
    ;
        CREATE TEMP TABLE "cipatree copy cupport d"
         ON COMMIT DROP
         AS SELECT DISTINCT b.cipain, a.wait
             FROM "cipatree copy cupport b" b LEFT JOIN "cipatree copy cupport a" a USING(cipain)
    ;
        CREATE TEMP TABLE "cipatree copy cupport z"(cipain int8, cipaher int8) ON COMMIT DROP;

        FOR i
         IN SELECT row_number() OVER(ORDER BY b.ord DESC) AS row
                 , b.cipain
                 , cipain.plan - e.e + COALESCE($4, now()) AS plan
             FROM "cipatree copy cupport b" b JOIN public.cipain USING(cipain)
                , (SELECT MIN(c.plan) AS e FROM "cipatree copy cupport b" c)e
            ORDER BY row
        LOOP
            RETURN QUERY
             WITH y AS(SELECT i.cipain
                            , NULLIF(array_remove(array_agg(d.wait), NULL), '{}') AS waitout
                        FROM "cipatree copy cupport d" d
                         LEFT JOIN "cipatree copy cupport z" z ON(d.wait = z.cipaher)
                        WHERE d.cipain = i.cipain
                       GROUP BY i.cipain
                      )
                , x AS(INSERT INTO public.cipain(cipaher, cipalan, waitout, ciparg, plan, prio)
                        SELECT i.cipain
                             , ci.cipalan
                             , $2 || y.waitout
                             , ci.ciparg || $3
                             , i.plan
                             , COALESCE($5, ci.prio)
                         FROM public.cipain ci JOIN y USING(cipain)
                         WHERE y.cipain = i.cipain
                        RETURNING cipain.cipain
                                , cipain.cipaher
                                , cipain.cipalan
                                , cipain.waitout
                                , cipain.ciparg
                                , cipain.plan
                                , cipain.prio
                                , cipain.deed
                                , cipain.pid
                                , cipain.try
                                , cipain.ghost
                      )
                , w AS(INSERT INTO "cipatree copy cupport z"
                        SELECT x.cipain, x.cipaher
                         FROM x
                      )
             SELECT x.cipain
                  , x.cipaher
                  , x.cipalan
                  , x.waitout
                  , x.ciparg
                  , x.plan
                  , x.prio
                  , x.deed
                  , x.pid
                  , x.try
                  , x.ghost
              FROM x
    ;
        END LOOP;
        NOTIFY cipaxn;
        RETURN;
    END;
$tree$
LANGUAGE plpgsql
;
#perform 0002
COMMENT ON FUNCTION public.cipatree(int8, int8[], text[], timestamp, int2)
 IS ' ,    '
;
#!#####################################################################################################
#perform 0002  ###################################  API     cipaghost  ####
CREATE TABLE IF NOT EXISTS public.cipaghost
     ( m      text
     , v      text
     , cipain int8 REFERENCES cipain
     , PRIMARY KEY(m, v)
     )
;
#perform 0002
COMMENT ON TABLE public.cipaghost        IS '  ';
COMMENT ON COLUMN public.cipaghost.m        IS '  - ';
COMMENT ON COLUMN public.cipaghost.v        IS '    ';
COMMENT ON COLUMN public.cipaghost.cipain   IS '   ';
#perform 0002  ################  API         cipaup  ####
CREATE OR REPLACE VIEW public.cipaup AS
 SELECT m
      , v
      , cipain
      , cipalan
      , waitout
      , ciparg
      , now()::timestamp AS plan
      , prio
  FROM public.cipaghost JOIN public.cipain USING(cipain)
  WHERE ghost
;
#perform 0002
COMMENT ON VIEW public.cipaup            IS '  ';
COMMENT ON COLUMN public.cipaup.m           IS '  - ';
COMMENT ON COLUMN public.cipaup.v           IS '    ';
COMMENT ON COLUMN public.cipaup.cipain      IS '  ';
COMMENT ON COLUMN public.cipaup.cipalan     IS '  public.cipalan';
COMMENT ON COLUMN public.cipaup.waitout     IS '    cipaon.cipaon';
COMMENT ON COLUMN public.cipaup.ciparg      IS ' ';
COMMENT ON COLUMN public.cipaup.plan        IS '  ';
COMMENT ON COLUMN public.cipaup.prio        IS '';
#perform 0002
CREATE OR REPLACE RULE cipagup AS
    ON UPDATE TO public.cipaup
    DO INSTEAD
    ( SELECT NULL::text, NULL::text, cipain, cipalan, waitout, ciparg, plan, prio
       FROM public.cipatree(OLD.cipain, NEW.waitout, NEW.ciparg, NEW.plan, NEW.prio)
    )
;
#!#####################################################################################################
#perform 0002  ###############################  API -   topute()  ####
CREATE OR REPLACE FUNCTION public.topute() RETURNS trigger AS
$topute$
    BEGIN
        UPDATE public.cipaup
           SET ciparg = ciparg || TG_ARGV[2:]
         WHERE (cipaup.m, cipaup.v) = (TG_ARGV[0], TG_ARGV[1])
    ;
         RETURN NULL;
    END;
$topute$
LANGUAGE plpgsql
;
#perform 0002
COMMENT ON FUNCTION public.topute() IS '     ';
#!#####################################################################################################
#perform 0002  ##############################################  API -  tolate()  ####
CREATE OR REPLACE FUNCTION public.tolate() RETURNS trigger AS
$tolate$
    BEGIN
        UPDATE public.cipato
           SET ciparg = TG_ARGV[2:]
         WHERE (cipato.m, cipato.v) = (TG_ARGV[0], TG_ARGV[1])
    ;
         RETURN NULL;
    END;
$tolate$
LANGUAGE plpgsql
;
#perform 0002
COMMENT ON FUNCTION public.tolate() IS '      cipalan';
#!#####################################################################################################
#perform 0002  #############################  API      cipapan  ####
CREATE TABLE IF NOT EXISTS public.cipapan
     ( m       text
     , v       text
     , cipalan int
     , PRIMARY KEY(m, v)
     )
;
#perform 0002
COMMENT ON TABLE public.cipapan        IS '   ';
COMMENT ON COLUMN public.cipapan.m        IS '  - ';
COMMENT ON COLUMN public.cipapan.v        IS '    ';
COMMENT ON COLUMN public.cipapan.cipalan  IS '  cipalan.cipalan';
#!#####################################################################################################
#perform 0002  #######################################  API      cipato  ####
CREATE OR REPLACE VIEW public.cipato AS
 SELECT m
      , v
      , NULL::int8       AS cipain
      , cipalan
      , NULL::int8[]     AS waitout
      , NULL::text[]     AS ciparg
      , now()::timestamp AS plan
      , 1000::int2       AS prio
  FROM public.cipapan JOIN public.cipalan USING(cipalan)
;
#perform 0002
COMMENT ON VIEW public.cipato            IS '  ';
COMMENT ON COLUMN public.cipato.m           IS '  - ';
COMMENT ON COLUMN public.cipato.v           IS '    ';
COMMENT ON COLUMN public.cipato.cipain      IS ' ';
COMMENT ON COLUMN public.cipato.cipalan     IS '  public.cipalan';
COMMENT ON COLUMN public.cipato.waitout     IS '    cipaon.cipaon';
COMMENT ON COLUMN public.cipato.ciparg      IS ' ';
COMMENT ON COLUMN public.cipato.plan        IS '  ';
COMMENT ON COLUMN public.cipato.prio        IS '';
#perform 0002
CREATE OR REPLACE RULE cipauto AS
    ON UPDATE TO public.cipato
    DO INSTEAD
    ( INSERT INTO cipain(cipalan, waitout, ciparg, plan, prio)
       SELECT OLD.cipalan, NEW.waitout, NEW.ciparg, NEW.plan, NEW.prio
      RETURNING NULL::text
              , NULL::text
              , cipain.cipain
              , cipain.cipalan
              , cipain.waitout
              , cipain.ciparg
              , cipain.plan
              , cipain.prio
    )
;
#perform 0002
GRANT SELECT ON public.cipares_q
              , public.cipares
              , public.ciparam
              , public.cipamask
              , public.cipalan_q
              , public.cipalan
              , public.cipaon
              , public.cipain
              , public.cipaxn_q
              , public.cipaxn
              , public.cipalevel_q
              , public.cipaghost
              , public.cipaup
              , public.cipapan
 TO cipa
;
#perform 0002
GRANT INSERT ON public.cipain
              , public.cipaxn
 TO cipa
;
#perform 0002
GRANT INSERT ON public.cipaon TO root;
#perform 0002
GRANT DELETE ON public.cipain, public.cipaxn TO root;
#perform 0002
GRANT UPDATE ON public.cipaup, public.cipato TO cipa;
#perform 0002
GRANT EXECUTE ON FUNCTION public.cipaun(int8), public.topute(), public.tocipa() TO cipa;
#end     0002
