#!/bin/sh -Te
#  Copyright (C)2019 @BABOLO http://www.babolo.ru/
#--PKG = mini-cipa
#  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: minicipa.m4,v 1.26 2019/10/22 14:59:15 babolo Exp $

cd /
export TMPDIR=/tmp
export LANG=C

CIPA=`/usr/bin/basename ${0}`
CIPA_CONF=CONFDIR/${CIPA}.conf
. ${CIPA_CONF}
pidfile="/var/run/${CIPA}.pid"

if  [ -r ${pidfile} ]; then
    pidd="`head -1 ${pidfile}`"
    if  [ -n "${pidd}" ]; then
        y=` /bin/ps -ax ${pidd}\
          | /usr/bin/awk '/bin/{$1 = "";\
                                $2 = "";\
                                $3 = "";\
                                $4 = "";\
                                if ($0 ~ /\/bin\/sh -T/) print "yes"\
                               }\
                         '\
          `
        if  [ "${y}" = "yes" ]; then
            kill -1 ${pidd} || :
            while [ -r ${pidfile} ]; do
                sleep 1
            done
fi; fi; fi

/bin/sh -T <<- EOF &
	mypid=\$\$
	echo "\${mypid}" > ${pidfile}
	date '+Start %F %T' >> ${pidfile}

	# --       HUP
	trap " kill -1 \\\` /bin/ps -axl						\
			  | /usr/bin/awk \"{if  (\\\\\\\\\\\\\\\$3 == \\\${mypid})	\
						print \\\\\\\\\\\\\\\$2}		\
					 \"						\
		       \\\`								\
	     ; /bin/rm -f ${pidfile}							\
	     ; kill -15 \\\${mypid}							\
	     " 1

	# -- endless loop
	while : ; do
	    if ! BINDIR/pgoblin "${0}" >> /var/log/MINICIPA.log 2>&1;  then
	        /usr/bin/logger -t ${CIPA} -p daemon.err "${CIPA} fails \`date '+%F %T'\`" || :
	    fi
	done
	/usr/bin/logger "${CIPA} stops"
EOF
exit

#!BINDIR/pgoblin
#echo      Q
##Q copy E
#style     00Q00Q
Q
#connect   0001
sqlite2
#connect   0002
pgsql dbname=MINICIPA requirepeer=postgres application_name=minicipa
#perform   0002
LISTEN cipaxn;
#binpresel o002
SELECT (date_part('epoch', COALESCE( (SELECT cipaxn.plan
                                       FROM public.cipaxn
                                      ORDER BY cipaxn.plan
                                      LIMIT 1
                                     )
                                   , now() + (SELECT param::interval
                                               FROM public.ciparam
                                               WHERE (m, v) = ('PKG', 'timeout')
                                             )
                 )                 ) * 1000000.0
       )::int8
;
#listen    00o2
cipaxn
#perform   0002   -- ,   
SELECT *, array_upper(args, 1) AS argc
INTO TEMP t
 FROM(SELECT cipaxn.cipain
           , cipalan.cipalan
           , cipalan.whom
           , cipalan.success
           , cipalan.cipath || cipaxn.ciparg AS args
       FROM public.cipaxn JOIN public.cipalan USING(cipalan)
       WHERE ready
      ORDER BY make_interval(0, 0, 0, 0, 0, 0, cipaxn.prio) * (cipaxn.try + 1) + cipaxn.plan
      LIMIT 1
     )z
;
#select    1002
SELECT '#exit
'WHERE (SELECT COUNT(1) FROM t) = 0
;
#eval      01     --   
#perform   0002
UPDATE cipain SET pid = 0, try = try + 1 FROM t WHERE cipain.cipain = t.cipain;
#fork             #####################################################################################
#cat       E
/var/log/MINICIPA.log
dnl #echo      D
dnl ##D pgo0 UD
dnl ## +H0
dnl SELECT 
dnl ## +U0
dnl 'BINDIR/su2', 
dnl ## +D0
dnl , '--', 
dnl ## +U
dnl args[
dnl ## -D
dnl ], 
dnl ## -D0
dnl ] 
dnl ## -H0
dnl FROM t;
dnl 
dnl 
dnl #style     00D00D
dnl D
dnl dnl #select    t002
dnl dnl SELECT t.cipain, t.t FROM t;
dnl dnl #select    T0t1
dnl dnl SELECT ?, ?;
dnl dnl #select    F0t1
dnl dnl SELECT ? WHERE ? IS NOT NULL;
dnl dnl #perform   00F2
dnl dnl UPDATE cipain SET try = try + 1 WHERE cipain = $1::int;
#select    E002   --   stderr
SELECT 'Start '
     , t.cipalan
     , '.'
     , t.cipain
     , ' '
     , to_char(now(), 'YYYY-MM-DD HH24:MI:SS ')
     , t.args
     , '
'FROM t
;
#select    1002   --     exec
WITH s AS(SELECT NULL      AS h
               , 'SELECT ' AS u
               , -1 AS n
         UNION
          SELECT NULL AS h
               , '''BINDIR/su2'', ' || quote_literal(t.whom) || ', ''--'', ' AS u
               , 0 AS n
           FROM t
           WHERE COALESCE(t.whom <> 'root', FALSE)
         UNION
          SELECT ','
               , ' args[' || i || ']'
               , i
           FROM t, generate_series(1, t.argc) AS i
           WHERE t.args[i] IS NOT NULL
         UNION
          SELECT ' FROM t;', NULL, t.argc + 1
           FROM t
         )
   , n AS(SELECT MIN(n) AS m FROM s WHERE n > 0)
SELECT CASE WHEN s.n <> n.m THEN s.h END
     , s.u
 FROM s, n
ORDER BY s.n
;
dnl #select    1002   --     exec
dnl SELECT s.u
dnl  FROM(SELECT CASE WHEN COALESCE(t.whom <> 'root', FALSE) THEN quote_literal(t.whom) END AS u
dnl            , 0 AS n
dnl        FROM t
dnl      UNION
dnl       SELECT i::text AS u, i AS n
dnl        FROM t, generate_series(1, t.argc) AS i
dnl      )s
dnl ORDER BY s.n
dnl ;
dnl #display   20100D   --    
#echo      21
#select    3202
#cat       N
/dev/null
#job       00001
local -Z
#perform   0001
CREATE TEMP TABLE j(i int4, n int4, c int4, s int4);
#exec      E3N01  -- 1        
#getjob    50001  --     ,   
#copyin    0051
COPY j FROM stdin;
#select    1001
SELECT '#exit
7
'WHERE (SELECT COUNT(1) FROM j) = 0
;
#eval      01     --   
#select    1001
SELECT '#exit
8
'WHERE (SELECT COUNT(1) FROM j) <> 1
;
#eval      01     --   
#select    R001
SELECT j.c FROM j;
#perform   00R2
UPDATE public.cipain SET deed = now(), pid = $1::int FROM t WHERE cipain.cipain = t.cipain;
#wait      00001  -- ,     
#perform   0001
DELETE FROM j;
#getjob    50001  --     
#copyin    0051
COPY j FROM stdin;
#select    R001
SELECT (j.s >> 8) & 255 FROM j;
#perform   00R2   --      
SELECT public.cipaun(t.cipain) FROM t WHERE NOT success OR 0 = $1::int;
#perform   0002
UPDATE cipain SET pid = NULL FROM t WHERE cipain.cipain = t.cipain;
#perform   0002
NOTIFY cipaxn;
#select    R001
SELECT (j.s >> 8) & 255, j.c FROM j;
#select    E0R2   --   stderr
SELECT 'Exit '
     , $1
     , ' '
     , t.cipalan
     , '.'
     , cipain
     , ' '
     , $2
     , ' '
     , to_char(now(), 'YYYY-MM-DD HH24:MI:SS ')
     , t.args
     , '
'FROM t
;
#exit             #####################################################################################
#exit      000x
