#!/bin/sh -e
echo 'Copyright (C)2014..2018 @BABOLO http://www.babolo.ru/'
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: test.sh,v 1.7 2018/05/22 18:14:34 babolo Exp $'

echo '        --------======== 1'
echo "tools/gen 0x50000 8192 > tools/test.t"
tools/gen 0x50000 8192 > tools/test.t
wc -c tools/test.t

echo '        --------======== 2'
echo "tools/test -pf $1 -b 8192 -r tools/test.t"
tools/test -pf $1 -b 8192 -r tools/test.t

echo '        --------======== 3'
echo "tools/test -pf $1 -b 16001 -r tools/test.t"
tools/test -pf $1 -b 16001 -r tools/test.t

echo '        --------======== 4'
echo "tools/test -pf $1 -b 33333 -r tools/test.t"
tools/test -pf $1 -b 33333 -r tools/test.t

echo '        --------======== 5'
echo 'OK>>test: read.c:mife_mmap:332: offset 345763 >= st_size 327680'
echo 'OK>>test: read.c:mife_read:565: Err: Illegal seek'
echo "tools/test -pf $1 -r tools/test.t 456 34678 59687 345763"
tools/test -pf $1 -r tools/test.t 456 34678 59687 345763

echo '        --------======== 6'
tools/gen 0x50000 16384 | wc -c
echo "tools/gen 0x50000 16384 | tools/test -pf $1 -b 8192"
tools/gen 0x50000 16384 | tools/test -pf $1 -b 8192


echo '        --------======== 7'
tools/gen 0x50000 16999 | wc -c
echo "tools/gen 0x50000 16999 | tools/test -pf $1 -b 8192"
tools/gen 0x50000 16999 | tools/test -pf $1 -b 8192

echo '        --------======== 8'
tools/gen 0x50000 16384 | wc -c
echo "tools/gen 0x50000 16384 | tools/test -pf $1 -b 33333"
tools/gen 0x50000 16384 | tools/test -pf $1 -b 33333

echo '        --------======== 9'
echo 'OK>>test: read.c:mife_read:565: Err: Illegal seek'
tools/gen 0x50000 16384 | wc -c
echo "tools/gen 0x50000 16384 | tools/test -pf $1 456 34678 59687 345763"
tools/gen 0x50000 16384 | tools/test -pf $1 456 34678 59687 345763

echo '        --------======== 10'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/test -pf $1 -b 8192 -x yyy"
tools/gen -yt 10000 25 5 | tools/test -pf $1 -b 8192 -x yyy

echo '        --------======== 11'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/test -pf $1 -b 8192 -x yyyyyy"
tools/gen -yt 10000 25 5 | tools/test -pf $1 -b 8192 -x yyyyyy

echo '        --------======== 12'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/test -pf $1 -b 8192 -x abacabac"
tools/gen -yt 10000 25 5 | tools/test -pf $1 -b 8192 -x abacabac

echo '        --------======== 13'
tools/gen -t 10000 25 5 | wc -c
echo "tools/gen -t 10000 25 5 | tools/test -pf $1 -b 8192 -x ''"
tools/gen -t 10000 25 5 | tools/test -pf $1 -b 8192 -x ''

echo '        --------======== 14'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/test -pf $1 -sb 0 -x yyy"
tools/gen -yt 10000 25 5 | tools/test -pf $1 -sb 0 -x yyy

echo '        --------======== 15'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/test -pf $1 -sb 0 -x yyyyyy"
tools/gen -yt 10000 25 5 | tools/test -pf $1 -sb 0 -x yyyyyy

echo '        --------======== 16'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/test -pf $1 -sb 0 -x abacabac"
tools/gen -yt 10000 25 5 | tools/test -pf $1 -sb 0 -x abacabac

echo '        --------======== 17'
tools/gen -t 10000 25 5 | wc -c
echo "tools/gen -t 10000 25 5 | tools/test -pf $1 -sb 0 -x ''"
tools/gen -t 10000 25 5 | tools/test -pf $1 -sb 0 -x ''

echo '        --------======== 18'
echo 'OK>>test: read.c:mife_pipe:237: timeout @ 9999999.999999999'
tools/gen -t 20000 10 5 | wc -c
echo "tools/gen -t 20000 10 5 | tools/test -pfb 678 -t 10000"
tools/gen -t 20000 10 5 | tools/test -pfb 678 -t 10000

rm -f tools/test.t

echo '        --------======== 19'
echo "tools/gen 1000000 50000 > tools/test.t"
tools/gen 1000000 50000 > tools/test.t
wc -c tools/test.t

echo '        --------======== 20'
echo "tools/test -pf $1 -r tools/test.t 34 56 67 900000"
tools/test -pf $1 -r tools/test.t 34 56 67 900000

echo '        --------======== 21'
echo "tools/test -pf  -r tools/test.t -sb 0"
tools/test -pf  -r tools/test.t -sb 0

echo '        --------======== 22'
echo "tools/test -pf -r tools/test.t -b 0"
tools/test -pf -r tools/test.t -b 0

rm -f tools/test.t

echo '        --------======== 23'
echo "tools/gen -y 1000000 50000 > tools/test.t"
tools/gen -y 1000000 50000 > tools/test.t
wc -c tools/test.t

echo '        --------======== 24'
echo "tools/test -pf $1 -r tools/test.t -x yyy -b 0"
tools/test -pf $1 -r tools/test.t -x yyy -b 0

echo '        --------======== 25'
echo "tools/test -pf $1 -r tools/test.t -x yyy -sb 0"
tools/test -pf $1 -r tools/test.t -x yyy -sb 0

echo '        --------======== 26'
echo "tools/gen 0x50000 8192 > tools/test.t"
tools/gen 0x50000 8192 > tools/test.t
wc -c tools/test.t

echo '        --------======== 27'
echo "tools/rtest -pf $1 -b 8192 -r tools/test.t"
tools/rtest -pf $1 -b 8192 -r tools/test.t

echo '        --------======== 28'
echo "tools/rtest -pf $1 -b 16001 -r tools/test.t"
tools/rtest -pf $1 -b 16001 -r tools/test.t

echo '        --------======== 29'
echo "tools/rtest -pf $1 -b 33333 -r tools/test.t"
tools/rtest -pf $1 -b 33333 -r tools/test.t

echo '        --------======== 30'
echo 'OK>>rtest: open.c:mife_ctlofft:603: offset - mife->offset 34678-0=34678 > mife->actlen 0'
echo 'OK>>rtest: open.c:mife_ctlofft:592: offset 345763 > st_size 327680'
echo "tools/rtest -pf $1 -r tools/test.t 456 34678 59687 345763"
tools/rtest -pf $1 -r tools/test.t 456 34678 59687 345763

echo '        --------======== 31'
tools/gen 0x50000 16384 | wc -c
echo "tools/gen 0x50000 16384 | tools/rtest -pf $1 -b 8192"
tools/gen 0x50000 16384 | tools/rtest -pf $1 -b 8192


echo '        --------======== 32'
tools/gen 0x50000 16999 | wc -c
echo "tools/gen 0x50000 16999 | tools/rtest -pf $1 -b 8192"
tools/gen 0x50000 16999 | tools/rtest -pf $1 -b 8192

echo '        --------======== 33'
tools/gen 0x50000 16384 | wc -c
echo "tools/gen 0x50000 16384 | tools/rtest -pf $1 -b 33333"
tools/gen 0x50000 16384 | tools/rtest -pf $1 -b 33333

echo '        --------======== 34'
echo 'OK>>rtest: open.c:mife_ctlofft:603: offset - mife->offset 34678-0=34678 > mife->actlen 0'
echo 'OK>>rtest: open.c:mife_ctlofft:603: offset - mife->offset 345763-32768=312995 > mife->actlen 16384'
echo 'OK>>rtest: read.c:mife_read:575: Err: Illegal seek'
tools/gen 0x50000 16384 | wc -c
echo "tools/gen 0x50000 16384 | tools/rtest -pf $1 456 34678 59687 345763"
tools/gen 0x50000 16384 | tools/rtest -pf $1 456 34678 59687 345763

echo '        --------======== 35'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -b 8192 -x yyy"
tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -b 8192 -x yyy

echo '        --------======== 36'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -b 8192 -x yyyyyy"
tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -b 8192 -x yyyyyy

echo '        --------======== 37'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -b 8192 -x abacabac"
tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -b 8192 -x abacabac

echo '        --------======== 38'
tools/gen -t 10000 25 5 | wc -c
echo "tools/gen -t 10000 25 5 | tools/rtest -pf $1 -b 8192 -x ''"
tools/gen -t 10000 25 5 | tools/rtest -pf $1 -b 8192 -x ''

echo '        --------======== 39'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -sb 0 -x yyy"
tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -sb 0 -x yyy

echo '        --------======== 40'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -sb 0 -x yyyyyy"
tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -sb 0 -x yyyyyy

echo '        --------======== 41'
tools/gen -yt 10000 25 5 | wc -c
echo "tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -sb 0 -x abacabac"
tools/gen -yt 10000 25 5 | tools/rtest -pf $1 -sb 0 -x abacabac

echo '        --------======== 42'
tools/gen -t 10000 25 5 | wc -c
echo "tools/gen -t 10000 25 5 | tools/rtest -pf $1 -sb 0 -x ''"
tools/gen -t 10000 25 5 | tools/rtest -pf $1 -sb 0 -x ''

echo '        --------======== 43'
echo 'OK>>rtest: read.c:mife_pipe:237: timeout @ 9999999.999999999'
tools/gen -t 20000 10 5 | wc -c
echo "tools/gen -t 20000 10 5 | tools/rtest -pfb 678 -t 10000"
tools/gen -t 20000 10 5 | tools/rtest -pfb 678 -t 10000

rm -f tools/test.t

echo '        --------======== 44'
echo "tools/gen 1000000 50000 > tools/test.t"
tools/gen 1000000 50000 > tools/test.t
wc -c tools/test.t

echo '        --------======== 45'
echo 'OK>>rtest: open.c:mife_ctlofft:603: offset - mife->offset 56-0=56 > mife->actlen 0'
echo 'OK>>rtest: open.c:mife_ctlofft:603: offset - mife->offset 900000-0=900000 > mife->actlen 266240'
echo "tools/rtest -pf $1 -r tools/test.t 34 56 67 900000"
tools/rtest -pf $1 -r tools/test.t 34 56 67 900000

echo '        --------======== 46'
echo "tools/rtest -pf  -r tools/test.t -sb 0"
tools/rtest -pf  -r tools/test.t -sb 0

echo '        --------======== 47'
echo "tools/rtest -pf -r tools/test.t -b 0"
tools/rtest -pf -r tools/test.t -b 0

rm -f tools/test.t

echo '        --------======== 48'
echo "tools/gen -y 1000000 50000 > tools/test.t"
tools/gen -y 1000000 50000 > tools/test.t
wc -c tools/test.t

echo '        --------======== 49'
echo "tools/rtest -pf $1 -r tools/test.t -x yyy -b 0"
tools/rtest -pf $1 -r tools/test.t -x yyy -b 0

echo '        --------======== 50'
echo "tools/rtest -pf $1 -r tools/test.t -x yyy -sb 0"
tools/rtest -pf $1 -r tools/test.t -x yyy -sb 0

echo '        --------======== 51'
echo "tools/gen 32 32 > tools/test.t"
tools/gen 32 32 > tools/test.t

echo '        --------======== 52'
echo "tools/test -pf -b 8192 -r tools/test.t 16 16"
tools/test -pf -b 8192 -r tools/test.t 16 16

echo '        --------======== 53'
echo "tools/rtest -pf -b 8192 -r tools/test.t 16 16"
tools/rtest -pf -b 8192 -r tools/test.t 16 16

echo '        --------======== 54'
echo "tools/gen 32 32 | tools/test -pf -b 8192 16 16"
tools/gen 32 32 | tools/test -pf -b 8192 16 16

echo '        --------======== 55'
echo "tools/gen 32 32 | tools/rtest -pf -b 8192 16 16"
tools/gen 32 32 | tools/rtest -pf -b 8192 16 16

exit

echo;echo ""
