/*-
 * Copyright (C)2003..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2003..2018 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: test.c,v 1.28 2018/12/06 17:28:56 babolo Exp $\n"

#define BLIN_COMPAT 3
#define MIFE_COMPAT 5

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include "../mife.h"
#define SEQN(i) ((((u_int32_t)(i) ^ 0x33CC55AA) >> (((u_int32_t)(i) & 3) * 7 + 2) | 0x80) & 0xFF)
#define SEEN(mf, offset, i) (((u_char*)mife_point((mf), MIFE_POINOFF, (off_t)(offset)))[i] & 0xFF)

int
main(int argc, char **argv) {
    FILE            *out = stdout;
    ssize_t          wantsize;
    ssize_t          reedsize;
    mife_tim         timeout;
    off_t            offset;
    BLIN_flag        flags;
    int              print;
    char            *eoln;
    int              optc;
    u_char          *pos;
    mife_descriptor *mf;
    int              fd;

    if  (!argv) exit(EX_USAGE);
    flags = BLIN_GEN1 | MIFE_BUFX;
    fd = fileno(stdin);
    eoln = NULL;
    wantsize = 65536;
    print = 0;
    timeout = 0;
    while ((optc = getopt(argc, argv, "b:efl:pqr:st:vx:")) > 0) {
        switch (optc) {
        case 'b': /******** want block size    ********/
                  wantsize = strtoul(optarg, NULL, 0);
                  break;
        case 'e': /******** output to stderr   ********/
                  out = stderr;
                  break;
        case 'f': /******** zero at end        ********/
                  flags |= MIFE_FULL;
                  break;
        case 'l': /******** buffer space       ********/
                  flags |= MIFE_BUFX;
                  flags |= (strtoul(optarg, NULL, 0) << 8) & MIFE_BUFL;
                  break;
        case 'p': /******** print block bound  ********/
                  print = 1;
                  break;
        case 'q': /******** quiet              ********/
                  flags &= ~BLIN_MASK;
                  break;
        case 'r': /******** in file            ********/
                  fd = open(optarg, O_RDONLY);
                  break;
        case 's': /******** zero at end        ********/
                  flags |= MIFE_SLID;
                  break;
        case 't': /******** timeouts           ********/
                  timeout = strtoul(optarg, NULL, 0) * 1000ULL;
                  break;
        case 'v': /******** verbose            ********/
                  BLIN_VERBOSE(flags);
                  break;
        case 'x': /******** end of line marker ********/
                  eoln = optarg;
                  break;
        default:
                  exit(EX_USAGE);
    }   }
    argc -= optind;
    argv += optind;
    if  (argc & 1) exit(EX_USAGE);
    mf = mife_init(flags);
    if  (mife_ctlfdsc(mf, fd)) {
        exit(EX_IOERR);
    }
    if  (timeout && mife_ctltim1(mf, timeout)) {
        exit(EX_IOERR);
    }
    /****************************
     * [len off[ len off[...]]] *
     ****************************/
    reedsize = 1;
    if  (argc == 0) {
        int i;

        for (i = 0, offset = 0; reedsize > 0 && !(mf->flags & MIFE_EOFL); ++i, offset += reedsize) {
            if  (mife_ctleoli(mf, eoln) < 0) err(EX_OSERR, "mife_eolinit");
            reedsize = mife_read(mf, wantsize, offset);
            if  (print && reedsize >= 0) {
                if  (!(pos = mife_get(mf, offset))) {
                    fprintf( out
                           , "i=%d %"BLIN_O"d[%"BLIN_D"] l=%"BLIN_D"->NO\n"
                           , i
                           , offset
                           , reedsize
                           , wantsize
                           )
                    ;
                } else {
                    fprintf( out
                           , "i=%d %"BLIN_O"d[%"BLIN_D"] l=%"BLIN_D"->%"BLIN_U" **"
                           , i
                           , offset
                           , reedsize
                           , wantsize
                           , (flags & MIFE_FULL) ? strlen((char*)pos) : reedsize
                           )
                    ;
                    for (int j = 0; j < 8 && j < reedsize; ++j) fprintf(out, " %02X", pos[j]);
                    fprintf(out, "\n");
                    for (ssize_t pl = 0; pl < reedsize; ++pl) {
                        if  (!eoln && ((pos[pl] & 0xFF) != SEQN(offset + pl))) {
                            fprintf( out
                                   , "off=%08"BLIN_O"X+%"BLIN_X" %02X<>%02X\n"
                                   , offset
                                   , pl
                                   , pos[pl] & 0xFF
                                   , SEQN(offset + pl)
                                   )
                            ;
        }   }   }   }   }
        fprintf(out, "%d %"BLIN_D"\n", i, reedsize);
    } else {
        int i;

        for (i = 0; argc; ++i, argc -= 2) {
            wantsize = strtoul(*(argv++), NULL, 0);
            offset = strtoq(*(argv++), NULL, 0);
            if  (mife_ctleoli(mf, eoln) < 0) err(EX_OSERR, "mife_eolinit");
            reedsize = mife_read(mf, wantsize, offset);
            if  (print && reedsize >= 0) {
                if  (!(pos = mife_get(mf, offset))) {
                    fprintf( out
                           , "i=%d %"BLIN_O"d[%"BLIN_D"] l=%"BLIN_D"->NO\n"
                           , i
                           , offset
                           , reedsize
                           , wantsize
                           )
                    ;
                } else {
                    fprintf( out
                           , "i=%d %"BLIN_O"d[%"BLIN_D"] l=%"BLIN_D"->%"BLIN_U" **"
                           , i
                           , offset
                           , reedsize
                           , wantsize
                           , (flags & MIFE_FULL) ? strlen((char*)pos) : reedsize
                           )
                    ;
                    for (int j = 0; j < 8 && j < reedsize; ++j) fprintf(out, " %02X", pos[j]);
                    fprintf(out, "\n");
                    for (ssize_t pl = 0; pl < reedsize; ++pl) {
                        if  (!eoln && ((pos[pl] & 0xFF) != SEQN(offset + pl))) {
                            fprintf( out
                                   , "off=%08"BLIN_O"X+%"BLIN_X" %02X<>%02X\n"
                                   , offset
                                   , pl
                                   , pos[pl] & 0xFF
                                   , SEQN(offset + pl)
                                   )
                            ;
        }   }   }   }   }
        fprintf(out, "%d %"BLIN_D"\n", i, reedsize);
    }
    exit(EX_OK);
}
