/*-
 * Copyright (C)2014..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2014..2018 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: notest.c,v 1.6 2018/12/06 17:28:56 babolo Exp $\n"

#define BLIN_COMPAT 3
#define MIFE_COMPAT 5

#include <sys/limits.h>
#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include "../mife.h"

int
main(int argc, char **argv) {
#   define blin_internal_flags BLIN_MASK
    mife_descriptor *mf;
    ssize_t ex = EX_OK;

    errno = 0;
    mf = mife_init(BLIN_MASK | MIFE_FULL);
    ifBLIN_QW0("mife_init=%"BLIN_X, BLIN_I(mf));
    if  (mf) {
        if  ((argc > 1) && argv && *argv) {
            ifBLIN_QX0("MIFE_CTLFILE =%s~", argv[1]);
            ex = mife_ctlfile(mf, argv[1]);
            ifBLIN_QW0("MIFE_CTLFILE ex=%"BLIN_D, ex);
        } else {
            ifBLIN_QX0("MIFE_CTLFDSC =%d", fileno(stdin));
            ex = mife_ctlfdsc(mf, fileno(stdin));
            ifBLIN_QW0("MIFE_CTLFDSC ex=%"BLIN_D, ex);
    }   }
    ifBLIN_QX0("mife=%"BLIN_X, BLIN_I(mf));
    ex = mife_fini(mf);
    ifBLIN_QW0("MIFE_CTLFINI ex=%"BLIN_D, ex);
    mf = NULL;
    exit(ex);
#   undef blin_internal_flags
}
