/*-
 * Copyright (C)2003..2013 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2003..2013 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: gen.c,v 1.9 2018/05/21 17:40:48 babolo Exp $\n"

/* gen length bsize [offset]
 * Generates test sequence
 */

#include <sys/types.h>
#include <sysexits.h>
#include <sys/uio.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <fcntl.h>
#include <stdio.h>
#define SEQN(i) (((i ^ 0x33CC55AA) >> ((i & 3) * 7 + 2) | 0x80) & 0xFF)

int
main(int argc, char **argv) {
    off_t length;
    char *buf;
    size_t bln, l;
    u_int32_t i;
    int ch, yy;
    unsigned int tt;

    tt = 0;
    yy = 0; /* fill blocks by 'y'   */
    if  (!argv || !argv[0] || !argv[0][0]) {
        fprintf(stderr, "Us1\n");
        exit(EX_USAGE);
    }
    while ((ch = getopt(argc, argv, "t:y")) != -1)
        switch (ch) {
        case 't': /******** time beetween blocks ********/
                  tt = strtoul(optarg, NULL, 0);
                  break;
        case 'y': /******** fill blocks by 'y'   ********/
                  yy = 1;
                  break;
        default:  fprintf(stderr, "Usf\n");
                  exit(EX_USAGE);
        }
    argc -= optind;
    argv += optind;

    /**********************
     * 0 - file length    *
     * 1 - block length   *
     *[2]- sequence begin *
     **********************/
    if  (argc < 2 || argc > 3 || !argv[0] || !argv[0][0] || !argv[1] || !argv[1][0]) {
        fprintf(stderr, "Us2\n");
        exit(EX_USAGE);
    }
    length = strtoq(argv[0], NULL, 0);
    bln = strtoul(argv[1], NULL, 0);
    i = 0;
    if  (argc > 2) {
        if  (!argv[2] || !argv[2][0]) exit(EX_USAGE);
        i = strtoul(argv[2], NULL, 0);
    }
    buf = malloc(bln);
    if  (!buf) exit(EX_NOPERM);
    while (length > 0) {
        for (l = 0; l < bln && length > 0; ++i, --length) {
            if  (yy) buf[l++] = 'y';
              else buf[l++] = SEQN(i);
        }
        write(fileno(stdout), buf, l);
        if  (tt) usleep(tt);
    }
    exit(EX_OK);
}
