/*-
 * Copyright (C)2003..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2003..2018 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: read.c,v 1.47 2018/08/30 15:34:43 babolo Exp $\n"

#define BLIN_COMPAT   3
#define MIFE_COMPAT   5
#define MIFE_INTERNAL 1

#include <sys/resource.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <sys/uio.h>
#include <limits.h>
#include <stdarg.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <malloc_np.h>
#include <babolo/BLINflag.h>
#include "mife.h"

#define C_zr 0x02 /* empty buffer    */
#define C_al 0x04 /* allocate buffer */
#define C_mv 0x08 /* shift buffer    */
#define C_ra 0x10 /* realloc buffer  */

static ssize_t
mife_pipe(mife_descriptor *mife, ssize_t ordlen, off_t offset) {
    int              retrylim;
    ssize_t          needlen;
    ssize_t          ex = -1;
    int              control;
    ssize_t          tmplen;
    void            *tmpbuf;
    ssize_t          rdlen;
    off_t            delta = 0;;
    struct timespec  tick;
    size_t           plb;
    int              i;

#   define blin_internal_flags (mife->flags)
    ifBLIN_QX2("+ %"BLIN_X, BLIN_I(mife));
    MIFE_DUMP(mife, delta);
    if  (mife->offset > offset) {
        ifBLIN_QX0("mife->offset > offset");
        ERROUT(-EX_USAGE, EINVAL);
    }
    if  (!ordlen) {
        needlen = (mife->flags & MIFE_SLID) ? mife->mindelta : 0;
    } else if (ordlen < mife->mindelta) {
        needlen = mife->mindelta;
    } else {
        needlen = ordlen;
    }
    plb = (mife->flags & MIFE_FULL) ? 1 : 0;
    mife->ofpoint = offset;
    MIFE_DUMP(mife, delta);
    for (; 0 <= needlen; ) {
    ;   /********************************************************************************   */
    ;   for (retrylim = 2;;) {                                                                     /**/
    ;   ;;  delta = mife->ofpoint - mife->offset;                                                  /**/
    ;   ;;  MIFE_DUMP(mife, delta);                                                                /**/
    ;   ;;  tmplen = (MAXPACKT * 2 - 1 + needlen + plb) & ~(MAXPACKT - 1);                         /**/
    ;   ;;  if  (tmplen < mife->mindelta) tmplen = mife->mindelta;            /* ???? MIFE_BUFX XXXX */
    ;   ;;  control = 0;                                                                           /**/
    ;   ;;  if  (!mife->buffer || !mife->buflen) {                                                 /**/
    ;   ;;      control |= C_zr | C_al;                                                            /**/
    ;   ;;  } else if (delta >= (off_t)mife->actlen) {                                             /**/
    ;   ;;      control |= C_zr;                                                                   /**/
    ;   ;;      if  (mife->buflen < (size_t)tmplen) control |= C_al;                               /**/
    ;   ;;  } else {                                                                               /**/
    ;   ;;      if  (delta && ((mife->actbeg + delta + needlen + plb) > mife->buflen)) control |= C_mv;
    ;   ;;      if  ((needlen + plb) > mife->buflen) control |= C_ra;                              /**/
    ;   ;;  }                                                                                      /**/
    ;   ;;  ifBLIN_QX3("control=%08X tmplen=%"BLIN_D, control, tmplen);                            /**/
    ;   ;;  if  (control & C_zr) {                                                                 /**/
    ;   ;;      if  (mife->eol) mife->eol->stop(mife);                                             /**/
    ;   ;;      mife->offset += mife->actlen;                                                      /**/
    ;   ;;      mife->actbeg = 0;                                                                  /**/
    ;   ;;      mife->actlen = 0;                                                                  /**/
    ;   ;;      MIFE_DUMP(mife, delta);                                                            /**/
    ;   ;;  }                                                                                      /**/
    ;   ;;  if  (control & C_al) {                                                                 /**/
    ;   ;;      if  (mife->flags & MIFE_ALLC) free(mife->buffer);                                  /**/
    ;   ;;      mife->flags |= MIFE_ALLC;                                                          /**/
    ;   ;;      mife->buflen = tmplen;                                                             /**/
    ;   ;;      if  (!(mife->buffer = malloc(mife->buflen))) {                                     /**/
    ;   ;;          ifBLIN_QW0("malloc(%"BLIN_U")", mife->buflen);                                 /**/
    ;   ;;          ERROUT(-EX_OSERR, ENOMEM);                                                     /**/
    ;   ;;      }                                                                                  /**/
    ;   ;;      MIFE_DUMP(mife, delta);                                                            /**/
    ;   ;;  }                                                                                      /**/
    ;   ;;  delta = mife->ofpoint - mife->offset;                                                  /**/
    ;   ;;  if  (control & C_mv) {                                                                 /**/
    ;   ;;      bcopy(mife->buffer + mife->actbeg + delta, mife->buffer, mife->actlen - delta);    /**/
    ;   ;;      mife->offset += delta;                                                             /**/
    ;   ;;      mife->actbeg = 0;                                                                  /**/
    ;   ;;      mife->actlen -= delta;                                                             /**/
    ;   ;;      if  (mife->eol) mife->eol->delta(mife, -delta);                                    /**/
    ;   ;;      delta = 0;                                                                         /**/
    ;   ;;      MIFE_DUMP(mife, delta);                                                            /**/
    ;   ;;  }                                                                                      /**/
    ;   ;;  tmplen = (MAXPACKT * 2 - 1 + mife->actbeg + delta + needlen + plb) & ~(MAXPACKT - 1);  /**/
    ;   ;;  if  (control & C_ra) {                                                                 /**/
    ;   ;;      mife->buflen = tmplen;                                                             /**/
    ;   ;;      if  (!(mife->flags & MIFE_ALLC)) {                                                 /**/
    ;   ;;          mife->flags |= MIFE_ALLC;                                                      /**/
    ;   ;;          if  (!(tmpbuf = malloc(tmplen))) {                                             /**/
    ;   ;;              ifBLIN_QW0("malloc(%"BLIN_U")", tmplen);                                   /**/
    ;   ;;              ERROUT(-EX_OSERR, ENOMEM);                                                 /**/
    ;   ;;          }                                                                              /**/
    ;   ;;          bcopy(mife->buffer + mife->actbeg, tmpbuf, mife->actlen);                      /**/
    ;   ;;          mife->actbeg = 0;                                                              /**/
    ;   ;;          mife->buffer = tmpbuf;                                                         /**/
    ;   ;;          mife->buflen = tmplen;                                                         /**/
    ;   ;;      } else {                                                                           /**/
    ;   ;;          if  (!(mife->buffer = reallocf(mife->buffer, mife->buflen))) {                 /**/
    ;   ;;              ifBLIN_QX0("realloc(%"BLIN_X", %"BLIN_U")", mife->buffer, mife->buflen);   /**/
    ;   ;;              ERROUT(-EX_OSERR, ENOMEM);                                                 /**/
    ;   ;;      }   }                                                                              /**/
    ;   ;;      MIFE_DUMP(mife, delta);                                                            /**/
    ;   ;;  }                                                                                      /**/
    ;   ;;  if  (delta >= (off_t)mife->actlen) {                                                   /**/
    ;   ;;      tmplen = delta;                                                                    /**/
    ;   ;;      tmpbuf = mife->buffer;                                                             /**/
    ;   ;;      ifBLIN_QX3("tmplen=%"BLIN_D" tmpbuf=%"BLIN_X, tmplen, BLIN_I(tmpbuf));             /**/
    ;   ;;  } else {                                                                               /**/
    ;   ;;      delta = 0;                                                                         /**/
    ;   ;;      tmplen = mife->ofpoint - mife->offset + needlen - mife->actlen;                    /**/
    ;   ;;      tmpbuf = mife->buffer + mife->actbeg + mife->actlen;                               /**/
    ;   ;;      ifBLIN_QX3("tmplen=%"BLIN_D" tmpbuf=%"BLIN_D" delta=%"BLIN_O"d"                    /**/
        /**/              , tmplen                                                                 /**/
        /**/              , BLIN_I(tmpbuf)                                                         /**/
        /**/              , delta                                                                  /**/
        /**/              )                                                                        /**/
        /**/    ;                                                                                  /**/
    ;   ;;  }                                                                                      /**/
    ;   ;;  if  (tmplen < MAXPACKT) tmplen = MAXPACKT;                                             /**/
    ;   ;;  if  ((mife->buffer + mife->buflen) >= (tmpbuf + tmplen + plb)) break;                  /**/
    ;   ;;  if  (!--retrylim) {                                                                    /**/
    ;   ;;      ifBLIN_QX0( "uderestimated buflen %"BLIN_U" < "BLIN_U                              /**/
        /**/              , mife->buflen                                                           /**/
        /**/              , tmpbuf - mife->buffer + tmplen                                         /**/
        /**/              )                                                                        /**/
        /**/    ;                                                                                  /**/
    ;   ;;      ERROUT(-EX_SOFTWARE, EDOOFUS);                                                     /**/
    ;   }   }/****************************************************************************************/
    ;   retrylim = (MIFE_RTRY & mife->flags) * 2;
    ;   ifBLIN_QX3( "tmplen=%"BLIN_D" tmpbuf++=%"BLIN_D" retrylim=%d"
                  , tmplen
                  , tmpbuf - mife->buffer
                  , retrylim
                  )
        ;
    ;   MIFE_DUMP(mife, delta);
    ;   do  { /* Read something only onse */
    ;   ;   if  (0 > clock_gettime(CLOCK_MONOTONIC_FAST, &tick)) {
    ;   ;       ifBLIN_QW1("clock_gettime #1");
    ;   ;   }
    ;   ;   /*******************************************************************   */
    ;   ;   if  (  (!mife->offset && !mife->actlen && (mife->itime.tv_sec || mife->itime.tv_nsec)) /**/
            /**/|| ((mife->offset || mife->actlen) && (mife->otime.tv_sec || mife->otime.tv_nsec)) /**/
            /**/) {                                                                                /**/
    ;   ;   ;;  ifBLIN_QX5("  kq=%d @ %u.%09lu", mife->kev->kq, tick.tv_sec, tick.tv_nsec);        /**/
    ;   ;   ;;  EV_SET(&mife->kev->kev, mife->f.fd, EVFILT_READ, EV_ADD | EV_ONESHOT, 0, 0, NULL); /**/
    ;   ;   ;;  i = kevent( mife->kev->kq                                                          /**/
            /**/          , &mife->kev->kev                                                        /**/
            /**/          , 1                                                                      /**/
            /**/          , &mife->kev->kev                                                        /**/
            /**/          , 1                                                                      /**/
            /**/          , mife->offset ? &mife->otime : &mife->itime                             /**/
            /**/          )                                                                        /**/
            /**/;                                                                                  /**/
    ;   ;   ;;  if  (0 > i) {                                                                      /**/
    ;   ;   ;;      ifBLIN_QW1("kevent");                                                          /**/
    ;   ;   ;;      EXOUT(-EX_IOERR);                                                              /**/
    ;   ;   ;;  } else if (!i) {                                                                   /**/
    ;   ;   ;;      rdlen = 0;                                                                     /**/
    ;   ;   ;;      if  (0 > clock_gettime(CLOCK_MONOTONIC_FAST, &tick)) {                         /**/
    ;   ;   ;;          ifBLIN_QW1("clock_gettime #2");                                            /**/
    ;   ;   ;;      }                                                                              /**/
    ;   ;   ;;      ifBLIN_QX1("timeout @ %"BLIN_U".%09lu", tick.tv_sec, tick.tv_nsec);            /**/
    ;   ;   ;;      break;                                                                         /**/
    ;   ;   ;;  }                                                                                  /**/
    ;   ;   ;;  if  (0 > clock_gettime(CLOCK_MONOTONIC_FAST, &tick)) {                             /**/
    ;   ;   ;;      ifBLIN_QW1("clock_gettime #3");                                                /**/
    ;   ;   ;;  }                                                                                  /**/
    ;   ;   ;;  ifBLIN_QX5( "  offset="BLIN_O"%d @ %"BLIN_U".%09lu"                                /**/
            /**/          , mife->offset                                                           /**/
            /**/          , tick.tv_sec                                                            /**/
            /**/          , tick.tv_nsec                                                           /**/
            /**/          )                                                                        /**/
            /**/;                                                                                  /**/
    ;   ;   }/****************************************************************************************/
    ;   ;   rdlen = mife->f.read(mife->f.fd, tmpbuf, tmplen);
    ;   ;   ifBLIN_QX2( "  -> read(%d, %"BLIN_X"[%"BLIN_D"])=%"BLIN_D" +%"BLIN_O"d retrylim=%d"
                      , mife->f.fd
                      , tmpbuf
                      , tmplen
                      , rdlen
                      , mife->offset
                      , retrylim
                      )
            ;
    ;   ;   if  (rdlen < 0) {
    ;   ;       if  (errno == EAGAIN || errno == EDEADLK) {
    ;   ;           ifBLIN_QW1("read retry");
    ;   ;           rdlen = 0;
    ;   ;       } else {
    ;   ;           ifBLIN_QW0("read");
    ;   ;           EXOUT(-EX_IOERR);
    ;   ;       }
    ;   ;   } else if (!rdlen) {
    ;   ;       --retrylim;
    ;   ;   }
    ;   ;   if (!rdlen) {
    ;   ;       if  (retrylim-- <= 0) break;
    ;   ;       usleep(1 << ((MIFE_RTRY & mife->flags) - (retrylim / 2)));
    ;   ;   }
    ;   ;   ifBLIN_QX3("rdlen=%"BLIN_D" delta=%"BLIN_O"d", rdlen, delta);
    ;   } while (!rdlen);
    ;   if  (!rdlen) {
    ;       mife->flags |= MIFE_EOFL;
    ;       needlen = -1;
    ;       if  (offset > mife->offset + (off_t)mife->actlen) {
    ;           ex = -EX_NOINPUT;
    ;           errno = ESPIPE;
    ;           goto ok;
    ;       }
    ;       ifBLIN_QX3("needlen=%"BLIN_D, needlen);
    ;       MIFE_DUMP(mife, delta);
    ;   } else if (!delta) {
    ;       if  (mife->eol) mife->eol->start(mife, mife->actbeg + mife->actlen);
    ;       mife->actlen += rdlen;
    ;       if  (ordlen && ((off_t)mife->actlen > (mife->ofpoint - mife->offset + ordlen))) {
    ;           needlen = -1;
    ;       }
    ;       if  (mife->eol && (0 <= mife->eol->detect(mife))) {
    ;           ifBLIN_QX5(" eolp=%"BLIN_D", eolst=%"BLIN_D, mife->eol->p, mife->eol->st);
    ;           needlen = -1;
    ;       }
    ;       ifBLIN_QX3("needlen=%"BLIN_D, needlen);
    ;       MIFE_DUMP(mife, delta);
    ;   } else if (delta <= rdlen) {
    ;       mife->actbeg = 0;
    ;       mife->actlen = rdlen;
    ;       mife->ofpoint = mife->offset + delta;
    ;       if  (ordlen && ((off_t)mife->actlen >= (delta + ordlen))) needlen = -1;
    ;       if  (mife->eol && (0 <= mife->eol->detect(mife))) {
    ;           ifBLIN_QX5(" eolp=%"BLIN_D", eolst=%"BLIN_D, mife->eol->p, mife->eol->st);
    ;           needlen = -1;
    ;       }
    ;       delta = 0;
    ;       ifBLIN_QX3("needlen=%"BLIN_D, needlen);
    ;       MIFE_DUMP(mife, delta);
    ;   } else {
    ;       mife->actlen += rdlen;
    ;       delta -= rdlen;
    ;       ifBLIN_QX3("needlen=%"BLIN_D, needlen);
    ;       MIFE_DUMP(mife, delta);
    }   }
    ex = mife->offset + mife->actlen - mife->ofpoint;     /* mife->actlen - mife->thepoint;     XXXX */
ok:
    if  (mife->flags & MIFE_FULL) CHARBUF[mife->actbeg + mife->actlen] = 0;
out:
    ifBLIN_QX2( "- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static ssize_t
mife_mmap(mife_descriptor *mife, ssize_t ordlen, off_t offset) {
    ssize_t  needlen;
    ssize_t  ex = -1;
    off_t    offtop;
    size_t   psz;

#   define blin_internal_flags (mife->flags)
    ifBLIN_QX2("+ %"BLIN_X" ordlen=%"BLIN_D" offset=%"BLIN_O"d", BLIN_I(mife), ordlen, offset);
    MIFE_DUMP(mife, (off_t)0);
    if  (offset >= mife->st_size) {
        ifBLIN_QX1("offset %lld >= st_size %lld", offset, mife->st_size);
        mife->flags |= MIFE_EOFL;
        if  (mife->flags & MIFE_FULL) CHARBUF[mife->actbeg + mife->actlen] = 0;
        ERROUT(-EX_NOINPUT, ESPIPE);
    }
    psz = getpagesize() - 1;
    if  (mife->buffer) {
        ifBLIN_QX2("  -> munmap %"BLIN_X"[%"BLIN_U"]", mife->buffer, mife->buflen);
        if  (0 > munmap(mife->buffer, mife->buflen)) {
            ifBLIN_QW0("munmap");
            EXOUT(-EX_IOERR);
        }
        mife->buffer = NULL;
    }
    mife->offset = offset & ~psz;
    mife->ofpoint = offset; /* mife->thepoint = offset - mife->offset;                          XXXX */
    mife->actbeg = 0;
    if  (!ordlen) {
        if  (mife->flags & MIFE_SLID) {
            needlen = mife->mindelta;
        } else {
            needlen = mife->st_size - offset;
            mife->flags |= MIFE_EOFL;
        }
    } else if (ordlen < mife->mindelta) {
        needlen = mife->mindelta;
    } else {
        needlen = ordlen;
    }
    ifBLIN_QX5(" needlen %"BLIN_U, needlen);
    for (;;) {
        void       *tmpbuf;

    ;   if  (offset + needlen >= mife->st_size) {
    ;       mife->actlen = mife->st_size - mife->offset;
    ;       offtop = (mife->st_size + ((mife->flags & MIFE_FULL) ? 1 : 0) + psz) & ~psz;
    ;       mife->flags |= MIFE_EOFL;
    ;   } else {
    ;       offtop = (offset + needlen + psz) & ~psz;
    ;       mife->actlen = offtop - mife->offset;
    ;       if  (mife->flags & MIFE_FULL) offtop += psz + 1;
    ;   }
    ;   mife->buflen = offtop - mife->offset;
    ;   if  (!(~mife->flags & (MIFE_EOFL | MIFE_FULL)) && !(mife->buflen & psz)) {
    ;       mife->buflen += psz + 1;
    ;       mife->buflen &= ~psz;
    ;       if  (!(mife->buffer = aligned_alloc(psz + 1, mife->buflen))) {
    ;           ifBLIN_QW0("aligned_alloc(%"BLIN_U", %"BLIN_U")", psz + 1, mife->buflen);
    ;           EXOUT(-EX_OSERR);
    ;       }
    ;       ifBLIN_QX2( "  -> alloc over %"BLIN_X"[%"BLIN_U"]", mife->buffer, mife->buflen);
    ;       mife->actbeg = mife->buflen & psz;
    ;       tmpbuf = mmap( mife->buffer + mife->actbeg
                         , mife->actlen
                         , PROT_READ | PROT_WRITE
                         , MAP_PRIVATE | MAP_FIXED
                         , mife->f.fd
                         , mife->offset
                         )
            ;
    ;       ifBLIN_QX2( "  -> mmap over tmpbuf=%"BLIN_X, tmpbuf);
    ;       MIFE_DUMP(mife, (off_t)0);
    ;       if  (tmpbuf == MAP_FAILED) {
    ;           EXOUT(-EX_IOERR);
    ;       }
    ;       mife->buffer = tmpbuf;
    ;   } else {
    ;       tmpbuf = mmap( NULL
                         , mife->buflen
                         , PROT_READ | PROT_WRITE
                         , MAP_PRIVATE
                         , mife->f.fd
                         , mife->offset
                         )
            ;
    ;       ifBLIN_QX2( "  -> mmap %d @ %"BLIN_O"d %"BLIN_X">>%"BLIN_X"[%"BLIN_U"]"
                      , mife->f.fd
                      , mife->offset
                      , mife->buffer
                      , tmpbuf
                      , mife->buflen
                      )
            ;
    ;       if  (tmpbuf == MAP_FAILED) {
    ;           ifBLIN_QW0( "mmap(NULL, %"BLIN_X"(%"BLIN_U"), %X, %X, %d, %"BLIN_O"d)"
                          , mife->buflen
                          , mife->buflen
                          , PROT_READ | PROT_WRITE
                          , MAP_PRIVATE
                          , mife->f.fd
                          , mife->offset
                          )
                ;
    ;           EXOUT(-EX_IOERR);
    ;       }
    ;       mife->buffer = tmpbuf;
    ;   }
    ;   if  (!(mife->flags & MIFE_EOFL) && !ordlen && mife->eol) {
    ;       /* mife->eol->start()  ,    */
    ;       mife->eol->start(mife, mife->ofpoint - mife->offset);             /* mife->thepoint XXXX */
    ;       if  (0 > mife->eol->detect(mife)) {
    ;           needlen *= 2;
    ;           ifBLIN_QX2( "  -> munmap %"BLIN_X"[%"BLIN_U"] needlen "BLIN_U
                          , mife->buffer
                          , mife->buflen
                          , needlen
                          )
                ;
    ;           if  (0 > munmap(mife->buffer, mife->buflen)) {
    ;               ifBLIN_QW2("munmap");
    ;               EXOUT(-EX_IOERR);
    ;           }
    ;           continue;
    ;   }   }
    ;   ex = mife->offset + mife->actlen - mife->ofpoint; /* mife->actlen - mife->thepoint;     XXXX */
    ;   if  (mife->flags & MIFE_FULL) CHARBUF[mife->actbeg + mife->actlen] = 0;
    ;   break;
    }
out:
    ifBLIN_QX2( "- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

#   define blin_internal_flags ((mife ? mife->flags : mife_default) & BLIN_MASK)

ssize_t
mife_read(mife_descriptor *mife, ssize_t ordlen, off_t offset) {
    ssize_t      ex = -1;
    struct stat  sb;
    int          i;

    ifBLIN_QX2( "+ %"BLIN_X" ordlen=%"BLIN_D" offset=%"BLIN_O"d page=%d"
              , BLIN_I(mife)
              , ordlen
              , offset
              , getpagesize()
              )
    ;
    if  (!mife) {
        ifBLIN_QX0("NULL mife descriptor");
        ERROUT(-EX_USAGE, EFAULT);
    }
    MIFE_DUMP(mife, (off_t)0);
    if  (0 > ordlen) {
        ifBLIN_QX0("0 > ordlen%"BLIN_D, ordlen);
        ERROUT(-EX_USAGE, EINVAL);
    }
    if  (  !!mife->buffer
        && (offset >= mife->offset)
        && (offset <= mife->offset + (off_t)mife->actlen)
        && (  (!!ordlen&& (offset + ordlen <= mife->offset + (off_t)mife->actlen))
           || (!!mife->eol && (0 <= mife->eol->detect(mife)))
           || (mife->flags & MIFE_EOFL)
        )  ) {
        ifBLIN_QX2("  -> none");
        mife->ofpoint = offset; /* mife->thepoint = offset - mife->offset;                      XXXX */
        ex = mife->offset + mife->actlen - offset; /* mife->actlen - mife->thepoint;            XXXX */
        goto out;
    }
    if  (mife->flags & (MIFE_EOFL | MIFE_INMM)) {
        ifBLIN_QX2("  -> eof");
        ex = -EX_USAGE;
        if  (!mife->buffer) {
            ifBLIN_QX0("NULL buffer");
            errno = EDOOFUS;
        } else if (mife->offset > offset) {
            ifBLIN_QX0("read backward");
            errno = ESPIPE;
        } else if (offset > mife->offset + (off_t)mife->actlen) {
            ifBLIN_QX1("read after end");
            mife->actbeg += mife->actlen;
            mife->offset += mife->actlen;
            mife->ofpoint = mife->offset;
            mife->actlen = 0;
            errno = EDOM;
            ex = -1;
        } else {
            ifBLIN_QX0("EOFL | INMM");
            errno = EINVAL;
        }
        goto out;
    }
    if  (!(mife->flags & (MIFE_PIPE | MIFE_MMAP))) {
        if  (fstat(mife->f.fd, &sb)) {
            ifBLIN_QW0("fstat");
            EXOUT(-EX_IOERR);
        }
        mife->st_mode = sb.st_mode;
        switch (mife->st_mode & S_IFMT) {
        case S_IFREG: case S_IFDIR:
            ifBLIN_QX4("  -> mmap %"BLIN_O"d mode %07o", sb.st_size, sb.st_mode);
            mife->flags |= MIFE_MMAP;
            mife->st_size = sb.st_size;
            break;
        case S_IFIFO: case S_IFCHR: case S_IFBLK: case S_IFSOCK:
            ifBLIN_QX4("  -> pipe");
            mife->flags |= MIFE_PIPE;
            break;
        default: case S_IFLNK: case S_IFWHT: {
            ifBLIN_QX0("  -> unknown %07o", sb.st_mode);
            ERROUT(-EX_OSERR, EINVAL);
    }   }   }
    if  (mife->flags & MIFE_MMAP) {
        ex = mife_mmap(mife, ordlen, offset);
    } else if (mife->flags & MIFE_PIPE) {
        ex = mife_pipe(mife, ordlen, offset);
    }
out:
    if  (0 > ex) {
        ifBLIN_QW0("Err");
    } else if (0 > (i = mife_ctltest(mife))) {
        ifBLIN_QW0("Illegal mife");
        ex = i;
    } else if (!!i) {
        ifBLIN_QX0("Incorrect mife");
        errno = EINVAL;
        ex = -i;
    }
    ifBLIN_QX2( "- %d", ex);
    return(ex);
}

void *
mife_pointer(mife_descriptor *mife) {
    void  *p = NULL;

    ifBLIN_QX2("+ %"BLIN_X, BLIN_I(mife));
    if  (!!mife_ctltest(mife)) {
        ifBLIN_QW0("Illegal mife");
        goto out;
    }
    MIFE_DUMP(mife, (off_t)0);
    p = mife->buffer + mife->ofpoint - mife->offset + mife->actbeg;
out:
    ifBLIN_QX2("- %"BLIN_X, BLIN_I(p));
    return(p);
}

void *
mife_get(mife_descriptor *mife, off_t offset) {
    void  *p = NULL;

    ifBLIN_QX2("+ %"BLIN_X" %"BLIN_O"d", BLIN_I(mife), offset);
    if  (!!mife_ctltest(mife)) {
        ifBLIN_QW0("Illegal mife");
        goto out;
    }
    MIFE_DUMP(mife, (off_t)0);
    if  (!!mife_ctlofft(mife, offset)) {
        ifBLIN_QW0("ill offset=%"BLIN_O"d", offset);
        goto out;
    }
    mife->ofpoint = offset;
    p = mife->buffer + offset - mife->offset + mife->actbeg;
out:
    ifBLIN_QX2("- %"BLIN_X, BLIN_I(p));
    return(p);
}

void *
mife_window(mife_descriptor *mife, off_t offset, ssize_t ordlen) {
    void    *p = NULL;
    ssize_t  tmplen;

    ifBLIN_QX2("+ %"BLIN_X" %"BLIN_O"d[%"BLIN_U"]", BLIN_I(mife), offset, ordlen);
    MIFE_DUMP(mife, (off_t)0);
    if  (0 > mife_ctlofft(mife, offset)) {
        ifBLIN_QW0("mife_ctlofft(,%"BLIN_O"d)", offset);
        goto out;
    }
    if  (0 > (tmplen = mife_read(mife, ordlen, offset))) {
        ifBLIN_QW0("mife_read(,%"BLIN_D",%"BLIN_O"d)", ordlen, offset);
        goto out;
    }
    if  (!!ordlen && (tmplen < ordlen)) {
        ifBLIN_QX1("short file %"BLIN_D" < %"BLIN_D, tmplen, ordlen);
    }
    p = mife->buffer + offset - mife->offset + mife->actbeg;
out:
    ifBLIN_QX2("- %"BLIN_X, BLIN_I(p));
    return(p);
}
