/*-
 * Copyright (C)2003..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2003..2018 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: old4.c,v 1.3 2018/05/22 21:21:59 babolo Exp $\n"

#define BLIN_COMPAT   3
#define MIFE_COMPAT   4
#define MIFE_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include "mife.h"

ssize_t
mife_ctl(mife_descriptor *mife, int type, ...) {
    ssize_t  ex = EX_OK;
    ssize_t  ordlen;
    off_t    offset;
    size_t   size;
    va_list  ap;
    char    *s;
    int      i;

#   define blin_internal_flags ((mife ? mife->flags : mife_default) & BLIN_MASK)
    ifBLIN_QX2("+ %"BLIN_X" type=%d", BLIN_I(mife), type);
    MIFE_DUMP(mife, (off_t)0);
    va_start(ap, type);
    if  (!mife) {
        ifBLIN_QX0("mife NULL");
        ERROUT(-EX_DATAERR, EFAULT);
    }
    switch (type) {
    case MIFE_CTLFLAG: {
            BLIN_flag flags = va_arg(ap, BLIN_flag);

            ifBLIN_QX3("  CTLFLAG %08X", flags);
            ex = mife_ctlflag(mife, flags);
        }
        break;
    case MIFE_CTLFILE:
        s = va_arg(ap, char *);
        ifBLIN_QX3("  CTLFILE %s", s);
        ex = mife_ctlfile(mife, s);
        break;
    case MIFE_CTLFDSC:
        i = va_arg(ap, int);
        ifBLIN_QX3("  CTLFDSC %d", i);
        ex = mife_ctlfdsc(mife, i);
        break;
    case MIFE_CTLCNST:
        s = va_arg(ap, void *);
        size = va_arg(ap, size_t);
        ifBLIN_QX3("  CTLCNST %"BLIN_X"["BLIN_U"]", BLIN_I(s), size);
        ex = mife_ctlcnst(mife, s, size);
        break;
    case MIFE_CTLBUFF:
        s = va_arg(ap, void *);
        size = va_arg(ap, size_t);
        ifBLIN_QX3("  CTLBUFF %"BLIN_X"["BLIN_U"]", BLIN_I(s), size);
        ex = mife_ctlcnst(mife, s, size);
        break;
    case MIFE_CTLEOLI:
        s = va_arg(ap, char *);
        if  (!s) {
            ifBLIN_QX3("  CTLEOLI NULL");
        } else {
            ifBLIN_QX3("  CTLEOLI =%s~", s);
        }
        ex = mife_ctleoli(mife, s);
        break;
    case MIFE_CTLITIM: {
            const struct timespec *timeout = va_arg(ap, struct timespec *);
            mife_tim     timout;

            ifBLIN_QX3("  CTLITIM %d.%09d", timeout->tv_sec, timeout->tv_nsec);
            timout = timeout->tv_sec * 1000000000ULL + timeout->tv_nsec;
            ex = mife_ctltim0(mife, timout);
        }
        break;
    case MIFE_CTLOTIM: {
            const struct timespec *timeout = va_arg(ap, struct timespec *);
            mife_tim     timout;

            ifBLIN_QX3("  CTLOTIM %d.%09d", timeout->tv_sec, timeout->tv_nsec);
            timout = timeout->tv_sec * 1000000000ULL + timeout->tv_nsec;
            ex = mife_ctltim1(mife, timout);
        }
        break;
    case MIFE_CTLTIM0: {
            mife_tim timeout = va_arg(ap, mife_tim);

            ifBLIN_QX3("  CTLTIM0 %"BLIN_O"u", timeout);
            ex = mife_ctltim0(mife, timeout);
        }
        break;
    case MIFE_CTLTIM1: {
            mife_tim timeout = va_arg(ap, mife_tim);

            ifBLIN_QX3("  CTLTIM1 %"BLIN_O"u", timeout);
            ex = mife_ctltim1(mife, timeout);
        }
        break;
    case MIFE_CTLFINI:
        ifBLIN_QX3("  CTLFINI");
        ex = mife_fini(mife);
        break;
    case MIFE_CTLTEST:
        ifBLIN_QX3( "  CTLTEST %"BLIN_X"->%"BLIN_X"[%"BLIN_D"] actbeg=%"BLIN_D" actlen=%"BLIN_D
                    " offset=%"BLIN_O"d ofpoint=%"BLIN_O"d"
                  , BLIN_I(mife)
                  , BLIN_I(mife->buffer)
                  , mife->buflen
                  , mife->actbeg
                  , mife->actlen
                  , mife->offset
                  , mife->ofpoint
                  );
        ex = mife_ctltest(mife);
        break;
    case MIFE_CTLPIPE:
        ifBLIN_QX3("  CTLPIPE");
        ex = mife_ctlpipe(mife);
        break;
    case MIFE_CTLSIZE:
        ifBLIN_QX3("  CTLSIZE");
        ex = mife_ctlsize(mife);
        break;
    case MIFE_CTLREAD:
        offset = va_arg(ap, off_t);
        ordlen = va_arg(ap, ssize_t);
        ifBLIN_QX3("  CTLREAD %"BLIN_O"d[%"BLIN_U"]", offset, ordlen);
        ex = mife_read(mife, ordlen, offset);
        break;
    case MIFE_CTLOFFT:
        offset = va_arg(ap, off_t);
        ifBLIN_QX3("  CTLOFFT %"BLIN_O"d", offset);
        ex = mife_ctlofft(mife, offset);
        break;
    case MIFE_CTLNULL:
        ifBLIN_QX3("  CTLNULL");
        ex = mife_ctlnull(mife);
        break;
    default:
        ifBLIN_QX0("Illegal command %d", type);
        ex = -EX_DATAERR;
        errno = EINVAL;
    }
out:
    va_end(ap);
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

void *
mife_point(mife_descriptor *mife, int type, ...) {
    void    *p = NULL;
    ssize_t  ordlen;
    off_t    offset;
    va_list  ap;
    int      i;

#   define blin_internal_flags ((mife ? mife->flags : mife_default) & BLIN_MASK)
    ifBLIN_QX2("+ %"BLIN_X" type=%d", BLIN_I(mife), type);
    MIFE_DUMP(mife, (off_t)0);
    va_start(ap, type);
    if  (0 > (i = mife_ctltest(mife))) {
        ifBLIN_QW0("Illegal mife");
        goto out;
    } else if (!!i) {
        ifBLIN_QX0("Incorrect mife");
        errno = EINVAL;
        goto out;
    }
    switch (type) {
    case MIFE_POINTER: {
            ifBLIN_QX3("  POINTER");
            p = mife_pointer(mife);
        }
        break;
    case MIFE_POINOFF: {
            offset = va_arg(ap, off_t);
            ifBLIN_QX3("  POINOFF %"BLIN_O"d", offset);
            p = mife_get(mife, offset);
        }
        break;
    case MIFE_POIWIND: {
            offset = va_arg(ap, off_t);
            ordlen = va_arg(ap, ssize_t);
            ifBLIN_QX3("  POIWIND %"BLIN_O"d[%"BLIN_U"]", offset, ordlen);
            p = mife_window(mife, offset, ordlen);
        }
        break;
    default:
        ifBLIN_QX0("Illegal command %d", type);
        errno = EINVAL;
    }
out:
    va_end(ap);
    ifBLIN_QX2("- %"BLIN_X, BLIN_I(p));
    return(p);
#   undef blin_internal_flags
}

mife_descriptor *
mife_open(BLIN_flag flags, const char *path) {
    mife_descriptor *mife = NULL;
    int er;

    if  ((mife = mife_init(flags)) && mife_ctlfile(mife, path)) {
        er = errno;
        mife_fini(mife);
        mife = NULL;
        errno = er;
    }
    return(mife);
}

mife_descriptor *
mife_opef(BLIN_flag flags, int fd) {
    mife_descriptor *mife = NULL;
    int er;

    if  ((mife = mife_init(flags)) && mife_ctlfdsc(mife, fd)) {
        er = errno;
        mife_fini(mife);
        mife = NULL;
        errno = er;
    }
    return(mife);
}

mife_descriptor *
mife_opes(BLIN_flag flags, const char *src, size_t size) {
    mife_descriptor *mife = NULL;
    int er;

    if  ((mife = mife_init(flags)) && mife_ctlcnst(mife, src, size)) {
        er = errno;
        mife_fini(mife);
        mife = NULL;
        errno = er;
    }
    return(mife);
}

mife_descriptor *
mife_opem(BLIN_flag flags, char *src, size_t size) {
    mife_descriptor *mife = NULL;
    int er;

    if  ((mife = mife_init(flags)) && mife_ctlbuff(mife, src, size)) {
        er = errno;
        mife_fini(mife);
        mife = NULL;
        errno = er;
    }
    return(mife);
}

__weak_reference(mife_fini, mife_close);
