/*-
 * Copyright (C)2003..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: mife.h,v 1.33 2018/06/03 14:37:21 babolo Exp $
 */

#ifndef  _MIFE_H_
# define _MIFE_H_

__BEGIN_DECLS

# ifndef  _SYS_TYPES_H_
#  warning this file needs sys/types.h as a prerequisite
#  include <sys/types.h>
# endif

# ifndef  _SYS_EVENT_H_
#  warning this file needs sys/event.h as a prerequisite
#  include <sys/event.h>
# endif

# ifndef  _SYS_TIME_H_
#  warning this file needs sys/time.h as a prerequisite
#  include <sys/time.h>
# endif

# ifndef  _BABOLO_BLINflag_H_
#  warning this file needs babolo/BLINflag.h as a prerequisite
#  include <babolo/BLINflag.h>
# endif

# ifndef MIFE_COMPAT
#  warning MIFE_COMPAT not defined
# endif

/*
 * MIFE_INMM
 * MIFE_MMAP
 * MIFE_PIPE
 */

# if defined(MIFE_COMPAT) && (MIFE_COMPAT <= 4)

#  define kukMIFE_RTRY(x)    ((u_int32_t)(x) & MIFE_RTRY)
#  define setMIFE_RTRY(a, x) do {(a) &= ~MIFE_RTRY; (a) |= kukMIFE_RTRY(x);} while(0)
#  define getMIFE_RTRY(a)    ((a) & MIFE_RTRY)
#  define kukMIFE_BUFL(x)    (((u_int32_t)(x) << 8) & MIFE_BUFL)
#  define setMIFE_BUFL(a, x) do {(a) &= ~MIFE_BUFL; (a) |= kukMIFE_BUFL(x);} while(0)
#  define getMIFE_BUFL(a)    (((a) >> 8) & (MIFE_BUFL >> 8))

typedef struct timespec mife_time;

# endif /* MIFE_COMPAT4 */

typedef struct mife_descriptor mife_descriptor;
typedef u_int64_t mife_tim;

typedef struct mife_eol {
    ssize_t   (*init)(mife_descriptor *mife, const char *eoln);       /*   eol */
    ssize_t   (*detect)(mife_descriptor *mife);                       /*                     */
    void      (*start)(mife_descriptor *mife, ssize_t delta);
    void      (*delta)(mife_descriptor *mife, ssize_t delta);
    void      (*stop)(mife_descriptor *mife);
    const char *ln;            /*                                                    */
    ssize_t    *trix;          /*                                            */
    ssize_t     max;           /*                                                       */
    size_t      trilen;        /*                                                 */
    ssize_t     p;             /*                                       */
    ssize_t     st;            /*                                  */
} mife_eol;

typedef struct mife_event {
    int           kq;
    struct kevent kev;
} mife_event;

/******************************************************************
 * -<-0                                                           *
 * :           buffer->----------------------------------         *
 * :                   :}actbeg                          }        *
 * -<-offset<---==----<-------------------------         }        *
 * :            ==     :}#thepoint#    }        }        }        *
 * -<-ofpoint<--==----<-<-mife_point() }eol->p  }        }        *
 * :            ==     :               }        }actlen  }buflen  *
 * :            ==     ----------------         }        }        *
 * :            ==     :                        }        }        *
 * :------------==------------------------------         }        *
 * :                   : 0 if FULL                       }        *
 * :                   :                                 }        *
 * :                   ----------------------------------         *
 * -<-st_size                                                     *
 * file                 #thepoint# == ofpoint - offset            *
 ******************************************************************/
struct mife_descriptor {
    BLIN_flag   flags;         /*                                                               */
    mode_t      st_mode;       /*                                                           */
    int16_t     dummy;
    off_t       st_size;       /*   ( )                                           */
    off_t       offset;        /*   ( actbeg)                                    */
    off_t       ofpoint;       /*                                                */
    mife_eol   *eol;           /*                                               */
    void       *buffer;        /*                                                               */
    mife_event *kev;           /*  kevent                                  */
    size_t      buflen;        /*                                                        */
    size_t      actbeg;        /*                                           */
    size_t      actlen;        /*                                           */
    ssize_t     mindelta;      /*                                      */
    struct timespec itime;     /*                                           */
    struct timespec otime;     /*                                   */
    union {
        struct {
            int     (*open)(void *, ...);                                /*   fstat() XXXX */
            ssize_t (*read)(int f, void *buf, size_t nbytes);
            int     (*close)(int f);
            int       fd;      /*                                            */
        } f;
        struct {
            void   *(*open)(void *, ...);                                /*   fstat() XXXX */
            ssize_t (*read)(void *a, void *buf, size_t nbytes);
            int     (*close)(void *a);
            void     *ad;      /*                                      */
        } a;
};  };

/*      64 */
typedef struct mife_aout {
    BLIN_flag   flag;          /*                                                               */
    union { size_t        pos;
            struct {
                u_int16_t lo;
                u_int16_t hi;
            } wr;
    } towrite;                 /*                                             */
    off_t       offset;        /*                                         */
    void       *iocb[];        /*                                      */
} mife_aout;

mife_descriptor *mife_init      __P((BLIN_flag flags));
# define MIFE_RTRY    0x0000FF /* R  */
# define MIFE_BUFS    8
# define MIFE_BUFL /* 0x000F00  * RW */ (0x0F << MIFE_BUFS)
# define MIFE_SLID    0x001000 /* R                                         */
# define MIFE_RECY    0x001000 /*  W                                    */
# define MIFE_STRI    0x002000 /* R  not use strlen(src) in CTLCNST & CTLBUFF                        */
# define MIFE_SYNC    0x002000 /*  W   AIO                                            */
# define MIFE_BACK    0x004000 /* R  Write back                                                      */
# define MIFE_INMM    0x010000 /* R                                               */
# define MIFE_ALLC    0x020000 /* RW    free()                                        */
# define MIFE_MMAP    0x040000 /* R   mmaped                                                    */
# define MIFE_CLOS    0x080000 /* RW    fd                                           */
# define MIFE_EOFL    0x100000 /* R                                               */
                               /*  W   EOF                                     */
# define MIFE_FULL    0x200000 /* R    \0                                            */
# define MIFE_PIPE    0x400000 /* R                                         */
# define MIFE_BUFX    0x800000 /* R                                          */

# if defined(MIFE_COMPAT) && (MIFE_COMPAT <= 4)

ssize_t          mife_ctl       __P((mife_descriptor *mife, int type, ...));
# define MIFE_CTLFLAG  0       /* (BLIN_flag flags)                                */
# define MIFE_CTLFILE  1       /* (char *path)  mife  path                                */
# define MIFE_CTLFDSC  2       /* (int fd)  mife   fd                          */
# define MIFE_CTLCNST  3       /* (const void *buf)   buf                     */
# define MIFE_CTLBUFF  4       /* (void *buf)  buf                                 */
# define MIFE_CTLEOLI  5       /* (const char *eoln)    eoln                 */
#  define MIFE_CTLITIM 6       /* (const struct timespec *timeout)               *
                                *          read()                                         */
#  define MIFE_CTLOTIM 7       /* (const struct timespec *timeout)               *
                                *          read()                                   */
# define MIFE_CTLFINI  8 /* (void)  mife                                  */
# define MIFE_CTLTIM0 10 /* (mife_tim timeout)     read()             */
# define MIFE_CTLTIM1 11 /* (mife_tim timeout)     read()       */
# define MIFE_CTLTEST 12 /* (void)    mife                             */
# define MIFE_CTLPIPE 13 /* (void)   ,                                   *
                          *             mife     */
# define MIFE_CTLSIZE 14 /* (void)      ,                     *
                          *          EAGAIN mife_point(MIFE_POIWIND)                    */
# define MIFE_CTLREAD 15 /* (off_t offset, ssize_t ordlen)  mife_read(mife, ordlen, offset)*/
# define MIFE_CTLOFFT 16 /* (off_t offset)    offset                 */
# define MIFE_CTLNULL 17 /* (void)  mife   MIFE_CTLFILE..MIFE_CTLBUFF              */

void            *mife_point     __P((mife_descriptor *mife, int type, ...));
# define MIFE_POINTER  0 /* (void)                    */
# define MIFE_POINOFF  1 /* (off_t offset)        offset,    *
                          *           ţ                                       */
# define MIFE_POIWIND  2 /* (off_t offset, ssize_t ordlen)    ordlen         *
                          *          offset,     offset        */

# endif /* MIFE_COMPAT4 */

ssize_t          mife_writ      __P((int fd, const void *buf, size_t nbytes));
mife_aout       *mife_aopen     __P((BLIN_flag flags, int fd));
int              mife_aput      __P((mife_aout *aso, int src));
int              mife_aclose    __P((mife_aout *aso));

void            *mife_pointer   __P((mife_descriptor *mife));
void            *mife_get       __P((mife_descriptor *mife, off_t offset));
void            *mife_window    __P((mife_descriptor *mife, off_t offset, ssize_t ordlen));
ssize_t          mife_read      __P((mife_descriptor *mife, ssize_t ordlen, off_t offset));
int              mife_ctlflag   __P((mife_descriptor *mife, BLIN_flag flags));
int              mife_ctlnull   __P((mife_descriptor *mife));
int              mife_ctlfile   __P((mife_descriptor *mife, const char *path));
int              mife_ctlfdsc   __P((mife_descriptor *mife, int fd));
int              mife_ctlcnst   __P((mife_descriptor *mife, const void *s, size_t size));
int              mife_ctlbuff   __P((mife_descriptor *mife, void *s, size_t size));
int              mife_ctleoli   __P((mife_descriptor *mife, const char *s));
int              mife_ctltim0   __P((mife_descriptor *mife, mife_tim timeout));
int              mife_ctltim1   __P((mife_descriptor *mife, mife_tim timeout));
int              mife_ctltest   __P((mife_descriptor *mife));
int              mife_ctlpipe   __P((mife_descriptor *mife));
ssize_t          mife_ctlsize   __P((mife_descriptor *mife));
int              mife_ctlofft   __P((mife_descriptor *mife, off_t offset));
int              mife_fini      __P((mife_descriptor *mife));

# if (defined(MIFE_COMPAT) && (MIFE_COMPAT <= 3)) || defined(MIFE_COMPAT3)

mife_descriptor *mife_opef      __P((BLIN_flag flags, int fd));
mife_descriptor *mife_open      __P((BLIN_flag flags, const char *path));
mife_descriptor *mife_opes      __P((BLIN_flag flags, const char *src, size_t size));
mife_descriptor *mife_opem      __P((BLIN_flag flags, char *src, size_t size));

ssize_t          mife_eolinit   __P((mife_descriptor *mife, const char *eoln));
ssize_t          mife_eoldetect __P((mife_descriptor *mife));

#  define eomax      eol->max
#  define eotrilen   eol->trilen
#  define eolp       eol->p
#  define eolst      eol->st
#  define eotrix     eol->trix
#  define eoln       eol->ln
#  define mife_close mife_fini

# endif /* MIFE_COMPAT3 */

# ifdef MIFE_INTERNAL
#  define MINEOLN      0x0F           /*    eoln                                 ****/
#  define MAXPACKT     (1 << 16)      /*    ,     *
                                       *    read(2)  (   sa(4))        *
                                       * !!!   2 !!!                            ****/
#  define MINDELTA     (MAXPACKT * 4) /*     ,  2             *
                                       *  .      SCSI    *
                                       * mtu  loopback.    .     *
                                       *    realloc()                     ****/
#  define NRETRY00     2              /*  read(2)      ,        *
                                       *  ,        *
                                       * read() == 0 NRETRY00  .                         ****/
#  define DEFMEM       0x80000000     /*  DEFMEM >> 8 ,    .    ****/

#  define M_defin      0x000001
#  define CHARBUF      ((char*)(mife->buffer))
#  define ERROUT(A, B) do {ex = (A); errno = (B); goto out;} while (0)
#  define EXOUT(A)     do {ex = (A); goto out;} while(0)
#  define MIFE_DUMP(MIFE, DELTA) do {mife_dump(__FILE__, __func__, __LINE__, MIFE, DELTA);} while (0)
#  define SETBDEF(F)                                                                                  \
    do {if (~mife_default & M_defin) mife_default = ((F) & BLIN_MASK) | M_defin;} while(0)

extern BLIN_flag mife_default;
extern mife_eol  mife_eol0;
void mife_dump __P((const char *file, const char *func, int line, mife_descriptor *mife, off_t delta));
# endif /* MIFE_INTERNAL */

__END_DECLS

#endif /* !_MIFE_H_ */
