/*-
 * Copyright (C)2004..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2004..2018 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: eol.c,v 1.23 2018/06/03 14:37:21 babolo Exp $\n"

#define BLIN_COMPAT   3
#define MIFE_COMPAT   5
#define MIFE_INTERNAL 1

#include <sys/limits.h>
#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include "mife.h"

/******************************************/
/* eomax == -1 eoln    */
/* eomax >= 0    eoln       */
/* eolst == -1 eoln       */
/* eolst >= 0           */
/******************************************/

static void
eolstart(mife_descriptor *mife, ssize_t delta) {
    if  (mife->eol->st <= 0) {
        mife->eol->p = delta;
        mife->eol->st = 0;
}   }

static void
eoldelta(mife_descriptor *mife, ssize_t delta) {
    if  (mife->eol->st >= 0) {
        mife->eol->p += delta;
        if  (mife->eol->p < 0) {
            mife->eol->p = 0;
            mife->eol->st = 0;
}   }   }

static void
eolstop(mife_descriptor *mife) {
    mife->eol->st = -1;
}

ssize_t
mife_eoldetect(mife_descriptor *mife) {
    ssize_t r;

#   define blin_internal_flags ((mife ? mife->flags : mife_default) & BLIN_MASK)
    r = -2;
    ifBLIN_QX2("+ %"BLIN_X, BLIN_I(mife));
    if  (!mife) {
        errno = EBADF;
        ifBLIN_QW0("NULL mife descriptor");
    } else if (mife->actlen > SSIZE_MAX) {
        errno = EDOM;
        ifBLIN_QW0("actlen");
    } else if (!mife->eol) {
        errno = EBADF;
        ifBLIN_QW0("NULL eol");
    } else if (mife->eol->ln && (mife->eol->st >= 0)) {
        MIFE_DUMP(mife, (off_t)0);
        r = -1;
        while ((mife->eol->p < (ssize_t)(mife->actlen)) && (r < 0)) {
            ifBLIN_QX4( "eolp=%"BLIN_D" eolst=%"BLIN_D" eomax=%"BLIN_D
                      , mife->eol->p, mife->eol->st, mife->eol->max
                      )
            ;
            if  ((mife->eol->st >= 0) && (mife->eol->st >= mife->eol->max)) {
                r = mife->eol->p;
                mife->eol->st = 0;
            } else {
                while (1) {
                    if  (CHARBUF[mife->actbeg + mife->eol->p] == mife->eol->ln[mife->eol->st]) {
                        ifBLIN_QX5(" + eolp=%"BLIN_D" eolst=%"BLIN_D, mife->eol->p, mife->eol->st);
                        mife->eol->st++;
                        break;
                    } else if (mife->eol->st) {
                        ifBLIN_QX5(" > eolp=%"BLIN_D" eolst=%"BLIN_D, mife->eol->p, mife->eol->st);
                        if  (mife->eol->st <= (mife->eol->trix)[mife->eol->st]) {
                            ifBLIN_QX0( "FATAL: eotrix not decreased %"BLIN_D" -> %"BLIN_D
                                      , mife->eol->st, (mife->eol->trix)[mife->eol->st]
                                      )
                            ;
                            exit(EX_SOFTWARE);
                        }
                        mife->eol->st = (mife->eol->trix)[mife->eol->st];
                    } else {
                        ifBLIN_QX5(" V eolp=%"BLIN_D" eolst=%"BLIN_D, mife->eol->p, mife->eol->st);
                        mife->eol->st = 0;
                        break;
                }   }
                mife->eol->p++;
    }   }   }
    ifBLIN_QX2("- %"BLIN_D, r);
    return(r);
#   undef blin_internal_flags
}

ssize_t
mife_eolinit(mife_descriptor *mife, const char *eoln) {
    int i;

#   define blin_internal_flags ((mife ? mife->flags : mife_default) & BLIN_MASK)
    ifBLIN_QX2("+ %"BLIN_X" %s%s~", BLIN_I(mife), eoln ? "=" : "", eoln ? eoln : "");
    MIFE_DUMP(mife, (off_t)0);
    i = -1;
    if  (!mife) {
        errno = EBADF;
        ifBLIN_QW0("NULL mife descriptor");
    } else if (mife->actlen > SSIZE_MAX) {
        errno = EDOM;
        ifBLIN_QW0("actlen");
    } else if (!eoln) {
        mife->eol->ln = NULL;
        i = 0;
    } else if (mife->eol) {
        mife->eol->max = strlen(eoln);
        if  (mife->eol->trilen < (mife->eol->max * sizeof(ssize_t))) {
            free(mife->eol->trix);
            mife->eol->trilen = 0;
        }
        if  (!mife->eol->trilen && mife->eol->max) {
            mife->eol->trilen = ((mife->eol->max * sizeof(ssize_t)) + MINEOLN) & ~MINEOLN;
            if  (!(mife->eol->trix = malloc(mife->eol->trilen))) {
                errno = ENOMEM;
                ifBLIN_QX0("no mem");
                i = -EX_OSERR;
                goto out;
        }   }
        mife->eol->st = -1;
        mife->eol->p = 0;
        mife->eol->ln = eoln;
        if  (mife->eol->max) (mife->eol->trix)[0] = -1;
        for (i = 1; i < mife->eol->max; ++i) {
            if  ((mife->eol->trix)[i - 1] < 0) {
                if  (eoln[i] == eoln[0]) (mife->eol->trix)[i] = 0;
            } else {
                if  (eoln[i - 1] == eoln[(mife->eol->trix)[i - 1]]) {
                    (mife->eol->trix)[i] = (mife->eol->trix)[i - 1] + 1;
        }   }   }
        for (i = 0; i < mife->eol->max; ++i) {
            if  ((mife->eol->trix)[i] < 0) (mife->eol->trix)[i] = 0;
            if  (((mife->eol->trix)[i] > 0) && (eoln[i] == eoln[(mife->eol->trix)[i]])) {
                (mife->eol->trix)[i] = 0;
            }
            ifBLIN_QX4(" [%d]%"BLIN_D, i, mife->eol->trix[i]);
        }
    } else {
        i = mife_ctleoli(mife, eoln);
    }
out:
    ifBLIN_QX2("- %d", i);
    return(i);
#   undef blin_internal_flags
}

mife_eol mife_eol0 =
{ mife_eolinit
, mife_eoldetect
, eolstart
, eoldelta
, eolstop
, NULL
, NULL
, 0
, 0
, 0
, 0
};
