/*-
 * Copyright (C)2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2018 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: dump.c,v 1.3 2018/06/03 14:37:21 babolo Exp $\n"

#define BLIN_COMPAT   3
#define MIFE_COMPAT   5
#define MIFE_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include "mife.h"

void
mife_dump(const char *file, const char *func, int line, mife_descriptor *mife, off_t delta) {
#   define blin_internal_flags (mife->flags)
    if  (!!mife && (mife->flags & BLIN_BIT3)) {
        blin_cry1( 3
                 , "%s:%s:%d mife%c%08X in %06o[%"BLIN_O"d] i%lu.%09lu o%lu.%09lu\n"
                   " offset=%"BLIN_O"d ofpoint=%"BLIN_O"d buf=%"BLIN_X"[%"BLIN_D"]+%"BLIN_D
                   " actbeg=%"BLIN_D" actlen=%"BLIN_D"\n"
                   " kev=%"BLIN_X" (o=%"BLIN_X" r=%"BLIN_X" c=%"BLIN_X" d=%"BLIN_X") dt=%"BLIN_O"d"
                 , file
                 , func
                 , line
                 , (!mife->dummy) ? ' ' : '*'
                 , mife->flags
                 , mife->st_mode
                 , mife->st_size
                 , mife->itime.tv_sec
                 , mife->itime.tv_nsec
                 , mife->otime.tv_sec
                 , mife->otime.tv_nsec
                 , mife->offset
                 , mife->ofpoint
                 , BLIN_I(mife->buffer)
                 , mife->buflen
                 , mife->mindelta
                 , mife->actbeg
                 , mife->actlen
                 , BLIN_I(mife->kev)
                 , BLIN_I(mife->a.open)
                 , BLIN_I(mife->a.read)
                 , BLIN_I(mife->a.close)
                 , BLIN_I(mife->a.ad)
                 , delta
                 )
        ;
    }
#   undef blin_internal_flags
}