/*-
 * Copyright (C)2007..2018 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2007..2018 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: awrit.c,v 1.23 2018/12/14 13:22:02 babolo Exp $\n"

#define BLIN_COMPAT   3
#define MIFE_COMPAT   5
#define MIFE_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <stdio.h>
#include <errno.h>
#include <aio.h>
#include <babolo/BLINflag.h>
#include "mife.h"

#define TRUFLAG(A) ((A) & (MIFE_BUFL | MIFE_SYNC | MIFE_CLOS | MIFE_EOFL | BLIN_MASK))

/*      64 */
/* ,  16  -    struct aiocb */
#define ROUND4(A)  (((A) + 15) & ~0x0F)
#define AIOBUF     65536
#define AIOSIZE    (ROUND4(sizeof(struct aiocb)))
#define AOUSIZE(A) (ROUND4((A) * sizeof(struct aiocb *) + sizeof(mife_aout)))
#define AIONUM(A)  ((((A) & MIFE_BUFL) >> MIFE_BUFS) + 1)
#define IOCB(A,B)  ((struct aiocb *)((A)->iocb[B]))

/*            *
 * (     UNIX)  *
 *    ,   ,        *
 *                 */
static int sigsys = 0;
static int siginit = 0;
static BLIN_flag sigflag = 0;
static struct sigaction sigact;
static char sigmes[] = "SIGSYS in mife AIO\n";

static void
atrap(int sig) {
    if  (sig == SIGSYS) {
        sigsys = 1;
        ifBLIN_QQ1(sigflag) write(fileno(stderr), sigmes, strlen(sigmes) + 1);
}   }

static void
ainit(BLIN_flag flags) {
    if  (!siginit) {
        bzero(&sigact, sizeof(sigact));
        sigact.sa_handler = atrap;
        sigemptyset(&sigact.sa_mask);
        siginit = 1;
        sigflag = flags;
}   }

mife_aout *
mife_aopen(BLIN_flag flags, int fd) {
    mife_aout *aso = NULL;
    size_t s, i;

#   define blin_internal_flags (flags & BLIN_MASK)
    ifBLIN_QX2("+ flags=%08X, fd=%d", flags, fd);
    SETBDEF(flags);
    if  (sigsys) flags |= MIFE_SYNC;
    if  (flags & MIFE_SYNC) {
        flags &= ~MIFE_BUFL;
    }
    s = (AIONUM(flags)) * AIOSIZE + AOUSIZE(AIONUM(flags));
    aso = calloc(s >> 4, 16); /*  mife_aout   struct aiocb   */
    if  (!aso) {
        errno = ENOMEM;
        ifBLIN_QW0("#1");
        goto out;
    }
    aso->flag = TRUFLAG(flags);
    for (i = 0; i <= ((flags & MIFE_BUFL) >> MIFE_BUFS); ++i) {
        ifBLIN_QX4("%"BLIN_X, BLIN_I(IOCB(aso, i)));
        aso->iocb[i] = (void*)aso + (i * AIOSIZE + AOUSIZE(AIONUM(flags)));
        IOCB(aso, i)->aio_fildes = fd;
        IOCB(aso, i)->aio_buf = malloc(AIOBUF);
        if  (!IOCB(aso, i)->aio_buf) {
            errno = ENOMEM;
            ifBLIN_QW0("%d", i);
            while (i > 0) {
                --i;
                free((void*)IOCB(aso, i)->aio_buf);
            }
            free(aso);
            goto out;
        }
        ifBLIN_QX4(" %"BLIN_X, BLIN_I(IOCB(aso, i)->aio_buf));
    }
out:
    ifBLIN_QX2("- flags=%08X, %"BLIN_X, flags, BLIN_I(aso));
    return(aso);
#   undef blin_internal_flags
}

int
mife_aput(mife_aout *aso, int src) {
    struct sigaction *oact = NULL;
    int ex, j;

#   define blin_internal_flags ((aso ? aso->flag : mife_default) & BLIN_MASK)
    ifBLIN_QX2("+ %04X:%04X %02X(%c)", aso->towrite.wr.hi, aso->towrite.wr.lo, src, src);
    if  (!aso) {
        ex = -1;
        errno = EBADF;
        ifBLIN_QW0("NULL aso descriptor");
    } else if (aso->flag & MIFE_EOFL && src == EOF) {
        ex = mife_aclose(aso);
    } else {
        ex = 0;
        ((char*)(IOCB(aso, aso->towrite.wr.hi)->aio_buf))[aso->towrite.wr.lo++] = src;
        if  (!aso->towrite.wr.lo) {
        ;   ifBLIN_QX1("write %d offset=%016"BLIN_O"X", aso->towrite.wr.hi, aso->offset);
        ;   IOCB(aso, aso->towrite.wr.hi)->aio_nbytes = AIOBUF;
        ;   IOCB(aso, aso->towrite.wr.hi)->aio_offset = aso->offset;
        ;   aso->offset += AIOBUF;
        ;   if  (sigsys) aso->flag |= MIFE_SYNC;
        ;   j = 0;
        ;   if  (!(aso->flag & (MIFE_SYNC | MIFE_FULL))) {
        ;       ainit(aso->flag);
        ;       ex = sigaction(SIGSYS, &sigact, oact);
        ;       ifBLIN_QX4("sigaction in=%d", ex);
        ;       if  (ex < 0) {
        ;           ifBLIN_QW0("sigaction in");
        ;       } else {
        ;           j = 1;
        ;   }   }
        ;   while (!ex && !(aso->flag & MIFE_SYNC) && aio_write(IOCB(aso, aso->towrite.wr.hi)) < 0) {
        ;       if  ((errno == ENOSYS) || (errno == EOPNOTSUPP) || sigsys) {
        ;           aso->flag |= MIFE_SYNC;
        ;           ifBLIN_QX1("sync");
        ;           ex = 0;
        ;           break;
        ;       } else if (errno != EAGAIN) {
        ;           ifBLIN_QW0("#1");
        ;   }   }
        ;   if  (!(aso->flag & MIFE_FULL)) {
        ;       aso->flag |= MIFE_FULL;
        ;       if  (j) {
        ;           ex |= sigaction(SIGSYS, oact, NULL);
        ;           ifBLIN_QX4("sigaction out=%d", ex);
        ;           if  (ex < 0) ifBLIN_QW0("sigaction out");
        ;   }   }
        ;   if  (aso->flag & MIFE_SYNC) {
        ;       lseek( IOCB(aso, aso->towrite.wr.hi)->aio_fildes
                     , IOCB(aso, aso->towrite.wr.hi)->aio_offset
                     , SEEK_SET
                     )
        ;       ;
        ;       ex = mife_writ( IOCB(aso, aso->towrite.wr.hi)->aio_fildes
                              , (void*)IOCB(aso, aso->towrite.wr.hi)->aio_buf
                              , AIOBUF
                              )
        ;       ;
        ;   } else if (!ex) {
        ;       if  (++aso->towrite.wr.hi >= AIONUM(aso->flag)) {
        ;           ifBLIN_QX4("buffer recicled");
        ;           aso->flag |= MIFE_RECY;
        ;           aso->towrite.wr.hi = 0;
        ;       }
        ;       if  (aso->flag & MIFE_RECY) {
        ;           if  (aio_error(IOCB(aso, aso->towrite.wr.hi)) == EINPROGRESS) {
        ;               while (aio_suspend( (const struct aiocb**)&aso->iocb[aso->towrite.wr.hi]
                                          , 1
                                          , NULL
                                          ) < 0
                              ) {
        ;                   if  (errno != EAGAIN) {
        ;                       ifBLIN_QW0("#2");
        ;                       ex = -1;
        ;           }   }   }
        ;           if  (!ex && aio_return(IOCB(aso, aso->towrite.wr.hi)) < 0) {
        ;               ifBLIN_QW0("#3");
        ;               ex = -1;
    }   }   }   }   }
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
mife_aclose(mife_aout *aso) {
    struct sigaction *oact = NULL;
    int j, ex = 0;
    size_t i;

#   define blin_internal_flags ((aso ? aso->flag : mife_default) & BLIN_MASK)
    ifBLIN_QX2("+");
    if  (!aso) {
        errno = EBADF;
        ifBLIN_QW0("NULL aso descriptor");
        ex = -1;
        goto out;
    }
    if  (aso->towrite.wr.lo) {
        ifBLIN_QX4("lo=%04X offset=%016"BLIN_O"X", aso->towrite.wr.lo, aso->offset);
        IOCB(aso, aso->towrite.wr.hi)->aio_nbytes = aso->towrite.wr.lo;
        IOCB(aso, aso->towrite.wr.hi)->aio_offset = aso->offset;
        if  (sigsys) aso->flag |= MIFE_SYNC;
        j = 0;
        if  (!(aso->flag & (MIFE_SYNC | MIFE_FULL))) {
            ainit(aso->flag);
            ex = sigaction(SIGSYS, &sigact, oact);
            ifBLIN_QX4("sigaction in=%d", ex);
            if  (ex < 0) {
                ifBLIN_QW0("sigaction in");
            } else {
                j = 1;
        }   }
        while (!ex && !(aso->flag & MIFE_SYNC) && aio_write(IOCB(aso, aso->towrite.wr.hi)) < 0) {
            if  ((errno == ENOSYS) || (errno == EOPNOTSUPP) || sigsys) {
                aso->flag |= MIFE_SYNC;
                ifBLIN_QX4("sync");
                ex = 0;
                break;
            } else if (errno != EAGAIN) {
                ifBLIN_QW0("#1");
        }   }
        if  (!(aso->flag & MIFE_FULL)) {
            aso->flag |= MIFE_FULL;
            if  (j) {
                ex |= sigaction(SIGSYS, oact, NULL);
                ifBLIN_QX4("sigaction out=%d", ex);
                if  (ex < 0) ifBLIN_QW0("sigaction out");
        }    }
        if  (aso->flag & MIFE_SYNC) {
            lseek(IOCB(aso, aso->towrite.wr.hi)->aio_fildes, aso->offset, SEEK_SET);
            ex = mife_writ( IOCB(aso, aso->towrite.wr.hi)->aio_fildes
                          , (void*)IOCB(aso, aso->towrite.wr.hi)->aio_buf
                          , aso->towrite.wr.lo
                          )
            ;
        } else {
            for (i = 0; !ex && !(aso->flag & MIFE_SYNC); ++i) {
                if  (aso->flag & MIFE_RECY) {
                    if  (i > ((MIFE_BUFL & aso->flag) >> MIFE_BUFS)) break;
                } else {
                    if  (!aso->towrite.wr.hi && !aso->towrite.wr.lo) break;
                    if  ((i + ((aso->towrite.wr.lo) ? 0 : 1)) > aso->towrite.wr.hi) break;
                }
                if  (aio_error(IOCB(aso, i)) == EINPROGRESS) {
                    while (aio_suspend((const struct aiocb**)&aso->iocb[i], 1, NULL) < 0) {
                        if  (errno != EAGAIN) {
                            ifBLIN_QW0("#2");
                            ex = -1;
                }   }   }
                if  (!ex && aio_return(IOCB(aso, i)) < 0) {
                    ifBLIN_QW0("#3");
                    ex = -1;
    }   }   }   }
    for (i = 0; i <= ((MIFE_BUFL & aso->flag) >> MIFE_BUFS); ++i) {
        free((void *)IOCB(aso, i)->aio_buf);
        if  ((aso->flag & MIFE_CLOS) && (ex = close(IOCB(aso, i)->aio_fildes))) {
            if  (errno != EBADF) {
                ifBLIN_QW0("fildes=%d at %d", IOCB(aso, i)->aio_fildes, i);
            } else {
                errno = 0;
                ex = 0;
    }   }   }
    free(aso);
out:
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}
