/*-
 * Copyright (C)2012 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2012 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: mercumeterq.c,v 1.21 2012/02/29 07:00:34 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <termios.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/parser.h>
#include <babolo/BLINflag.h>
#include <mercumeter.h>

static u_char wk[] =
{ 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143
, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159
, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175
, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191
, 225, 226, 247, 231, 228, 229, 246, 250, 233, 234, 235, 236, 237, 238, 239, 240
, 242, 243, 244, 245, 230, 232, 227, 254, 251, 253, 255, 249, 248, 252, 224, 241
, 193, 194, 215, 199, 196, 197, 214, 218, 201, 202, 203, 204, 205, 206, 207, 208
, 210, 211, 212, 213, 198, 200, 195, 222, 219, 221, 223, 217, 216, 220, 192, 209
};

static char cfb[][21] =
{ "ScanEnable"
, "OptEnable"
, "CheckEnable"
, "ExeEnable"
, "PListReadOnly"
, "NotUsed"
, "CaptureEnable"
, "DayLightSavingEnable"
};

static char csm[][13] =
{ "PlcProtected"
, "TimerSet    "
, "None2       "
, "None3       "
, "None4       "
, "None5       "
, "None6       "
, "None7       "
};

static char ccn[][6] =
{ "None0"
, "None1"
, "None2"
, "None3"
, "None4"
, "None5"
, "None6"
, "None7"
};

static char cbx[][13] =
{ "EMPTY"
, "REQ_ACCEPTED"
, "TRANSACTION"
, "OK"
, "ERROR"
, "UnKnown"
, "UnKnown"
, "UnKnown"
, "UnKnown"
, "UnKnown"
, "UnKnown"
, "UnKnown"
, "UnKnown"
, "UnKnown"
, "UnKnown"
, "UnKnown"
, "ANS_READY"
, "TRANS_TYPE"
, "None6"
, "None7"
};

static char wd[][3] = {"", "", "", "", "", "", ""};

static int
nibble(char c) {
    int e;

    if  (c >= '0' && c <= '9') e = c - '0';
    else if (c >= 'A' && c <= 'F') e = c - 'A' + 10;
    else if (c >= 'a' && c <= 'f') e = c - 'a' + 10;
    else e = -1;
    return(e);
}

static u_char *
hextring(char *o, size_t *ln) {
    size_t l, i;
    u_char *cmd;

    cmd = NULL;
    l = strlen(o) / 2 + 2;
    if  (!(cmd = malloc(l + sizeof(memeter_1pack) + 1))) {
        ifBLIN_QX0("No mem");
        goto out;
    }
    for (*ln = 0, i = 0; o[i];) {
        int e;

        if  (*ln >= l) {
            ifBLIN_QX0("Software error");
            goto out;
        }
        if  (0 > (e = nibble(o[i++]))) {
            ifBLIN_QX0("Illegal input");
            goto out;
        }
        cmd[*ln] = e << 4;
        if  (0 > (e = nibble(o[i++]))) {
            ifBLIN_QX0("Illegal input");
            goto out;
        }
        cmd[*ln] |= e;
        ++*ln;
    }
out:
    return(cmd);
}

static void
usage(int ex) {
    printf( "%s [options] N [params]\n"
            "  -b BAUD        - baud rate\n"
            "  -c CNTR        - counter addr do query for\n"
            "  -E -ANYOPT ENV - option from environment\n"
            "  -f ADDR        - src addr in controller\'s dialog\n"
            "  -i TABLE       - print INSERT TO TABLE statement in 90 and 91\n"
            "  -I [0123456]   - levels for input dumps\n"
            "  -l /dev/line   - tty controller is on\n"
            "  -O [0123456]   - levels for output dumps\n"
            "  -q             - quit\n"
            "  -t ADDR        - dst addr in controller\'s dialog\n"
            "  -v[v...]       - more verbose\n"
            "  -z ...         - recursive getopt without env substitution\n"
            "  -Z ...         - recursive getopt with env substitution\n"
            "  -?             - this help\n"
            "    N: 0 REQ      - request controller with REQ hex string on 2 level\n"
            "       1          - query controller addr and query controller on 3 level\n"
            "       2 REQ MBOX - request PLCII modem CNTR via controller\'s\n"
            "                    MBOX with REQ hex string on 4 level\n"
            "       3 MBOX     - query PLCII modem CNTR via controller\'s MBOX on 5 level\n"
            "       4 MBOX     - query counter CNTR via controller\'s MBOX on 6 level\n"
          , getprogname()
          )
    ;
    exit(ex);
}

static int
getallc(memeter_cfg *cfg, int report) {
    memeter_answ *w;
    u_int32_t i, k;
    int ex = EX_OK;

    do {
        u_int32_t *a;

        if  (!(a = memeter_3exchg(cfg, MEMETER_GET_SEG_NUM))) {
            ifBLIN_QW0("memeter_3exchg");
            break;
        }
        cfg->nmbox = *a;
        free(a);
    } while(0);
    cfg->nmeter = 0;
    if  (!(cfg->meters = malloc(256 * 32 * sizeof(u_int32_t)))) {
        ifBLIN_QX0("no mem");
        ex = EX_OSERR;
        goto out;
    }
    for (i = 0; i < 256; ++i) {
        if  (!(w = memeter_3exchg(cfg, MEMETER_GET_NL_PAGE, i))) {
            ifBLIN_QW0("memeter_3exchg");
            ex = EX_IOERR;
            goto out;
        }
        if  (w->a1 > 32) {
            free(w);
            ifBLIN_QX0("Too long");
            ex = EX_PROTOCOL;
            break;
        }
        for (k = 0; k < w->a1; ++k) cfg->meters[cfg->nmeter++] = w->a2[k];
        if  (w->a1 != 32) break;
        free(w);
    }
    free(w);
out:
    if  (report) {
        printf("%u devices found:", cfg->nmeter);
        for (i = 0; i < cfg->nmeter; ++i) {
            if  (!(i & 3)) printf("\n    ");
            printf(" %08X", cfg->meters[i]);
        }
        printf("\n");
    }
    return(ex);
}

static char *
rediropt(memeter_cfg *cfg, babolo_opt **opt, int redirenv) {
    ifBLIN_FLAG = cfg->flags;
    char *e, *o;

    if  (!(o = babolo_getoptarg(opt, 0))) {
        ifBLIN_QW0("No argument");
        usage(EX_USAGE);
    } else if ((redirenv > 0) && (!(o = getenv(e = o)))) {
        ifBLIN_QX0("No ENV %s", e);
        usage(EX_USAGE);
    }
    return(o);
}

int
main(int argc, char **argv) {
#   define blin_internal_flags (cfg->flags)
#   define INBUF 512            /* overkill XXXX */
    char *flar = "b:c:Ef:i:I:l:O:qt:vw:z:Z:?";
    int redirenv, c, ex = EX_OK;
    memeter_cfg *cfg;
    babolo_parm *bp;
    babolo_opt *opt;
    size_t len;
    char *o;

    if  (!(cfg = calloc(1, sizeof(memeter_cfg)))) {
        errx(EX_UNAVAILABLE, "Calloc failed #1");
    }
    cfg->flags = BLIN_VER1 | MEMETER_SCAN;
    cfg->contrwait = 100000;
    cfg->from = MEMETER_HOST_ADDR;
    cfg->to = MEMETER_BROADDR;
    cfg->baud = B9600;
    cfg->nmeter = 0;
    cfg->wait = 10;
    opt = NULL;
    if  (babolo_openopt(Bpars_NONU, &opt, argc, argv, flar)) {
        ifBLIN_QW0("openopt");
        usage(EX_SOFTWARE);
    }
    for (redirenv = 0; (c = babolo_getopt(&opt)) != 0; redirenv--) {
        if  (redirenv < 0) redirenv = 0;
        switch (c) {
        case 'b': cfg->baud = strtoul(rediropt(cfg, &opt, redirenv), NULL, 0);                   break;
        case 'c':
            cfg->cntr = strtoul(rediropt(cfg, &opt, redirenv), NULL, 0);
            cfg->flags &= ~MEMETER_SCAN;
            break;
        case 'E': redirenv = 2;                                                                  break;
        case 'f': cfg->from = strtoul(rediropt(cfg, &opt, redirenv), NULL, 0);                   break;
        case 'i': cfg->tablename = rediropt(cfg, &opt, redirenv);                                break;
        case 'I':
            {   size_t i;

            ;   o = rediropt(cfg, &opt, redirenv);
            ;   for (i = 0; o[i]; ++i) {
            ;       if  (o[i] >= '0' && o[i] <= '7') {
            ;           cfg->flags |= MEMETER_0IDUMP >> (o[i] - '0');
            }   }   }
            break;
        case 'l': cfg->linename = rediropt(cfg, &opt, redirenv);                                 break;
        case 'O':
            {   size_t i;

            ;   o = rediropt(cfg, &opt, redirenv);
            ;   for (i = 0; o[i]; ++i) {
            ;       if  (o[i] >= '0' && o[i] <= '7') {
            ;           cfg->flags |= MEMETER_0ODUMP >> (o[i] - '0');
            }   }   }
            break;
        case 'q': cfg->flags &= ~BLIN_VERMASK;                                                   break;
        case 't': cfg->to = strtoul(rediropt(cfg, &opt, redirenv), NULL, 0);                     break;
        case 'v': BLIN_VERBOSE(cfg->flags);                                                      break;
        case 'w': cfg->wait = strtoul(rediropt(cfg, &opt, redirenv), NULL, 0);                   break;
        case 'z':
            o = rediropt(cfg, &opt, redirenv);
            bp = babolo_getparm(Bpars_NOEN | Bpars_NOAL | Bpars_NONU, &o, (u_char*)"", 0);
            babolo_openopt(0, &opt, bp->argc, (char **)bp->argv, NULL);
            break;
        case 'Z':
            o = rediropt(cfg, &opt, redirenv);
            bp = babolo_getparm(Bpars_NOAL | Bpars_NONU, &o, (u_char*)"", 0);
            babolo_openopt(0, &opt, bp->argc, (char **)bp->argv, NULL);
            break;
        case '?': usage(EX_OK);
        default : usage(EX_USAGE);
    }   }
    errno = 0;
    if  ((o = babolo_getarg(&opt))) {
        int type;

        type = strtoul(o, NULL, 0);
        switch (type) {
        case 0:
            errno = 0;
            if  (!(o = babolo_getarg(&opt))) goto err;
            {   u_char *cmd, *ans;
                size_t ol;
                int r;

                if  (!(cmd = hextring(o, &len))) {
                    ifBLIN_QX0("hextring");
                    ex = EX_SOFTWARE;
                    goto out;
                }
                ol = INBUF;
                if  (!(ans = malloc(ol))) {
                    ifBLIN_QX0("Malloc failed #1");
                    ex = EX_OSERR;
                    goto out;
                }
                if  (0 > (r = memeter_2exchg(cfg, cmd, len, ans, &ol))) {
                    ifBLIN_QW0("memeter_2exchg");
                    goto out;
                } else if (r) {
                    printf("answer shortened for %u\n", r);
                }
                memeter_dump(ans, ol, "Got 2 answer ");
            }
            goto out;
        case 1:
            do {
                u_int32_t *a;

                if  (!(a = memeter_3exchg(cfg, MEMETER_GET_ADDR))) {
                    ifBLIN_QW0("memeter_3exchg");
                    break;
                }
                cfg->to = *a;
                printf("found %04X controller\n", *a);
                free(a);
            } while(0);
            do {
                memeter_ansb *v;
                u_int32_t i;

                if  (!(v = memeter_3exchg(cfg, MEMETER_GET_VERINFO))) {
                    ifBLIN_QW0("memeter_3exchg");
                    break;
                }
                printf("version: ");
                if  (v->a1 > 255) {
                    ifBLIN_QX0("Too long");
                    ex = EX_SOFTWARE;
                    break;
                }
                for (i = 0; i < v->a1; ++i) {
                    printf("%c", (v->a2[i] < 0x80) ? v->a2[i] : wk[v->a2[i] - 0x80]);
                }
                printf("\n");
                free(v);
            } while(0);
            do {
                memeter_ans7 *d;

                if  (!(d = memeter_3exchg(cfg, MEMETER_GET_TIMEDATE))) {
                    ifBLIN_QW0("memeter_3exchg");
                    break;
                }
                printf( "date: %04u-%02u-%02u %s %02u:%02u:%02u\n"
                      , 2000 + d->a7
                      , 1 + d->a6
                      , 1 + d->a5
                      , wd[d->a4] /* XXXX  a4 */
                      , d->a3
                      , d->a2
                      , d->a1
                      )
                ;
                free(d);
            } while(0);
            do {
                u_int32_t *a, k;

                if  (!(a = memeter_3exchg(cfg, MEMETER_GET_CONFIG))) {
                    ifBLIN_QW0("memeter_3exchg");
                    break;
                }
                for (k = 0; k < 8; ++k, *a >>= 1) {
                    printf( "%s %c%s\n"
                          , (!k) ? "config:" : "       "
                          , (*a & 1) ? '+' : '-'
                          , cfb[k]
                    );
                }
                free(a);
            } while(0);
            do {
                u_int32_t *a;

                if  (!(a = memeter_3exchg(cfg, MEMETER_GET_SEG_NUM))) {
                    ifBLIN_QW0("memeter_3exchg");
                    break;
                }
                cfg->nmbox = *a;
                printf("mboxes: %u segments\n", *a);
                free(a);
            } while(0);
            do {
                char *c;
                u_int32_t i;

                if  (!(c = memeter_3exchg(cfg, MEMETER_GET_LOG_FILE))) {
                    ifBLIN_QW0("memeter_3exchg");
                    break;
                }
                printf("log=");
                for (i = 0; i < 240; ++i) {
                    if  ((c[i] >= ' ') && (c[i] < 0x7F)) {
                        printf("%c", c[i]);
                    } else {
                        printf("\\x%02X", c[i]);
                }   }
                printf("\n");
                free(c);
            } while(0);
            ex = getallc(cfg, 1);
            /*  GET_TIMESLOT */
            {   u_int32_t i;

                for (i = 0; i < cfg->nmeter; ++i) {
                    printf("device %u: %08X\n", i, cfg->meters[i]);
                    do {
                        memeter_answ *w;
                        u_int32_t *a, k;

                        if  (!(w = memeter_3exchg(cfg, MEMETER_GET_P_LIST, cfg->meters[i]))) {
                            ifBLIN_QW0("memeter_3exchg");
                            break;
                        }
                        if  (!(a = memeter_3exchg(cfg, MEMETER_GET_PARENT, cfg->meters[i]))) {
                            ifBLIN_QW0("memeter_3exchg");
                            break;
                        }
                        if  (w->a1 > 16) {
                            ifBLIN_QX0("Too long");
                            ex = EX_SOFTWARE;
                            break;
                        }
                        for (k = 0; k < w->a1; ++k) {
                             if  (!(k & 3)) printf(k ? "\n             " : "parent nodes ");
                             printf( " %c%08X%c"
                                   , (w->a2[k] == *a) ? '+' : ' '
                                   , w->a2[k]
                                   , (w->a2[k] == *a) ? '+' : ' '
                                   )
                             ;
                        }
                        printf("\n");
                        free(w);
                        free(a);
                    } while(0);
                    do {
                        memeter_ans3 *g;
                        u_int32_t *a, k;

                        if  (!(g = memeter_3exchg(cfg, MEMETER_GET_MOD_CONFIG, cfg->meters[i]))) {
                            ifBLIN_QW0("memeter_3exchg");
                            break;
                        }
                        if  (!(a = memeter_3exchg(cfg, MEMETER_GET_SL_CONFIG, cfg->meters[i]))) {
                            ifBLIN_QW0("memeter_3exchg");
                            break;
                        }
                        printf("PLC Ver: %3u, Host proto: %3u, BCNF:", g->a1, g->a2);
                        for ( k = 0
                            ; (k < 8) && ((k < 2) || (g->a3) || *a)
                            ; ++k, g->a3 >>= 1, *a >>= 1
                            ) {
                            printf( "%s %c%s %s %c%s\n"
                                  , (!k) ? " " : "                                     "
                                  , (g->a3 & 1) ? '+' : '-'
                                  , csm[k]
                                  , (!k) ? "slave config:" : "             "
                                  , (*a & 1) ? '+' : '-'
                                  , ccn[k]
                            );
                        }
                        free(g);
                        free(a);
                    } while(0);
                    {   u_int32_t m;

                        for (m = 0; m < cfg->nmbox; ++m) {
                            do {
                                memeter_ans3 *g;
                                u_int32_t k;

                                g = memeter_3exchg(cfg, MEMETER_GET_SEG_STATUS, cfg->meters[i], m);
                                if  (!g) {
                                    ifBLIN_QW0("memeter_3exchg");
                                    break;
                                }
                                printf( "  mbox %3u, cicle %3u0ms, %5u errors, status %s"
                                      , m, g->a2, g->a3, cbx[g->a1 & MEMETER_SEG_STATUS_MASK]
                                      )
                                ;
                                for ( k = 16
                                    ; (k < 20) && ((k < 18) || (g->a1 & 0xF0))
                                    ; ++k, g->a1 >>= 1
                                    ) {
                                    printf( "\n%s %c%s"
                                          , (!k) ? "" : "                                             "
                                          , (g->a1 & 0x10) ? '+' : '-'
                                          , cbx[k]
                                    );
                                }
                                printf("\n");
                            } while(0);
                            do {
                                memeter_ansb *b;
                                u_int32_t k;

                                b = memeter_3exchg(cfg, MEMETER_GET_SEG_REQ, cfg->meters[i], m);
                                if  (!b) {
                                    ifBLIN_QW0("memeter_3exchg");
                                    break;
                                }
                                printf( "    req len=%04X(%u)", b->a1, b->a1);
                                for (k = 0; k < b->a1; ++k) {
                                    if  (!(k & 0x0F)) printf("\n      %04X", k);
                                    if  (!(k & 0x01)) printf(" ");
                                    if  (!(k & 0x07)) printf(" ");
                                    printf("%02X", b->a2[k]);
                                }
                                printf("\n");
                            } while(0);
                            do {
                                memeter_ans8 *b;
                                u_int32_t k;

                                b = memeter_3exchg(cfg, MEMETER_GET_SEG_ANS, cfg->meters[i], m);
                                if  (!b) {
                                    ifBLIN_QW0("memeter_3exchg");
                                    break;
                                }
                                printf( "    ans len=%04X(%u) date: %04u-%02u-%02u %02u:%02u:%02u"
                                      , b->a7
                                      , b->a7
                                      , 2000 + b->a6
                                      , 1 + b->a5
                                      , 1 + b->a4
                                      , b->a3
                                      , b->a2
                                      , b->a1
                                      )
                                ;
                                for (k = 0; k < b->a7; ++k) {
                                    if  (!(k & 0x0F)) printf("\n      %04X", k);
                                    if  (!(k & 0x01)) printf(" ");
                                    if  (!(k & 0x07)) printf(" ");
                                    printf("%02X", b->a8[k]);
                                }
                                printf("\n");
                            } while(0);
            }   }   }   }
            goto out;
        case 2:
            errno = 0;
            if  (!(o = babolo_getarg(&opt))) {
                ifBLIN_QX0("No hex string");
                goto err;
            }
            {   u_char *cmd, *ans;
                memeter_ctr ctr;
                u_int32_t a, m;
                size_t ol;
                int r, q;

                if  (!(cmd = hextring(o, &len))) {
                    ifBLIN_QX0("hextring");
                    ex = EX_SOFTWARE;
                    goto out;
                }
                if  (cfg->flags & MEMETER_SCAN) {
                    ifBLIN_QX0("Counter number absent");
                    ex = EX_OSERR;
                    goto out;
                }
                a = cfg->cntr;
                if  (!(o = babolo_getarg(&opt))) {
                    ifBLIN_QX0("No mbox N");
                    goto err;
                }
                m = strtoul(o, NULL, 0);
                ol = INBUF;
                if  (!(ans = malloc(ol))) {
                    ifBLIN_QX0("Malloc failed #1");
                    ex = EX_OSERR;
                    goto out;
                }
                ctr.cfg = cfg;
                ctr.ctr = a;
                ctr.mbx = m;
                ctr.mst = MEMETER_SEG_STATUS_RECMD | MEMETER_SEG_STATUS_RETYPE;
                if  (0 > (q = memeter_4req(&ctr, cmd, len))) {
                    ifBLIN_QW0("memeter_4req");
                    goto out;
                }
                do {
                    ++q;
                    usleep(q * 10000);
                    if  (0 > (r = memeter_4ans(&ctr, ans, &ol))) {
                        ifBLIN_QX0("memeter_4ans %d", r);
                        ex = EX_OSERR;
                        goto out;
                    } else if (!r) {
                        memeter_dump(ans, ol, "Got 4 answer ");
                        goto out;
                    }
                    q = q * 2 + r;
                } while (q < cfg->contrwait);
                ifBLIN_QX0("memeter_4ans %d %d", r, q);
            }
            goto out;
        case 3:
            errno = 0;
            if  (!(o = babolo_getarg(&opt))) {
                ifBLIN_QX0("No mbox num");
                goto err;
            }
            do {
                u_int32_t m, i, t = 0;
                memeter_ctr ctr;

                m = strtoul(o, NULL, 0);
                ctr.cfg = cfg;
                ctr.mbx = m;
                ctr.mst = MEMETER_SEG_STATUS_RECMD | MEMETER_SEG_STATUS_RETYPE;
                if  (cfg->flags & MEMETER_SCAN) {
                    ex = getallc(cfg, 0);
                    t = cfg->nmeter;
                    if  (!t) {
                        ifBLIN_QX0("No counters found");
                        ex = EX_IOERR;
                        break;
                }   }
                do {
                    int q, r, qq = 0;
                    u_int32_t k;
                    u_char *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_5req(&ctr, MEMETER_PLCII_GETCNF))) {
                            ifBLIN_QX0("memeter_5req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_5ans(&ctr, MEMETER_PLCII_GETCNF, &ans, qq))) {
                            ifBLIN_QX0("memeter_5ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Got modem config %02X %02X", ans[0], ans[1]);
                            for (k = 0; (k < 8) && ((k < 1) || ans[2]); ++k, ans[2] >>= 1) {
                                printf( "%s %c%s\n"
                                      , (!k) ? "" : "                      "
                                      , (ans[2] & 1) ? '+' : '-'
                                      , csm[k]
                                );
                    }   }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_char *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_5req(&ctr, MEMETER_PLCII_GETCNT))) {
                            ifBLIN_QX0("memeter_5req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_5ans(&ctr, MEMETER_PLCII_GETCNT, &ans, qq))) {
                            ifBLIN_QX0("memeter_5ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "Got node counters MCNT=%02X HCNT=%02X LCNT=%02X\n"
                                  , ans[0], ans[1], ans[2]
                                  )
                            ;
                    }   }
                } while(0);
            } while(0);
            goto out;
        case 4:
            errno = 0;
            if  (!(o = babolo_getarg(&opt))) {
                ifBLIN_QX0("No mbox num");
                goto err;
            }
            do {
                u_int32_t m, i, t = 0;
                memeter_ctr ctr;

                m = strtoul(o, NULL, 0);
                ctr.cfg = cfg;
                ctr.mbx = m;
                ctr.mst = MEMETER_SEG_STATUS_RECMD | MEMETER_SEG_STATUS_RETYPE;
                if  (cfg->flags & MEMETER_SCAN) {
                    ex = getallc(cfg, 0);
                    t = cfg->nmeter;
                    if  (!t) {
                        ifBLIN_QX0("No counters found");
                        ex = EX_IOERR;
                }   }
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_SERIAL))) {
                           ifBLIN_QX0("memeter_6req %d", q);
                           ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_SERIAL, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "serial %08X @ %04u-%02u-%02u\n"
                                  , ans[0], 2000 + ans[3], ans[2], ans[1]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_TRANS_COFF))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_TRANS_COFF, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Ku=%u Ki=%u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_VERSION))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_VERSION, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Version %02X.%02X.%02X\n", ans[0], ans[1], ans[2]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_ADDR))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_ADDR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Addr %02X\n", ans[0]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_DST))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_DST, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "DST %02x-%02x %02x %02x-%02x %02x\n"
                                  , ans[2], ans[1], ans[0], ans[5], ans[4], ans[3]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_FLAGS))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_FLAGS, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Flags %04X\n", ans[0]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    memeter_ansb *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_STATUS))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        u_int32_t k;

                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_STATUS, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Status");
                            for (k = 0; k < ans->a1; ++k) printf(" %02X", ans->a2[k]);
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_char *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_LOCATION))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        u_int32_t k;

                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_LOCATION, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Location");
                            for (k = 0; k < 4; ++k) printf(" %02X", ans[k]);
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_PEAK_TIME, 1))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_PEAK_TIME, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "Peak time %02u:%02u..%02u:%02u %02u:%02u..%02u:%02u\n"
                                  , ans[1], ans[0], ans[3], ans[2], ans[5], ans[4], ans[7], ans[6]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_PEAK_PWR, 1))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_PEAK_PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "Max pwr A+ %u %u A- %u %u R+ %u %u R- %u %u\n"
                                  , ans[0], ans[1], ans[2], ans[3], ans[4], ans[5], ans[6], ans[7]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 0, MEMETER_C_PARAM_PWR_P);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr P 0 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 1, MEMETER_C_PARAM_PWR_P);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr P 1 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 2, MEMETER_C_PARAM_PWR_P);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr P 2 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 3, MEMETER_C_PARAM_PWR_P);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr P 3 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 0, MEMETER_C_PARAM_PWR_Q);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr Q 0 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 1, MEMETER_C_PARAM_PWR_Q);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr Q 1 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 2, MEMETER_C_PARAM_PWR_Q);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr Q 2 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 3, MEMETER_C_PARAM_PWR_Q);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr Q 3 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 0, MEMETER_C_PARAM_PWR_S);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr S 0 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 1, MEMETER_C_PARAM_PWR_S);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr S 1 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 2, MEMETER_C_PARAM_PWR_S);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr S 2 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 3, MEMETER_C_PARAM_PWR_S);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr S 3 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1V, 1))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1V, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("V 1 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1V, 3))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1V, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("V 3 %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1FREQ))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1FREQ, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("F %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_FIXED_PWR, MEMETER_C_PARAM_PWR_P);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_FIXED_PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "FIX Pwr P %02X %u %u %u %u\n"
                                  , ans[0], ans[1], ans[2], ans[3], ans[4]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_FIXED_PWR, MEMETER_C_PARAM_PWR_Q);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_FIXED_PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "FIX Pwr Q %02X %u %u %u %u\n"
                                  , ans[0], ans[1], ans[2], ans[3], ans[4]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_FIXED_PWR, MEMETER_C_PARAM_PWR_S);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_FIXED_PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "FIX Pwr S %02X %u %u %u %u\n"
                                  , ans[0], ans[1], ans[2], ans[3], ans[4]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_FIXED_V))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_FIXED_V, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("FIX V %02X %u %u %u\n", ans[0], ans[1], ans[2], ans[3]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_FIXED_FREQ))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_FIXED_FREQ, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("FIX F %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_FIXED_COFF);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_FIXED_COFF, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "FIX Coff %02X %u %u %u %u\n"
                                  , ans[0], ans[1], ans[2], ans[3], ans[4]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_FIXED_ANGLE))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_FIXED_ANGLE, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("FIX Angle %02X %u %u %u\n", ans[0], ans[1], ans[2], ans[3]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_char *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_FIXED_DATE))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_FIXED_DATE, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "FIX D %02X %02X %02X %02X %02X %02X %02X %02X\n"
                                  , ans[0], ans[1], ans[2], ans[3], ans[4], ans[5], ans[6], ans[7]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_FIXED_ENERGY);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_FIXED_ENERGY, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "FIX Energy %02X %u %u %u %u\n"
                                  , ans[0], ans[1], ans[2], ans[3], ans[4]
                                  )
                        ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_PWR, MEMETER_C_PARAM_PWR_P);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr P %02X %u %u %u %u\n", ans[0], ans[1], ans[2], ans[3], ans[4]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_PWR, MEMETER_C_PARAM_PWR_Q);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "Pwr Q %02X %u %u %u %u\n"
                                  , ans[0], ans[1], ans[2], ans[3], ans[4]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_PWR, MEMETER_C_PARAM_PWR_S);
                        if  (0 > q) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_PWR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Pwr S %02X %u %u %u %u\n", ans[0], ans[1], ans[2], ans[3], ans[4]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_V))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_V, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("V %02X %u %u %u\n", ans[0], ans[1], ans[2], ans[3]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_I))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_I, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("I %02X %u %u %u\n", ans[0], ans[1], ans[2], ans[3]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req( &ctr, MEMETER_C_GET_MAIN_COFF))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_COFF, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("C %02X %u %u %u %u\n", ans[0], ans[1], ans[2], ans[3], ans[4]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_FREQ))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_FREQ, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("F %1X %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_ANGLE))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_ANGLE, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Angle %02X %u %u %u\n", ans[0], ans[1], ans[2], ans[3]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_char *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_VARIANT))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        char *k = NULL;

                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_VARIANT, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            switch(ans[0] & 0xC0) {
                            case 0x00: k = "0.2"; break;
                            case 0x40: k = "0.5"; break;
                            case 0x80: k = "1.0"; break;
                            case 0xC0: k = "2.0"; break;
                            }
                            printf("C1A=%s%%", k);
                            switch(ans[0] & 0x30) {
                            case 0x00: k = "0.2"; break;
                            case 0x10: k = "0.5"; break;
                            case 0x20: k = "1.0"; break;
                            case 0x30: k = "2.0"; break;
                            }
                            printf(", C1R=%s%%", k);
                            switch(ans[0] & 0x0C) {
                            case 0x00: k = "57.7"; break;
                            case 0x04: k = "220" ; break;
                            case 0x08: k = "??"  ; break;
                            case 0x0C: k = "???" ; break;
                            }
                            printf(", V=%sV", k);
                            switch(ans[0] & 0x03) {
                            case 0x00: k = "5"  ; break;
                            case 0x01: k = "1"  ; break;
                            case 0x02: k = "10" ; break;
                            case 0x03: k = "???"; break;
                            }
                            printf(", I=%sA", k);
                            printf(", directions=%u", (ans[1] & 0x80) ? 1 : 2);
                            printf(", temperature=%uC\n", (ans[1] & 0x40) ? 40 : 20);
                            printf(", mean pwr prof %s", (ans[1] & 0x20) ? "yes" : "no");
                            printf(", %u phases", (ans[1] & 0x10) ? 1 : 3);
                            switch(ans[1] & 0x0F) {
                            case 0x00: k = "5000" ; break;
                            case 0x01: k = "25000"; break;
                            case 0x02: k = "1250" ; break;
                            case 0x03: k = "500"  ; break;
                            case 0x04: k = "1000" ; break;
                            case 0x05: k = "250"  ; break;
                            default  : k = "???"  ; break;
                            }
                            printf(", %s pulse/KWh", k);
                            printf(", ph.sum %s\n", (ans[2] & 0x80) ? "abs" : "signed");
                            printf(", %s tarificator", (ans[2] & 0x40) ? "internal" : "external");
                            switch(ans[2] & 0x30) {
                            case 0x00: k = "AR"  ; break;
                            case 0x10: k = "A"   ; break;
                            default  : k = "unkn"; break;
                            }
                            printf(", type %s", k);
                            printf(", variant %u", ans[2] & 0x0F);
                            printf(", mem3=%uKx8\n", (ans[3] & 0x80) ? 128 : 64);
                            printf(", PLM modem %s", (ans[3] & 0x40) ? "yes" : "no");
                            printf(", GSM modem %s", (ans[3] & 0x20) ? "yes" : "no");
                            printf(", IRDA %s", (ans[3] & 0x10) ? "yes" : "no");
                            switch(ans[3] & 0x0C) {
                            case 0x00: k = "CAN"  ; break;
                            case 0x04: k = "RS485"; break;
                            case 0x08: k = "res"  ; break;
                            case 0x0C: k = "no"   ; break;
                            }
                            printf(", If1=%s", k);
                            printf(", ext supl %s\n", (ans[3] & 0x02) ? "yes" : "no");
                            printf(", electric plumb %s", (ans[3] & 0x01) ? "yes" : "no");
                            printf("%s", (ans[4] & 0xF0) ? ", UNKNOWN" : "");
                            printf(", If2 %s", (ans[4] & 0x08) ? "yes" : "no");
                            printf(", int If1 supl %s", (ans[4] & 0x04) ? "yes" : "no");
                            printf(", control %s\n", (ans[4] & 0x02) ? "yes" : "no");
                            printf(", separate pwr acc %s", (ans[4] & 0x01) ? "yes" : "no");
                            printf("%s", ans[5] ? ", RESERV\n" : "\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_MEAN_PWR_LAST))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MEAN_PWR_LAST, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "Addr %05X, %s, mem init %s, not full %s, over %s\n"
                                  , ans[0] & 0x01FFFF
                                  , (ans[0] & 0x80000000) ? "winterr" : "summer"
                                  , (ans[0] & 0x40000000) ? "yes" : "no"
                                  , (ans[0] & 0x20000000) ? "yes" : "no"
                                  , (ans[0] & 0x10000000) ? "yes" : "no"
                                  )
                            ;
                            printf( ", @ 20%02x-%02x-%02x %02x:%02x mean time %u\n"
                                  , ans[5], ans[4], ans[3], ans[1], ans[2], ans[6]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_TARIF_STATUS))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_TARIF_STATUS, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("tarif stat %02X\n", ans[0]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_LOAD_CTL_STATUS))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_LOAD_CTL_STATUS, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("load ctl stat %04X\n", ans[0]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_IND_TARIF))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_IND_TARIF, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Ind tarif %02X %02X %02X %02X\n", ans[0], ans[1], ans[2], ans[3]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_IND_PERIOD))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_IND_PERIOD, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Ind time %02X %02X %02X %02X\n", ans[0], ans[1], ans[2], ans[3]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_TIMEOUT_COFF))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_TIMEOUT_COFF, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Timeout coff %02X\n", ans[0]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_LOSS_ACC_MODE))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_LOSS_ACC_MODE, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Loss acc mode %04X\n", ans[0]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_LOSS))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_LOSS, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf( "Ploss %u %u %u %u %u %u\n"
                                  , ans[0], ans[1], ans[2], ans[3], ans[4], ans[5]
                                  )
                            ;
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_MEAN_TIME))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MEAN_TIME, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            printf("Mean voltage time %u, mean frequency time %u\n", ans[0], ans[1]);
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_RST, 0))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_RST, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %10u %10u %10u %10u"
                                      , k ? "\n             " : "Energy sum t0"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_RST, 1))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_RST, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %10u %10u %10u %10u"
                                      , k ? "\n             " : "Energy sum t1"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_RST, 5))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_RST, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %10u %10u %10u %10u"
                                      , k ? "\n             " : "Energy sum t5"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_RST, 6))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_RST, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %10u %10u %10u %10u"
                                      , k ? "\n             " : "Energy sum t6"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_CUR_YEAR, 6))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_CUR_YEAR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %10u %10u %10u %10u"
                                      , k ? "\n            " : "Energy cy t6"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_LAST_YEAR, 6))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_LAST_YEAR, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %10u %10u %10u %10u"
                                      , k ? "\n            " : "Energy ly t6"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_MON, 6, 1))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_MON, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %8u %8u %8u %8u"
                                      , k ? "\n                " : "Energy mon m1 t6"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_CUR_DAY, 6))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_CUR_DAY, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %10u %10u %10u %10u"
                                      , k ? "\n            " : "Energy cd t6"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_LAST_DAY, 6))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_LAST_DAY, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %10u %10u %10u %10u"
                                      , k ? "\n            " : "Energy ld t6"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_PHASE, 6, 1))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_PHASE, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %8u %8u %8u %8u"
                                      , k ? "\n                " : "Energy ph m1 t6"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
                do {
                    int q, r, qq = 0;
                    u_int32_t k, *ans;

                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_PHASE, 1, 6))) {
                            ifBLIN_QX0("memeter_6req %d", q);
                            ex = EX_IOERR;
                        }
                        if  (qq < q) qq = q;
                    }
                    qq += 256;
                    for (i = 0; i < t; ++i) {
                        ctr.ctr = t ? cfg->meters[i] : cfg->cntr;
                        if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_PHASE, &ans, qq))) {
                            ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                            ex = EX_IOERR;
                        } else {
                            if  (t) printf("(((( %08X ))))\n", ctr.ctr);
                            for (k = 0; k < ans[0]; ++k) {
                                printf( "%s %8u %8u %8u %8u"
                                      , k ? "\n                " : "Energy ph m1 t6"
                                      , ans[k * 4 + 1], ans[k * 4 + 2], ans[k * 4 + 3], ans[k * 4 + 4]
                                      )
                                ;
                            }
                            printf("\n");
                    }   }
                } while(0);
            } while(0);
            goto out;
        case 90:
            {   memeter_ctr ctr;
                int q, qq = 0;
                u_int32_t i;

                ctr.cfg = cfg;
                ctr.mst = MEMETER_SEG_STATUS_REMASK | MEMETER_SEG_STATUS_TRANS_TYPE;
                ex = getallc(cfg, 0);
                if  (!cfg->nmeter) {
                    ifBLIN_QX0("No counters found");
                    ex = EX_IOERR;
                    break;
                }
                for (ctr.mbx = 0, i = 0; i < cfg->nmeter; ++i) {
                    ctr.ctr = cfg->meters[i];
                    if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_TIME, 0))) {
                        ifBLIN_QX0("memeter_6req %d", q);
                        ex = EX_IOERR;
                        goto out;
                    }
                    if  (qq < q) qq = q;
                }
                for (ctr.mbx = 1, i = 0; i < cfg->nmeter; ++i) {
                    ctr.ctr = cfg->meters[i];
                    if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_TRANS_COFF))) {
                        ifBLIN_QX0("memeter_6req %d", q);
                        ex = EX_IOERR;
                        goto out;
                    }
                    if  (qq < q) qq = q;
                }
                for (ctr.mbx = 2, i = 0; i < cfg->nmeter; ++i) {
                    ctr.ctr = cfg->meters[i];
                    if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_RST, 0))) {
                        ifBLIN_QX0("memeter_6req %d", q);
                        ex = EX_IOERR;
                        goto out;
                    }
                    if  (qq < q) qq = q;
                }
                for (ctr.mbx = 3, i = 0; i < cfg->nmeter; ++i) {
                    ctr.ctr = cfg->meters[i];
                    q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 0, MEMETER_C_PARAM_PWR_P);
                    if  (0 > q) {
                        ifBLIN_QX0("memeter_6req %d", q);
                        ex = EX_IOERR;
                        goto out;
                    }
                    if  (qq < q) qq = q;
                }
                if  (qq < 256) qq = 256;
                ctr.mst = MEMETER_SEG_STATUS_RETYPE | MEMETER_SEG_STATUS_RECMD;
                {   u_int32_t a;

                    for (a = 3; a < cfg->nmbox; ++a) {
                        for (ctr.mbx = a, i = 0; i < cfg->nmeter; ++i) {
                            ctr.ctr = cfg->meters[i];
                            if  (0 > (q = memeter_4req(&ctr, NULL, 0))) {
                               ifBLIN_QX0("memeter_4req %d", q);
                               ex = EX_IOERR;
                }   }   }   }
                for (i = 0; i < cfg->nmeter; ++i) {
                    u_int32_t *a0, *a1, *a2, *a3;
                    int r;

                    ctr.ctr = cfg->meters[i];
                    ctr.mbx = 0;
                    if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_TIME, &a0, qq))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                        goto out;
                    }
                    ctr.mbx = 1;
                    if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_TRANS_COFF, &a1, qq))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                        goto out;
                    }
                    ctr.mbx = 2;
                    if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_RST, &a2, qq))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                        goto out;
                    }
                    ctr.mbx = 3;
                    if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &a3, qq))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                        goto out;
                    }
                    if  (cfg->tablename) {
                        printf( "INSERT INTO %s"
                                " VALUES(\'20%02x-%02x-%02x %02x:%02x:%02x\'"
                                ", \'%08X\', %u.%03u, %u.%02u);\n"
                              , cfg->tablename
                              , a0[6], a0[5], a0[4], a0[2], a0[1], a0[0]
                              , ctr.ctr
                              , (u_int32_t)((u_int64_t)a2[1] * a1[0] * a1[1] / 1000)
                              , (u_int32_t)((u_int64_t)a2[1] * a1[0] * a1[1] % 1000)
                              , (u_int32_t)((u_int64_t)a3[1] * a1[0] * a1[1] / 100)
                              , (u_int32_t)((u_int64_t)a3[1] * a1[0] * a1[1] % 100)
                              )
                        ;
                    } else {
                        printf( "20%02x-%02x-%02x_%02x:%02x:%02x\t%08X\t%u.%03u\t%u.%02u\n"
                              , a0[6], a0[5], a0[4], a0[2], a0[1], a0[0]
                              , ctr.ctr
                              , (u_int32_t)((u_int64_t)a2[1] * a1[0] * a1[1] / 1000)
                              , (u_int32_t)((u_int64_t)a2[1] * a1[0] * a1[1] % 1000)
                              , (u_int32_t)((u_int64_t)a3[1] * a1[0] * a1[1] / 100)
                              , (u_int32_t)((u_int64_t)a3[1] * a1[0] * a1[1] % 100)
                              )
                        ;
            }   }   }
            goto out;
        case 91:
            {   memeter_ctr ctr;
                int q, qq = 0;
                u_int32_t i;

                ctr.cfg = cfg;
                ctr.mst = MEMETER_SEG_STATUS_RECMD
                        | MEMETER_SEG_STATUS_RETYPE
                        | MEMETER_SEG_STATUS_TRANS_TYPE
                ;
                ex = getallc(cfg, 0);
                if  (!cfg->nmeter) {
                    ifBLIN_QX0("No counters found");
                    ex = EX_IOERR;
                    break;
                }
                for (ctr.mbx = 0, i = 0; i < cfg->nmeter; ++i) {
                    ctr.ctr = cfg->meters[i];
                    if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_TIME, 0))) {
                        ifBLIN_QX0("memeter_6req %d", q);
                        ex = EX_IOERR;
                        goto out;
                    }
                    if  (qq < q) qq = q;
                }
                for (ctr.mbx = 1, i = 0; i < cfg->nmeter; ++i) {
                    ctr.ctr = cfg->meters[i];
                    if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_TRANS_COFF))) {
                        ifBLIN_QX0("memeter_6req %d", q);
                        ex = EX_IOERR;
                    }
                    if  (qq < q) qq = q;
                }
                for (ctr.mbx = 2, i = 0; i < cfg->nmeter; ++i) {
                    ctr.ctr = cfg->meters[i];
                    if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_RST, 0))) {
                        ifBLIN_QX0("memeter_6req %d", q);
                        ex = EX_IOERR;
                        goto out;
                    }
                    if  (qq < q) qq = q;
                }
                for (ctr.mbx = 3, i = 0; i < cfg->nmeter; ++i) {
                    ctr.ctr = cfg->meters[i];
                    q = memeter_6req(&ctr, MEMETER_C_GET_MAIN_1PWR, 0, MEMETER_C_PARAM_PWR_P);
                    if  (0 > q) {
                        ifBLIN_QX0("memeter_6req %d", q);
                        ex = EX_IOERR;
                        goto out;
                    }
                    if  (qq < q) qq = q;
                }
                if  (qq < 256) qq = 256;
                for (i = 0; i < cfg->nmeter; ++i) {
                    u_int32_t *a0, *a1, *a2, *a3;
                    int r;

                    ctr.ctr = cfg->meters[i];
                    ctr.mbx = 0;
                    if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_TIME, &a0, qq))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                        goto out;
                    }
                    ctr.mbx = 1;
                    if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_TRANS_COFF, &a1, qq))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                        goto out;
                    }
                    ctr.mbx = 2;
                    if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_RST, &a2, qq))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                        goto out;
                    }
                    ctr.mbx = 3;
                    if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_MAIN_1PWR, &a3, qq))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                        goto out;
                    }
                    if  (cfg->tablename) {
                        printf( "INSERT INTO %s"
                                " VALUES(\'20%02x-%02x-%02x %02x:%02x:%02x\'"
                                ", \'%08X\', %u.%03u, %u.%02u);\n"
                              , cfg->tablename
                              , a0[6], a0[5], a0[4], a0[2], a0[1], a0[0]
                              , ctr.ctr
                              , (u_int32_t)((u_int64_t)a2[1] * a1[0] * a1[1] / 1000)
                              , (u_int32_t)((u_int64_t)a2[1] * a1[0] * a1[1] % 1000)
                              , (u_int32_t)((u_int64_t)a3[1] * a1[0] * a1[1] / 100)
                              , (u_int32_t)((u_int64_t)a3[1] * a1[0] * a1[1] % 100)
                              )
                        ;
                    } else {
                        printf( "20%02x-%02x-%02x_%02x:%02x:%02x\t%08X\t%u.%03u\t%u.%02u\n"
                              , a0[6], a0[5], a0[4], a0[2], a0[1], a0[0]
                              , ctr.ctr
                              , (u_int32_t)((u_int64_t)a2[1] * a1[0] * a1[1] / 1000)
                              , (u_int32_t)((u_int64_t)a2[1] * a1[0] * a1[1] % 1000)
                              , (u_int32_t)((u_int64_t)a3[1] * a1[0] * a1[1] / 100)
                              , (u_int32_t)((u_int64_t)a3[1] * a1[0] * a1[1] % 100)
                              )
                        ;
            }   }   }
            goto out;
        case 92:
            errno = 0;
            if  (!(o = babolo_getarg(&opt))) {
                ifBLIN_QX0("No month num");
                goto err;
            }
            {   char mm[][4] =
                { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}
                ;
                memeter_ctr ctr;
                u_int32_t i, m;
                int q, qq = 0;

                m = strtoul(o, NULL, 0);
                if  ((m < 1) || (m > 12)) {
                    ifBLIN_QX0("Invalid month num %u", m);
                    goto err;
                }
                ctr.cfg = cfg;
                ctr.mst = MEMETER_SEG_STATUS_RECMD | MEMETER_SEG_STATUS_RETYPE;
                ex = getallc(cfg, 0);
                if  (!cfg->nmeter) {
                    ifBLIN_QX0("No counters found");
                    ex = EX_IOERR;
                    break;
                }
                for (ctr.mbx = 11, i = 0; i < cfg->nmeter; ++i) {
                    ctr.ctr = cfg->meters[i];
                    if  (0 > (q = memeter_6req(&ctr, MEMETER_C_ENERGY_MON, 0, m))) {
                       ifBLIN_QX0("memeter_6req %d", q);
                       ex = EX_IOERR;
                    }
                    if  (qq < q) qq = q;
                }
                if  (qq < 256) qq = 256;
                for (i = 0; i < cfg->nmeter; ++i) {
                    u_int32_t *a1;
                    int r;

                    ctr.ctr = cfg->meters[i];
                    ctr.mbx = 11;
                    if  ((r = memeter_6ans(&ctr, MEMETER_C_ENERGY_RST, &a1, qq))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                    }
                    printf("%s %u.%03u\n", mm[m - 1], a1[1] / 1000, a1[1] % 1000);
            }   }
            goto out;
        case 99:
            errno = 0;
            if  (!(o = babolo_getarg(&opt))) {
                ifBLIN_QX0("No Ki");
                goto err;
            }
            {   memeter_ctr ctr;
                u_int32_t m;
                int q;

                m = strtoul(o, NULL, 0);
                ctr.mbx = 11;
                ctr.cfg = cfg;
                ctr.ctr = cfg->cntr;
                ctr.mst = MEMETER_SEG_STATUS_RECMD | MEMETER_SEG_STATUS_RETYPE;
                ex = getallc(cfg, 0);
                if  (!cfg->nmeter) {
                    ifBLIN_QX0("No counters found");
                    ex = EX_IOERR;
                    break;
                }
                if  (0 > (q = memeter_6req(&ctr, MEMETER_C_SET_TRANS_COFF, 1, m))) {
                    ifBLIN_QX0("memeter_6req %d", q);
                    ex = EX_IOERR;
                }
                if  (q < 256) q = 256;
                {   u_int32_t *a1;
                    int r;

                    if  ((r = memeter_6ans(&ctr, MEMETER_C_SET_TRANS_COFF, &a1, q))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                }   }
                if  (0 > (q = memeter_6req(&ctr, MEMETER_C_GET_TRANS_COFF))) {
                    ifBLIN_QX0("memeter_6req %d", q);
                    ex = EX_IOERR;
                }
                if  (q < 256) q = 256;
                {   u_int32_t *ans;
                    int r;

                    if  ((r = memeter_6ans(&ctr, MEMETER_C_GET_TRANS_COFF, &ans, q))) {
                        ifBLIN_QX0("memeter_6ans %08X(%d)", r, r);
                        ex = EX_IOERR;
                    }
                    printf("Ku=%u Ki=%u\n", ans[0], ans[1]);
            }   }
            goto out;
    }   }
err:
    if  (errno) {
        ifBLIN_QW0("babolo_getarg #1");
        ex = EX_SOFTWARE;
        goto out;
    } else {
        ifBLIN_QX0("Nothing to do");
        ex = EX_USAGE;
        goto out;
    }
out:
    exit(ex);
}
