/*-
 * Copyright (C)2012 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: mercumeter.h,v 1.18 2012/02/29 07:00:34 babolo Exp $
 */

#define MEMETER_HOST_ADDR 0xFFFF
#define MEMETER_BROADDR   0x3FFF
#define MEMETER_UART_HLEN 5         /* memeter_uarts src + dst + len   */
#define MEMETER_RES_OK    ((void*)1)
#define MEMETER_MINWAIT   256       /* must have some bits out of 0xFF */


// level3
#define MEMETER_SET_CONFIG      0x00
#define MEMETER_SET_TIMEDATE    0x01
#define MEMETER_SET_ADDR        0x06
#define MEMETER_SET_P_LIST      0x14
#define MEMETER_SET_ADD_NODE    0x15
#define MEMETER_SET_DEL_NODE    0x16
#define MEMETER_SET_SL_CONFIG   0x18
#define MEMETER_SET_SEG_NUM     0x19
#define MEMETER_SET_SEG_STATUS  0x1A
#define MEMETER_SET_SEG_REQ     0x1B
#define MEMETER_SET_CLR_ALL_SEG 0x1D
#define MEMETER_SET_REPLACE_ID  0x1E
#define MEMETER_SET_PARENT      0x1F
#define MEMETER_SET_CLEAR_ST    0x7D
#define MEMETER_GET_CLEAR_ST    0x7D
#define MEMETER_GET_CONFIG      0x80
#define MEMETER_GET_TIMEDATE    0x81
#define MEMETER_GET_VERINFO     0x83
#define MEMETER_GET_ADDR        0x86
#define MEMETER_GET_NL_PAGE     0x90
#define MEMETER_GET_P_LIST      0x94
#define MEMETER_GET_MOD_CONFIG  0x97
#define MEMETER_GET_SL_CONFIG   0x98
#define MEMETER_GET_SEG_NUM     0x99
#define MEMETER_GET_SEG_STATUS  0x9A
#define MEMETER_GET_SEG_REQ     0x9B
#define MEMETER_GET_SEG_ANS     0x9C
#define MEMETER_GET_PARENT      0x9F
#define MEMETER_GET_TIMESLOT    0xA0
#define MEMETER_GET_LOG_FILE    0xF0
//  00 80
#define MEMETER_CONFIG_ScanEnable           0x01
#define MEMETER_CONFIG_OptEnable            0x02
#define MEMETER_CONFIG_CheckEnable          0x04
#define MEMETER_CONFIG_ExeEnable            0x08
#define MEMETER_CONFIG_PListReadOnly        0x10
#define MEMETER_CONFIG_CaptureEnable        0x40
#define MEMETER_CONFIG_DayLightSavingEnable 0x80
//  1A 9A
#define MEMETER_SEG_STATUS_EMPTY        0x00
#define MEMETER_SEG_STATUS_REQ_ACCEPTED 0x01
#define MEMETER_SEG_STATUS_TRANSACTION  0x02
#define MEMETER_SEG_STATUS_OK           0x03
#define MEMETER_SEG_STATUS_ERROR        0x04
#define MEMETER_SEG_STATUS_MASK         0x0F
#define MEMETER_SEG_STATUS_ANS_READY    0x10
//  1A 9A  3exchg(MEMETER_SET_SEG_STATUS, ...
#define MEMETER_SEG_STATUS_TRANS_TYPE   0x20 // 0 , 1 
//  3exchg(MEMETER_SET_SEG_STATUS, ...
#define MEMETER_SEG_STATUS_REMASK     0xFF00
#define MEMETER_SEG_STATUS_RETYPE     0x4400
#define MEMETER_SEG_STATUS_RETYPEALL  0x5500
#define MEMETER_SEG_STATUS_RECMD      0xA000
#define MEMETER_SEG_STATUS_RECMDALL   0xAA00

//  97
#define MEMETER_MOD_CONFIG_PlcProtected 0x01
#define MEMETER_MOD_CONFIG_TimerSet     0x02

//level5
#define MEMETER_PLCII_SCAN    0x00
#define MEMETER_PLCII_GETCNF  0x01
#define MEMETER_PLCII_SETIME  0x02
#define MEMETER_PLCII_CLOSE   0x03
#define MEMETER_PLCII_OPEN    0x04
#define MEMETER_PLCII_GETCNT  0x05
#define MEMETER_PLCII_THROUGH 0x40
#define MEMETER_PLCII_ILLEGAL 0xFE
#define MEMETER_PLCII_NOCOMM  0xFF

//level6
#define MEMETER_C_CHANTST                0x00
#define MEMETER_C_PASS                   0x01
#define MEMETER_C_CLOSE                  0x02
#define MEMETER_C_SET_MEAN_PWR_INI     0x0003
#define MEMETER_C_SET_IND_TARIF        0x0103
#define MEMETER_C_SET_IND_PERIOD       0x0203
#define MEMETER_C_SET_TEST             0x0403
#define MEMETER_C_SET_ADDR             0x0503
#define MEMETER_C_SET_DATE_FIX         0x0803
#define MEMETER_C_SET_CONTROL_INI      0x0A03
#define MEMETER_C_SET_TIME             0x0C03
#define MEMETER_C_SET_TIME_CORR        0x0D03
#define MEMETER_C_SET_COMM_PARM        0x1503
#define MEMETER_C_SET_RESET            0x1603
#define MEMETER_C_SET_DST_DIS          0x1803
#define MEMETER_C_SET_DST_TIME         0x1903
#define MEMETER_C_SET_TRANS_COFF       0x1B03
#define MEMETER_C_SET_PASS             0x1F03
#define MEMETER_C_SET_ENERGY_RST       0x2003
#define MEMETER_C_SET_LOCATION         0x2203
#define MEMETER_C_SET_PEAK_TIME        0x2303
#define MEMETER_C_SET_MON_MAX_RST      0x2403
#define MEMETER_C_SET_CONST_AB         0x2703
#define MEMETER_C_SET_I_DIAP_DIS       0x2803
#define MEMETER_C_SET_N_CORR_DIS       0x2903
#define MEMETER_C_SET_TARIF_MODE       0x2A03
#define MEMETER_C_SET_PWR_LIMIT        0x2C03
#define MEMETER_C_SET_PWR_LIMIT_ENA    0x2D03
#define MEMETER_C_SET_ENERGY_LIMIT     0x2E03
#define MEMETER_C_SET_ENERGY_LIMIT_ENA 0x2F03
#define MEMETER_C_SET_IMP_OUT_MODE     0x3003
#define MEMETER_C_SET_LOAD_CTL_MODE    0x3103
#define MEMETER_C_SET_TIMEOUT_COFF     0x3203
#define MEMETER_C_SET_LOSS_ACC_MODE    0x3303
#define MEMETER_C_SET_LOSS             0x3403
#define MEMETER_C_SET_VALID_VALUES     0x3603
#define MEMETER_C_SET_MEAN_TIME        0x3703
#define MEMETER_C_GET_TIME             0x0004
#define MEMETER_C_J_ONOFF              0x0104
#define MEMETER_C_J_TIME_SET           0x0204
#define MEMETER_C_J_ONOFF1             0x0304
#define MEMETER_C_J_ONOFF2             0x0404
#define MEMETER_C_J_ONOFF3             0x0504
#define MEMETER_C_J_PWR_LIMIT          0x0604
#define MEMETER_C_J_TARIF_SET          0x0704
#define MEMETER_C_J_HOLIDAY_SET        0x0804
#define MEMETER_C_J_ENERGY_RST         0x0904
#define MEMETER_C_J_MEAN_PWR_INI       0x0A04
#define MEMETER_C_J_ENERGY_LIMIT1      0x0B04
#define MEMETER_C_J_ENERGY_LIMIT2      0x0C04
#define MEMETER_C_J_ENERGY_LIMIT3      0x0D04
#define MEMETER_C_J_ENERGY_LIMIT4      0x0E04
#define MEMETER_C_J_PWR_LIMIT_SET      0x0F04
#define MEMETER_C_J_ENERGY_LIMIT_SET   0x1004
#define MEMETER_C_J_LOSS_SET           0x1104
#define MEMETER_C_J_CASE               0x1204
#define MEMETER_C_J_REPROG             0x1304
#define MEMETER_C_J_STATUS             0x1404
#define MEMETER_C_J_PEAK_TIME_SET      0x1504
#define MEMETER_C_J_MAX_PWR_RST        0x1604
#define MEMETER_C_J_MIN_V1             0x2004
#define MEMETER_C_J_MIN_NOM_V1         0x2104
#define MEMETER_C_J_MAX_NOM_V1         0x2204
#define MEMETER_C_J_MAX_V1             0x2304
#define MEMETER_C_J_MIN_V2             0x2404
#define MEMETER_C_J_MIN_NOM_V2         0x2504
#define MEMETER_C_J_MAX_NOM_V2         0x2604
#define MEMETER_C_J_MAX_V2             0x2704
#define MEMETER_C_J_MIN_V3             0x2804
#define MEMETER_C_J_MIN_NOM_V3         0x2904
#define MEMETER_C_J_MAX_NOM_V3         0x2A04
#define MEMETER_C_J_MAX_V3             0x2B04
#define MEMETER_C_J_MIN_FREQ           0x2C04
#define MEMETER_C_J_MIN_NOM_FREQ       0x2D04
#define MEMETER_C_J_MAX_NOM_FREQ       0x2E04
#define MEMETER_C_J_MAX_FREQ           0x2F04
#define MEMETER_C_ENERGY_RST           0x0005
#define MEMETER_C_ENERGY_CUR_YEAR      0x0105
#define MEMETER_C_ENERGY_LAST_YEAR     0x0205
#define MEMETER_C_ENERGY_MON           0x0305
#define MEMETER_C_ENERGY_CUR_DAY       0x0405
#define MEMETER_C_ENERGY_LAST_DAY      0x0505
#define MEMETER_C_ENERGY_PHASE         0x0605
#define MEMETER_C_RMEM_1               0x0106
#define MEMETER_C_RMEM_2               0x0206
#define MEMETER_C_RMEM_3ALL            0x0306
#define MEMETER_C_RMEM_3APLUS          0x1306
#define MEMETER_C_RMEM_3AMINUS         0x2306
#define MEMETER_C_RMEM_3RPLUS          0x3306
#define MEMETER_C_RMEM_3RMINUS         0x4306
#define MEMETER_C_WMEM                   0x07
#define MEMETER_C_GET_SERIAL           0x0008
#define MEMETER_C_GET_TRANS_COFF       0x0208
#define MEMETER_C_GET_VERSION          0x0308
#define MEMETER_C_GET_ADDR             0x0508
#define MEMETER_C_GET_DST              0x0708
#define MEMETER_C_GET_FLAGS            0x0908
#define MEMETER_C_GET_STATUS           0x0A08
#define MEMETER_C_GET_LOCATION         0x0B08
#define MEMETER_C_GET_PEAK_TIME        0x0C08
#define MEMETER_C_GET_PEAK_PWR         0x0D08
#define MEMETER_C_GET_MAIN_1PWR      0x001108
#define MEMETER_C_GET_MAIN_1V        0x011108
#define MEMETER_C_GET_MAIN_1I        0x021108
#define MEMETER_C_GET_MAIN_1COFF     0x031108
#define MEMETER_C_GET_MAIN_1FREQ     0x041108
#define MEMETER_C_GET_MAIN_1ANGLE    0x051108
#define MEMETER_C_GET_VARIANT          0x1208
#define MEMETER_C_GET_MEAN_PWR_LAST    0x1308
#define MEMETER_C_GET_FIXED_PWR      0x001408
#define MEMETER_C_GET_FIXED_V        0x011408
#define MEMETER_C_GET_FIXED_I        0x021408
#define MEMETER_C_GET_FIXED_COFF     0x031408
#define MEMETER_C_GET_FIXED_FREQ     0x041408
#define MEMETER_C_GET_FIXED_ANGLE    0x051408
#define MEMETER_C_GET_FIXED_DATE     0x0E1408
#define MEMETER_C_GET_FIXED_ENERGY   0x0F1408
#define MEMETER_C_GET_MAIN_PWR       0x001608
#define MEMETER_C_GET_MAIN_V         0x011608
#define MEMETER_C_GET_MAIN_I         0x021608
#define MEMETER_C_GET_MAIN_COFF      0x031608
#define MEMETER_C_GET_MAIN_FREQ      0x041608
#define MEMETER_C_GET_MAIN_ANGLE     0x051608
#define MEMETER_C_GET_TARIF_STATUS     0x1708
#define MEMETER_C_GET_LOAD_CTL_STATUS  0x1808
#define MEMETER_C_GET_PWR_LIMIT        0x1908
#define MEMETER_C_GET_ENERGY_LIMIT     0x1A08
#define MEMETER_C_GET_IND_TARIF        0x1B08
#define MEMETER_C_GET_IND_PERIOD       0x1C08
#define MEMETER_C_GET_TIMEOUT_COFF     0x1D08
#define MEMETER_C_GET_LOSS_ACC_MODE    0x1E08
#define MEMETER_C_GET_LOSS             0x1F08
#define MEMETER_C_GET_VALID_VALUES     0x2008
#define MEMETER_C_GET_MEAN_TIME        0x2108

#define MEMETER_C_ALL    0xFE // broadcast counter addr

#define MEMETER_C_J_LAST 0xFF
#define MEMETER_C_J_ALL  0xFE
#define MEMETER_C_J_0019 0xFE
#define MEMETER_C_J_2039 0xFD
#define MEMETER_C_J_4059 0xFC
#define MEMETER_C_J_6079 0xFB
#define MEMETER_C_J_8099 0xFA

// for MEMETER_C_SET_COMM_PARM
#define MEMETER_C_COMM_B300    0x05
#define MEMETER_C_COMM_B600    0x04
#define MEMETER_C_COMM_B1200   0x03
#define MEMETER_C_COMM_B2400   0x02
#define MEMETER_C_COMM_B4800   0x01
#define MEMETER_C_COMM_B9600   0x00
#define MEMETER_C_COMM_BMASK   0x0F
#define MEMETER_C_COMM_EVEN    0x20
#define MEMETER_C_COMM_ODD     0x10
#define MEMETER_C_COMM_EONO    0x00
#define MEMETER_C_COMM_EOMASK  0x30
#define MEMETER_C_COMM_REPEAT  0x80

// for MEMETER_C_GET_MAIN_PARAMS*, MEMETER_C_GET_FIXED
#define MEMETER_C_PARAM_PWR_P    0
#define MEMETER_C_PARAM_PWR_Q    1
#define MEMETER_C_PARAM_PWR_S    2

#define MEMETER_EX_3NO    (-1)
#define MEMETER_EX_3ERR   (-2)
#define MEMETER_EX_3SPC   (-3)
#define MEMETER_EX_3SUPP  (-4)
#define MEMETER_EX_4NULL  (-5)
#define MEMETER_EX_4PROTO (-6)
#define MEMETER_EX_4SPEC  0x7E
#define MEMETER_EX_4COMM  0x7F
#define MEMETER_EX_5PROTO (-7)
#define MEMETER_EX_BMASK4 (~0x03FF)
#define MEMETER_EX_BMASK5 (~0x07FF)
#define MEMETER_EX_MEM    (-9)
#define MEMETER_EX_LOWAIT (-10)
#define MEMETER_EX_6USE   (-11)
#define MEMETER_EX_6PROTO (-12)


typedef struct memeter_3conf {
    u_char prm; /*  ,   parm3                */
    u_char ans; /*                                */
    u_char arr; /*  ,   parm3                 */
    u_char com; /*        */
    char  *lit; /*                          */
} memeter_3conf;

typedef union memeter_1pack {
    u_char octets[0];
    struct {
        u_char crc24[3];
        u_char src[2];
        u_char dst[2];
        u_char len;
        u_char p2[1];
    };
} memeter_1pack;

typedef struct memeter_6cmd {
    u_char ml;                        /*                           */
    u_char cl;                        /*                       */
    u_char al;                        /*              */
    u_char rl;                        /*    5            */
    u_char ol;                        /*    6 ( u_int32_t)     */
    u_char mode;                      /*                   */
    signed char p[10];                /*  , <0 -   */
    const struct memeter_6conf *next; /*                        */
    const char                 *lit;  /*                  */
} memeter_6cmd;

struct memeter_6conf;
typedef struct memeter_6conf {
    u_int32_t    quo;
    memeter_6cmd s[];
} memeter_6conf;

typedef struct memeter_cfg {
    u_int32_t   flags;
#   define      MEMETER_0ODUMP 0x800000
#   define      MEMETER_1ODUMP (MEMETER_0ODUMP >> 1) // 0x400000
#   define      MEMETER_2ODUMP (MEMETER_0ODUMP >> 2) // 0x200000
#   define      MEMETER_3ODUMP (MEMETER_0ODUMP >> 3) // 0x100000
#   define      MEMETER_4ODUMP (MEMETER_0ODUMP >> 4) // 0x080000
#   define      MEMETER_5ODUMP (MEMETER_0ODUMP >> 5) // 0x040000
#   define      MEMETER_6ODUMP (MEMETER_0ODUMP >> 6) // 0x020000
#   define      MEMETER_7ODUMP (MEMETER_0ODUMP >> 7) // 0x010000
#   define      MEMETER_0IDUMP 0x008000
#   define      MEMETER_1IDUMP (MEMETER_0IDUMP >> 1) // 0x004000
#   define      MEMETER_2IDUMP (MEMETER_0IDUMP >> 2) // 0x002000
#   define      MEMETER_3IDUMP (MEMETER_0IDUMP >> 3) // 0x001000
#   define      MEMETER_4IDUMP (MEMETER_0IDUMP >> 4) // 0x000800
#   define      MEMETER_5IDUMP (MEMETER_0IDUMP >> 5) // 0x000400
#   define      MEMETER_6IDUMP (MEMETER_0IDUMP >> 6) // 0x000200
#   define      MEMETER_7IDUMP (MEMETER_0IDUMP >> 7) // 0x000100
#   define      MEMETER_0INIT  0x000080
#   define      MEMETER_SCAN   0x000040
    speed_t     baud;
    const char *linename;
    const char *tablename;
    int         line;
    u_char      wait; /* line I/O wait time in ms */
    u_char      nmbox;
    u_char      dummy[2];
    int32_t     contrwait;
    u_int32_t   cntr;
    u_int16_t   from;
    u_int16_t   to;
    u_int32_t   nmeter;
    u_int32_t  *meters;
} memeter_cfg;

typedef struct memeter_ctr {
    memeter_cfg *cfg;
    u_int32_t    ctr;
    u_int16_t    mst;
    u_char       mbx;
} memeter_ctr;

typedef struct memeter_ans2 {
    u_int32_t   a1;
    u_int32_t   a2;
} memeter_ans2;

typedef struct memeter_ans3 {
    u_int32_t   a1;
    u_int32_t   a2;
    u_int32_t   a3;
} memeter_ans3;

typedef struct memeter_ans4 {
    u_int32_t   a1;
    u_int32_t   a2;
    u_int32_t   a3;
    u_int32_t   a4;
} memeter_ans4;

typedef struct memeter_ans5 {
    u_int32_t   a1;
    u_int32_t   a2;
    u_int32_t   a3;
    u_int32_t   a4;
    u_int32_t   a5;
} memeter_ans5;

typedef struct memeter_ans7 {
    u_int32_t   a1;
    u_int32_t   a2;
    u_int32_t   a3;
    u_int32_t   a4;
    u_int32_t   a5;
    u_int32_t   a6;
    u_int32_t   a7;
} memeter_ans7;

typedef struct memeter_ansb {
    u_int32_t   a1;
    u_char      a2[];
} memeter_ansb;

typedef struct memeter_ansh {
    u_int32_t   a1;
    u_int16_t   a2[];
} memeter_ansh;

typedef struct memeter_answ {
    u_int32_t   a1;
    u_int32_t   a2[];
} memeter_answ;

typedef struct memeter_ans8 {
    u_int32_t   a1;
    u_int32_t   a2;
    u_int32_t   a3;
    u_int32_t   a4;
    u_int32_t   a5;
    u_int32_t   a6;
    u_int32_t   a7;
    u_char      a8[];
} memeter_ans8;

u_int32_t      memeter_crc32   __P((u_char *octets, size_t len));
u_int32_t      memeter_crc24   __P((u_char *octets, size_t len));
u_int32_t      memeter_csum1   __P((u_char *octets, size_t len));
u_int32_t      memeter_load    __P((u_char *octets, ssize_t len));
u_int32_t      memeter_vaxload __P((u_char *octets, ssize_t len));
void           memeter_store   __P((u_char *octets, ssize_t len, u_int32_t c));
void           memeter_dumpx   __P((u_char *octets, size_t len, const char *label));
void           memeter_dump    __P((u_char *octets, size_t len, const char *label));
int            memeter_0exchg  __P((memeter_cfg *cfg, u_char *o, size_t ol, u_char *ans, size_t *il));
memeter_1pack *memeter_1exchg  __P((memeter_cfg *cfg, memeter_1pack *out));
int            memeter_2exchg  __P((memeter_cfg *cfg, u_char *o, size_t ol, u_char *ans, size_t *il));
void          *memeter_3exchg  __P((memeter_cfg *cfg, u_char cmd, ...));
int            memeter_4req    __P((memeter_ctr *ctr, u_char *o, size_t ol));
int            memeter_4ans    __P((memeter_ctr *ctr, u_char *ans, size_t *il));
int            memeter_4ant    __P((memeter_ctr *ctr, u_char *ans, size_t *il, int q));
int            memeter_5req    __P((memeter_ctr *ctr, u_char cmd, ...));
int            memeter_5ans    __P((memeter_ctr *ctr, u_char cmd, void *out, int q));
int            memeter_6req    __P((memeter_ctr *ctr, u_int32_t cmd, ...));
int            memeter_6ans    __P((memeter_ctr *ctr, u_int32_t cmd, void *out, int q));

//0 -
//1 +
//2 =
//3 *
//4 .
//5 ,
//6 #
