/*-
 * Copyright (C)2012 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2012 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: octets.c,v 1.9 2012/02/29 07:00:34 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <stdio.h>

#define CRC32_INIT  0xFFFFFFFF
#define CRC32_POLY  0xEDB88320
#define CRC24_INIT  0x00B704CE
#define CRC24_POLY  0x01864CFB

/*************************************************************************
 *         .
 * memeter_crc32(octets, len)  crc32   octets 
 *              len   
 * memeter_crc24(octets, len)  crc24   octets 
 *              len   
 * memeter_csum1(octets, len)     
 *              octets  len   
 * memeter_load(octets, len)    octets 
 *              len     
 * memeter_store(octets, len, c)  c     octets
 *               len .
 * 
 *************************************************************************/

u_int32_t                     /* IEEE 802.3 */
memeter_crc32(u_char *octets, size_t len) {
    u_int32_t carry, r;
    size_t i;
    int j;

    r = CRC32_INIT;
    for (i = 0; i < len; ++i) {
        r ^= octets[i];
        for (j = 0; j < 8; ++j) {
            carry = r & 1;
            r >>= 1;
            if  (carry) r ^= CRC32_POLY;
    }   }
    r ^= CRC32_INIT;
    return(r);
}

u_int32_t                       /* RFC-2440 */
memeter_crc24(u_char *octets, size_t len) {
    u_int32_t r;
    size_t i;
    int j;

    r = CRC24_INIT;
    for (i = 0; i < len; ++i) {
        r ^= octets[i] << 16;
        for (j = 0; j < 8; ++j)  {
            r <<= 1;
            if  (r & 0x1000000) r ^= CRC24_POLY;
    }   }
    r &= 0x00FFFFFF;
    return(r);
}

u_int32_t
memeter_csum1(u_char *octets, size_t len) {
    u_int32_t r;
    size_t i;

    r = 0;
    for (i = 0; i < len; ++i) {
        r += octets[i];
    }
    --r;
    r &= 0x000000FF;
    return(r);
}

u_int32_t
memeter_load(u_char *octets, ssize_t len) {
    u_int32_t r;
    ssize_t i;

    r = 0;
    if  (len < 0) {
        for (i = 0; i < -len; ++i) {
            r <<= 8;
            r |= octets[i];
        }
    } else {
        for (i = len; i > 0;) {
            r <<= 8;
            r |= octets[--i];
    }   }
    return(r);
}

u_int32_t
memeter_vaxload(u_char *octets, size_t len) {
    return((memeter_load(octets, len - 2) << 16) | memeter_load(&octets[len - 2], 2));
}

void
memeter_store(u_char *octets, ssize_t len, u_int32_t c) {
    ssize_t i;

    if  (len < 0) {
        for (i = 0; i > len; --i) {
            octets[i - len - 1] = c & 0xFF;
            c >>= 8;
        }
    } else {
        for (i = 0; i < len; ++i) {
            octets[i] = c & 0xFF;
            c >>= 8;
}   }   }

void
memeter_dumpx(u_char *o, size_t ol, const char *label) {
    size_t i;

    for (i = 0; i < ol; ++i) {
        if  (!(i & 0x0F)) printf("\n%s%04X", label, (u_int32_t)i);
        if  (!(i & 0x01)) printf(" ");
        if  (!(i & 0x07)) printf(" ");
        printf("%02X", o[i]);
    }
    printf("\n");
}

void
memeter_dump(u_char *o, size_t ol, const char *label) {
    printf("%slen=%04X(%u)", label, (u_int32_t)ol, (u_int32_t)ol);
    memeter_dumpx(o, ol, label);
}
