/*-
 * Copyright (C)2012 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2012 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: level6.c,v 1.8 2012/02/29 07:00:34 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <termios.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <mercumeter.h>

//   XXXX  ?     ,  -   
static const memeter_6conf conf63 =
{ 0x38
, { {  4, 2, 0, 1, 0, 0, { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_MEAN_PWR_INI"    } /* 00 */
  , { 10, 2, 0, 1, 0, 0, { 2, 2, 2, 2, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_IND_TARIF"       } /* 01 */
  , {  6, 2, 0, 1, 0, 0, { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_IND_PERIOD"      } /* 02 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 03 */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_TEST"            } /* 04 */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_ADDR"            } /* 05 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 06 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 07 */
  , {  2, 2, 0, 1, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_DATE_FIX"        } /* 08 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 09 */
  , {  2, 2, 0, 1, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_CONTROL_INI"     } /* 0A */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0B */
  , { 10, 2, 0, 1, 0, 0, { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}, NULL, "C_SET_TIME"            } /* 0C */
  , {  5, 2, 0, 1, 0, 0, { 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_TIME_CORR"       } /* 0D */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0E */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0F */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 10 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 11 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 12 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 13 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 14 */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_COMM_PARM"       } /* 15 */
  , {  2, 2, 0, 1, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_RESET"           } /* 16 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 17 */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_DST_DIS"         } /* 18 */
  , {  8, 2, 0, 1, 0, 0, { 1, 1, 1, 1, 1, 1, 0, 0, 0, 0}, NULL, "C_SET_DST_TIME"        } /* 19 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1A */
  , {  6, 2, 0, 1, 0, 0, {-2,-2, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_TRANS_COFF"      } /* 1B */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1C */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1D */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1E */
  , { 15, 2,12, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_PASS"            } /* 1F */
  , {  2, 2, 0, 1, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_ENERGY_RST"      } /* 20 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 21 */
  , {  6, 2, 4, 1, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_LOCATION"        } /* 22 XXXX ? */
  , { 11, 2, 0, 1, 0, 0, { 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, NULL, "C_SET_PEAK_TIME"       } /* 23 */
  , {  2, 2, 0, 1, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_MON_MAX_RST"     } /* 24 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 25 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 26 */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_CONST_AB"        } /* 27 */
  , {  4, 2, 0, 1, 0, 0, { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_I_DIAP_DIS"      } /* 28 */
  , {  4, 2, 0, 1, 0, 0, { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_N_CORR_DIS"      } /* 29 */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_TARIF_MODE"      } /* 2A */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 2B */
  , {  5, 2, 0, 1, 0, 0, { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_PWR_LIMIT"       } /* 2C */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_PWR_LIMIT_ENA"   } /* 2D */
  , {  7, 2, 0, 1, 0, 0, { 1, 4, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_ENERGY_LIMIT"    } /* 2E XXXX ? */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_ENERGY_LIMIT_ENA"} /* 2F */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_IMP_OUT_MODE"    } /* 30 */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_LOAD_CTL_MODE"   } /* 31 */
  , {  3, 2, 0, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_TIMEOUT_COFF"    } /* 32 */
  , {  4, 2, 0, 1, 0, 0, { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_LOSS_ACC_MODE"   } /* 33 */
  , { 14, 2, 0, 1, 0, 0, {-2,-2,-2,-2,-2,-2, 0, 0, 0, 0}, NULL, "C_SET_LOSS"            } /* 34 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 35 */
  , { 18, 2, 0, 1, 0, 0, {-2,-2,-2,-2,-2,-2,-2,-2, 0, 0}, NULL, "C_SET_VALID_VALUES"    } /* 36 */
  , {  4, 2, 0, 1, 0, 0, { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_SET_MEAN_TIME"       } /* 37 */
} };

static const memeter_6conf conf64 =
{ 0x30
, { {  2, 2, 0,  8,   8, 1, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_TIME"            } /* 00 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_ONOFF"             } /* 01 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_TIME_SET"          } /* 02 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_ONOFF1"            } /* 03 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_ONOFF2"            } /* 04 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_ONOFF3"            } /* 05 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_PWR_LIMIT"         } /* 06 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_TARIF_SET"         } /* 07 */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_HOLIDAY_SET"       } /* 08 */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_ENERGY_RST"        } /* 09 */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MEAN_PWR_INI"      } /* 0A */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_ENERGY_LIMIT1"     } /* 0B */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_ENERGY_LIMIT2"     } /* 0C */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_ENERGY_LIMIT3"     } /* 0D */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_ENERGY_LIMIT4"     } /* 0E */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_PWR_LIMIT_SET"     } /* 0F */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_ENERGY_LIMIT_SET"  } /* 10 */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_LOSS_SET"          } /* 11 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_CASE"              } /* 12 */
  , {  3, 2, 0, 12, 141, 4, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_REPROG"            } /* 13 */
  , {  3, 2, 0, 12, 161, 5, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_STATUS"            } /* 14 */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_PEAK_TIME_SET"     } /* 15 */
  , {  3, 2, 0,  6, 121, 3, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MAX_PWR_RST"       } /* 16 */
  , {  0, 2, 0,  0,   0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 17 */
  , {  0, 2, 0,  0,   0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 18 */
  , {  0, 2, 0,  0,   0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 19 */
  , {  0, 2, 0,  0,   0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1A */
  , {  0, 2, 0,  0,   0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1B */
  , {  0, 2, 0,  0,   0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1C */
  , {  0, 2, 0,  0,   0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1D */
  , {  0, 2, 0,  0,   0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1E */
  , {  0, 2, 0,  0,   0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1F */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MIN_V1"            } /* 20 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MIN_NOM_V1"        } /* 21 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MAX_NOM_V1"        } /* 22 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MAX_V1"            } /* 23 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MIN_V2"            } /* 24 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MIN_NOM_V2"        } /* 25 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MAX_NOM_V2"        } /* 26 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MAX_V2"            } /* 27 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MIN_V3"            } /* 28 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MIN_NOM_V3"        } /* 29 */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MAX_NOM_V3"        } /* 2A */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MAX_V3"            } /* 2B */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MIN_F"             } /* 2C */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MIN_NOM_F"         } /* 2D */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MAX_NOM_F"         } /* 2E */
  , {  3, 2, 0, 12, 241, 2, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_J_MAX_F"             } /* 2F */
} };

static const memeter_6conf conf65 =
{ 0x07
, { {  3, 2, 0, 16, 25, 6, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_ENERGY_RST"          } /* 00 */
  , {  3, 2, 0, 16, 25, 6, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_ENERGY_CUR_YEAR"     } /* 01 */
  , {  3, 2, 0, 16, 25, 6, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_ENERGY_LAST_YEAR"    } /* 02 */
  , {  3, 2, 0, 16, 25, 6, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_ENERGY_MON"          } /* 03 */
  , {  3, 2, 0, 16, 25, 6, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_ENERGY_CUR_DAY"      } /* 04 */
  , {  3, 2, 0, 16, 25, 6, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_ENERGY_LAST_DAY"     } /* 05 */
  , {  3, 2, 0, 12, 19, 7, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_ENERGY_PHASE"        } /* 06 */
} };

static const memeter_6conf conf66 =
{ 0x44
, { {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 00 */
  , {  5, 2, 0, 1, 64, 10, {-2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "MEMETER_C_RMEM_1"      } /* 01 */
  , {  5, 2, 0, 1, 64, 10, {-2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "MEMETER_C_RMEM_2"      } /* 02 */
  , {  5, 2, 0, 1, 64, 10, {-2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "MEMETER_C_RMEM_3ALL"   } /* 03 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 04 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 05 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 06 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 07 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 08 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 09 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0A */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0B */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0C */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0D */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0E */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0F */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 10 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 11 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 12 */
  , {  5, 2, 0, 1, 64, 10, {-2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "MEMETER_C_RMEM_3APLUS" } /* 13 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 14 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 15 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 16 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 17 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 18 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 19 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1A */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1B */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1C */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1D */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1E */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 1F */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 20 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 21 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 22 */
  , {  5, 2, 0, 1, 64, 10, {-2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "MEMETER_C_RMEM_3AMINUS"} /* 23 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 24 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 25 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 26 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 27 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 28 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 29 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 2A */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 2B */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 2C */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 2D */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 2E */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 2F */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 30 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 31 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 32 */
  , {  5, 2, 0, 1, 64, 10, {-2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "MEMETER_C_RMEM_3RPLUS" } /* 33 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 34 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 35 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 36 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 37 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 38 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 39 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 3A */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 3B */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 3C */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 3D */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 3E */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 3F */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 40 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 41 */
  , {  0, 2, 0, 0,  0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 42 */
  , {  5, 2, 0, 1, 64, 10, {-2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "MEMETER_C_RMEM_3RMINUS"} /* 43 */
} };

static const memeter_6conf conf686 =
{ 0x06
, { {  3, 3, 0,12, 5, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_PWR"        } /* 00 */
  , {  3, 3, 0, 9, 4, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_V"          } /* 01 */
  , {  3, 3, 0, 9, 4, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_I"          } /* 02 */
  , {  3, 3, 0,12, 5, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_COFF"       } /* 03 */
  , {  3, 3, 0, 3, 2, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_FREQ"       } /* 04 */
  , {  3, 3, 0, 9, 4, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_ANGLE"      } /* 05 */
} };

static const memeter_6conf conf684 =
{ 0x10
, { {  3, 3, 0,16, 5, 16, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_FIXED_PWR"       } /* 00 */
  , {  3, 3, 0, 9, 4, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_FIXED_V"         } /* 01 */
  , {  3, 3, 0, 9, 4, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_FIXED_I"         } /* 02 */
  , {  3, 3, 0,12, 5, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_FIXED_COFF"      } /* 03 */
  , {  3, 3, 0, 3, 2, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_FIXED_FREQ"      } /* 04 */
  , {  3, 3, 0, 9, 4, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_FIXED_ANGLE"     } /* 05 */
  , {  0, 3, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 06 */
  , {  0, 3, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 07 */
  , {  0, 3, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 08 */
  , {  0, 3, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 09 */
  , {  0, 3, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0A */
  , {  0, 3, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0B */
  , {  0, 3, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0C */
  , {  0, 3, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0D */
  , {  3, 3, 0, 8, 2, 11, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_FIXED_DATE"      } /* 0E */
  , {  3, 3, 0,16, 5, 16, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_FIXED_ENERGY"    } /* 0F */
} };

static const memeter_6conf conf681 =
{ 0x06
, { {  3, 3, 0, 3, 2, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_1PWR"       } /* 00 */
  , {  3, 3, 0, 3, 2, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_1V"         } /* 01 */
  , {  3, 3, 0, 3, 2, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_1I"         } /* 02 */
  , {  3, 3, 0, 3, 2, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_1COFF"      } /* 03 */
  , {  3, 3, 0, 3, 2, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_1FREQ"      } /* 04 */
  , {  3, 3, 0, 3, 2, 12, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MAIN_1ANGLE"     } /* 05 */
} };

static const memeter_6conf conf68 =
{ 0x22
, { {  2, 2, 0, 7, 4,  8, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_SERIAL"          } /* 00 */
  , {  0, 2, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 01 */
  , {  2, 2, 0, 4, 2,  9, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_TRANS_COFF"      } /* 02 */
  , {  2, 2, 0, 3, 3,  1, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_VERSION"         } /* 03 */
  , {  0, 2, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 04 */
  , {  2, 2, 0, 2, 1,  9, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_ADDR"            } /* 05 */
  , {  0, 2, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 06 */
  , {  2, 2, 0, 6, 6,  1, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_DST"             } /* 07 */
  , {  0, 2, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 08 */
  , {  2, 2, 0, 2, 1,  9, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_FLAGS"           } /* 09 */
  , {  2, 2, 0, 4, 0, 10, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_STATUS"          } /* 0A */
  , {  2, 2, 0, 4, 1, 11, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_LOCATION"        } /* 0B */
  , {  3, 2, 0, 8, 8,  1, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_PEAK_TIME"       } /* 0C */
  , {  3, 2, 0,16, 8, 14, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_PEAK_PWR"        } /* 0D */
  , {  0, 2, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0E */
  , {  0, 2, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 0F */
  , {  0, 2, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 10 */
  , {  0, 2, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, &conf681,                 NULL} /* 11 */
  , {  2, 2, 0, 6, 2, 11, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_VARIANT"         } /* 12 */
  , {  2, 2, 0, 9, 7, 13, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MEAN_PWR_LAST"   } /* 13 */
  , {  0, 3, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, &conf684,                 NULL} /* 14 */
  , {  0, 2, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL,                     NULL} /* 15 */
  , {  0, 3, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, &conf686,                 NULL} /* 16 */
  , {  2, 2, 0, 2, 1,  9, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_TARIF_STATUS"    } /* 17 */
  , {  2, 2, 0, 2, 1,  9, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_LOAD_CTL_STATUS" } /* 18 */
  , {  2, 2, 0, 0, 0,  0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_PWR_LIMIT"       } /* 19 ? XXXX */
  , {  3, 2, 0, 0, 0,  0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_ENERGY_LIMIT"    } /* 1A ? XXXX */
  , {  2, 2, 0, 8, 4, 14, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_IND_TARIF"       } /* 1B */
  , {  2, 2, 0, 4, 4,  1, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_IND_PERIOD"      } /* 1C */
  , {  2, 2, 0, 2, 1,  9, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_TIMEOUT_COFF"    } /* 1D */
  , {  2, 2, 0, 2, 1, 14, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_LOSS_ACC_MODE"   } /* 1E */
  , {  2, 2, 0,12, 6, 14, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_LOSS"            } /* 1F */
  , {  2, 2, 0,16, 8, 14, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_VALID_VALUES"    } /* 20 ? XXXX */
  , {  2, 2, 0, 2, 2,  1, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, "C_GET_MEAN_TIME"       } /* 21 */
} };

static const memeter_6conf conf6 =
{ 9
, { {  1, 1, 0, 1, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},    NULL, "C_CHANTST"} /* 00 */
  , {  8, 1, 6, 1, 0, 0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},    NULL, "C_PASS"   } /* 01 */
  , {  1, 1, 0, 1, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},    NULL, "C_CLOSE"  } /* 02 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, &conf63,        NULL} /* 03 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, &conf64,        NULL} /* 04 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, &conf65,        NULL} /* 05 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, &conf66,        NULL} /* 06 */
  , { 21, 1,16, 1, 0, 0, { 1,-2, 1, 0, 0, 0, 0, 0, 0, 0},    NULL,  "C_WMEM"  } /* 07 */
  , {  0, 2, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, &conf68,        NULL} /* 08 */
} };

static const char fmt[][6] = {" Err", " %02X", " %04X", " %06X", " %08X"};

static const memeter_6cmd *
findcmd(u_int32_t cmd, const memeter_6conf *c) {
    const memeter_6cmd *f = NULL;

    if  ((cmd & 0xFF) < c->quo) {
        f = &c->s[cmd & 0xFF];
        if  (f->next) f = findcmd(cmd >> 8, f->next);
    }
    return(f);
}

int
memeter_6req(memeter_ctr *ctr, u_int32_t cmd, ...) {
    ifBLIN_FLAG = ctr->cfg->flags;
    u_int32_t i, v, ci, len;
    u_char *out = NULL, *c;
    const memeter_6cmd *f;
    int ex = EX_OK;
    va_list ap;

    va_start(ap, cmd);
    if  (!(f = findcmd(cmd, &conf6)) || !f->ml) {
        if  (ctr->cfg->flags & MEMETER_6ODUMP) {
            if  (f && f->ml > 1) {
                printf("<<6 ##### %02X %02X\n", cmd, cmd >> 8);
            } else {
                printf("<<6 ##### %02X\n", cmd);
        }   }
        ifBLIN_QX0("Illegal command %02X %02X @ 6", cmd, cmd >> 8);
        errno = EINVAL;
        ex = EX_USAGE;
        goto out;
    }
    if  (!(out = malloc(f->ml))) {
        ifBLIN_QX0("Malloc failed #1");
        errno = ENOMEM;
        ex = EX_OSERR;
        goto out;
    }
    ci = 0;
    memeter_store(&out[ci], f->cl, cmd);
    ci += f->cl;
    if  (ctr->cfg->flags & MEMETER_6ODUMP) printf("<<6 ##### %s", f->lit);
    for (i = 0; f->p[i]; ++i) {
        u_int32_t l;

        l = (f->p[i] > 0) ? f->p[i] : -f->p[i];
        if  (ci + l > f->ml) {
            ifBLIN_QX0("No spase in command");
            errno = EDOOFUS;
            ex = EX_SOFTWARE;
            goto out;
        }
        v = va_arg(ap, u_int32_t);
        memeter_store(&out[ci], f->p[i], v);
        if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(fmt[l], v);
        ci += l;
    }
    len = f->al;
    switch (cmd) {
    case MEMETER_C_WMEM            :
        len = v;
        break;
    case MEMETER_C_ENERGY_MON      :
    case MEMETER_C_ENERGY_PHASE    :
        v = va_arg(ap, u_int32_t) & 0x0F;
        if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(fmt[1], v);
        out[ci - 2] = (out[ci - 2] & 0x0F) | (v << 4);
    case MEMETER_C_ENERGY_RST      :
    case MEMETER_C_ENERGY_CUR_YEAR :
    case MEMETER_C_ENERGY_LAST_YEAR:
    case MEMETER_C_ENERGY_CUR_DAY  :
    case MEMETER_C_ENERGY_LAST_DAY :
        out[ci - 2] = ((out[ci - 2] << 4) & 0xF0) | ((out[ci - 2] >> 4) & 0x0F);
        break;
    case MEMETER_C_GET_MAIN_V     :
    case MEMETER_C_GET_MAIN_I     :
    case MEMETER_C_GET_MAIN_ANGLE :
        out[ci - 1] |= 0x10;
    case MEMETER_C_GET_MAIN_COFF  :
        out[ci - 1] = ((out[ci - 1] << 4) & 0xF0) | ((out[ci - 1] >> 4) & 0x0F);
        break;
    case MEMETER_C_GET_MAIN_PWR   :
        v = va_arg(ap, u_int32_t) & 0x03;
        if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(fmt[1], v);
        out[ci - 1] = ((out[ci - 1] << 4) & 0xF0) | (v << 2);
        break;
    case MEMETER_C_GET_MAIN_1V     :
    case MEMETER_C_GET_MAIN_1I     :
    case MEMETER_C_GET_MAIN_1ANGLE :
    case MEMETER_C_GET_MAIN_1COFF  :
        v = va_arg(ap, u_int32_t) & 0x0F;
        if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(fmt[1], v);
        out[ci - 1] = ((out[ci - 1] << 4) & 0xF0) | v;
        break;
    case MEMETER_C_GET_MAIN_1PWR   :
        v = va_arg(ap, u_int32_t) & 0x03;
        if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(fmt[1], v);
        out[ci - 1] = ((out[ci - 1] << 4) & 0xF0) | v;
        v = va_arg(ap, u_int32_t) & 0x03;
        if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(fmt[1], v);
        out[ci - 1] |= v << 2;
        break;
    case MEMETER_C_GET_FIXED_PWR   :
        v = va_arg(ap, u_int32_t);
        if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(fmt[1], v);
        out[ci - 1] |= v << 6;
    case MEMETER_C_GET_FIXED_V     :
    case MEMETER_C_GET_FIXED_I     :
    case MEMETER_C_GET_FIXED_COFF  :
    case MEMETER_C_GET_FIXED_FREQ  :
    case MEMETER_C_GET_FIXED_ANGLE :
    case MEMETER_C_GET_FIXED_DATE  :
    case MEMETER_C_GET_FIXED_ENERGY:
    case MEMETER_C_GET_MAIN_1FREQ  :
        out[ci - 1] = ((out[ci - 1] << 4) & 0xF0) | ((out[ci - 1] >> 4) & 0x0F);
        break;
    }
    if  (f->al) {
        c = va_arg(ap, u_char *);
        for (i = 0; i < f->al; ++i) {
            if  (ci >= f->al) {
                ifBLIN_QX0("No spase in command");
                errno = EDOOFUS;
                ex = EX_SOFTWARE;
                goto out;
            }
            out[ci] = c[i];
            if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" %02X", out[ci]);
            ++ci;
    }   }
    if  (ctr->cfg->flags & MEMETER_6ODUMP) printf("\n");
    ex = memeter_5req(ctr, MEMETER_PLCII_THROUGH, f->ml, out);
out:
    free(out);
    return(ex);
}

int
memeter_6ans(memeter_ctr *ctr, u_int32_t cmd, void *out, int q) {
    ifBLIN_FLAG = ctr->cfg->flags;
    memeter_ansb *a = NULL;
    const memeter_6cmd *f;
    int ex = 0, nl = 0;

    ifBLIN_QX2("+ %04X %d\n", cmd, q);
    {   u_int32_t **o = out;

       *o = NULL;
    }
    if  (q < MEMETER_MINWAIT) {
        ifBLIN_QX0("time wail low %d", q);
        errno = EINVAL;
        ex = MEMETER_EX_LOWAIT;
        goto out;
    }
    if  ((ex = memeter_5ans(ctr, MEMETER_PLCII_THROUGH, &a, q))) goto out;
    if  (!(f = findcmd(cmd, &conf6)) || !f->ml) {
        ifBLIN_QX0("Illegal command %02X %02X @ 6", cmd, cmd >> 8);
        errno = EINVAL;
        ex = MEMETER_EX_6USE;
        goto out;
    }
    if  (a->a1 < f->rl) {
        ifBLIN_QX0("answer shorten");
        errno = ENOMSG;
        ex = MEMETER_EX_6PROTO;
        goto out;
    }
    if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(">>6 ##### %s", f->lit);
    nl = 1;
    {   u_int32_t **o = out;

        if  (f->ol && (!(*o = malloc(f->ol * sizeof(u_int32_t))))) {
            ifBLIN_QX0("Malloc failed #1");
            errno = ENOMEM;
            ex = MEMETER_EX_MEM;
            goto out;
    }   }
    switch(f->mode) {
    case 0:
        /*         */
        ex = a->a2[0];
        break;
    case 1:
        /*      , *
         *   ,      *
         *   -           */
        {   u_int32_t i, **o = out;

            if  (f->rl != a->a1) {
                ifBLIN_QX0("proto length %u <> %u", a->a1, f->rl);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            for (i = 0; i < a->a1; ++i) {
                (*o)[i] = a->a2[i];
                if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" %02X", (*o)[i]);
        }   }
        break;
    case 2:
        /*     2 - */
        {   u_int32_t i, k, **o = out;

            k = a->a1;
            if  (k == 12) {
                (*o)[0] = 0xFFFFFFFF;
            } else if (k == 13) {
                (*o)[0] = a->a2[12];
                --k;
            } else if (!(k % 12)) {
                (*o)[0] = (k / 12) | 0xFFFFFF00;
            } else {
                ifBLIN_QX0("proto length %u !/ 12", a->a1);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" [%04X]", (*o)[0] & 0xFFFF);
            for (i = 0; i < k; ++i) {
                (*o)[i + 1] = a->a2[i];
                ++i;
                if  (ctr->cfg->flags & MEMETER_6ODUMP) {
                    if  (!(i % 12) && !i) printf("                      "); /* strlen(f->lit) XXXX */
                    printf(" %02X", (*o)[i]);
                    nl = 1;
                    if  ((i % 12) == 11) {
                        printf("\n");
                        nl = 0;
        }   }   }   }
        break;
    case 3:
        /*     1 - */
        {   u_int32_t i, k, **o = out;

            k = a->a1;
            if  (k == 6) {
                (*o)[0] = 0xFFFFFFFF;
            } else if (k == 7) {
                (*o)[0] = a->a2[6];
                --k;
            } else if (!(k % 6)) {
                (*o)[0] = (k / 6) | 0xFFFFFF00;
            } else {
                ifBLIN_QX0("proto length %u !/ 6", a->a1);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" [%04X]", (*o)[0] & 0xFFFF);
            for (i = 0; i < k; ++i) {
                (*o)[i + 1] = a->a2[i];
                ++i;
                if  (ctr->cfg->flags & MEMETER_6ODUMP) {
                    if  (!(i % 6) && !i) printf("                      "); /* strlen(f->lit) XXXX */
                    printf(" %02X", (*o)[i]);
                    nl = 1;
                    if  ((i % 6) == 5) {
                        printf("\n");
                        nl = 0;
        }   }   }   }
        break;
    case 4:
        /*   C_J_REPROG */
        {   struct {
                u_int32_t a1;
                u_int32_t a2;
                u_int32_t a3;
                u_int32_t a4;
                u_int32_t a5;
                u_int32_t a6;
                u_char    a7[7];
            } **o = out;
            u_int32_t i, k;

            k = a->a1;
            if  (k == 12) {
                (*o)->a1 = 0xFFFFFFFF;
            } else if (k == 13) {
                (*o)->a1 = a->a2[12];
                --k;
            } else if (!(k % 12)) {
                (*o)->a1 = (k / 12) | 0xFFFFFF00;
            } else {
                ifBLIN_QX0("proto length %u !/ 12", a->a1);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" [%04X]", (*o)->a1 & 0xFFFF);
            for (i = 0; i < (k / 12); ++i) {
                (*o)->a2 = a->a2[0];
                (*o)->a3 = a->a2[1];
                (*o)->a4 = a->a2[2];
                (*o)->a5 = a->a2[3];
                (*o)->a6 = a->a2[11];
                bcopy(&a->a2[4], (*o)->a7, 7);
                if  (ctr->cfg->flags & MEMETER_6ODUMP) {
                    printf( "%s %02X %02X %02X %02X %02X %02X%02X%02X%02X%02X%02X%02X\n"
                          , (i) ? "                           " : ""
                          , (*o)->a2
                          , (*o)->a3
                          , (*o)->a4
                          , (*o)->a5
                          , (*o)->a6
                          , (*o)->a7[0]
                          , (*o)->a7[1]
                          , (*o)->a7[2]
                          , (*o)->a7[3]
                          , (*o)->a7[4]
                          , (*o)->a7[5]
                          , (*o)->a7[6]
                          )
                    ;
                    nl = 0;
        }   }   }
        break;
    case 5:
        /*   C_J_STATUS */
        {   struct {
                u_int32_t a1;
                u_int32_t a2;
                u_int32_t a3;
                u_int32_t a4;
                u_int32_t a5;
                u_int32_t a6;
                u_int32_t a7;
                u_char    a8[6];
            } **o = out;
            u_int32_t i, k;

            k = a->a1;
            if  (k == 12) {
                (*o)->a1 = 0xFFFFFFFF;
            } else if (k == 13) {
                (*o)->a1 = a->a2[12];
                --k;
            } else if (!(k % 12)) {
                (*o)->a1 = (k / 12) | 0xFFFFFF00;
            } else {
                ifBLIN_QX0("proto length %u !/ 12", a->a1);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" [%04X]", (*o)->a1 & 0xFFFF);
            for (i = 0; i < (k / 12); ++i) {
                (*o)->a2 = a->a2[0];
                (*o)->a3 = a->a2[1];
                (*o)->a4 = a->a2[2];
                (*o)->a5 = a->a2[3];
                (*o)->a6 = a->a2[4];
                (*o)->a7 = a->a2[5];
                bcopy(&a->a2[6], (*o)->a8, 6);
                if  (ctr->cfg->flags & MEMETER_6ODUMP) {
                    printf( "%s %02X %02X %02X %02X %02X %02X %02X%02X%02X%02X%02X%02X\n"
                          , (i) ? "                           " : ""
                          , (*o)->a2
                          , (*o)->a3
                          , (*o)->a4
                          , (*o)->a5
                          , (*o)->a6
                          , (*o)->a7
                          , (*o)->a8[0]
                          , (*o)->a8[1]
                          , (*o)->a8[2]
                          , (*o)->a8[3]
                          , (*o)->a8[4]
                          , (*o)->a8[5]
                          )
                    ;
                    nl = 0;
        }   }   }
        break;
    case 6:
        /*   1, 5  6   4 4   VAX  */
        {   u_int32_t i, **o = out;

            if  ((a->a1 != 16) && (a->a1 != 80) && (a->a1 != 96)) {
                ifBLIN_QX0("proto length %u != 16,80,96", a->a1);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            (*o)[0] = a->a1 / 16;
            if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" [%u]", (*o)[0]);
            for (i = 0; i < (*o)[0]; ++i) {
                (*o)[i * 4 + 1] = memeter_vaxload(&a->a2[i * 16], 4);
                (*o)[i * 4 + 2] = memeter_vaxload(&a->a2[i * 16 + 4], 4);
                (*o)[i * 4 + 3] = memeter_vaxload(&a->a2[i * 16 + 8], 4);
                (*o)[i * 4 + 4] = memeter_vaxload(&a->a2[i * 16 + 12], 4);
                if  (ctr->cfg->flags & MEMETER_6ODUMP) {
                    printf( "%s %10u %10u %10u %10u\n"
                          , (i) ? "                           " : "" /* strlen(f->lit) XXXX */
                          , (*o)[i * 4 + 1]
                          , (*o)[i * 4 + 2]
                          , (*o)[i * 4 + 3]
                          , (*o)[i * 4 + 4]
                          )
                    ;
                    nl = 0;
        }   }   }
        break;
    case 7:
        /*   1, 5  6   3 4   VAX  */
        {   u_int32_t i, **o = out;

            if  ((a->a1 != 12) && (a->a1 != 60) && (a->a1 != 72)) {
                ifBLIN_QX0("proto length %u != 12,60,72", a->a1);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            (*o)[0] = a->a1 / 12;
            if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" [%u]", (*o)[0]);
            for (i = 0; i < (*o)[0]; ++i) {
                (*o)[i * 3 + 1] = memeter_vaxload(&a->a2[i * 12], 4);
                (*o)[i * 3 + 2] = memeter_vaxload(&a->a2[i * 12 + 4], 4);
                (*o)[i * 3 + 3] = memeter_vaxload(&a->a2[i * 12 + 8], 4);
                if  (ctr->cfg->flags & MEMETER_6ODUMP) {
                    printf( "%s %10u %10u %10u\n"
                          , (i) ? "                           " : "" /* strlen(f->lit) XXXX */
                          , (*o)[i * 4 + 1]
                          , (*o)[i * 4 + 2]
                          , (*o)[i * 4 + 3]
                          )
                    ;
                    nl = 0;
        }   }   }
        break;
    case 8:
        /* 4   2/100 ,  ,  3  C_GET_SERIAL */
        {   u_int32_t i, **o = out;

            if  (f->rl != a->a1) {
                ifBLIN_QX0("proto length %u <> %u", a->a1, f->rl);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            for (**o = 0, i = 0; i < 4; ++i) **o = (**o << 8) + (a->a2[i] / 10 * 16) + (a->a2[i] % 10);
            if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" %08u", **o);
            for (i = 4; i < a->a1; ++i) {
                (*o)[i - 3] = a->a2[i];
                if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" %02X", (*o)[i - 3]);
        }   }
        break;
    case 9:
        /*  2     , *
         *   ,         *
         *   -   .          *
         *   .                         */
        {   u_int32_t i, **o = out;

            if  (f->rl != a->a1) {
                ifBLIN_QX0("proto length %u <> %u", a->a1, f->rl);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            for (i = 0; (i * 2) < a->a1; ++i) {
                (*o)[i] = memeter_load(&a->a2[i * 2], -2);
                if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" %04X", (*o)[i]);
        }   }
        break;
    case 10:
        /*     */
        {   memeter_ansb **o = out;
            u_int32_t i;

            *o = a;
            if  (ctr->cfg->flags & MEMETER_6ODUMP) {
                for (i = 0; i < a->a1; ++i) printf(" %02X", a->a2[i]);
            }
            a = NULL;
        }
        break;
    case 11:
        /*           *
         *   ,         *
         *   -   .          */
        {   u_char **o = out;
            u_int32_t i;

            if  (f->rl != a->a1) {
                ifBLIN_QX0("proto length %u <> %u", a->a1, f->rl);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            for (i = 0; i < a->a1; ++i) {
                (*o)[i] = a->a2[i];
                if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" %02X", (*o)[i]);
        }   }
        break;
    case 12:
        /*   -  2     , *
         *        ,  *
         *    - , .                    *
         *   - .                            *
         *   - 3  4 .                      *
         *   ,                *
         *   -   .                 */
        {   u_int32_t i, k, **o = out;

            if  (f->rl != a->a1) {
                ifBLIN_QX0("proto length %u <> %u", a->a1, f->rl);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            k = f->rl / 3;
            (*o)[0] = 0;
            if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" [%u]", (*o)[0]);
            for (i = 0; i < k; ++i) {
                (*o)[0] <<= 2;
                (*o)[0] |= a->a2[i * 3] >> 6;
                (*o)[i + 1] = memeter_vaxload(&a->a2[i * 3], 3) & 0x003FFFFF;
            }
            if  (ctr->cfg->flags & MEMETER_6ODUMP) {
                for (i = 0; i < k; ++i) printf( " %1X", ((*o)[0] >> ((k - i - 1) * 2)) & 0x3);
                for (i = 0; i < k; ++i) printf( " %u", (*o)[i + 1]);
        }   }
        break;
    case 13:
        /*     . *
         *  3     , *
         *     .                  *
         *   ,          *
         *   -   .           */
        {   u_int32_t i, **o = out;

            if  (f->rl != a->a1) {
                ifBLIN_QX0("proto length %u <> %u", a->a1, f->rl);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            a->a2[0] = ((a->a2[0] << 4) & 0xF0) | ((a->a2[0] >> 4) & 0x0F);
            (*o)[0] = memeter_load(a->a2, -3);
            if  (ctr->cfg->flags & MEMETER_6ODUMP) printf( " %06X", (*o)[0]);
            for (i = 3; i < a->a1; ++i) {
                (*o)[i - 2] = a->a2[i];
                if  (ctr->cfg->flags & MEMETER_6ODUMP) printf( " %02X", (*o)[i - 2]);
        }   }
        break;
    case 14:
        /*  2     , *
         *   ,         *
         *   -   .          *
         *   .                         */
        {   u_int32_t i, **o = out;

            if  (f->rl != a->a1) {
                ifBLIN_QX0("proto length %u <> %u", a->a1, f->rl);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            for (i = 0; (i * 2) < a->a1; ++i) {
                (*o)[i] = memeter_load(&a->a2[i * 2], 2);
                if  (ctr->cfg->flags & MEMETER_6ODUMP) printf(" %04X", (*o)[i]);
        }   }
        break;
    case 15:
        break;
    case 16:
        /*   -  2     , *
         *        ,  *
         *    - , .                    *
         *  4  -   4             *
         *    VAX .                   */
        {   u_int32_t i, **o = out;

            if  (a->a1 != 16) {
                ifBLIN_QX0("proto length %u <>16", a->a1);
                errno = ENOMSG;
                ex = MEMETER_EX_6PROTO;
                goto out;
            }
            (*o)[0] = 0;
            for (i = 0; i < 4; ++i) {
                (*o)[0] <<= 2;
                (*o)[0] |= a->a2[i * 4] >> 6;
                (*o)[i + 1] = memeter_vaxload(&a->a2[i * 4], 4) & 0x3FFFFFFF;
            }
            if  (ctr->cfg->flags & MEMETER_6ODUMP) {
                for (i = 0; i < 4; ++i) printf( " %1X", ((*o)[0] >> ((3 - i) * 2)) & 0x3);
                for (i = 0; i < 4; ++i) printf( " %u", (*o)[i + 1]);
        }   }
        break;
    }
out:
    free(a);
    if  (ctr->cfg->flags & MEMETER_6ODUMP) printf("\n");
    {   u_char **o = out;

        ifBLIN_QX2("- %d "BLIN_X" "BLIN_X"\n", ex, BLIN_I(out), BLIN_I(*o));
    }
    return(ex);
}
