/*-
 * Copyright (C)2012 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2012 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: level5.c,v 1.5 2012/02/29 07:00:34 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <termios.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <mercumeter.h>

static char cn[][13] =
{ "PLCII_SCAN"
, "PLCII_GETCNF"
, "PLCII_SETIME"
, "PLCII_CLOSE"
, "PLCII_OPEN"
, "PLCII_GETCNT"
};

int
memeter_5req(memeter_ctr *ctr, u_char cmd, ...) {
    ifBLIN_FLAG = ctr->cfg->flags;
    u_char *out = NULL;
    int ex = EX_OK;
    va_list ap;

    va_start(ap, cmd);
    ifBLIN_QX2("+ %02X\n", cmd);
    switch (cmd) {
    default                   :
        if  (ctr->cfg->flags & MEMETER_5ODUMP) printf("<<5 ,,,,, %02X\n", cmd);
        ifBLIN_QX0("Illegal command %02X @ 5", cmd);
        errno = EINVAL;
        ex = EX_USAGE;
        break;
    case MEMETER_PLCII_SCAN   :
        {   u_int32_t val;
            size_t oi;

            if  (!(out = malloc(9))) {
                ifBLIN_QX0("Malloc failed #1");
                errno = ENOMEM;
                ex = EX_OSERR;
                goto out;
            }
            if  (ctr->cfg->flags & MEMETER_5ODUMP) printf("<<5 ,,,,, %s", cn[cmd]);
            oi = 0;
            out[oi++] = cmd;
            val = va_arg(ap, u_int32_t);
            if  (ctr->cfg->flags & MEMETER_5ODUMP) printf(" %08X", val);
            memeter_store(&out[oi], 4, val);
            oi += 4;
            val = va_arg(ap, u_int32_t);
            if  (ctr->cfg->flags & MEMETER_5ODUMP) printf(" %08X", val);
            memeter_store(&out[oi], 4, val);
            oi += 4;
            if  (ctr->cfg->flags & MEMETER_5ODUMP) printf("\n");
            ex = memeter_4req(ctr, out, oi);
        }
        break;
    case MEMETER_PLCII_SETIME :
        {   u_int32_t val;

            if  (!(out = malloc(5))) {
                ifBLIN_QX0("Malloc failed #1");
                errno = ENOMEM;
                ex = EX_OSERR;
                goto out;
            }
            out[0] = cmd;
            val = va_arg(ap, u_int32_t);
            if  (ctr->cfg->flags & MEMETER_5ODUMP) {
                printf("<<5 ,,,,, %s %08X(%u)\n", cn[cmd], val, val);
            }
            memeter_store(&out[1], 4, val);
            ex = memeter_4req(ctr, out, 5);
        }
        break;
    case MEMETER_PLCII_GETCNF :
    case MEMETER_PLCII_CLOSE  :
    case MEMETER_PLCII_OPEN   :
    case MEMETER_PLCII_GETCNT :
        if  (!(out = malloc(1))) {
            ifBLIN_QX0("Malloc failed #1");
            errno = ENOMEM;
            ex = EX_OSERR;
            goto out;
        }
        if  (ctr->cfg->flags & MEMETER_5ODUMP) printf("<<5 ,,,,, %s\n", cn[cmd]);
        out[0] = cmd;
        ex = memeter_4req(ctr, out, 1);
        break;
    case MEMETER_PLCII_THROUGH:
        {   u_int32_t l;
            u_char *c;

            l = va_arg(ap, u_int32_t);
            if  (!(out = malloc(l + 1))) {
                ifBLIN_QX0("Malloc failed #1");
                errno = ENOMEM;
                ex = EX_OSERR;
                goto out;
            }
            out[0] = cmd;
            c = va_arg(ap, u_char *);
            if  (ctr->cfg->flags & MEMETER_5ODUMP) {
                printf("<<5 ,,,,, PLCII_THROUGH");
                printf(" len=%04X(%u)", l, l);
                memeter_dumpx(c, l, "<<5 ,,,,, ");
            }
            bcopy(c, &out[1], l);
            ex = memeter_4req(ctr, out, l + 1);
        }
        break;
    }
out:
    free(out);
    ifBLIN_QX2("- %d\n", ex);
    return(ex);
}

int
memeter_5ans(memeter_ctr *ctr, u_char cmd, void *out, int q) {
#   define INBUF 512              /* overkill XXXX */
    ifBLIN_FLAG = ctr->cfg->flags;
    u_char *a = NULL;
    int ex = 0;
    size_t il;

    ifBLIN_QX2("+ %02X %u\n", cmd, q);
    {   u_int32_t **o = out;

       *o = NULL;
    }
    if  (q < MEMETER_MINWAIT) {
        ifBLIN_QX0("time wait low %d", q);
        errno = EINVAL;
        ex = MEMETER_EX_LOWAIT;
        goto out;
    }
    il = INBUF;
    if  (!(a = malloc(il))) {
        errno = ENOMEM;
        ifBLIN_QW0("Malloc failed #1");
        ex = MEMETER_EX_MEM;
        goto out;
    }
    if  ((ex = memeter_4ant(ctr, a, &il, q))) goto out;
    if  (!il) {
        ifBLIN_QX0("null message");
        errno = ENOMSG;
        ex = MEMETER_EX_4NULL;
        goto out;
    }
    ifBLIN_QX3(",,,,, %02X %02X\n", a[0], q);
    switch (a[0] ^ 0x80) {
    default                   :
        if  (ctr->cfg->flags & MEMETER_5ODUMP) printf(">>5 ,,,,, %02X", a[0]);
        ifBLIN_QX0("unknown command %02X", a[0]);
        ex = MEMETER_EX_5PROTO;
        goto out;
    case MEMETER_EX_4SPEC     :
        ifBLIN_QX0("protocol violation");
        if  (ctr->cfg->flags & MEMETER_5ODUMP) printf(">>5 ,,,,, PLCII_ILLEGAL\n");
        if  (il != 1) {
            ifBLIN_QX0("illegal protocol packet %u <> 1", il);
            errno = ENOMSG;
            ex = MEMETER_EX_4PROTO;
            goto out;
        }
        ex = MEMETER_EX_BMASK4 | MEMETER_EX_4SPEC;
        goto out;
    case MEMETER_EX_4COMM     :
        {   u_int32_t **ans = out;

            ifBLIN_QX0("node unreachable");
            if  (il != 5) {
                ifBLIN_QX0("illegal protocol packet");
                errno = ENOMSG;
                ex = MEMETER_EX_4PROTO;
                goto out;
            }
            if  (!((*ans) = malloc(sizeof(u_int32_t)))) {
                errno = ENOMEM;
                ifBLIN_QW0("Malloc failed #2");
                ex = MEMETER_EX_MEM;
                goto out;
            }
            (*ans)[0] = memeter_load(&a[1], 4);
            if  (ctr->cfg->flags & MEMETER_5ODUMP) printf(">>5 ,,,,, PLCII_NOCOMM %08X\n", (*ans)[0]);
            ex = MEMETER_EX_BMASK4 | MEMETER_EX_4COMM;
        }
        goto out;
    case MEMETER_PLCII_SCAN   :
    case MEMETER_PLCII_SETIME :
    case MEMETER_PLCII_CLOSE  :
    case MEMETER_PLCII_OPEN   :
        if  (ctr->cfg->flags & MEMETER_5ODUMP) printf(">>5 ,,,,, %s %02X\n", cn[a[0] ^ 0x80], a[1]);
        if  (il != 2) {
            ifBLIN_QX0("node unreaceable");
            errno = ENOMSG;
            ex = MEMETER_EX_4PROTO;
            goto out;
        }
        if  (a[1]) ex = MEMETER_EX_BMASK4 | a[1];
        break;
    case MEMETER_PLCII_GETCNF :
    case MEMETER_PLCII_GETCNT :
        {   u_char **b = out;

            if  (ctr->cfg->flags & MEMETER_5ODUMP) {
                printf(">>5 ,,,,, %s %02X %02X %02X %02X\n", cn[a[0] ^ 0x80], a[1], a[2], a[3], a[4]);
            }
            if  (il != 5) {
                ifBLIN_QX0("node unreaceable");
                errno = EPROCUNAVAIL;
                ex = MEMETER_EX_4PROTO;
                goto out;
            }
            if  (!((*b) = malloc(3 * sizeof(u_char)))) {
                errno = ENOMEM;
                ifBLIN_QW0("Malloc failed #3");
                ex = MEMETER_EX_MEM;
                goto out;
            }
            if  (a[1]) ex = MEMETER_EX_BMASK4 | a[1];
            (*b)[0] = a[2];
            (*b)[1] = a[3];
            (*b)[2] = a[4];
        }
        break;
    case MEMETER_PLCII_THROUGH:
        {   memeter_ansb **b = out;

            --il;
            if  (ctr->cfg->flags & MEMETER_5ODUMP) {
                printf(">>5 ,,,,, PLCII_THROUGH len=%04X(%u)", (u_int32_t)il, (u_int32_t)il);
            }
            if  (!((*b) = malloc(sizeof(u_int32_t) * 2 + il))) {
                errno = ENOMEM;
                ifBLIN_QW0("Malloc failed #4");
                ex = MEMETER_EX_MEM;
                goto out;
            }
            (*b)->a1 = il;
            bcopy(&a[1], (*b)->a2, il);
            if  (ctr->cfg->flags & MEMETER_5ODUMP) memeter_dumpx((*b)->a2, il, ">>5 ,,,,, ");
        }
        break;
    }
    if  (a[0] ^ 0x80 ^ cmd) ex = MEMETER_EX_BMASK5 | a[0];
out:
    free(a);
    {   u_char **o = out;

        ifBLIN_QX2("- %d "BLIN_X" "BLIN_X"\n", ex, BLIN_I(out), BLIN_I(*o));
    }
    return(ex);
}
