/*-
 * Copyright (C)2012 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2012 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: level4.c,v 1.7 2012/02/29 07:00:34 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <termios.h>
#include <strings.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mercumeter.h>

int
memeter_4req(memeter_ctr *ctr, u_char *o, size_t ol) {
    ifBLIN_FLAG = ctr->cfg->flags;
    memeter_ans3 *s;
    memeter_ansb *b;
    u_int32_t t;
    void *ans;
    int ex = 0;

    ifBLIN_QX2("+\n");
    if  (ctr->cfg->flags & MEMETER_4ODUMP) {
        printf( "<<4 ..... %08X %02X %04X len=%04X(%u)"
              , ctr->ctr
              , ctr->mbx
              , ctr->mst
              , (u_int32_t)ol
              , (u_int32_t)ol
              )
        ;
        memeter_dumpx(o, ol, "<<4 ..... ");
    }
    if  ((ctr->mst & MEMETER_SEG_STATUS_RETYPEALL) == 0) {
        t = 0;
    } else if ((ctr->mst & MEMETER_SEG_STATUS_RETYPEALL) == MEMETER_SEG_STATUS_RETYPEALL) {
        t = 1;
    } else if (!(s = memeter_3exchg(ctr->cfg, MEMETER_GET_SEG_STATUS, ctr->ctr, ctr->mbx))) {
        ex = MEMETER_EX_3NO;
        goto out;
    } else {
        t = ((s->a1 ^ ctr->mst) & MEMETER_SEG_STATUS_TRANS_TYPE) ? 1 : 0;
        ex = s->a2;
    }
    if  ((ctr->mst & MEMETER_SEG_STATUS_RECMDALL) == 0) {
    } else if ((ctr->mst & MEMETER_SEG_STATUS_RECMDALL) == MEMETER_SEG_STATUS_RECMDALL) {
        t |= 2;
    } else if (!(b = memeter_3exchg(ctr->cfg, MEMETER_GET_SEG_REQ, ctr->ctr, ctr->mbx))) {
        ex = MEMETER_EX_3NO;
        goto out;
    } else if ((b->a1 != ol) || bcmp(b->a2, o, ol)) {
        t |= 2;
    }
    ifBLIN_QX3("mst=%04X t=%02X", ctr->mst, t);
    t = (ctr->mst >> (t * 2 + 8)) & 3;
    ifBLIN_QX3(" -> %02X", t);
    if  (!(t & 1)) {
    } else if (!(s = memeter_3exchg(ctr->cfg, MEMETER_SET_SEG_STATUS, ctr->ctr, ctr->mbx, ctr->mst))) {
        ex = MEMETER_EX_3NO;
        goto out;
    } else {
        ex = s->a2;
    }
    if  ((t & 2) && !(ans = memeter_3exchg( ctr->cfg
                                          , MEMETER_SET_SEG_REQ
                                          , ctr->ctr
                                          , ctr->mbx
                                          , ol
                                          , o
        )            )                    ) {
        ex = MEMETER_EX_3NO;
        goto out;
    }
out:
    ifBLIN_QX2("- %d\n", ex);
    return(ex);
}

int
memeter_4ans(memeter_ctr *ctr, u_char *ans, size_t *il) {
    ifBLIN_FLAG = ctr->cfg->flags;
    memeter_ans8 *b;
    memeter_ans3 *g;
    int ex;

    ifBLIN_QX2("+ %d\n", *il);
    if  (!(g = memeter_3exchg(ctr->cfg, MEMETER_GET_SEG_STATUS, ctr->ctr, ctr->mbx))) {
        ex = MEMETER_EX_3NO;
        goto out;
    }
    if  (!(g->a1 & MEMETER_SEG_STATUS_ANS_READY)) {
        ex = g->a2 + 1;
        goto out;
    }
    if  (!(b = memeter_3exchg(ctr->cfg, MEMETER_GET_SEG_ANS, ctr->ctr, ctr->mbx))) {
        ex = MEMETER_EX_3NO;
        goto out;
    }
    if  (*il < b->a7) {
        ifBLIN_QX0("no space %u for result %u", *il, b->a7, *il);
        errno = ENOSPC;
        ex = MEMETER_EX_3SPC;
        goto out;
    }
    *il = b->a7;
    bcopy(b->a8, ans, *il);
    ex = 0;
    if  (ctr->cfg->flags & MEMETER_4IDUMP) {
        printf( ">>4 ..... %08X %02X %04u-%02u-%02u %02u:%02u:%02u len=%04X(%u)"
              , ctr->ctr, ctr->mbx
              , 2000 + b->a6, 1 + b->a5, 1 + b->a4, b->a3, b->a2, b->a1
              , b->a7, b->a7
              )
        ;
        memeter_dumpx(b->a8, b->a7, ">>4 ..... ");
    }
out:
    ifBLIN_QX2("- %d %d\n", ex, *il);
    return(ex);
}

int
memeter_4ant(memeter_ctr *ctr, u_char *ans, size_t *il, int q) {
    int ex;

    ifBLIN_QX2("+ %d %u\n", q, *il);
    if  (q < MEMETER_MINWAIT) {
        ifBLIN_QX0("time wail low %d", q);
        errno = EINVAL;
        ex = MEMETER_EX_LOWAIT;
        goto out;
    }
    do {
        if  (!(ex = memeter_4ans(ctr, ans, il))) {
            break;
        } else if (0 > ex) {
            goto out;
        }
        if  (q > ctr->cfg->contrwait) break;
        usleep(q * 5000);
        q = q * 2 + ex;
    } while (1);
    if  (ex > 0) {
        ifBLIN_QX0("timeout");
        errno = ETIMEDOUT;
        ex = q;
    }
out:
    ifBLIN_QX2("- %d %d\n", ex, *il);
    return(ex);
}
