/*-
 * Copyright (C)2012 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2012 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: level3.c,v 1.7 2012/02/29 07:00:34 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <termios.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include <mercumeter.h>

#define N1B    0x80
#define IT0    0x40
#define ITE    0x20
#define ITM    0x60
#define CNN    10
#define OBULEN 256

typedef enum kind
{ P00, P0 , P1 , P2 , P4 , P5 , P5c, P6
, P8 , PM , P44, PD , PS , PST, PSt, P1e
, P2e, P4m, P4c, PMc, Pc
} kind;

typedef struct param3 {
    u_char fl;
#   define LMASK 0x0F
    u_char mx;
    u_char pm[CNN];
} param3;

static const memeter_3conf conf3[256] =
{ {P1 , MEMETER_GET_CONFIG     , P1 ,   1, "SET_CONFIG"     } // 0x00 5.1.4
, {PD , MEMETER_GET_TIMEDATE   , PD ,   7, "SET_TIMEDATE"   } // 0x01 5.1.5
, {  0,                       0,   0,   0,              NULL} // 0x02
, {  0,                       0,   0,   0,              NULL} // 0x03
, {  0,                       0,   0,   0,              NULL} // 0x04
, {  0,                       0,   0,   0,              NULL} // 0x05
, {P2 , MEMETER_GET_ADDR       , P2 ,   2, "SET_ADDR"       } // 0x06 5.1.2
, {  0,                       0,   0,   0,              NULL} // 0x07
, {  0,                       0,   0,   0,              NULL} // 0x08
, {  0,                       0,   0,   0,              NULL} // 0x09
, {  0,                       0,   0,   0,              NULL} // 0x0A
, {  0,                       0,   0,   0,              NULL} // 0x0B
, {  0,                       0,   0,   0,              NULL} // 0x0C
, {  0,                       0,   0,   0,              NULL} // 0x0D
, {  0,                       0,   0,   0,              NULL} // 0x0E
, {  0,                       0,   0,   0,              NULL} // 0x0F
, {  0,                       0,   0,   0,              NULL} // 0x10
, {  0,                       0,   0,   0,              NULL} // 0x11
, {  0,                       0,   0,   0,              NULL} // 0x12
, {  0,                       0,   0,   0,              NULL} // 0x13
, {P44, MEMETER_GET_P_LIST     , P44, 255, "SET_P_LIST"     } // 0x14 5.1.15
, {P4 , MEMETER_SET_ADD_NODE   , P4 ,   1, "SET_ADD_NODE"   } // 0x15 5.1.7
, {P4 , MEMETER_SET_DEL_NODE   , P4 ,   1, "SET_DEL_NODE"   } // 0x16 5.1.8
, {  0,                       0,   0,   0,              NULL} // 0x17
, {P5 , MEMETER_GET_SL_CONFIG  , P5 ,   2, "SET_SL_CONFIG"  } // 0x18 5.1.16
, {P1 , MEMETER_GET_SEG_NUM    , P1 ,   1, "SET_SEG_NUM"    } // 0x19 5.1.11
, {P6 , MEMETER_GET_SEG_STATUS , PST,   2, "SET_SEG_STATUS" } // 0x1A 5.1.18
, {PM , MEMETER_GET_SEG_REQ    , P5c,   2, "SET_SEG_REQ"    } // 0x1B 5.1.19
, {  0,                       0,   0,   0,              NULL} // 0x1C
, {P0 , MEMETER_SET_CLR_ALL_SEG, P0 ,   0, "SET_CLR_ALL_SEG"} // 0x1D 5.1.12
, {P8 , MEMETER_SET_REPLACE_ID , P8 ,   2, "SET_REPLACE_ID" } // 0x1E 5.1.14
, {P8 , MEMETER_GET_PARENT     , P8 ,   2, "SET_PARENT"     } // 0x1F 5.1.17
, {  0,                       0,   0,   0,              NULL} // 0x20
, {  0,                       0,   0,   0,              NULL} // 0x21
, {  0,                       0,   0,   0,              NULL} // 0x22
, {  0,                       0,   0,   0,              NULL} // 0x23
, {  0,                       0,   0,   0,              NULL} // 0x24
, {  0,                       0,   0,   0,              NULL} // 0x25
, {  0,                       0,   0,   0,              NULL} // 0x26
, {  0,                       0,   0,   0,              NULL} // 0x27
, {  0,                       0,   0,   0,              NULL} // 0x28
, {  0,                       0,   0,   0,              NULL} // 0x29
, {  0,                       0,   0,   0,              NULL} // 0x2A
, {  0,                       0,   0,   0,              NULL} // 0x2B
, {  0,                       0,   0,   0,              NULL} // 0x2C
, {  0,                       0,   0,   0,              NULL} // 0x2D
, {  0,                       0,   0,   0,              NULL} // 0x2E
, {  0,                       0,   0,   0,              NULL} // 0x2F
, {  0,                       0,   0,   0,              NULL} // 0x30
, {  0,                       0,   0,   0,              NULL} // 0x31
, {  0,                       0,   0,   0,              NULL} // 0x32
, {  0,                       0,   0,   0,              NULL} // 0x33
, {  0,                       0,   0,   0,              NULL} // 0x34
, {  0,                       0,   0,   0,              NULL} // 0x35
, {  0,                       0,   0,   0,              NULL} // 0x36
, {  0,                       0,   0,   0,              NULL} // 0x37
, {  0,                       0,   0,   0,              NULL} // 0x38
, {  0,                       0,   0,   0,              NULL} // 0x39
, {  0,                       0,   0,   0,              NULL} // 0x3A
, {  0,                       0,   0,   0,              NULL} // 0x3B
, {  0,                       0,   0,   0,              NULL} // 0x3C
, {  0,                       0,   0,   0,              NULL} // 0x3D
, {  0,                       0,   0,   0,              NULL} // 0x3E
, {  0,                       0,   0,   0,              NULL} // 0x3F
, {  0,                       0,   0,   0,              NULL} // 0x40
, {  0,                       0,   0,   0,              NULL} // 0x41
, {  0,                       0,   0,   0,              NULL} // 0x42
, {  0,                       0,   0,   0,              NULL} // 0x43
, {  0,                       0,   0,   0,              NULL} // 0x44
, {  0,                       0,   0,   0,              NULL} // 0x45
, {  0,                       0,   0,   0,              NULL} // 0x46
, {  0,                       0,   0,   0,              NULL} // 0x47
, {  0,                       0,   0,   0,              NULL} // 0x48
, {  0,                       0,   0,   0,              NULL} // 0x49
, {  0,                       0,   0,   0,              NULL} // 0x4A
, {  0,                       0,   0,   0,              NULL} // 0x4B
, {  0,                       0,   0,   0,              NULL} // 0x4C
, {  0,                       0,   0,   0,              NULL} // 0x4D
, {  0,                       0,   0,   0,              NULL} // 0x4E
, {  0,                       0,   0,   0,              NULL} // 0x4F
, {  0,                       0,   0,   0,              NULL} // 0x50
, {  0,                       0,   0,   0,              NULL} // 0x51
, {  0,                       0,   0,   0,              NULL} // 0x52
, {  0,                       0,   0,   0,              NULL} // 0x53
, {  0,                       0,   0,   0,              NULL} // 0x54
, {  0,                       0,   0,   0,              NULL} // 0x55
, {  0,                       0,   0,   0,              NULL} // 0x56
, {  0,                       0,   0,   0,              NULL} // 0x57
, {  0,                       0,   0,   0,              NULL} // 0x58
, {  0,                       0,   0,   0,              NULL} // 0x59
, {  0,                       0,   0,   0,              NULL} // 0x5A
, {  0,                       0,   0,   0,              NULL} // 0x5B
, {  0,                       0,   0,   0,              NULL} // 0x5C
, {  0,                       0,   0,   0,              NULL} // 0x5D
, {  0,                       0,   0,   0,              NULL} // 0x5E
, {  0,                       0,   0,   0,              NULL} // 0x5F
, {  0,                       0,   0,   0,              NULL} // 0x60
, {  0,                       0,   0,   0,              NULL} // 0x61
, {  0,                       0,   0,   0,              NULL} // 0x62
, {  0,                       0,   0,   0,              NULL} // 0x63
, {  0,                       0,   0,   0,              NULL} // 0x64
, {  0,                       0,   0,   0,              NULL} // 0x65
, {  0,                       0,   0,   0,              NULL} // 0x66
, {  0,                       0,   0,   0,              NULL} // 0x67
, {  0,                       0,   0,   0,              NULL} // 0x68
, {  0,                       0,   0,   0,              NULL} // 0x69
, {  0,                       0,   0,   0,              NULL} // 0x6A
, {  0,                       0,   0,   0,              NULL} // 0x6B
, {  0,                       0,   0,   0,              NULL} // 0x6C
, {  0,                       0,   0,   0,              NULL} // 0x6D
, {  0,                       0,   0,   0,              NULL} // 0x6E
, {  0,                       0,   0,   0,              NULL} // 0x6F
, {  0,                       0,   0,   0,              NULL} // 0x70
, {  0,                       0,   0,   0,              NULL} // 0x71
, {  0,                       0,   0,   0,              NULL} // 0x72
, {  0,                       0,   0,   0,              NULL} // 0x73
, {  0,                       0,   0,   0,              NULL} // 0x74
, {  0,                       0,   0,   0,              NULL} // 0x75
, {  0,                       0,   0,   0,              NULL} // 0x76
, {  0,                       0,   0,   0,              NULL} // 0x77
, {  0,                       0,   0,   0,              NULL} // 0x78
, {  0,                       0,   0,   0,              NULL} // 0x79
, {  0,                       0,   0,   0,              NULL} // 0x7A
, {  0,                       0,   0,   0,              NULL} // 0x7B
, {  0,                       0,   0,   0,              NULL} // 0x7C
, {P0 , MEMETER_SET_CLEAR_ST   , P0 ,   0, "SET_CLEAR_ST"   } // 0x7D 5.1.9
, {  0,                       0,   0,   0,              NULL} // 0x7E
, {  0,                       0,   0,   0,              NULL} // 0x7F
, {P0 , MEMETER_GET_CONFIG     , P1 ,   0, "GET_CONFIG"     } // 0x80 5.1.4
, {P0 , MEMETER_GET_TIMEDATE   , PD ,   0, "GET_TIMEDATE"   } // 0x81 5.1.5
, {  0,                       0,   0,   0,              NULL} // 0x82
, {P0 , MEMETER_GET_VERINFO    , PS ,   0, "GET_VERINFO"    } // 0x83 5.1.3
, {  0,                       0,   0,   0,              NULL} // 0x84
, {  0,                       0,   0,   0,              NULL} // 0x85
, {P0 , MEMETER_GET_ADDR       , P2 ,   0, "GET_ADDR"       } // 0x86 5.1.1 5.1.2
, {  0,                       0,   0,   0,              NULL} // 0x87
, {  0,                       0,   0,   0,              NULL} // 0x88
, {  0,                       0,   0,   0,              NULL} // 0x89
, {  0,                       0,   0,   0,              NULL} // 0x8A
, {  0,                       0,   0,   0,              NULL} // 0x8B
, {  0,                       0,   0,   0,              NULL} // 0x8C
, {  0,                       0,   0,   0,              NULL} // 0x8D
, {  0,                       0,   0,   0,              NULL} // 0x8E
, {  0,                       0,   0,   0,              NULL} // 0x8F
, {P1 , MEMETER_GET_NL_PAGE    , P4m,   1, "GET_NL_PAGE"    } // 0x90 5.1.6
, {  0,                       0,   0,   0,              NULL} // 0x91
, {  0,                       0,   0,   0,              NULL} // 0x92
, {  0,                       0,   0,   0,              NULL} // 0x93
, {P4 , MEMETER_GET_P_LIST     , P4c,   1, "GET_P_LIST"     } // 0x94 5.1.15
, {  0,                       0,   0,   0,              NULL} // 0x95
, {  0,                       0,   0,   0,              NULL} // 0x96
, {P4 , MEMETER_GET_MOD_CONFIG , Pc ,   1, "GET_MOD_CONFIG" } // 0x97 5.1.21
, {P4 , MEMETER_GET_SL_CONFIG  , P5c,   1, "GET_SL_CONFIG"  } // 0x98 5.1.16
, {P0 , MEMETER_GET_SEG_NUM    , P1 ,   0, "GET_SEG_NUM"    } // 0x99 5.1.11
, {P5 , MEMETER_GET_SEG_STATUS , PSt,   2, "GET_SEG_STATUS" } // 0x9A 5.1.18
, {P5 , MEMETER_GET_SEG_REQ    , PM ,   2, "GET_SEG_REQ"    } // 0x9B 5.1.19
, {P5 , MEMETER_GET_SEG_ANS    , PMc,   2, "GET_SEG_ANS"    } // 0x9C 5.1.20
, {  0,                       0,   0,   0,              NULL} // 0x9D
, {  0,                       0,   0,   0,              NULL} // 0x9E
, {P4 , MEMETER_GET_PARENT     , P8 ,   1, "GET_PARENT"     } // 0x9F 5.1.17
, {P1 , MEMETER_GET_TIMESLOT   , P2e,   1, "GET_TIMESLOT"   } // 0xA0 5.1.13
, {  0,                       0,   0,   0,              NULL} // 0xA1
, {  0,                       0,   0,   0,              NULL} // 0xA2
, {  0,                       0,   0,   0,              NULL} // 0xA3
, {  0,                       0,   0,   0,              NULL} // 0xA4
, {  0,                       0,   0,   0,              NULL} // 0xA5
, {  0,                       0,   0,   0,              NULL} // 0xA6
, {  0,                       0,   0,   0,              NULL} // 0xA7
, {  0,                       0,   0,   0,              NULL} // 0xA8
, {  0,                       0,   0,   0,              NULL} // 0xA9
, {  0,                       0,   0,   0,              NULL} // 0xAA
, {  0,                       0,   0,   0,              NULL} // 0xAB
, {  0,                       0,   0,   0,              NULL} // 0xAC
, {  0,                       0,   0,   0,              NULL} // 0xAD
, {  0,                       0,   0,   0,              NULL} // 0xAE
, {  0,                       0,   0,   0,              NULL} // 0xAF
, {  0,                       0,   0,   0,              NULL} // 0xB0
, {  0,                       0,   0,   0,              NULL} // 0xB1
, {  0,                       0,   0,   0,              NULL} // 0xB2
, {  0,                       0,   0,   0,              NULL} // 0xB3
, {  0,                       0,   0,   0,              NULL} // 0xB4
, {  0,                       0,   0,   0,              NULL} // 0xB5
, {  0,                       0,   0,   0,              NULL} // 0xB6
, {  0,                       0,   0,   0,              NULL} // 0xB7
, {  0,                       0,   0,   0,              NULL} // 0xB8
, {  0,                       0,   0,   0,              NULL} // 0xB9
, {  0,                       0,   0,   0,              NULL} // 0xBA
, {  0,                       0,   0,   0,              NULL} // 0xBB
, {  0,                       0,   0,   0,              NULL} // 0xBC
, {  0,                       0,   0,   0,              NULL} // 0xBD
, {  0,                       0,   0,   0,              NULL} // 0xBE
, {  0,                       0,   0,   0,              NULL} // 0xBF
, {  0,                       0,   0,   0,              NULL} // 0xC0
, {  0,                       0,   0,   0,              NULL} // 0xC1
, {  0,                       0,   0,   0,              NULL} // 0xC2
, {  0,                       0,   0,   0,              NULL} // 0xC3
, {  0,                       0,   0,   0,              NULL} // 0xC4
, {  0,                       0,   0,   0,              NULL} // 0xC5
, {  0,                       0,   0,   0,              NULL} // 0xC6
, {  0,                       0,   0,   0,              NULL} // 0xC7
, {  0,                       0,   0,   0,              NULL} // 0xC8
, {  0,                       0,   0,   0,              NULL} // 0xC9
, {  0,                       0,   0,   0,              NULL} // 0xCA
, {  0,                       0,   0,   0,              NULL} // 0xCB
, {  0,                       0,   0,   0,              NULL} // 0xCC
, {  0,                       0,   0,   0,              NULL} // 0xCD
, {  0,                       0,   0,   0,              NULL} // 0xCE
, {  0,                       0,   0,   0,              NULL} // 0xCF
, {  0,                       0,   0,   0,              NULL} // 0xD0
, {  0,                       0,   0,   0,              NULL} // 0xD1
, {  0,                       0,   0,   0,              NULL} // 0xD2
, {  0,                       0,   0,   0,              NULL} // 0xD3
, {  0,                       0,   0,   0,              NULL} // 0xD4
, {  0,                       0,   0,   0,              NULL} // 0xD5
, {  0,                       0,   0,   0,              NULL} // 0xD6
, {  0,                       0,   0,   0,              NULL} // 0xD7
, {  0,                       0,   0,   0,              NULL} // 0xD8
, {  0,                       0,   0,   0,              NULL} // 0xD9
, {  0,                       0,   0,   0,              NULL} // 0xDA
, {  0,                       0,   0,   0,              NULL} // 0xDB
, {  0,                       0,   0,   0,              NULL} // 0xDC
, {  0,                       0,   0,   0,              NULL} // 0xDD
, {  0,                       0,   0,   0,              NULL} // 0xDE
, {  0,                       0,   0,   0,              NULL} // 0xDF
, {  0,                       0,   0,   0,              NULL} // 0xE0
, {  0,                       0,   0,   0,              NULL} // 0xE1
, {  0,                       0,   0,   0,              NULL} // 0xE2
, {  0,                       0,   0,   0,              NULL} // 0xE3
, {  0,                       0,   0,   0,              NULL} // 0xE4
, {  0,                       0,   0,   0,              NULL} // 0xE5
, {  0,                       0,   0,   0,              NULL} // 0xE6
, {  0,                       0,   0,   0,              NULL} // 0xE7
, {  0,                       0,   0,   0,              NULL} // 0xE8
, {  0,                       0,   0,   0,              NULL} // 0xE9
, {  0,                       0,   0,   0,              NULL} // 0xEA
, {  0,                       0,   0,   0,              NULL} // 0xEB
, {  0,                       0,   0,   0,              NULL} // 0xEC
, {  0,                       0,   0,   0,              NULL} // 0xED
, {  0,                       0,   0,   0,              NULL} // 0xEE
, {  0,                       0,   0,   0,              NULL} // 0xEF
, {P0 , MEMETER_GET_LOG_FILE   , P1e,   0, "GET_LOG_FILE"   } // 0xF0 5.1.10
, {  0,                       0,   0,   0,              NULL} // 0xF1
, {  0,                       0,   0,   0,              NULL} // 0xF2
, {  0,                       0,   0,   0,              NULL} // 0xF3
, {  0,                       0,   0,   0,              NULL} // 0xF4
, {  0,                       0,   0,   0,              NULL} // 0xF5
, {  0,                       0,   0,   0,              NULL} // 0xF6
, {  0,                       0,   0,   0,              NULL} // 0xF7
, {  0,                       0,   0,   0,              NULL} // 0xF8
, {  0,                       0,   0,   0,              NULL} // 0xF9
, {  0,                       0,   0,   0,              NULL} // 0xFA
, {  0,                       0,   0,   0,              NULL} // 0xFB
, {  0,                       0,   0,   0,              NULL} // 0xFC
, {  0,                       0,   0,   0,              NULL} // 0xFD
, {  0,                       0,   0,   0,              NULL} // 0xFE
, {  0,                       0,   0,   0,              NULL} // 0xFF
};

static const param3 parm3[] =
{ {            0,   0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}} // P00
, {            0,   0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}} // P0
, {        0 | 1,   0, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}} // P1
, {        0 | 1,   0, { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0}} // P2
, {      N1B | 1,   0, { 4, 0, 0, 0, 0, 0, 0, 0, 0, 0}} // P4
, {        0 | 2,   0, { 4, 1, 0, 0, 0, 0, 0, 0, 0, 0}} // P5
, {      N1B | 2,   0, { 4, 1, 0, 0, 0, 0, 0, 0, 0, 0}} // P5c
, {        0 | 3,   0, { 4, 1, 1, 0, 0, 0, 0, 0, 0, 0}} // P6
, {      N1B | 2,   0, { 4, 4, 0, 0, 0, 0, 0, 0, 0, 0}} // P8
, {IT0 | N1B | 2, 250, { 4, 1, 1, 0, 0, 0, 0, 0, 0, 0}} // PM
, {IT0       | 1,  16, { 4, 4, 0, 0, 0, 0, 0, 0, 0, 0}} // P44
, {        0 | 7,   0, { 1, 1, 1, 1, 1, 1, 1, 0, 0, 0}} // PD
, {IT0       | 0, 255, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}} // PS
, {        0 | 5,   0, { 4, 1, 1, 2, 1, 0, 0, 0, 0, 0}} // PST
, {      N1B | 5,   0, { 4, 1, 1, 2, 1, 0, 0, 0, 0, 0}} // PSt
, {ITE       | 0, 240, { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}} // P1e
, {ITE       | 1,  64, { 1, 2, 0, 0, 0, 0, 0, 0, 0, 0}} // P2e
, {IT0       | 1,  32, { 1, 4, 0, 0, 0, 0, 0, 0, 0, 0}} // P4m
, {IT0 | N1B | 1,  16, { 4, 4, 0, 0, 0, 0, 0, 0, 0, 0}} // P4c
, {IT0 | N1B | 8, 244, { 4, 1, 1, 1, 1, 1, 1, 1, 1, 0}} // PMc
, {ITM | N1B | 1,   1, { 4, 1, 1, 1, 0, 0, 0, 0, 0, 0}} // Pc
};

static const char fmt[][6] = {" Err", " %02X", " %04X", " Err", " %08X"};

static ssize_t
count(memeter_cfg *cfg, const param3 *ar, size_t pm, size_t ci, size_t il) {
    ifBLIN_FLAG = cfg->flags;
    ssize_t c;

    ifBLIN_QX4( "C#0 fl=%02X mx=%02X pm=%02X %02X %02X %02X %02X %02X %02X %02X %02X %02X\n"
                "ci=%u pm=%u < %u sw %02X\n"
              , ar->fl
              , ar->mx
              , ar->pm[0]
              , ar->pm[1]
              , ar->pm[2]
              , ar->pm[3]
              , ar->pm[4]
              , ar->pm[5]
              , ar->pm[6]
              , ar->pm[7]
              , ar->pm[8]
              , ar->pm[9]
              , ci
              , pm
              , ar->fl & LMASK
              )
    ;
    for (c = 0; pm < (ar->fl & LMASK); ++pm) {
        ci += ar->pm[pm];
        c += 4;
    }
    ifBLIN_QX4("C#1 ci=%u pm=%u c=%d sw %02X\n", ci, pm, c, ar->fl & ITM);
    switch (ar->fl & ITM) {
    case   0:
        ifBLIN_QX4("C#2 ITM 0\n");
        break;
    case IT0:
        if  (  (il < ci)
            || !ar->pm[pm]
            || (((il - ci) / ar->pm[pm]) > ar->mx)
            || ((il - ci) & (ar->pm[pm] - 1))
            ) {
            ifBLIN_QX0("illegal cmd length");
            ifBLIN_QX4("il=%04X ci=%04X mx=%04X pm=%04X [pm]=%04X\n", il, ci, ar->mx, pm, ar->pm[pm]);
            errno = ENOMSG;
            c = -1;
            goto out;
        }
        c += 4 + (il - ci);
        ++pm;
        ifBLIN_QX4("C#2 ITM IT0 pm=%u c=%d\n", pm, c);
        break;
    case ITE:
        if  (  (il < ci)
            || (((il - ci) / ar->pm[pm]) != ar->mx)
            || ((il - ci) & (ar->pm[pm] - 1))
            ) {
            ifBLIN_QX0("illegal cmd length");
            errno = ENOMSG;
            c = -1;
            goto out;
        }
        c += (il - ci) * ar->pm[pm];
        ++pm;
        ifBLIN_QX4("C#2 ITM ITE pm=%u c=%d\n", pm, c);
        break;
    case ITM: /*  ,    ,  1   XXXX */
        for (; ar->pm[pm] && (ci < il); ++pm) {
            ci += ar->pm[pm];
            c += 4;
        }
        ifBLIN_QX4("C#2 ITM ITM ci=%u pm=%u c=%d\n", ci, pm, c);
        break;
    }
    if  (ci > il) {
        ifBLIN_QX0("short cmd");
        errno = ENOSPC;
        c = -1;
        goto out;
    }
    if  (ar->pm[pm]) {
        ifBLIN_QX0("internal error");
        errno = EDOOFUS;
        c = -1;
        goto out;
    }
out:
    return(c);
}

void *
memeter_3exchg(memeter_cfg *cfg, u_char cmd, ...) {
    u_char *out = NULL, *in = NULL;
    ifBLIN_FLAG = cfg->flags;
    u_int32_t *res = NULL;
    int ex = EX_OK;
    size_t il, oi;
    va_list ap;

    va_start(ap, cmd);
    ifBLIN_QX2("+ %02X\n", cmd);
    if  (conf3[cmd].lit) {
        if  (cfg->flags & MEMETER_3ODUMP) printf("<<3 ***** %s", conf3[cmd].lit);
    } else {
        ifBLIN_QX0("illegal cmd %u", cmd);
        errno = ENOTSUP;
        goto out;
    }
    if  (!(out = malloc(OBULEN + 4))) {
        ifBLIN_QX0("Malloc failed #1");
        errno = ENOMEM;
        goto out;
    }
    /*       */
    oi = 0;
    out[oi++] = cmd;
    {   u_int32_t *o4 = NULL;
        u_int16_t *o2 = NULL;
        u_char *o1 = NULL;
        u_int32_t val, fl;
        size_t ci, mx;
        size_t l;

        /*   */
        fl = parm3[conf3[cmd].prm].fl;
        for (ci = 0; ci < (fl & LMASK); ++ci) {
            switch ((l = parm3[conf3[cmd].prm].pm[ci])) {
            default:
                ifBLIN_QX0("illegal param %d", l);
                errno = EINVAL;
                goto out;
            case 4:
            case 2:
            case 1:
                val = va_arg(ap, u_int32_t);
                if  (cfg->flags & MEMETER_3ODUMP) printf(fmt[l], val);
            }
            
            memeter_store(&out[oi], l, val);
            oi += l;
            if  (oi > OBULEN) {
                ifBLIN_QX0("Overflow #1");
                errno = ENOSPC;
                goto out;
        }   }
        /*   */
        mx = parm3[conf3[cmd].prm].mx;
        if  (!(fl & ITM) || !mx) {
            /*     */
        } else if (((fl & ITM) == ITM) || (parm3[conf3[cmd].prm].pm[(fl & LMASK) + 1])) {
            /*       */
            ifBLIN_QX0("illegal param #0");
            errno = EINVAL;
            goto out;
        } else {
            if  ((fl & ITM) == IT0) mx = va_arg(ap, size_t);
            if  (mx && cfg->flags & MEMETER_3ODUMP) {
                printf(" len=%04X(%u)\n<<3 ***** ", (u_int32_t)mx, (u_int32_t)mx);
            }
            switch ((l = parm3[conf3[cmd].prm].pm[fl & LMASK])) {
            default:
                ifBLIN_QX0("illegal param %d", l);
                errno = EINVAL;
                goto out;
            case 4:
                o4 = va_arg(ap, u_int32_t*); break;
            case 2:
                o2 = va_arg(ap, u_int16_t*); break;
            case 1:
                o1 = va_arg(ap, u_char*);    break;
            }
            for (ci = 0; ci < mx; ++ci) {
                switch (l) {
                case 4:
                    memeter_store(&out[oi], l, o4[ci]);
                    if  (cfg->flags & MEMETER_3ODUMP) printf(fmt[l], o4[ci]);
                    break;
                case 2:
                    memeter_store(&out[oi], l, o2[ci]);
                    if  (cfg->flags & MEMETER_3ODUMP) printf(fmt[l], o2[ci]);
                    break;
                case 1:
                    out[oi] = o1[ci];
                    if  (cfg->flags & MEMETER_3ODUMP) printf(fmt[l], o1[ci]);
                    break;
                }
                oi += l;
                if  (oi > OBULEN) {
                    ifBLIN_QX0("Overflow #1");
                    errno = ENOSPC;
                    goto out;
    }   }   }   }
    if  (cfg->flags & MEMETER_3ODUMP) printf("\n");
    /*     */
    il = OBULEN;
    if  (!(in = malloc(il))) {
        ifBLIN_QX0("Malloc failed #2");
        errno = ENOMEM;
        goto out;
    }
    /*   */
    if  ((ex = memeter_2exchg(cfg, out, oi, in, &il))) {
        goto out;
    } else if (!il) {
        ifBLIN_QX0("message empty");
        errno = ENOMSG;
        goto out;
    } else if (conf3[cmd].ans != in[0]) {
        ifBLIN_QX0("unexpected message type");
        errno = ENOMSG;
        goto out;
    } else if ((parm3[conf3[cmd].arr].fl & N1B) && (il == 1)) {
        ifBLIN_QX1("short answer");
        errno = ENOATTR;
        goto out;
    }
    /*   */
    {   size_t ci, pm, ri, rl;
        ssize_t i;

        if  (cfg->flags & MEMETER_3IDUMP) printf(">>3 ***** %s", conf3[conf3[cmd].ans].lit);
        /*         ,    */
        {   size_t l, comlen;

            comlen = (oi > il) ? il : oi;
            for (ci = 1, pm = 0; (ci < comlen) && (pm < conf3[cmd].com); ++pm, ci += l) {
                l = parm3[conf3[cmd].prm].pm[pm];
                ifBLIN_QX4("l=%u ci=%u pm=%u comlen=%u\n", l, ci, pm, comlen);
                if  (cfg->flags & MEMETER_3IDUMP) printf(fmt[l], memeter_load(&in[ci], l));
                if  (ci + l > comlen) {
                    ifBLIN_QX0("unexpected message length");
                    errno = ENOSPC;
                    goto out;
                } else if (memcmp(&in[ci], &out[ci], l)) {
                    ifBLIN_QX0("unexpected message parameter");
                    errno = ENOMSG;
                    goto out;
        }   }   }
        if  (cfg->flags & MEMETER_3IDUMP) printf(" |");
        /*   */
        ifBLIN_QX3( "ci=%u[pm=%u] conf3[%02X]=%02X,%02X,%02X,%02X\n"
                  , ci, pm, cmd, conf3[cmd].prm, conf3[cmd].ans, conf3[cmd].arr, conf3[cmd].com
                  )
        ;
        if  (0 > (i = count(cfg, &parm3[conf3[cmd].arr], pm, ci, il))) goto out;
        if  (!i) {
            res = MEMETER_RES_OK;
            goto out;
        }
        ifBLIN_QX3(" alloc for ans %d\n", i);
        if  (!(res = malloc(i))) {
            ifBLIN_QX0("Malloc failed #3");
            errno = ENOMEM;
            goto out;
        }
        for (ri = 0; pm < (parm3[conf3[cmd].arr].fl & LMASK);) {
            size_t l;

            l = parm3[conf3[cmd].arr].pm[pm++];
            res[ri] = memeter_load(&in[ci], l);
            ifBLIN_QX5("ci=%02X ri=%02X pm=%02X l=%02X val=%08X\n", ci, ri, pm, l, res[ri]);
            if  (cfg->flags & MEMETER_3IDUMP) printf(fmt[l], res[ri]);
            ci += l;
            ++ri;
        }
        ifBLIN_QX3(" ans reg %u[%u]\n", pm, ci);
        rl = 0;
        switch (parm3[conf3[cmd].arr].fl & ITM) {
        case   0:
            rl = 4 * ri;
            break;
        case IT0:
            res[ri] = (il - ci) / parm3[conf3[cmd].arr].pm[pm];
            if  (cfg->flags & MEMETER_3IDUMP) {
                u_int32_t u;
                u_char *v;
                size_t l;

                l = parm3[conf3[cmd].arr].pm[pm];
                printf("\n>>3 ***** [%u]", res[ri]);
                if  ((il - ci) & (l - 1)) printf("+%u", (u_int32_t)((il - ci) & (l - 1)));
                v = &in[ci];
                for (u = 0; u < res[ri]; ++u, v += l) printf(fmt[l], memeter_load(v, l));
            }
            bcopy(&in[ci], &res[++ri], il - ci);
            ci = il;
            rl = 4 * ri + il - ci;
            ++pm;
            break;
        case ITE:
            if  (cfg->flags & MEMETER_3IDUMP) {
                u_int32_t u;
                u_char *v;
                size_t l;

                l = parm3[conf3[cmd].arr].pm[pm];
                if  (((il - ci) / l) == parm3[conf3[cmd].arr].mx) {
                    printf("\n>>3 ***** {%u}", (u_int32_t)((il - ci) / l));
                } else {
                    printf("\n>>3 ***** %u<%u>", parm3[conf3[cmd].arr].mx, (u_int32_t)((il - ci) / l));
                }
                if  ((il - ci) & (l - 1)) printf("+%u", (u_int32_t)((il - ci) & (l - 1)));
                v = &in[ci];
                for (u = 0; u < ((il - ci) / l); ++u, v += l) printf(fmt[l], memeter_load(v, l));
            }
            bcopy(&in[ci], &res[ri], il - ci);
            ci = il;
            rl = 4 * ri + il - ci;
            ++pm;
            break;
        case ITM: /*  ,    ,  1   XXXX */
            for (; parm3[conf3[cmd].arr].pm[pm] && (ci < il); ++pm) {
                size_t l;

                l = parm3[conf3[cmd].arr].pm[pm];
                res[ri] = memeter_load(&in[ci], l);
                if  (cfg->flags & MEMETER_3IDUMP) printf(fmt[l], res[ri]);
                ci += l;
                ++ri;
            }
            rl = 4 * ri;
            break;
        }
        ifBLIN_QX3(" ans arr %u[%u]->[%u](%u)\n", pm, ci, rl, ri);
        if  (ci > il) {
            ifBLIN_QX0("short cmd");
            errno = ENOSPC;
            free(res);
            res = NULL;
            goto out;
        }
        if  (parm3[conf3[cmd].arr].pm[pm] || ((int)rl > i)) {
            ifBLIN_QX0("internal error");
            errno = EDOOFUS;
            free(res);
            res = NULL;
            goto out;
    }   }
out:
    if  (cfg->flags & MEMETER_3IDUMP) printf("\n");
    free(out);
    out = NULL;
    free(in);
    in = NULL;
    ifBLIN_QX2("- %"BLIN_X"\n", BLIN_I(res));
    return(res);
}
