/*-
 * Copyright (C)2012 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2012 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: level2.c,v 1.5 2012/02/11 20:34:25 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <strings.h>
#include <termios.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mercumeter.h>

/*************************************************************************
 * 
 *************************************************************************/

static void
memeter_1setc(memeter_1pack *p) {
    size_t plen;

    plen = p->len;
    memeter_store(p->crc24, 3, memeter_crc24(p->src, MEMETER_UART_HLEN));
    p->p2[p->len] = memeter_csum1(p->p2, p->len);
}

int
memeter_2exchg(memeter_cfg *cfg, u_char *cmd, size_t ol, u_char *ans, size_t *il) {
    ifBLIN_FLAG = cfg->flags;
    memeter_1pack *p, *a;
    int ex = EX_OK;
    size_t plen;

    if  (cfg->flags & MEMETER_2ODUMP) memeter_dump(cmd, ol, "<<2 ===== ");
    plen = ol + sizeof(memeter_1pack);
    ifBLIN_QX2("+ %u\n", plen);
    if  (!(p = malloc(plen))) {
        errno = ENOMEM;
        ifBLIN_QW0("Malloc failed #1");
        ex = -EX_OSERR;
        goto out;
    }
    memeter_store(p->src, 2, cfg->from);
    memeter_store(p->dst, 2, cfg->to);
    p->len = ol;
    bcopy(cmd, p->p2, ol);
    memeter_1setc(p);
    a = memeter_1exchg(cfg, p);
    free(p);
    if  (!a) {
        ifBLIN_QW0("memeter_1exchg");
        ex = -EX_IOERR;
        goto out;
    }
    if  (a->len > *il) {
        ifBLIN_QW0("Short buffer");
        ex = a->len - *il;
    } else {
        *il = a->len;
    }
    bcopy(&a->p2, ans, *il);
    free(a);
out:
    if  (cfg->flags & MEMETER_2IDUMP) {
        if  (ex >= 0) {
            memeter_dump(ans, *il, ">>2 ===== ");
        } else {
            printf(" << transport absent\n");
    }   }
    ifBLIN_QX2("- %d %u\n", ex, *il);
    return(ex);
}
