/*-
 * Copyright (C)2012 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2012 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: level1.c,v 1.9 2012/02/29 07:00:34 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <strings.h>
#include <termios.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mercumeter.h>

/*************************************************************************
 * memeter_1exchg(cfg, out)  out   
 * 
 *************************************************************************/

void
memeter_1dump(memeter_cfg *cfg, memeter_1pack *p, const char *label) {
    u_int32_t t, r;
    size_t plen;

    plen = p->len;
    t = memeter_crc24(p->src, MEMETER_UART_HLEN);
    r = memeter_load(p->crc24, 3);
    printf( "%s%02X%02X%02X%s%08X"
          , label
          , p->crc24[0], p->crc24[1], p->crc24[2]
          , (r == t) ? "==" : "<>"
          , t
          )
    ;
    printf(" %04X=>%04X [%u]", memeter_load(p->src, 2), memeter_load(p->dst, 2), (u_int32_t)plen);
    t = memeter_csum1(p->p2, p->len);
    r = p->p2[p->len];
    if  (plen < 6) {
        size_t i;

        printf(" ");
        for (i = 0; i < plen; ++i) printf("%02X", p->p2[i]);
        printf(" %02X%s%02X\n", r, (r == t) ? "==" : "<>", t);
    } else {
        size_t i;

        printf(" %02X%s%02X", r, (r == t) ? "==" : "<>", t);
        for (i = 0; i < plen; ++i) {
            if  (!(i & 0x0F)) printf("\n%s%04X", label, (u_int32_t)i);
            if  (!(i & 0x01)) printf(" ");
            if  (!(i & 0x07)) printf(" ");
            printf("%02X", p->p2[i]);
        }
        printf("\n");
}   }

static int
memeter_1testc(memeter_1pack *p) {
    size_t plen;
    int ex = 0;

    plen = p->len;
    if  (memeter_load(p->crc24, 3) != memeter_crc24(p->src, MEMETER_UART_HLEN)) {
        ex = -1;
        errno = EPROTO;
        goto out;
    }
    if  (p->p2[p->len] != memeter_csum1(p->p2, p->len)) {
        ex = -1;
        errno = EPROTO;
        goto out;
    }
out:
    return(ex);
}

memeter_1pack *
memeter_1exchg(memeter_cfg *cfg, memeter_1pack *out) {
#   define INBUF 512 /* overkill XXXX */
    memeter_1pack *a = NULL;
    ifBLIN_FLAG = cfg->flags;
    size_t plen, alen;
    int ex = EX_OK;

    if  (cfg->flags & MEMETER_1ODUMP) memeter_1dump(cfg, out, "<<1 +++++ ");
    plen = out->len + sizeof(memeter_1pack);
    ifBLIN_QX2("+ %u %u\n", plen, out->len);
    alen = INBUF;
    if  (!(a = malloc(alen))) {
        errno = ENOMEM;
        ifBLIN_QW0("Malloc failed #1");
        ex = EX_OSERR;
        goto out;
    }
    if  ((ex = memeter_0exchg(cfg, (u_char*)out, plen, (u_char*)a, &alen))) goto out;
    if  (alen < sizeof(memeter_1pack)) {
        ifBLIN_QX0("Too short #0");
        errno = ENOSPC;
        ex = EX_IOERR;
        goto out;
    }
    plen = a->len + sizeof(memeter_1pack);
    if  (alen < plen) {
        ifBLIN_QX0("Too short #1");
        errno = ENOSPC;
        ex = EX_IOERR;
        goto out;
    }
    if  (memeter_1testc(a)) {
        ifBLIN_QW0("Checksum");
        errno = EINVAL;
        goto out;  /* May be conditional on flag XXXX */
    }
    if  (alen > plen) {
        ifBLIN_QW1("Too long");
    }
out:
    if  (ex) {
        free(a);
        a = NULL;
    }
    if  (cfg->flags & MEMETER_1IDUMP) {
        if  (a) {
            memeter_1dump(cfg, a, ">>1 +++++ ");
        } else {
            printf(" << answer absent\n");
    }   }
    ifBLIN_QX2("- %d %d\n", ex, a ? (int)a->len : -1);
    return(a);
}
