/*-
 * Copyright (C)2012 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2012 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: level0.c,v 1.12 2012/02/20 22:19:13 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <termios.h>
#include <sys/uio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <babolo/BLINflag.h>
#include <mercumeter.h>

/*************************************************************************
 * memeter_0exchg(cfg, out, ol, ans, il)  out[ol]   ans[*il]
 * 
 *************************************************************************/

static void
memeter_statinfo(memeter_cfg *cfg) {
    ifBLIN_QV4(cfg->flags) {
        struct termios term;
        size_t i;
        int state;

        if  (0 > (ioctl(cfg->line, TIOCGETA, &term))) {
            ifBLIN_QW0("TIOCGETA %s", cfg->linename);
        } else {
            printf( " i %08X o %08X c %08X l %08X ispeed %u ospeed %u\n"
                  , term.c_iflag
                  , term.c_oflag
                  , term.c_cflag
                  , term.c_lflag
                  , term.c_ispeed
                  , term.c_ospeed
                  )
            ;
            for (i = 0; i < NCCS; ++i) printf(" %02X", term.c_cc[i]);
            printf("\n");
            if  (0 > (ioctl(cfg->line, TIOCMGET, &state))) {
                ifBLIN_QW0("TIOCMGET %s", cfg->linename);
            } else {
                printf( "%08X %cLE %cDTR %cDSR %cRTS %cCTS %cST %cSR %cCD %cRI\n"
                      , state
                      , (state & TIOCM_LE ) ? '+' : '-'
                      , (state & TIOCM_DTR) ? '+' : '-'
                      , (state & TIOCM_DSR) ? '+' : '-'
                      , (state & TIOCM_RTS) ? '+' : '-'
                      , (state & TIOCM_CTS) ? '+' : '-'
                      , (state & TIOCM_ST ) ? '+' : '-'
                      , (state & TIOCM_SR ) ? '+' : '-'
                      , (state & TIOCM_CD ) ? '+' : '-'
                      , (state & TIOCM_RI ) ? '+' : '-'
                      )
                ;
}   }   }   }

static int
memeter_wt(memeter_cfg *cfg, int mode) {
    ifBLIN_FLAG = cfg->flags;
    int ex = EX_OK;
    int state;

    if  (0 > (state = fcntl(cfg->line, F_GETFL))) {
        ifBLIN_QW0("F_GETFL %s", cfg->linename);
        ex = EX_IOERR;
    } else if (0 > fcntl(cfg->line, F_SETFL, mode ? (state & ~O_NONBLOCK) : (state | O_NONBLOCK))) {
        ifBLIN_QW0("F_SETFL %s", cfg->linename);
        ex = EX_IOERR;
    }
    return(ex);
}

static int
memeter_0init(memeter_cfg *cfg) {
    ifBLIN_FLAG = cfg->flags;
    struct termios term;
    int ex = EX_OK;

    ifBLIN_QX2("+ %s\n", cfg->linename);
    if  (cfg->flags & MEMETER_0INIT) {
    } else if (0 > (cfg->line = open(cfg->linename, O_RDWR | O_EXLOCK | O_NONBLOCK))) {
        ifBLIN_QW0("open line %s", cfg->linename);
        ex = EX_IOERR;
    } else if (0 > (ioctl(cfg->line, TIOCGETA, &term))) {
        ifBLIN_QW0("TIOCGETA %s", cfg->linename);
        ex = EX_IOERR;
    } else {
        memeter_statinfo(cfg);
        term.c_iflag &= ~(IGNPAR | INPCK | ISTRIP | INLCR | IGNCR | ICRNL | IXON | IXOFF | IMAXBEL);
        term.c_oflag &= ~OPOST;
        term.c_cflag &= ~(CSIZE | PARENB | CRTS_IFLOW | CDTR_IFLOW | CDSR_OFLOW | CCAR_OFLOW | MDMBUF);
        term.c_cflag |= CS8 | CREAD | CLOCAL; /* | CCTS_OFLOW | CRTS_IFLOW; */
        term.c_lflag &= ~(ECHO | ECHOCTL | ISIG | ICANON | IEXTEN | TOSTOP);
        term.c_lflag |= NOKERNINFO;
        term.c_ispeed = cfg->baud;
        term.c_ospeed = cfg->baud;
        term.c_cc[VMIN] = 0;
        term.c_cc[VTIME] = cfg->wait;
        if  (0 > (ioctl(cfg->line, TIOCSETAW, &term))) {
            ifBLIN_QW0("TIOCSETAW %s", cfg->linename);
            ex = EX_IOERR;
        } else {
            cfg->flags |= MEMETER_0INIT;
    }   }
    memeter_statinfo(cfg);
    ifBLIN_QX2("- %d\n", ex);
    return(ex);
}

int
memeter_0exchg(memeter_cfg *cfg, u_char *o, size_t ol, u_char *ans, size_t *il) {
    ifBLIN_FLAG = cfg->flags;
    int ex = EX_OK;

    ifBLIN_QX2("+ %u\n", ol);
    if  ((ex = memeter_0init(cfg))) goto out;
    if  ((ex = memeter_wt(cfg, 0))) goto out;
    {   int r;

        do {
            ifBLIN_QX3("try read up to %u\n", *il);
            if  ((0 > (r = read(cfg->line, ans, *il))) && (errno != EAGAIN)) {
                ifBLIN_QW0("read #0");
                ex = EX_IOERR;
                goto out;
            }
            if  ((r > 0) && (cfg->flags & MEMETER_0IDUMP)) memeter_dump(ans, r, ">>0#----- ");
        } while ((r > 0) && ((size_t)r == *il));
        errno = 0;
    }
    if  (cfg->flags & MEMETER_0ODUMP) memeter_dump(o, ol, "<<0 ----- ");
    if  ((ex = memeter_wt(cfg, 1))) goto out;
    {   int w;

        ifBLIN_QX3("to write %u\n", ol);
        if  ((int)ol != (w = write(cfg->line, o, ol))) {
            if  (w < 0) {
                ifBLIN_QW0("write #1");
            } else {
                ifBLIN_QX0("write #2 %d != %u", w, ol);
                errno = EBADMSG;
            }
            ex = EX_IOERR;
            goto out;
        }
        ifBLIN_QX3(" wrote %u\n", w);
    }
    {   size_t ix;
        int q;

        for (ix = 0, q = 1;;) {
            int r;

            ifBLIN_QX3("to read up to %u\n", *il - ix);
            if  (0 > (r = read(cfg->line, ans + ix, *il - ix))) {
                if  (errno == EAGAIN) continue;
                ifBLIN_QW0("read #1");
                ex = EX_IOERR;
                goto out;
            }
            ix += r;
            ifBLIN_QX3(" reed %u\n", r);
            if  (!q && !r) break;
            q = r;
        }
        *il = ix;
        errno = 0;
    }
    if  (cfg->flags & MEMETER_0IDUMP) memeter_dump(ans, *il, ">>0 ----- ");
out:
    ifBLIN_QX2("- %d %u\n", ex, *il);
    return(ex);
}
