#!/bin/sh -e
# Copyright GD (C)2004
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: up.m4,v 1.5 2004/08/16 12:54:37 gd Exp $

genclass=verlihub
suffix=
inclass=verlihub
. ${JAILUP_CONF}
kind=`${dirname} "${0}"`
kind=`${basename} "${kind}"`
t=`${basename} "${0}"`
mysql=`/usr/bin/which mysql`
if  [ "${t}" != "${t#*-}" ]; then
    kind="${kind}/-${t#*-}"
fi

if  [ -z "${1}" ]; then
    ${cat} << EOF
# jailup ${kind} @BABOLO V.M 0.23  13-Nov-2003
#     Usage:
# jailup ${inclass} dir jailname jailaddr
#     where jailname - hostname for jail (see jail(2) hostname)
#           jailaddr - IP addr for jail (see jail(2) ip_number)
#           dir relative to ${JAILUPDIR} and ${JAILRODIR}
# installed /usr/ports/net/verlihub
#
# Note: Verlihub use MySQL as backend, but can connect only
#       via TCP socket and NOT via UNIX socket
EOF
    exit
fi
umask 022

jdir="${1}"
jailsname="${2}"
jailsaddr="${3}"
main_dir="${JAILUPDIR}/${jdir}"
conf_dir="${JAILRODIR}/${jdir}"

${mkdir} "${main_dir}" "${conf_dir}" "${conf_dir}/verlihub"
${up_mdir} "${main_dir}" ${MTREE}

${up_conf} "${conf_dir}/" /etc/ << EOF
resolv.conf
services
localtime
EOF

${up_data} "${main_dir}/usr/share/GeoIP/" /usr/local/share/GeoIP/ << "EOF"
    GeoIP.dat
EOF

${up_data} "${main_dir}/usr/share/zoneinfo/" /usr/share/zoneinfo/ << "EOF"
    posixrules
    GMT
EOF

${up_shlib} "${main_dir}/usr/lib" << "EOF"
    GeoIP c c_r crypt crypto m mysqlclient pcre ssl verlihub z
EOF

${up_libexe} "${main_dir}/usr/libexec" << EOF
    ld-elf.so.1
    verlihub
EOF

      #####################################
      ####                             ####
      #### Begin of etc fill           ####
      ####                             ####

read -p "Enter mysql host (where verlihub database located): " db_host
read -p "Enter verlihub database name: " db_data
read -p "Enter verlihub user for mysql: " db_user
read -p "Enter verlihub password for mysql: " db_pass

${up_ponf} "${conf_dir}/verlihub/dbconfig" << EOF
db_host= ${db_host}
db_data= ${db_data}
db_user= ${db_user}
db_pass= ${db_pass}
EOF

${up_mtree} "${main_dir}" ${MTREE}
${mtree} -Ueqxp "${conf_dir}" << "EOF"
/set type=file uname=root gname=wheel mode=0644 flags=none
.				type=dir mode=0755
    verlihub			type=dir mode=0755
	plugins			type=dir mode=0755
	..
    ..
    resolv.conf
    services
    localtime
..
EOF

      ####                             ####
      #### End of etc fill             ####
      ####                             ####
      #####################################

      #####################################
      ####                             ####
      ####  Begin of verlihub DB mod   ####
      ####                             ####
if [ ! -z "${mysql}" -a -x "${mysql}" ]
then
    exists_tables_list="`${mysql} -Bs \
	-h ${db_host} -u ${db_user} \
	-p${db_pass} -e 'SHOW TABLES' ${db_data}`"
    SL="0"
    bl="0"
    ft="0"
    kl="0"
    rl="0"
    tr="0"
    ul="0"
    for i in ${exists_tables_list}
    do
	if [ "${i}" = "SetupList" ]
	then
	    SL="1"
	elif [ "${i}" = "banlist" ]
	then
	    bl="1"
	elif [ "${i}" = "file_trigger" ]
	then
	    ft="1"
	elif [ "${i}" = "kicklist" ]
	then
	    kl="1"
	elif [ "${i}" = "reglist" ]
	then
	    rl="1"
	elif [ "${i}" = "temp_rights" ]
	then
	    tr="1"
	elif [ "${i}" = "unbanlist" ]
	then
	    ul="1"
	fi
    done
    if [ "${SL}" = "0" ]
    then
	echo "SetupList table not exists, creating..."
	cat ${UPLIBDIR}/${inclass}/SetupList | \
	    ${mysql} -Bs \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
	${mysql} -Bs \
		-e "UPDATE SetupList SET val = '${jailsname}' WHERE file = 'config' AND var = 'hub_host';" \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
	${mysql} -Bs \
		-e "UPDATE SetupList SET val = '${jailsaddr}' WHERE file = 'config' AND var = 'listen_ip';" \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
	${mysql} -Bs \
		-e "UPDATE SetupList SET val = '${jailsname}' WHERE file = 'config' AND var = 'redir_host0';" \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
    fi
    if [ "${bl}" = "0" ]
    then
	echo "banlist table not exists, creating..."
	cat ${UPLIBDIR}/${inclass}/banlist | \
	    ${mysql} -Bs \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
    fi
    if [ "${ft}" = "0" ]
    then
	echo "file_trigger table not exists, creating..."
	cat ${UPLIBDIR}/${inclass}/file_trigger | \
	    ${mysql} -Bs \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
    fi
    if [ "${kl}" = "0" ]
    then
	echo "kicklist table not exists, creating..."
	cat ${UPLIBDIR}/${inclass}/kicklist | \
	    ${mysql} -Bs \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
    fi
    if [ "${rl}" = "0" ]
    then
	echo "reglist table not exists, creating..."
	cat ${UPLIBDIR}/${inclass}/reglist | \
	    ${mysql} -Bs \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
	while [ -z "${m_nick}" ]
	do
	    read -p "Enter master nick: " m_nick
	done
	pass_length=`head -c 512 /dev/urandom | \
		tr -d '\012' | sed -e "s/[^7-9]//g" | \
		head -c 1`
	p_nick=`head -c 255 /dev/urandom | \
		tr -d '\012' | sed -e "s/[^[:alnum:]]//g" | \
		sed -e "s/[--]//g" | head -c ${pass_length}`
	${mysql} -Bs \
		-e "INSERT INTO reglist (
			reg_date,nick,class,login_pwd,pwd_change,pwd_crypt
		    ) VALUES (
			unix_timestamp(now()),'${m_nick}',10,encrypt('${p_nick}'),0,1
		    );" \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
	echo "Master nick: ${m_nick}"
        echo "Master password: ${p_nick}"
    fi
    if [ "${tr}" = "0" ]
    then
	echo "temp_rights table not exists, creating..."
	cat ${UPLIBDIR}/${inclass}/temp_rights | \
	    ${mysql} -Bs \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
    else
	echo "Table temp_rights already exists...OK"
    fi
    if [ "${ul}" = "0" ]
    then
	echo "unbanlist table not exists, creating..."
	cat ${UPLIBDIR}/${inclass}/unbanlist | \
	    ${mysql} -Bs \
		-h ${db_host} -u ${db_user} \
		-p${db_pass} ${db_data}
    fi
else
    echo "Can't find mysql client for test/init verlihub DB!
You must do it youself."
fi
      ####                             ####
      ####   End of verlihub DB mod    ####
      ####                             ####
      #####################################

${cat} << EOF >> "${genconfig}"
#${genclass}	${inclass}	${jdir}	${jailsname}	${jailsaddr}	0	0	0
EOF
      #####################################
      ####                             ####
      #### Begin of fstab mod          ####
      ####                             ####
${cat} << EOF >> "${etcdir}/fstab"
#${conf_dir}		${main_dir}/etc	null	ro,nodev,noexec	0 0
EOF
      ####                             ####
      #### End of fstab mod            ####
      ####                             ####
      #####################################
