SHEBANG
# Copyright @BABOLO (C)2002,2003
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: up.m4,v 1.2 2003/05/07 02:18:00 babolo Exp $

JNTROSTUP(tftpd,,dnl
,dnl
# jailup tftpd dir jailname jailaddr uid
#     where dir relative to ${jailupdir} and ${jailrodir}
# tftpd from base system useddnl
)

jdir="${1}"
jailsname="${2}"
jailsaddr="${3}"
juid="${4:-tftp}"
main_dir="${JAILUPDIR}/${jdir}"
conf_dir="${JAILRODIR}/${jdir}"

${mkdir} "${main_dir}" "${conf_dir}/etc" "${conf_dir}/boot"
${up_mdir} "${main_dir}" ${MTREE}

${up_data} "${conf_dir}" << "EOF"
    /etc/localtime
EOF

${up_conf} "${conf_dir}/etc/" /etc/ << "EOF"
    host.conf
    hosts
    resolv.conf
    protocols
EOF

${up_shlib} "${main_dir}/usr/lib" << "EOF"
    c crypt m util wrap
EOF

${up_libexe} "${main_dir}/usr/libexec" << EOF
    ld-elf.so.1
    tftpd
    xinetd
EOF

      #####################################
      ####                             ####
      #### Begin of etc fill           ####
      ####                             ####
${up_ponf} "${conf_dir}/xinetd" << "EOF"
defaults
{
	log_type	= SYSLOG daemon
	log_on_success	= PID HOST DURATION
	log_on_failure	= HOST
}

service	tftp
{
	type		= UNLISTED
	protocol	= udp
	socket_type	= dgram
	port		= 69
	wait		= yes
	user		= root
	group		= nogroup
	server		= /usr/libexec/tftpd
	server_args	= -lu ${juid} -s /boot /r /w
	only_from	= 127.0.0.1
}
EOF

${up_ponf} "${conf_dir}/group" << "EOF"
wheel:*:0:
tftp:*:600009:
nogroup:*:65533:
EOF

if  [ ! -e "${conf_dir}/etc/master.passwd" ]; then
    ${cat} << "EOF" > "${conf_dir}/etc/master.passwd"
root:*:0:0::0:0:root:/:/nonexistent
tftp:*:600009:600009::0:0:TFTP:/boot:/nonexistent
EOF
fi
      ####                             ####
      #### End of etc fill             ####
      ####                             ####
      #####################################

${mtree} -Ueqxp "${main_dir}" -f ${MTREE}
${mtree} -Ueqxp "${conf_dir}" << "EOF"
/set type=dir uname=root gname=wheel mode=0755 flags=none
.
    boot
    ..
    etc
/set type=file mode=0644
        host.conf
        hosts
        resolv.conf
        localtime
        protocols
        group
        xinetd
        master.passwd		mode=0600
    ..
..
EOF

${pwd_mkdb} -d "${conf_dir}/etc" -p "${conf_dir}/etc/master.passwd"

${cat} << EOF >> "${genconfig}"
#${genclass}	xinetd		${jdir}	${jailsname}	${jailsaddr}	0	0	0	xinetd
EOF

      #####################################
      ####                             ####
      #### Begin of fstab mod          ####
      ####                             ####
${cat} << EOF >> "${etcdir}/fstab"
#/null			${main_dir}/dev	null	ro,noexec	0 0
#${conf_dir}/etc	${main_dir}/etc	null	ro,nodev,noexec	0 0
#${conf_dir}/boot	${main_dir}/boot/r	null	ro,nodev,noexec	0 0
EOF
      ####                             ####
      #### End of fstab mod            ####
      ####                             ####
      #####################################
