SHEBANG
# Copyright @BABOLO (C)2002,2003
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: up-local.m4,v 1.2 2003/05/07 02:32:00 babolo Exp $

JNTROSTUP(inn,-local,inndnl
,dnl
# jailup inn-local dir jailname jailaddr [user [group [port]]]
#     where jailname - hostname for jail (see jail(2) hostname)
#           jailaddr - IP addr for jail (see jail(2) ip_number)
#           dir relative to ${JAILUPDIR} and ${JAILRODIR}
# installed ports/news/inn WITHOUT --with-perl
#                                                   useddnl
)

jdir="${1}"
jailsname="${2}"
jailsaddr="${3}"
user="${4:-news}"
group="${5:-news}"
port="${6:-119}"
main_dir="${JAILUPDIR}/${jdir}"
conf_dir="${JAILRODIR}/${jdir}"
dbdir="${main_dir}/var/db"

${mkdir} "${main_dir}" "${conf_dir}"
${up_mdir} "${main_dir}" ${MTREE}
ETCOPY(host.conf hosts protocols resolv.conf)
${up_shlib} "${main_dir}/usr/lib" << "EOF"
    c crypt crypto ssl
EOF

${up_libexe} "${main_dir}/usr/libexec" << EOF
    ld-elf.so.1
    /usr/local/news/bin/inndstart
    /usr/local/news/bin/innd
    /usr/local/news/bin/nnrpd
EOF

      #####################################
      ####                             ####
      #### Begin of etc fill           ####
      ####                             ####
${up_ponf} "${conf_dir}/group" << "EOF"
wheel:*:0:root
news:*:8:
nogroup:*:65533:
nobody:*:65534:
EOF

${up_ponf} "${conf_dir}/master.passwd" << "EOF"
root:*:0:0::0:0:Charlie &:/:/nonexistent
news:*:8:8::0:0:News Subsystem:/:/nonexistent
nobody:*:65534:65534::0:0:Unprivileged user:/nonexistent:/nonexistent
EOF

${sed} -e "s|%%HOST%%|${jailsname}|"\
       -e "s|%%PORT%%|${port}|" "${TEMPLATE}" | ${up_ponf} "${conf_dir}/inn.conf"
${cat} << EOF >> "${etcdir}/rc.local"
#${rm} -f /var/run/news
#${ln} -s "${main_dir}/var/run/news" /var/run/news
EOF

for i in incoming.conf readers.conf overview.fmt newsfeeds storage.conf; do
    ${sed} -e "s|%%HOST%%|${jailsname}|"\
           -e "s|%%PORT%%|${port}|" "${TEMPLATE}@${i}" | ${up_ponf} "${conf_dir}/${i}"
done

${up_conf} "${dbdir}/" "${TEMPLATE}:" << "EOF"
    active
    history.dir
    newsgroups
EOF

for i in active.times history history.hash history.index; do
    ${touch} "${dbdir}/${i}"
done
      ####                             ####
      #### End of etc fill             ####
      ####                             ####
      #####################################

${up_mtree} "${main_dir}" ${MTREE}
${mtree} -Ueqxp "${conf_dir}" << "EOF"
/set type=file uname=root gname=wheel mode=0644 flags=none
.				type=dir mode=0755
    group
    host.conf
    hosts
    localtime
    protocols
    resolv.conf
    master.passwd		mode=0600
    readers.conf		gname=news mode=640
    storage.conf		gname=news mode=640
    inn.conf
    overview.fmt
    newsfeeds
..
EOF

${pwd_mkdb} -d "${conf_dir}" -p "${conf_dir}/master.passwd"

${cat} << EOF >> "${genconfig}"
#${genclass}	${inclass}${suffix}	${jdir}	${jailsname}	${jailsaddr}	0	${user}	${group}
EOF

      #####################################
      ####                             ####
      #### Begin of fstab mod          ####
      ####                             ####
${cat} << EOF >> "${etcdir}/fstab"
#/null			${main_dir}/dev	null	ro,noexec	0 0
#${conf_dir}		${main_dir}/etc	null	ro,nodev,noexec	0 0
EOF
      ####                             ####
      #### End of fstab mod            ####
      ####                             ####
      #####################################
