#!/bin/sh -e
# Copyright GD (C)2004
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: up-smtpd.m4,v 1.2 2008/09/22 18:15:29 babolo Exp $

genclass=clamd
suffix=-smtpd
inclass=clamd-smtpd
. ${JAILUP_CONF}
kind=`${dirname} "${0}"`
kind=`${basename} "${kind}"`
t=`${basename} "${0}"`
if  [ "${t}" != "${t#*-}" ]; then
    kind="${kind}/-${t#*-}"
fi

if  [ -z "${1}" ]; then
    ${cat} << EOF
# jailup ${inclass} clamdir jailname jailaddr
#     where jailname - hostname for jail (see jail(2) hostname)
#           jailaddr - IP addr for jail (see jail(2) ip_number)
#           clamdir - clamd dir relative to ${JAILUPDIR} and ${JAILRODIR}
# installed ports/security/clamsmtpd used
EOF
    exit
fi
umask 022

this=${UPLIBDIR}/${genclass}
MTREE=${this}/mtree${suffix}
jdir="${1}"
jailsname="${2}"
jailsaddr="${3}"
main_dir="${JAILUPDIR}/${jdir}"
conf_dir="${JAILRODIR}/${jdir}"

${up_mdir} "${main_dir}" ${MTREE}

${up_shlib} "${main_dir}/usr/lib" << "EOF"
    c_r
EOF

${up_libexe} "${main_dir}/usr/libexec" << EOF
    ld-elf.so.1
    clamsmtpd
EOF

      #####################################
      ####                             ####
      #### Begin of etc fill           ####
      ####                             ####
${up_ponf} "${conf_dir}/clamsmtpd.conf" << EOF
OutAddress: ${jailsaddr}:10026
Listen: ${jailsaddr}:10025
ClamAddress: /var/run/clamd
Header: X-AV-Checked: ClamAV
TempDirectory: /tmp
Bounce: off
Quarantine: off
TransparentProxy: off
User: clamav
EOF
      ####                             ####
      #### End of etc fill             ####
      ####                             ####
      #####################################

${up_mtree} "${main_dir}" ${MTREE}
${mtree} -Ueqxp "${conf_dir}" << "EOF"
/set type=file uname=root gname=wheel mode=0644 flags=none
.				type=dir mode=0755
    clamsmtpd.conf
..
EOF

${cat} << EOF >> "${genconfig}"
#${genclass}	${inclass}	${jdir}	${jailsname}	${jailsaddr}	0	0	0
EOF
