#!/bin/sh -e
# Copyright GD (C)2004
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: up-fresh.m4,v 1.2 2008/09/22 18:15:29 babolo Exp $

genclass=clamd
suffix=-fresh
inclass=clamd-fresh
. ${JAILUP_CONF}
kind=`${dirname} "${0}"`
kind=`${basename} "${kind}"`
t=`${basename} "${0}"`
if  [ "${t}" != "${t#*-}" ]; then
    kind="${kind}/-${t#*-}"
fi

if  [ -z "${1}" ]; then
    ${cat} << EOF
# jailup ${inclass} dir jailname jailaddr [clamdirlist]
#     where jailname - hostname for jail (see jail(2) hostname)
#           jailaddr - IP addr for jail (see jail(2) ip_number)
#           dir - relative to ${JAILUPDIR} and ${JAILRODIR}
#           clamdir - clamd dir relative to ${JAILUPDIR} and ${JAILRODIR}
# installed ports/security/clamav used
EOF
    exit
fi
umask 022

this=${UPLIBDIR}/${genclass}
MTREE=${this}/mtree${suffix}
jdir="${1}"
jailsname="${2}"
jailsaddr="${3}"
main_dir="${JAILUPDIR}/${jdir}"
conf_dir="${JAILRODIR}/${jdir}"

${mkdir} "${main_dir}" "${conf_dir}"
${up_mdir} "${main_dir}" ${MTREE}

ETCOPY(resolv.conf localtime)

${up_ldsh} << EOF | ${up_shlib} "${main_dir}/usr/lib"
    /usr/local/bin/freshclam
EOF

${up_libexe} "${main_dir}/usr/libexec" << EOF
    ld-elf.so.1
    freshclam
EOF

${touch} "${main_dir}/var/log/freshclam"

      #####################################
      ####                             ####
      #### Begin of etc fill           ####
      ####                             ####
${up_ponf} "${conf_dir}/freshclam.conf" << EOF
DatabaseDirectory /usr/share
UpdateLogFile /var/log/freshclam
LogTime yes
LogVerbose yes
PidFile /var/run/freshclam.pid
DatabaseOwner clamav
DNSDatabaseInfo current.cvd.clamav.net
DatabaseMirror db.ru.clamav.net
DatabaseMirror database.clamav.net
CompressLocalDatabase no
Checks 48
EOF

${up_ponf} "${conf_dir}/group" << "EOF"
wheel:*:0:root
clamav:*:3310:
EOF

${up_ponf} "${conf_dir}/master.passwd" << "EOF"
root:*:0:0::0:0:Charlie &:/:/nonexistent
clamav:*:3310:3310::0:0:Clam AV:/:/nonexistent
EOF

${cat} << EOF >> "${etcdir}/newsyslog.conf"
#${main_dir}/var/log/freshclam		644  9     *	@T00  Z ${main_dir}/var/run/freshclam.pid
EOF
      ####                             ####
      #### End of etc fill             ####
      ####                             ####
      #####################################

${up_mtree} "${main_dir}" ${MTREE}
${mtree} -Ueqxp "${conf_dir}" << "EOF"
/set type=file uname=root gname=wheel mode=0644 flags=none
.				type=dir mode=0755
    freshclam.conf
    group
    master.passwd		mode=0600
    resolv.conf
    localtime
..
EOF

${pwd_mkdb} -d "${conf_dir}" -p "${conf_dir}/master.passwd"

${cat} << EOF >> "${genconfig}"
#${genclass}	${inclass}	${jdir}	${jailsname}	${jailsaddr}	0	0	0
EOF
      #####################################
      ####                             ####
      #### Begin of fstab mod          ####
      ####                             ####
${cat} << EOF >> "${etcdir}/fstab"
#/null			${main_dir}/dev	null	ro,noexec	0 0
#${conf_dir}		${main_dir}/etc	null	ro,nodev,noexec	0 0
EOF

shift 3

for i in "${@}"
do
    if [ -d "${JAILUPDIR}/${i}/usr/share" ]
    then
	${cat} << EOF >> "${etcdir}/fstab"
#${main_dir}/usr/share		${JAILUPDIR}/${i}/usr/share	null	ro,nodev,noexec	0 0
EOF
    fi
done
      ####                             ####
      #### End of fstab mod            ####
      ####                             ####
      #####################################
