/*-
 * Copyright (C) @BABOLO  2003 Jan 15
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2003 Jan 15\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: jailupctl.c,v 1.1 2003/04/26 21:13:48 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sysexits.h>
#include <sys/uio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <syslog.h>
#include <stdarg.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <err.h>

#define SHELL "/bin/sh"

#ifdef PREFIX
#   define JAILUPRC PREFIX"/etc/jailup.rc"
#   define STARTUPDIR PREFIX"/etc/jailup"
#endif

#define MAXRCLEN 0x7FFFFFFE
#define todo     (argv[0])
#define genclass (argv[1])
#define dirjail  (argv[2])
#define jrabl 001   /* entry not disabled (first space in line */
#define jrsto 002   /* execute stop                            */
#define jrsta 004   /* execute start                           */
#define jrtrm 010   /* execute restop                          */
#define jrest 020   /* execute restart                         */

#define NAMELENMAX 128
char *prefix, *startupdir, *jailuprc;
char exclusives[][NAMELENMAX] = {"syslogd", "named", NULL};
int flag_v = 0;
char *rc;
struct sparced
{   char *gencl;  /* genclass               */
    char *incl;   /* inclass                */
    char *dirj;   /* directory              */
    char *tail;   /* hostname, IPaddr so on */
    char mode;
} sparced;

int exclude(char *name)
{   int i;
    for (i = 0; exclusives[i] && exclusives[i][0]; i++)
        if  (0 == strncmp(name, exclusives[i], NAMELENMAX)) return(i + 1);
    return(0);
}

/*
 * exec ${STARTUPDIR}/<tofun>/<class> <chdir> hostname IPaddr uid gid ...
 *                                           |<tail>
 */
unsigned
exup(char *tofun, char *class, char *chdir, char *tail) {
    char *parm;
    pid_t p;
    int st;

    if  (flag_v > 1) fprintf(stderr, "Exup: ");
    if  (0 > asprintf(&parm, "%s/%s/%s", startupdir, tofun, class))             err(EX_TEMPFAIL, NULL);
    if  (0 > access(parm, X_OK))                                             err(EX_UNAVAILABLE, NULL);
    free(parm);
    if  (0 > asprintf(&parm, "exec %s/%s/%s %s %s", startupdir, tofun, class, chdir, tail))
                                                                                err(EX_TEMPFAIL, NULL);
    if  (flag_v) fprintf(stderr, "%s\n", parm);
    switch (p = fork()) {
    case -1:                                                                       err(EX_OSERR, NULL);
    case 0:
/*
 *      if  (0 > daemon(0,1))                                                      err(EX_OSERR, NULL);
 */
        execl(SHELL, "sh", "-c", parm, (char *)NULL);
        syslog(LOG_ERR | LOG_DAEMON, "No %s/%s up: %m", tofun, class);
        _exit(EX_OSERR);
    default:
        if  (!strcmp(tofun, "restart")) {
            if  (0 > waitpid(p, &st, 0)) {
                syslog( LOG_ERR | LOG_DAEMON, "%s:%s/%s %s %s"
                      , strerror(errno), tofun, class, chdir, tail
                      );
            }
            if  (!WIFEXITED(st)) return(jrsta);
            if  (WEXITSTATUS(st) != 0) return(jrsta);
        } else if  (!strcmp(tofun, "restop")) {
            if  (0 > waitpid(p, &st, 0)) {
                syslog( LOG_ERR | LOG_DAEMON, "%s:%s/%s %s %s"
                      , strerror(errno), tofun, class, chdir, tail
                      );
    }   }   }
    free(parm);
    return(0);
}

void usage(int ex, char *jailuprc, char *startupdir)
{   int c;

    fprintf( stderr
           , "jailupctl @BABOLO V.M "VERS"  "DATE"\n"
             "   Usage:\n"
             "jailupctl [-v[v[v]]] {start|restart|stop} [genclass [dirjail]]\n"
             "   -v verbose\n"
             "   reads %s string by string\n"
             "   and starts daemons %s/{start|restart|stop}/{inclass} in {dirjail}\n"
             "   PREFIX, JAILUPRC, STARTUPDIR environment variables used\n"
             "   JAILUPRC file must be not longer then %d bytes\n"
             "Exclusives:\n"
           , jailuprc
           , startupdir
           , MAXRCLEN
           );
    for (c = 0; exclusives[c] && exclusives[c][0]; c++)
        fprintf(stderr, "    %d %s\n", c + 1, exclusives[c]);
    exit(ex);
}

char *next(char *in, char *end, struct sparced *sped)
{   unsigned ctl = 0;
    int c, i, j;
    enum {inii, lkgn, dogn, lkin, doin, lkdj, dodj, lktl, dotl, skip, purg, done} state;
         /****************************
          * inii - begin of a string *
          * lkgn - look for genclass *
          * dogn - genclass found    *
          * lkin - look for inclass  *
          * doin - inclass found     *
          * lkdj - look for dirjail  *
          * dodj - dirjail found     *
          * lktl - look for tail     *
          * dotl - tail found        *
          * skip - skip comment      *
          * purg - purge string      *
          * done - just the end      *
          ****************************/
    enum symclass {snl, ssp, slt, scm, sxx};
                 /**********************
                  * snl - new line     *
                  * ssp - white space  *
                  * slt - some symbol  *
                  * scm - comment      *
                  * sxx - symclass end *
                  **********************/
    unsigned char chtab[257] = { snl
        /* 0    1    2    3     4    5    6    7     8    9    A    B     C    D    E    F */
  /*0*/ , snl, slt, slt, slt,  slt, slt, slt, slt,  slt, ssp, snl, slt,  slt, snl, slt, slt
  /*1*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*2*/ , ssp, slt, slt, scm,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*3*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*4*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*5*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*6*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*7*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*8*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*9*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*A*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*B*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*C*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*D*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*E*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
  /*F*/ , slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt,  slt, slt, slt, slt
        };
#   define retu 0000400
#   define popl 0001000
#   define nlfy 0002000
#   define togn 0004000
#   define toin 0010000
#   define todj 0020000
#   define totl 0040000
#   define foff 0100000
#   define fonn 0200000
#   define inil 0400000
    unsigned control[done][sxx] =
        /*               snl                  ssp                         slt                  scm*/
/*inii*/{        popl |  inii,  foff | popl | lkgn,  fonn | togn | popl | dogn,  inil | popl | purg
/*lkgn*/, inil | popl |  inii,         popl | lkgn,         togn | popl | dogn,  inil | popl | purg
/*dogn*/, inil | popl |  inii,  nlfy | popl | lkin,                popl | dogn,  inil | popl | purg
/*lkin*/, inil | popl |  inii,         popl | lkin,         toin | popl | doin,  inil | popl | purg
/*doin*/, inil | popl |  inii,  nlfy | popl | lkdj,                popl | doin,  inil | popl | purg
/*lkdj*/, inil | popl |  inii,         popl | lkdj,         todj | popl | dodj,  inil | popl | purg
/*dodj*/, nlfy | popl | retu ,  nlfy | popl | lktl,                popl | dodj,  nlfy | popl | skip
/*lktl*/,        popl | retu ,         popl | lktl,         totl | popl | dotl,         popl | skip
/*dotl*/, nlfy | popl | retu ,         popl | dotl,                popl | dotl,         popl | dotl
/*skip*/,        popl | retu ,         popl | skip,                popl | skip,         popl | skip
/*purg*/,        popl |  inii,         popl | purg,                popl | purg,         popl | purg
        };
    {sped->tail = NULL; sped->incl = NULL; sped->gencl = NULL;};
    for (state = inii; (ctl & retu) == 0; state = ctl & 0xFF)
    {   c = (in < end) ? *in & 0xFF : -1;
        ctl = control[state][chtab[c + 1]];
        if  (flag_v > 2)
            fprintf( stderr, "s%d, c%02X(%d), ctl %08o in=%08X\n"
                   , state, c, chtab[c + 1], ctl, (unsigned)in
                   );
        if  (ctl & inil) {sped->tail = NULL; sped->incl = NULL; sped->gencl = NULL;};
        if  (ctl & fonn) sped->mode = jrabl;
        if  (ctl & foff) sped->mode = 0;
        if  (ctl & totl) sped->tail = in;
        if  (ctl & todj) sped->dirj = in;
        if  (ctl & toin) sped->incl = in;
        if  (ctl & togn) sped->gencl = in;
        if  (ctl & nlfy) *in = '\0';
        if  (ctl & popl) in++;
        if  (c < 0) break;
    };
    return(in);
}

int main(int argc, char **argv, char **envp)
{   int rcfile, c;
    char *in, *p;
    unsigned doma;
    struct stat sb;

    prefix = getenv("PREFIX");
    jailuprc = getenv("JAILUPRC");
    startupdir = getenv("STARTUPDIR");
#ifdef PREFIX
    if  (NULL == prefix) prefix = PREFIX;
#endif
#ifdef JAILUPRC
    if  (NULL == jailuprc) jailuprc = JAILUPRC;
#else
    if  (  NULL == jailuprc
        && NULL != prefix
        && 0 > asprintf(&jailuprc, "%s/etc/jailup.rc", prefix)
        )                                                                       err(EX_TEMPFAIL, NULL);
#endif
#ifdef STARTUPDIR
    if  (NULL == startupdir) startupdir = STARTUPDIR;
#else
    if  (  NULL == startupdir
        && NULL != prefix
        && 0 > asprintf(&startupdir, "%s/etc/jailup", prefix)
        )                                                                       err(EX_TEMPFAIL, NULL);
#endif
    while((c = getopt(argc, argv, "vh?")) > 0)
    {   switch(c)
        {case 'v': flag_v++;                 break;
         case 'h': usage(EX_OK, jailuprc, startupdir);
         default: usage(EX_USAGE, jailuprc, startupdir);
    }   };
    argc -= optind;
    argv += optind;

    if  (NULL == jailuprc || NULL == startupdir || argc < 1 || argc > 3)
                                                                 usage(EX_USAGE, jailuprc, startupdir);
    if  (flag_v) fprintf( stderr, "PREFIX=%s\nJAILUPRC=%s\nSTARTUPDIR=%s\n"
                        , prefix, jailuprc, startupdir
                        );
    if  (flag_v > 1)
    {   fprintf(stderr, "Exclusives:\n");
        for (c = 0; exclusives[c] && exclusives[c][0]; c++)
            fprintf(stderr, "    %d %s\n", c + 1, exclusives[c]);
    }
    doma = 0;
    if  (0 == strcmp(todo, "start"  )) doma = jrsta;
    if  (0 == strcmp(todo, "stop"   )) doma = jrsto;
    if  (0 == strcmp(todo, "restart")) doma = jrsto | jrsta;
    if  (0 == strcmp(todo, "restop" )) doma = jrtrm;
    if  (flag_v) fprintf( stderr, "Todo %s %03o\n", todo, doma);
    if  (doma == 0)                                              usage(EX_USAGE, jailuprc, startupdir);
    /* Environment and arguments parse ready */

    if  (0 > (rcfile = open(jailuprc, O_RDONLY | O_EXLOCK)))                     err(EX_NOINPUT, NULL);
    if  (0 > fstat(rcfile, &sb))                                                 err(EX_NOINPUT, NULL);
    if  (sb.st_size > MAXRCLEN)                                              err(EX_UNAVAILABLE, NULL);
#ifdef READ_INSTEAD
    if  (NULL == (in = malloc(sb.st_size + 1)))                              err(EX_UNAVAILABLE, NULL);
    /*            VXXXXXXXXV        */
    if  (sb.st_size != read(rcfile, in, sb.st_size))                               err(EX_IOERR, NULL);
#else
    if  (MAP_FAILED == (in = mmap( NULL, sb.st_size + 1
                                 , PROT_READ | PROT_WRITE, MAP_PRIVATE
                                 , rcfile, (off_t)0
        )              )         )                                                 err(EX_IOERR, NULL);
#endif
    close(rcfile);
    for (p = in; p < in + sb.st_size;)
    {   p = next(p, in + sb.st_size, &sparced);
        if  (NULL == sparced.gencl) break;
        if  (flag_v)
            fprintf( stderr, "%s genclass=%s, inclass=%s, dirjail=%s, tail=%s\n"
                   , sparced.mode ? "On " : "Off"
                   , sparced.gencl, sparced.incl, sparced.dirj, sparced.tail
                   );
        if  (flag_v > 1)
        {   fprintf(stderr, "    Argc=%d, exclude=%d", argc, exclude(sparced.gencl));
            if  (argc > 1) fprintf(stderr, " genclass(%s==%s)=%s"
                                  , sparced.gencl, genclass
                                  , strcmp(sparced.gencl, genclass) ? "No " : "Yes"
                                  );
            if  (argc > 2) fprintf(stderr, " dirjail(%s==%s)=%s"
                                  , sparced.dirj, dirjail
                                  , strcmp(sparced.dirj, dirjail) ? "No " : "Yes"
                                  );
            fprintf(stderr, "\n");
        }

        if  (  (argc == 1 && !exclude(sparced.gencl))
            || (argc == 2 && 0 == strcmp(sparced.gencl, genclass))
            || (  argc == 3
               && 0 == strcmp(sparced.gencl, genclass)
               && 0 == strcmp(sparced.dirj, dirjail)
            )  )
        {   unsigned dodoma;
            char *path;
            unsigned char docod[] =
            /*           -,                     stop,    start,               stop|start */
            {     0,     0,       jrsto,       jrsto, 0, jrsta,       jrsto,       jrest
            , jrtrm, jrtrm, jrsto|jrtrm, jrsto|jrtrm, 0,     0, jrsto|jrtrm, jrsto|jrtrm
            };

            dodoma = docod[doma | sparced.mode];
            if  (0 > asprintf(&path, "%s/%s/%s", startupdir, todo, sparced.incl))
                                                                                err(EX_TEMPFAIL, NULL);
            if  (dodoma & jrest && (0 > access(path, X_OK))) dodoma = jrsto | jrsta;
            free(path);
            if  (0 > asprintf(&path, "%s/%s/%s", startupdir, "restop", sparced.incl))
                                                                                err(EX_TEMPFAIL, NULL);
            if  (dodoma & jrtrm && (0 > access(path, X_OK))) dodoma &= ~jrtrm;
            free(path);
            if  (flag_v > 1) fprintf(stderr, "Todo %03o\n", dodoma);
            if  (dodoma & jrsto)           exup("stop"   , sparced.incl, sparced.dirj, sparced.tail);
            if  (dodoma & jrtrm)           exup("restop" , sparced.incl, sparced.dirj, sparced.tail);
            if  (dodoma & jrest) dodoma |= exup("restart", sparced.incl, sparced.dirj, sparced.tail);
            if  (dodoma & jrsta)           exup("start"  , sparced.incl, sparced.dirj, sparced.tail);
    }   }
    return(EX_OK);
}
