SHEBANG
# Copyright @BABOLO (C)2002,2003
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: up.m4,v 1.1 2004/12/01 11:36:10 gd Exp $

JNTROSTUP(syslog,,syslogdnl
,dnl
# jailup syslog dir jailname jailaddr
#     where jailname - hostname for jail (see jail(2) hostname)
#           jailaddr - IP addr for jail (see jail(2) ip_number)
#           dir relative to ${JAILUPDIR} and ${JAILRODIR}
# system /usr/sbin/syslogd
#                                                   useddnl
)

jdir="${1}"
jailsname="${2}"
jailsaddr="${3}"
main_dir="${JAILUPDIR}/${jdir}"
conf_dir="${JAILRODIR}/${jdir}"

${mkdir} "${main_dir}" "${conf_dir}"
${up_mdir} "${main_dir}" ${MTREE}

echo "localtime" |  ${up_data} "${conf_dir}/" /etc/

${up_shlib} "${main_dir}/usr/lib" << "EOF"
    c util
EOF

${up_libexe} "${main_dir}/usr/libexec" << EOF
    ld-elf.so.1
    /usr/sbin/syslogd
EOF

${touch} "${main_dir}/var/log/messages"

      #####################################
      ####                             ####
      #### Begin of etc fill           ####
      ####                             ####
if [ ! -e "${conf_dir}/syslog.conf" ]
then
    ${up_ponf} "${conf_dir}/syslog.conf" << "EOF"
#*.*	/var/log/messages
EOF
fi

if  [ ! -e "${conf_dir}/group" ]; then
    ${cat} << "EOF" > "${conf_dir}/group"
wheel:*:0:
nogroup:*:65533:
nobody:*:65534:
EOF
fi

if  [ ! -e "${conf_dir}/master.template" ]; then
    ${cat} << "EOF" > "${conf_dir}/master.template"
root:*:0:0::0:0:Charlie &:/:/nonexistent
nobody:*:65534:65534::0:0:Unprivileged user:/nonexistent:/nonexistent
EOF
fi

if  [ ! -e "${conf_dir}/master.passwd" ]; then
    ${cp} -p "${conf_dir}/master.template" "${conf_dir}/master.passwd"
fi
      ####                             ####
      #### End of etc fill             ####
      ####                             ####
      #####################################

${mtree} -Ueqxp "${main_dir}" -f ${MTREE}
${mtree} -Ueqxp "${conf_dir}" << "EOF"
/set type=file uname=root gname=wheel mode=0644 flags=none
.			type=dir mode=0755
    group
    localtime
    master.passwd		mode=0600
    syslog.conf
..
EOF
${pwd_mkdb} -d "${conf_dir}" -p "${conf_dir}/master.passwd"

${cat} << EOF >> "${genconfig}"
#${genclass}	syslog	${jdir}	${jailsname}	${jailsaddr}	0	0	0
EOF
      #####################################
      ####                             ####
      #### Begin of fstab mod          ####
      ####                             ####
${cat} << EOF >> "${etcdir}/fstab"
#${conf_dir}		${main_dir}/etc	null	ro,nodev,noexec	0 0
EOF
      ####                             ####
      #### End of fstab mod            ####
      ####                             ####
      #####################################
