/*-
 * Copyright @BABOLO (C)2002,2003
 * All rights reserved.
 * Based on:
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <phk@FreeBSD.ORG> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.   Poul-Henning Kamp
 * ----------------------------------------------------------------------------
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright @BABOLO (C)2002,2003\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: jail.c,v 1.2 2004/08/16 04:21:20 babolo Exp $";
#endif /* not lint */

#include <sys/time.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <netinet/in.h>
#include <login_cap.h>
#include <sys/jail.h>
#include <sysexits.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <pwd.h>
#include <grp.h>

#define J_PATH argv[0]
#define J_HOSTNAME argv[1]
#define J_HOSTADDR argv[2]
#define J_EXEC_N 3
#define J_EXEC argv[J_EXEC_N]
#define	DEFNICE	INT_MIN

void
usage(int ex) {
    fprintf( stderr
           , "%s @BABOLO V.M "VERS"  "DATE" from jailup(8) package\n"
             "Usage:\n"
             "%s [-l ][-u user ][-g group ][-n nice ][-p pidfile ]...[-P pidfile ] path hostname ip-number command \n"
             "   -l for use login classes database in jailed environment for setusercontext()\n"
             "   -p write pid to pidfile before jailed, repetitive\n"
             "   -P write pid to pidfile after jailed, only last -P used\n"
           , getprogname()
           , getprogname()
           );
    exit(ex);
}

int
main(int argc, char **argv) {
    struct jail j;
    int i, login = 0;
    struct in_addr in;
    uid_t chuser;
    gid_t gidset[NGROUPS], chgrp, tgrp;
    int uset = 0, gset = 0, gnumset = 0;
    char *end;
    struct passwd *chuserp = NULL;
    struct group *chgrpp = NULL;
    long niceness = DEFNICE;
    char *ep;
    login_cap_t *lc;
    FILE *pid;
    char *pidfl = NULL;

    while ((i = getopt(argc, argv, "g:ln:p:P:u:?")) != -1) {
        switch (i) {
        case 'g':
            if  ((chgrpp = getgrnam(optarg)) == NULL) {
                /* Try if group is by number, not by name */
                tgrp = (gid_t)strtol(optarg, &end, 10);
                if (*end)                                errx(EX_DATAERR, "%s: no such group", optarg);
            } else {
                tgrp = chgrpp->gr_gid;
            }
            if  (gset) {
                if  (gnumset >= NGROUPS)             errx(EX_NOUSER, "group number > %d", NGROUPS + 1);
                gidset[gnumset++] = tgrp;
            } else {
                chgrp = tgrp;
                gset = 1;
            }
            break;
        case 'l':
            login = 1;
            break;
        case 'n':
            errno = 0;
            niceness = strtol(optarg, &ep, 10);
            if  (ep == optarg || *ep != '\0' || errno ||
                niceness < INT_MIN || niceness > INT_MAX)
                                                    errx(EX_DATAERR, "%s: invalid nice value", optarg);
            break;
        case 'p':
            pid = fopen(optarg, "w");
            if  (!pid)                                            err(EX_CANTCREAT, "file %s", optarg);
            fprintf(pid, "%d\n", getpid());
            fclose(pid);
            break;
        case 'P':
            pidfl = optarg;
            break;
        case 'u':
            if  ((chuserp = getpwnam(optarg)) == NULL) {
                /* Try if user is by number, not by name */
                chuser = (uid_t)strtol(optarg, &end, 10);
                if  (*end)                                 errx(EX_NOUSER, "%s: no such user", optarg);
            } else {
                chuser = chuserp->pw_uid;
            }
            uset = 1;
            break;
        case '?':
            usage(EX_OK);
        default:
            usage(EX_USAGE);
    }   }

    argc -= optind;
    if  (argc < 4)                                                                     usage(EX_USAGE);
    argv += optind;
    if  (chdir(J_PATH))                                        err(EX_UNAVAILABLE, "chdir %s", J_PATH);
    memset(&j, 0, sizeof(j));
    j.version = 0;
    j.path = J_PATH;
    j.hostname = J_HOSTNAME;
    if  (!inet_aton(J_HOSTADDR, &in))            errx(EX_NOHOST, "Couldn't make sense of ip-number\n");
    j.ip_number = ntohl(in.s_addr);
    if  (jail(&j))                                             err(EX_SOFTWARE, "Imprisonment failed");
    if  (gset) {
        setgid(chgrp);
        if  (setgroups(gnumset, gidset) == -1)              err(EX_NOUSER, "group access list failed");
    }
    errno = 0;
    if  (niceness != INT_MIN && setpriority(PRIO_PROCESS, 0, (int)niceness))       warn("setpriority");
    if  (login) {
        unsigned int ufl = LOGIN_SETALL;
        if  (setsid() == -1) err(1, "New session failed");
        if  (!gset) ufl &= ~LOGIN_SETGROUP;
        if  (!uset) ufl &= ~LOGIN_SETUSER;
        if  (niceness == INT_MIN) ufl &= ~LOGIN_SETPRIORITY;
        chuserp = getpwuid(uset ? chuser : 0);
        lc = login_getpwclass(chuserp);
        if  (setusercontext(lc, chuserp, chuserp->pw_uid, ufl) < 0) err(EX_SOFTWARE, "setusercontext");
    } else if (uset) setuid(chuser);
    if  (pidfl) {
        pid = fopen(pidfl, "w");
        if  (!pid)                                                 err(EX_CANTCREAT, "file %s", pidfl);
        fprintf(pid, "%d\n", getpid());
        fclose(pid);
    }
    if  (execv(J_EXEC, argv + J_EXEC_N))                      err(EX_UNAVAILABLE, "execv(%s)", J_EXEC);
    exit(0);
}
