SHEBANG
# Copyright @BABOLO (C)2002,2003
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: addon.m4,v 1.1 2003/05/02 21:18:15 babolo Exp $

JNTROSTUP(,,,dnl
# jailup devnull <dirlist>
#     !!! where UNLIKE others jailups dirlist is absolute !!!
# This command does not establish any jail at all, it just
# prepare some directories with devices to export into jails
# All other jailups assume that /null holds minimum device set
# Use "jailup devnull /null" for this)

umask 022
for i in "$@"; do
    ${mkdir} "${i}"
    ${rm} -f "${i}/random";  ${mknod} "${i}/random"	c 2 3
    ${rm} -f "${i}/urandom"; ${mknod} "${i}/urandom"	c 2 4
    ${rm} -f "${i}/null";    ${mknod} "${i}/null"  	c 2 2
    ${rm} -f "${i}/zero";    ${mknod} "${i}/zero"  	c 2 12
    ${rm} -f "${i}/stdin";   ${mknod} "${i}/stdin" 	c 22 0
    ${rm} -f "${i}/stdout";  ${mknod} "${i}/stdout"	c 22 1
    ${rm} -f "${i}/stderr";  ${mknod} "${i}/stderr"	c 22 2
    ${mtree} -Ueqxp "${i}" << "EOF"
/set type=char uname=root gname=wheel mode=0644 flags=none
.		type=dir mode=0755
    random
    urandom
/set mode=0666
    null
    zero
    stdin
    stdout
    stderr
/set type=link mode=0700 link=null
    console
    kmem
    mem
..
EOF
done
