# Copyright (C) @BABOLO  2003 Jan 15
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: jailup.make,v 1.4 2006/08/25 13:04:09 babolo Exp $

BASE		= jailup
GENCLASS	?= ${MODULE}
REQUIRED	+= babolo-libmake:0.13

PREFIX		?= /usr/local
LIBINCLUDEDIR	?= ${PREFIX}/include/babolo
BINOVER		?= ${PREFIX}/libexec/${BASE}/${MODULE}${SUBMODULE}
.include <${LIBINCLUDEDIR}/define.make>
STARTUPDIR	?= ${CONFDIR}/jailup
SCRIPTFILTER	+= -e 's|%%DATE%%|${DATE}|g' -e 's|%%VERS%%|${VERS}|g'

postinstall:
.if defined(MODULE)
. for I in start restart stop restop
	${MKDIR} -p ${STARTUPDIR}/${I}
.  for J in ${GENCLASS}
.   for K in ${CLASS}
	if [ -e ${I}${K} ]; then\
		${INSTALL_SCRIPT} ${I}${K} ${STARTUPDIR}/${I}/${J}${K};\
	elif [ -e ${I} ]; then\
		${INSTALL_SCRIPT}  ${I} ${STARTUPDIR}/${I}/${J}${K};\
	fi
.   endfor
.  endfor
. endfor
.endif

.include <${LIBINCLUDEDIR}/common.make>
