dnl Copyright (C) @BABOLO  2003 Jan 15
dnl All rights reserved.
dnl
dnl Redistribution and use in source and binary forms, with or without
dnl modification, are permitted provided that the following conditions
dnl are met:
dnl 1. Redistributions of source code must retain the above copyright
dnl    notice, this list of conditions and the following disclaimer.
dnl 2. Redistributions in binary form must reproduce the above copyright
dnl    notice, this list of conditions and the following disclaimer in the
dnl    documentation and/or other materials provided with the distribution.
dnl
dnl THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
dnl ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
dnl IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
dnl ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
dnl FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
dnl DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
dnl OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
dnl HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
dnl LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
dnl OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
dnl SUCH DAMAGE.
dnl
dnl $Id: def.m4,v 1.6 2006/08/25 12:15:51 babolo Exp $
dnl
dnl ############################################
dnl SHBANG
dnl ############################################
define(SHBANG,#!/bin/sh)dnl
dnl
dnl ############################################
dnl SHEBANG
dnl ############################################
define(SHEBANG,SHBANG -e)dnl
dnl
dnl ############################################
dnl JNTROST
dnl ############################################
define(JNTROSTPARM,dnl
ifelse($2, , ,
$2="${$1}"dnl
JNTROSTPARM(incr($1), shift(shift($@)))dnl
))dnl
dnl --------------------------------------------
define(JNTROST,dnl
inclass=$1
lclass=$1
. ${JAILUP_CONF}dnl
JNTROSTPARM(1, shift($@))dnl
)dnl
dnl
dnl ############################################
dnl JNTROSTA
dnl ############################################
define(JNTROSTA,dnl
JNTROST($@)
if [ -r "${JAILUPDIR}/${path}/etc/login.conf" ]; then fl='-ln'; else fl='-n'; fidnl
)dnl
dnl
dnl ############################################
dnl DEFPID
dnl ############################################
define(DEFPID,dnl
pidfi=${JAILUPDIR}/${path}/var/run/${ifelse($1,,lclass,$1)}.pid
pidnum=`${head} -1 ${pidfi}` || ${true}dnl
)dnl
dnl
dnl ############################################
dnl DEFDOG
dnl ############################################
define(DEFDOG,dogfi=`${jun_ctl} dogfi "${ifelse($1,,lclass,$1)}" "${path}"`)dnl
dnl
dnl ############################################
dnl KILLPID
dnl ############################################
define(KILLPID,[ -n "${pidnum}" -a -f ${pidfi} ] && ${kill} ifelse($1,,,-$1 )${pidnum})dnl
dnl
dnl ############################################
dnl TERMDOG
dnl ############################################
define(TERMDOG,dnl
${jun_ctl} termdog "${ifelse($1,,inclass,$1)}" "${path}" ${hname} ${ipadr} ${dogfi})dnl
dnl
dnl ############################################
dnl RESTDOG
dnl ############################################
define(RESTDOG,dnl
DEFDOG($1)
TERMDOG > /dev/null 2>&1
echo $$ > ${dogfi}dnl
)dnl
dnl
dnl ############################################
dnl TERMPID
dnl ############################################
define(TERMPID,${jun_ctl} termpid "/usr/libexec/${ifelse($1,,lclass,$1)}" ${pidfi} ${uid})dnl
dnl
dnl ############################################
dnl KILDOG
dnl ############################################
define(KILDOG,${jun_ctl} kildog "${ifelse($1,,inclass,$1)}" "${path}" ${hname} ${ipadr} ${dogfi})dnl
dnl
dnl ############################################
dnl KILPID
dnl ############################################
define(KILPID,${jun_ctl} kilpid "/usr/libexec/${ifelse($1,,lclass,$1)}" ${pidfi} ${uid})dnl
dnl
dnl ############################################
dnl DOLOOP
dnl ENDLOOP
dnl ############################################
define(DOLOOP,while ${true}; do)dnl
define(ENDLOOP,done)dnl
dnl
dnl ############################################
dnl DOJAILID
dnl ############################################
define(DOJAILID,${jail} -u ${uid} -g ${gid} ${fl} ${nice} "${JAILUPDIR}/${path}" ${hname} ${ipadr} /usr/libexec/${ifelse($1,,lclass,$1)})dnl
dnl
dnl ############################################
dnl DOJAIL
dnl ############################################
define(DOJAIL,${jail} ifelse($1,,,$1 )${fl} ${nice} "${JAILUPDIR}/${path}" ${hname} ${ipadr} /usr/libexec/${lclass})dnl
dnl
dnl ############################################
dnl KWAIT
dnl ############################################
define(KWAIT,dnl
${sleep} ifelse($1,,60,$1)
pidnum=`${head} -1 ${pidfi}` || ${true}
[ -n "${pidnum}" ] && ${pid_kwait} -qp ${pidnum}dnl
)dnl
dnl
dnl ############################################
dnl JNTROSTUP
dnl ############################################
define(JNTROSTUP,dnl
genclass=$1
suffix=$2
inclass=ifelse($3,,$1$2,$3)
. ${JAILUP_CONF}
kind=`${dirname} "${0}"`
kind=`${basename} "${kind}"`
t=`${basename} "${0}"`
if  [ "${t}" != "${t#*-}" ]; then
    kind="${kind}/-${t#*-}"
fi

if  [ -z "${1}" ]; then
    ${cat} << EOF
# jailup ${kind} @BABOLO V.M VERS  %%DATE%%
#     Usage:
$4
EOF
ifelse($5,,,$5)dnl
    exit
fi
umask 022dnl
)dnl
dnl
dnl ############################################
dnl ETCOPY
dnl ############################################
define(ETCOPY,dnl
echo "localtime" | ${up_data} "${conf_dir}/" /etc/
ifelse($1,,,
${up_conf} "${conf_dir}/" /etc/ << EOF
$1
EOF
))dnl
dnl
dnl ############################################
dnl CONFCOPY
dnl ############################################
define(CONFCOPY,dnl
if  [ ! -e "${conf_dir}/"$1 ]; then
    ${cp} $2 "${conf_dir}/"$1
elif ! ${diff} -bBdqa $2 "${conf_dir}/"$1 > /dev/null; then
    ${cp} $2 "${conf_dir}/"$1.sample
fidnl
)dnl
dnl
dnl ############################################
dnl 
dnl ############################################
dnl define(,)dnl
