/*-
 * Copyright (C) @BABOLO  2003 Mar 23
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2003 Mar 23\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: rmflaged.c,v 1.2 2003/07/22 04:11:46 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <err.h>
#define FLAG_Q 0x001
#define FLAG_V 0x002
#define FLAG_F 0x004

void
usage(int ex) {
    fprintf( stderr
           , "%s @BABOLO V.M "VERS"  "DATE" from jailup(8) package\n"
             "Usage:\n"
             "%s [-fqv] file\n"
           , getprogname()
           , getprogname()
           );
    exit(ex);
}

int
main(int argc, char **argv) {
    u_int32_t flag;
    int c, f, e, flagv;
    struct stat sb;
    u_long chfl = UF_IMMUTABLE | UF_APPEND | UF_NOUNLINK | SF_IMMUTABLE | SF_APPEND | SF_NOUNLINK;

    flag = 0;
    flagv = 1;
    while ((c = getopt(argc, argv, "fhqv?")) != -1) {
        switch (c) {
        case 'f':
            flag |= FLAG_F;
            break;
        case 'q':
            flagv = 0;
            break;
        case 'v':
            flagv++;
            break;
        case 'h':
        case '?':
            usage(EX_OK);
        default:
            usage(EX_USAGE);
    }   }
    argc -= optind;
    argv += optind;
    if  (argc != 1) usage(EX_USAGE);
    f = open(*argv, O_SHLOCK|O_NOFOLLOW|O_NONBLOCK);
    if  (flag & FLAG_F && f < 0 && errno == EWOULDBLOCK) {
        if  (flagv > 1) warnx("11: File %s locked, force", *argv);
        f = open(*argv, O_NOFOLLOW|O_NONBLOCK);
    }
    if  (f < 0) {
        if  (flagv) warn("12");
        exit(EX_NOINPUT);
    }
    if  (fstat(f, &sb) < 0) {
        if  (flagv) warn("13");
        exit(EX_NOINPUT);
    }
    if  (fchflags(f, sb.st_flags) < 0) {
        if  (flagv) warn("14");
        exit(EX_NOPERM);
    }
    if  (fchflags(f, sb.st_flags & ~chfl) < 0) {
        if  (flagv) warn("15");
        exit(EX_NOPERM);
    }
    if  (unlink(*argv) < 0) {
        if  (flagv) warn("16");
    }
    if  (fchflags(f, sb.st_flags) < 0) {
        if  (flagv) warn("17");
        exit(EX_NOPERM);
    }
    if  (close(f) < 0) {
        if  (flagv) warn("18");
        exit(EX_DATAERR);
    }
    exit(EX_OK);
}
