/*-
 * Copyright (C) @BABOLO  2003 Apr 27
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2003 Apr 27\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pid_kwait.c,v 1.2 2003/07/22 04:11:46 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>

void
usage(int ex) {
    fprintf( stderr
           , "%s @BABOLO V.M "VERS"  "DATE" from jailup(8) package\n"
             "Usage:\n"
             "%s [-qv] -p pid\n"
           , getprogname()
           , getprogname()
           );
    exit(ex);
}

int
main(int argc, char **argv) {
    int c, i, flag_v;
    int kq;
    struct kevent reg, event;
    pid_t p;
    struct timespec noll;

    flag_v = 1;
    p = 0;
    bzero(&noll, sizeof(noll));
    while ((c = getopt(argc, argv, "p:qvh?")) != -1) {
        switch (c) {
        case 'p':
            p = strtol(optarg, NULL, 0);
            break;
        case 'q':
            flag_v = 0;
            break;
        case 'v':
            flag_v++;
            break;
        case 'h':
        case '?':
            usage(EX_OK);
        default:
            usage(EX_USAGE);
    }   }
    argc -= optind;
    argv += optind;
    if  (p == 0 || argc != 0) usage(EX_USAGE);
    if  ((kq = kqueue()) < 0)                                                      err(EX_OSERR, NULL);
    EV_SET(&reg, p, EVFILT_PROC, EV_ADD, NOTE_EXIT, 0, NULL);
    i = kevent(kq, &reg, 1, &event, 1, NULL);
    if  (flag_v) fprintf(stderr, "kevent= %d(%d)\n", i, 1);
    if  (flag_v > 1)
        fprintf( stderr
               , "ident = %d(%d)\nfilter= %04X(%04X)\nflags = %04X(%04X)\nfflags= %08X(%08X)\ndata  = %d(%d)\n"
               , event.ident              , reg.ident
               , event.filter & 0x0000FFFF, reg.filter & 0x0000FFFF
               , event.flags              , reg.flags
               , event.fflags             , reg.fflags
               , event.data               , reg.data
               );
    exit(0);
}
