/*-
 * Copyright (C) @BABOLO  2003 Mar 23
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2003 Mar 23\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: lnflaged.c,v 1.2 2003/07/22 04:11:46 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <err.h>
#define FLAG_Q 0x001
#define FLAG_V 0x002
#define FLAG_F 0x004
#define FLAG_U 0x008

void
usage(int ex) {
    fprintf( stderr
           , "%s @BABOLO V.M "VERS"  "DATE" from jailup(8) package\n"
             "Usage:\n"
             "%s [-fqv] source_file target_file\n"
           , getprogname()
           , getprogname()
           );
    exit(ex);
}

int
main(int argc, char **argv) {
    u_int32_t flag;
    int c, f, r, e, flagv;
    struct stat sb, sc;
    u_long chfl = UF_IMMUTABLE | UF_APPEND | UF_NOUNLINK | SF_IMMUTABLE | SF_APPEND | SF_NOUNLINK;

    flag = 0;
    flagv = 1;
    while ((c = getopt(argc, argv, "fhqv?")) != -1) {
        switch (c) {
        case 'f':
            if  (flag & FLAG_F) flag |= FLAG_U;
            flag |= FLAG_F;
            break;
        case 'q':
            flagv = 0;
            break;
        case 'v':
            flagv++;
            break;
        case 'h':
        case '?':
            usage(EX_OK);
        default:
            usage(EX_USAGE);
    }   }
    argc -= optind;
    argv += optind;
    if  (argc != 2) usage(EX_USAGE);
    f = open(*argv, O_SHLOCK|O_NOFOLLOW|O_NONBLOCK);
    if  (flag & FLAG_F && f < 0 && errno == EWOULDBLOCK) {
        if  (flagv > 1) warnx("10: File %s locked, force\n", *argv);
        f = open(*argv, O_NOFOLLOW|O_NONBLOCK);
    }
    if  (f < 0) {
        if  (flagv) warn("11");
        exit(EX_NOINPUT);
    }
    if  (fstat(f, &sb) < 0) {
        if  (flagv) warn("12");
        exit(EX_NOINPUT);
    }
    if  (stat(argv[1], &sc) == 0) {
        if  (sb.st_dev == sc.st_dev && sb.st_ino == sc.st_ino) {
            if  (close(f) < 0) {
                if  (flagv) warn("20");
                exit(EX_DATAERR);
            }
            exit(EX_OK);
        }
        if  (!(flag & FLAG_U)) {
            if  (flagv) warnx("21: File %s exists\n", argv[1]);
            exit(EX_USAGE);
        }
        r = open(argv[1], O_SHLOCK|O_NOFOLLOW|O_NONBLOCK);
        if  (flag & FLAG_F && r < 0 && errno == EWOULDBLOCK) {
            if  (flagv > 1) warnx("22: File %s locked, force\n", argv[1]);
            r = open(argv[1], O_NOFOLLOW|O_NONBLOCK);
        }
        if  (r < 0) {
            if  (flagv) warn("23");
            exit(EX_NOINPUT);
        }
        if  (fstat(r, &sc) < 0) {
            if  (flagv) warn("24");
            exit(EX_NOINPUT);
        }
        if  (fchflags(r, sb.st_flags) < 0) {
            if  (flagv) warn("25");
            exit(EX_NOPERM);
        }
        if  (fchflags(r, sb.st_flags & ~chfl) < 0) {
            if  (flagv) warn("26");
            exit(EX_NOPERM);
        }
        if  (unlink(argv[1]) < 0) {
            if  (flagv) warn("27");
        }
        if  (fchflags(r, sb.st_flags) < 0) {
            if  (flagv) warn("28");
            exit(EX_NOPERM);
        }
        if  (close(r) < 0) {
            if  (flagv) warn("29");
    }   }
    if  (fchflags(f, sb.st_flags) < 0) {
        if  (flagv) warn("30");
        exit(EX_NOPERM);
    }
    if  (fchflags(f, sb.st_flags & ~chfl) < 0) {
        if  (flagv) warn("31");
        exit(EX_NOPERM);
    }
    if  (link(*argv, argv[1]) < 0) {
        if  (flagv) warn("32");
    }
    if  (fchflags(f, sb.st_flags) < 0) {
        if  (flagv) warn("33");
        exit(EX_NOPERM);
    }
    if  (close(f) < 0) {
        if  (flagv) warn("34");
        exit(EX_DATAERR);
    }
    exit(EX_OK);
}
