/*-
 * Copyright (C)2005 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2005 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: test.c,v 1.4 2013/01/26 11:44:33 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <mife.h>
#include <babolo/BLINflag.h>
#include "../getCGIparm.h"

int
main(int argc, char **argv) {
    int i;
    u_char *os, *qd, *ns, *pat;
    BLIN_flag flags = 0;

    qd = (u_char*)"\t";
    ns = (u_char*)"\\N";
    os = (u_char*)"";
    pat = (u_char*)"any";
    while ((i = getopt(argc, argv, "d:ein:o:p:qv")) != -1) {
        switch (i) {
        case 'd':
            qd = (u_char*)optarg;
            break;
        case 'e':
            flags |= gCGI_EOPT;
            break;
        case 'i':
            flags |= gCGI_RNUM;
            break;
        case 'n':
            ns = (u_char*)optarg;
            break;
        case 'o':
            os = (u_char*)optarg;
            break;
        case 'p':
            pat = (u_char*)optarg;
            break;
        case 'q':
            flags &= ~BLIN_VERMASK;
            break;
        case 'v':
            BLIN_VERBOSE(flags);
            break;
    }   }
    ifBLIN_QV5(flags) fprintf(stderr, "optind=%5d\n", optind);
    argc -= optind;
    argv += optind;
    for (i = 0; argv[i]; i++) {
        ifBLIN_QV5(flags) fprintf(stderr, "%5d %s~\n", i, argv[i]);
    }
    i = getCGIparmopt(flags, (u_char*const*const)argv, os, pat, qd, ns, mife_writ, fileno(stdout));
    if  (i > 0) exit(i);
    argv -= i;
    i = getCGIparmarray(flags, (u_char*const*const)argv, pat, qd, ns, mife_writ, fileno(stdout));
    exit(i);
}
