/*-
 * Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pass4.c,v 1.8 2013/01/26 11:44:33 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include "getCGIparm_int.h"
#include "getCGIparm.h"
#define BUFL 512
static u_char *pname, buff[BUFL];

/**********************************
 * positions to begin of new line *
 **********************************/
static void
scaml(FILE *ine) {
    while(!feof(ine) && fgetc(ine) != '\n');
}

/*******************************************
 * skip out strings with white space begin *
 *******************************************/
static void
scamb(FILE *ine) {
    int c;

    while(!feof(ine)) {
    c = fgetc(ine);
        if  (c == ' ' || c == '\t') scaml(ine);
        else {
            if  (!feof(ine)) ungetc(c, ine);
            break;
}   }   }

/****************
 * inputs flass *
 ****************/
static u_int32_t
scamg(FILE *ine) {
    int c = 0;
    u_int32_t i = 0, n = 0;

    if  (pname) free(pname);
    pname = NULL;
    if  (feof(ine));
    else if ((c = fgetc(ine)) == '-') {
        while(!feof(ine) && (c = fgetc(ine)) == 'x') i = ((i << 1) | 1) & gCGI_ERRMASK;
        if  (!feof(ine) && c == 'n') {
            while(!feof(ine) && (c = fgetc(ine)) == ' ');
            pname = malloc(BUFL); n = 0;
            if  (!feof(ine)) ungetc(c, ine);
            while(!feof(ine) && (c = fgetc(ine)) > ' ') pname[n++] = c;
            pname[n++] = '\0';
        }
        while(!feof(ine) && (c == ' ' || c == '\t')) c = fgetc(ine);
        if  (!feof(ine)) ungetc(c, ine);
    } else ungetc(c, ine);
    return(i);
}

/*****************
 * inputs totype *
 *****************/
static int
scamp(FILE *ine) {
    int c = 0, p = 0;

    while(p < BUFL - 1 && !feof(ine) && c != '\n') {
        c = fgetc(ine);
        if  (!feof(ine) && c != '\n') buff[p++] = c;
    }
    if  (c != '\n') scaml(ine);
    buff[p] = '\0';
    return(p);
}

void
getCGIparmpass4( BLIN_flag flags
     , const u_char * const totype
     , const u_char * const toname
     , const u_char * const errform
     , FILE *errout
     ) {
    int i;
    FILE *ine;
    u_int32_t f;
    const u_char *empty = (const u_char *)"";

    pname = NULL;
    ifBLIN_QV3(flags)
        fprintf( stderr
               , "P4 flags=%06X, totype=%s~, toname=%s~, errform=%s~\n"
               , flags
               , totype ? totype : empty
               , toname ? toname : empty
               , errform ? errform : empty
               );
    if  (flags & gCGI_TEXT) {
        if  (~flags & gCGI_OTST) fprintf(errout, "%s", errform);
    } else if  (flags & gCGI_FILE) {
        ine = fopen((char*)errform, "r");
        if  (ine) {
            for (;;) {
                i = fgetc(ine);
                if  (feof(ine) || ferror(ine)) break;
                if  (~flags & gCGI_OTST) fputc(i, errout);
            }
        fclose(ine);
        }
    } else if  (flags & gCGI_FORM) {
        ine = fopen((char*)errform, "r");
        while(ine && !feof(ine)) {
            scamb(ine);					/* skip text till command */
            f = scamg(ine);				/* -x flags in f now */
            if  ((i = scamp(ine)) && i && buff[i - 1] == '*') {
                f |= gCGI_OPEN;
                --i;
            }
            ifBLIN_QV4(flags)
                fprintf(stderr, "pname =%s~,%s~\n", pname ? pname : empty, i ? buff : empty);
            if  (  (f & gCGI_ERRMASK) <= (flags & gCGI_ERRMASK)
                && (!toname || !pname || (toname && pname && strcmp((char*)pname, (char*)toname) == 0))
                && !( (f & gCGI_OPEN)
                    ? strncmp((char*)totype, (char*)buff, i)
                    : strcmp((char*)totype, (char*)buff)
                )   ) {
                int c = fgetc(ine);
                while(!feof(ine) && c != ' ' && c != '\t') {
                    ungetc(c, ine);
                    scaml(ine);
                    c = fgetc(ine);
                }
                while(!feof(ine) && (c == ' ' || c == '\t')) {
                    c = fgetc(ine);
                    while(!feof(ine) && c != '\n') {
                        if  (~flags & gCGI_OTST) fputc(c, errout);
                        c = fgetc(ine);
                    }
                    if  (!feof(ine)) {
                        if  (~flags & gCGI_OTST) fputc(c, errout);
                        c = fgetc(ine);
                }   }
                fclose(ine);
                ine = NULL;
            }
            if  (pname) free(pname);
            pname = NULL;
    }   }
    ifBLIN_QV3(flags) fprintf(stderr, "P4 ex\n");
}
